/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jgnash.engine.CommodityNode;
import jgnash.engine.CurrencyNode;
import jgnash.engine.QuoteSource;
import jgnash.engine.SecurityHistoryNode;
import jgnash.util.DateUtils;

public class SecurityNode
extends CommodityNode
implements Cloneable {
    private static final long serialVersionUID = -8377663762619941498L;
    private CurrencyNode reportedCurrency;
    private String quoteSource = QuoteSource.NONE.name();
    private transient QuoteSource cachedQuoteSource;
    private String isin;
    private List<SecurityHistoryNode> historyNodes = new ArrayList<SecurityHistoryNode>();
    private transient ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public SecurityNode() {
    }

    public SecurityNode(CurrencyNode node) {
        this();
        this.setReportedCurrencyNode(node);
    }

    private ReadWriteLock getLock() {
        return this.lock;
    }

    @Override
    public String getPrefix() {
        return this.reportedCurrency.getPrefix();
    }

    @Override
    public void setPrefix(String ignored) {
    }

    @Override
    public String getSuffix() {
        return this.reportedCurrency.getSuffix();
    }

    @Override
    public void setSuffix(String ignored) {
    }

    public QuoteSource getQuoteSource() {
        if (this.cachedQuoteSource == null) {
            this.cachedQuoteSource = QuoteSource.valueOf(this.quoteSource);
        }
        return this.cachedQuoteSource;
    }

    public void setQuoteSource(QuoteSource source) {
        this.quoteSource = source.name();
        this.cachedQuoteSource = source;
    }

    public String getISIN() {
        return this.isin;
    }

    public void setISIN(String isin) {
        this.isin = isin;
    }

    public void setReportedCurrencyNode(CurrencyNode node) {
        this.reportedCurrency = node;
    }

    public CurrencyNode getReportedCurrencyNode() {
        return this.reportedCurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addHistoryNode(SecurityHistoryNode node) {
        Lock l = this.getLock().writeLock();
        l.lock();
        try {
            int index = Collections.binarySearch(this.historyNodes, node);
            if (index < 0) {
                this.historyNodes.add(-index - 1, node);
            } else {
                this.historyNodes.set(index, node);
            }
        }
        finally {
            l.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeHistoryNode(SecurityHistoryNode hNode) {
        Lock l = this.getLock().writeLock();
        l.lock();
        boolean result = false;
        try {
            result = this.historyNodes.remove(hNode);
        }
        finally {
            l.unlock();
        }
        return result;
    }

    private SecurityHistoryNode getLastHistoryNode() {
        this.getLock().readLock().lock();
        SecurityHistoryNode node = null;
        if (!this.historyNodes.isEmpty()) {
            node = this.historyNodes.get(this.historyNodes.size() - 1);
        }
        this.getLock().readLock().unlock();
        return node;
    }

    public List<SecurityHistoryNode> getHistoryNodes() {
        return new ArrayList<SecurityHistoryNode>(this.historyNodes);
    }

    protected SecurityHistoryNode getHistoryNode(Date date) {
        Date testDate = DateUtils.levelDate(date);
        this.getLock().readLock().lock();
        SecurityHistoryNode hNode = null;
        for (int i = this.historyNodes.size() - 1; i >= 0; --i) {
            SecurityHistoryNode node = this.historyNodes.get(i);
            if (testDate.compareTo(node.getDate()) < 0) continue;
            hNode = node;
            break;
        }
        if (hNode == null) {
            hNode = this.getLastHistoryNode();
        }
        this.getLock().readLock().unlock();
        return hNode;
    }

    BigDecimal getMarketPrice(Date date) {
        BigDecimal marketPrice = BigDecimal.ZERO;
        Date testDate = DateUtils.levelDate(date);
        this.getLock().readLock().lock();
        for (SecurityHistoryNode node : this.historyNodes) {
            if (node.getDate().getTime() > testDate.getTime()) break;
            marketPrice = node.getPrice();
        }
        this.getLock().readLock().unlock();
        return marketPrice;
    }

    public BigDecimal getMarketPrice(Date date, CurrencyNode node) {
        return this.getMarketPrice(date).multiply(this.getReportedCurrencyNode().getExchangeRate(node));
    }

    @Override
    public Object clone() {
        SecurityNode node = (SecurityNode)super.clone();
        node.historyNodes = new ArrayList<SecurityHistoryNode>();
        node.lock = new ReentrantReadWriteLock(true);
        return node;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.lock = new ReentrantReadWriteLock(true);
        return this;
    }
}

