/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class InlineStats {
    private String configName = "Inlining stats";
    private Map morphicity = new TreeMap();
    private int nLiveClasses = 0;
    private int nLiveMethods = 0;
    private int nNoPreexist = 0;
    private int nInlined = 0;

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public void noteMorphicity(int morphicity) {
        Integer r = new Integer(morphicity);
        Integer count = (Integer)this.morphicity.get(r);
        if (count == null) {
            this.morphicity.put(r, new Integer(1));
        } else {
            this.morphicity.put(r, new Integer(count + 1));
        }
    }

    public void noteNoPreexist() {
        ++this.nNoPreexist;
    }

    public void noteInlined() {
        ++this.nInlined;
    }

    public void noteLiveMethods(int nLiveMethods) {
        this.nLiveMethods = nLiveMethods;
    }

    public void noteLiveClasses(int nLiveClasses) {
        this.nLiveClasses = nLiveClasses;
    }

    public void printSummary(PrintWriter pw) {
        pw.println("Statistics for " + this.configName + " (" + new Date() + ")");
        pw.println("  Number of live classes: " + this.nLiveClasses);
        pw.println("  Number of live methods: " + this.nLiveMethods);
        pw.println("  Call site morphism:");
        Iterator morphs = this.morphicity.keySet().iterator();
        int total = 0;
        while (morphs.hasNext()) {
            Integer morph = (Integer)morphs.next();
            Integer count = (Integer)this.morphicity.get(morph);
            total += count.intValue();
            pw.println("    " + morph + "\t" + count);
        }
        pw.println("  Total number of call sites: " + total);
        pw.println("  Number of non-preexistent call sites: " + this.nNoPreexist);
        pw.println("  Number of inlined methods: " + this.nInlined);
    }
}

