/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.PersistentIntegerArray;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.AddressKeySlotHandler;
import com.db4o.internal.freespace.FreespaceBTree;
import com.db4o.internal.freespace.LengthKeySlotHandler;
import com.db4o.internal.freespace.RamFreespaceManager;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public class BTreeFreespaceManager
extends AbstractFreespaceManager {
    private RamFreespaceManager _delegate;
    private FreespaceBTree _slotsByAddress;
    private FreespaceBTree _slotsByLength;
    private PersistentIntegerArray _idArray;
    private int _delegateIndirectionID;
    private int _delegationRequests;

    public BTreeFreespaceManager(LocalObjectContainer localObjectContainer) {
        super(localObjectContainer);
        this._delegate = new RamFreespaceManager(localObjectContainer);
    }

    private void addSlot(Slot slot) {
        this._slotsByLength.add(this.transaction(), slot);
        this._slotsByAddress.add(this.transaction(), slot);
    }

    public Slot allocateTransactionLogSlot(int n) {
        return this._delegate.allocateTransactionLogSlot(n);
    }

    public void beginCommit() {
    }

    private void beginDelegation() {
        ++this._delegationRequests;
    }

    public void commit() {
        this.beginDelegation();
        this._slotsByAddress.commit(this.transaction());
        this._slotsByLength.commit(this.transaction());
    }

    private void createBTrees(int n, int n2) {
        this._slotsByAddress = new FreespaceBTree(this.transaction(), n, new AddressKeySlotHandler());
        this._slotsByLength = new FreespaceBTree(this.transaction(), n2, new LengthKeySlotHandler());
    }

    public void endCommit() {
        this.endDelegation();
    }

    private void endDelegation() {
        --this._delegationRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Slot slot) {
        if (!this.started()) {
            return;
        }
        if (this.isDelegating()) {
            this._delegate.free(slot);
            return;
        }
        try {
            Slot slot2;
            BTreePointer bTreePointer;
            this.beginDelegation();
            Slot[] slotArray = new Slot[2];
            Slot slot3 = slot;
            BTreePointer bTreePointer2 = this.searchBTree(this._slotsByAddress, slot, SearchTarget.LOWEST);
            BTreePointer bTreePointer3 = bTreePointer = bTreePointer2 != null ? bTreePointer2.previous() : this._slotsByAddress.lastPointer(this.transaction());
            if (bTreePointer != null && (slot2 = (Slot)bTreePointer.key()).isDirectlyPreceding(slot3)) {
                slotArray[0] = slot2;
                slot3 = slot2.append(slot3);
            }
            if (bTreePointer2 != null && slot3.isDirectlyPreceding(slot2 = (Slot)bTreePointer2.key())) {
                slotArray[1] = slot2;
                slot3 = slot3.append(slot2);
            }
            for (int i = 0; i < slotArray.length; ++i) {
                if (slotArray[i] == null) continue;
                this.removeSlot(slotArray[i]);
            }
            if (!this.canDiscard(slot3.length())) {
                this.addSlot(slot3);
            }
            this._file.overwriteDeletedBlockedSlot(slot);
        }
        finally {
            this.endDelegation();
        }
    }

    public void freeSelf() {
        this._slotsByAddress.free(this.transaction());
        this._slotsByLength.free(this.transaction());
    }

    public void freeTransactionLogSlot(Slot slot) {
        this._delegate.freeTransactionLogSlot(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot getSlot(int n) {
        if (!this.started()) {
            return null;
        }
        if (this.isDelegating()) {
            return this._delegate.getSlot(n);
        }
        try {
            this.beginDelegation();
            BTreePointer bTreePointer = this.searchBTree(this._slotsByLength, new Slot(0, n), SearchTarget.HIGHEST);
            if (bTreePointer == null) {
                Slot slot = null;
                return slot;
            }
            Slot slot = (Slot)bTreePointer.key();
            this.removeSlot(slot);
            int n2 = slot.length() - n;
            if (!this.canDiscard(n2)) {
                this.addSlot(slot.subSlot(n));
                slot = slot.truncate(n);
            }
            Slot slot2 = slot;
            return slot2;
        }
        finally {
            this.endDelegation();
        }
    }

    private void initializeExisting(int n) {
        this._idArray = new PersistentIntegerArray(n);
        this._idArray.read(this.transaction());
        int[] nArray = this._idArray.array();
        int n2 = nArray[0];
        int n3 = nArray[1];
        this._delegateIndirectionID = nArray[2];
        this.createBTrees(n2, n3);
        this._slotsByAddress.read(this.transaction());
        this._slotsByLength.read(this.transaction());
        Pointer4 pointer4 = this.transaction().readPointer(this._delegateIndirectionID);
        this.transaction().writeZeroPointer(this._delegateIndirectionID);
        this.transaction().flushFile();
        this._delegate.read(pointer4._slot);
    }

    private void initializeNew() {
        this.createBTrees(0, 0);
        this._slotsByAddress.write(this.transaction());
        this._slotsByLength.write(this.transaction());
        this._delegateIndirectionID = this._file.getPointerSlot();
        int[] nArray = new int[]{this._slotsByAddress.getID(), this._slotsByLength.getID(), this._delegateIndirectionID};
        this._idArray = new PersistentIntegerArray(nArray);
        this._idArray.write(this.transaction());
        this._file.systemData().freespaceAddress(this._idArray.getID());
    }

    private boolean isDelegating() {
        return this._delegationRequests > 0;
    }

    public int onNew(LocalObjectContainer localObjectContainer) {
        return 0;
    }

    public void read(int n) {
    }

    private void removeSlot(Slot slot) {
        this._slotsByLength.remove(this.transaction(), slot);
        this._slotsByAddress.remove(this.transaction(), slot);
    }

    private BTreePointer searchBTree(BTree bTree, Slot slot, SearchTarget searchTarget) {
        BTreeNodeSearchResult bTreeNodeSearchResult = bTree.searchLeaf(this.transaction(), slot, searchTarget);
        return bTreeNodeSearchResult.firstValidPointer();
    }

    public int slotCount() {
        return this._slotsByAddress.size(this.transaction()) + this._delegate.slotCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n) {
        try {
            this.beginDelegation();
            if (n == 0) {
                this.initializeNew();
            } else {
                this.initializeExisting(n);
            }
        }
        finally {
            this.endDelegation();
        }
    }

    private boolean started() {
        return this._idArray != null;
    }

    public byte systemType() {
        return 4;
    }

    public String toString() {
        return this._slotsByLength.toString();
    }

    public int totalFreespace() {
        return super.totalFreespace() + this._delegate.totalFreespace();
    }

    public void traverse(Visitor4 visitor4) {
        this._slotsByAddress.traverseKeys(this.transaction(), visitor4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write() {
        try {
            this.beginDelegation();
            Slot slot = this._file.getSlot(this._delegate.marshalledLength());
            Pointer4 pointer4 = new Pointer4(this._delegateIndirectionID, slot);
            this._delegate.write(pointer4);
            int n = this._idArray.getID();
            return n;
        }
        finally {
            this.endDelegation();
        }
    }
}

