/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.jasper;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.ui.report.jasper.DynamicJasperReportFrame;
import jgnash.ui.report.jasper.DynamicJasperReportPanel;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.save.JRCsvSaveContributor;
import net.sf.jasperreports.view.save.JROdtSaveContributor;
import net.sf.jasperreports.view.save.JRPdfSaveContributor;

class DynamicJasperReportPanel
extends JPanel
implements ActionListener {
    private static final int REPORT_RESOLUTION = 72;
    private float MIN_ZOOM = 0.5f;
    private float MAX_ZOOM = 10.0f;
    private int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200};
    private int defaultZoomIndex = 2;
    private JasperPrint jPrint = null;
    private int pageIndex = 0;
    private float zoom = 0.0f;
    private JRGraphics2DExporter exporter = null;
    private int screenResolution = 72;
    private float realZoom = 0.0f;
    private DecimalFormat zoomFormat = new DecimalFormat("#.#");
    private ResourceBundle resourceBundle = null;
    protected JToggleButton actualSizeButton;
    protected JButton firstButton;
    protected JToggleButton fitPageButton;
    protected JToggleButton fitWidthButton;
    protected JButton lastButton;
    protected JButton nextButton;
    private JButton pageSetupButton;
    protected JButton previousButton;
    protected JButton printButton;
    protected JButton saveButton;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected JComboBox zoomComboBox;
    protected JComboBox fontSizeComboBox;
    private JPanel scrollPanePanel;
    private JPanel spaceHoldPanel;
    private JPanel mainPanel;
    private JPanel pageGluePanel;
    private List<JRSaveContributor> saveContributors = new ArrayList<JRSaveContributor>();
    private DynamicJasperReport report;
    private PageRenderer pageRenderer;
    private static final String LAST_DIRECTORY = "lastDirectory";
    private static final String LAST_CONTRIBUTOR = "lastContributor";
    private DynamicJasperReportFrame frame;

    protected DynamicJasperReportPanel(DynamicJasperReportFrame frame, DynamicJasperReport report) {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        this.resourceBundle = ResourceBundle.getBundle("net/sf/jasperreports/view/viewer");
        this.report = report;
        this.frame = frame;
        report.setViewer(this);
        this.initializeUI();
        this.initSaveContributors();
        new ReportWorker().execute();
    }

    void clear() {
        this.emptyContainer(this);
        this.jPrint = null;
    }

    private String getBundleString(String key) {
        return this.resourceBundle.getString(key);
    }

    private void initSaveContributors() {
        this.saveContributors.add((JRSaveContributor)new JRPdfSaveContributor(Locale.getDefault(), this.resourceBundle));
        this.saveContributors.add((JRSaveContributor)new JROdtSaveContributor(Locale.getDefault(), this.resourceBundle));
        this.saveContributors.add((JRSaveContributor)new JRCsvSaveContributor(Locale.getDefault(), this.resourceBundle));
    }

    private void initializeUI() {
        JToolBar toolBar = new JToolBar();
        this.firstButton = new JButton();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.lastButton = new JButton();
        this.actualSizeButton = new JToggleButton();
        this.fitPageButton = new JToggleButton();
        this.fitWidthButton = new JToggleButton();
        this.zoomInButton = new JButton();
        DefaultComboBoxModel<String> zoomModel = new DefaultComboBoxModel<String>();
        for (int z : this.zooms) {
            zoomModel.addElement(z + "%");
        }
        this.zoomComboBox = new JComboBox(zoomModel);
        DefaultComboBoxModel<Integer> fontModel = new DefaultComboBoxModel<Integer>();
        for (int i = 0; i <= 10; ++i) {
            fontModel.addElement(5 + i);
        }
        this.fontSizeComboBox = new JComboBox(fontModel);
        this.fontSizeComboBox.setToolTipText(Resource.get().getString("ToolTip.FontSize"));
        this.fontSizeComboBox.setSelectedItem(this.report.getBaseFontSize());
        this.fontSizeComboBox.addActionListener(this);
        this.zoomOutButton = new JButton();
        this.mainPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        this.scrollPanePanel = new JPanel();
        this.pageGluePanel = new JPanel();
        JPanel pagePanel = new JPanel();
        JPanel shadowPanel1 = new JPanel();
        JPanel shadowPanel2 = new JPanel();
        JPanel shadowPanel3 = new JPanel();
        JPanel shadowPanel4 = new JPanel();
        JPanel shadowPanel5 = new JPanel();
        this.setLayout(new BorderLayout());
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/jgnash/resource/document-save-as.png")));
        this.saveButton.setToolTipText(this.getBundleString("save"));
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(this);
        toolBar.add(this.saveButton);
        this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/jgnash/resource/document-print.png")));
        this.printButton.setToolTipText(this.getBundleString("print"));
        this.printButton.setFocusable(false);
        this.printButton.addActionListener(this);
        toolBar.add(this.printButton);
        toolBar.add(new JToolBar.Separator());
        this.pageSetupButton = new JButton(new ImageIcon(this.getClass().getResource("/jgnash/resource/document-properties.png")));
        this.pageSetupButton.setToolTipText(Resource.get().getString("ToolTip.PageSetup"));
        this.pageSetupButton.setFocusable(false);
        this.pageSetupButton.addActionListener(this);
        toolBar.add(this.pageSetupButton);
        this.fontSizeComboBox.setMaximumSize(new Dimension(50, this.pageSetupButton.getMinimumSize().height));
        this.fontSizeComboBox.setMinimumSize(new Dimension(50, this.pageSetupButton.getMinimumSize().height));
        this.fontSizeComboBox.setPreferredSize(new Dimension(50, this.pageSetupButton.getPreferredSize().height));
        toolBar.add(this.fontSizeComboBox);
        toolBar.add(new JToolBar.Separator());
        this.firstButton.setIcon(new ImageIcon(this.getClass().getResource("/jgnash/resource/go-first.png")));
        this.firstButton.setToolTipText(this.getBundleString("first.page"));
        this.firstButton.setFocusable(false);
        this.firstButton.setEnabled(false);
        this.firstButton.addActionListener(this);
        toolBar.add(this.firstButton);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/jgnash/resource/go-previous.png")));
        this.previousButton.setToolTipText(this.getBundleString("previous.page"));
        this.previousButton.setFocusable(false);
        this.previousButton.setEnabled(false);
        this.previousButton.addActionListener(this);
        toolBar.add(this.previousButton);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/jgnash/resource/go-next.png")));
        this.nextButton.setToolTipText(this.getBundleString("next.page"));
        this.nextButton.setFocusable(false);
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(this);
        toolBar.add(this.nextButton);
        this.lastButton.setIcon(new ImageIcon(this.getClass().getResource("/jgnash/resource/go-last.png")));
        this.lastButton.setToolTipText(this.getBundleString("last.page"));
        this.lastButton.setFocusable(false);
        this.lastButton.setEnabled(false);
        this.lastButton.addActionListener(this);
        toolBar.add(this.lastButton);
        toolBar.add(new JToolBar.Separator());
        this.actualSizeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/actualsize.GIF")));
        this.actualSizeButton.setToolTipText(this.getBundleString("actual.size"));
        this.actualSizeButton.setFocusable(false);
        this.actualSizeButton.addActionListener(this);
        toolBar.add(this.actualSizeButton);
        this.fitPageButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitpage.GIF")));
        this.fitPageButton.setToolTipText(this.getBundleString("fit.page"));
        this.fitPageButton.setFocusable(false);
        this.fitPageButton.addActionListener(this);
        toolBar.add(this.fitPageButton);
        this.fitWidthButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitwidth.GIF")));
        this.fitWidthButton.setToolTipText(this.getBundleString("fit.width"));
        this.fitWidthButton.setFocusable(false);
        this.fitWidthButton.addActionListener(this);
        toolBar.add(this.fitWidthButton);
        toolBar.add(new JToolBar.Separator());
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/jgnash/resource/zoom-in.png")));
        this.zoomInButton.setToolTipText(this.getBundleString("zoom.in"));
        this.zoomInButton.setFocusable(false);
        this.zoomInButton.addActionListener(this);
        toolBar.add(this.zoomInButton);
        this.zoomComboBox.setEditable(true);
        this.zoomComboBox.setToolTipText(this.getBundleString("zoom.ratio"));
        this.zoomComboBox.setMaximumSize(new Dimension(90, this.zoomInButton.getMinimumSize().height));
        this.zoomComboBox.setMinimumSize(new Dimension(90, this.zoomInButton.getMinimumSize().height));
        this.zoomComboBox.setPreferredSize(new Dimension(90, this.zoomInButton.getPreferredSize().height));
        this.zoomComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DynamicJasperReportPanel.this.zoomStateChange();
            }
        });
        this.zoomComboBox.addActionListener(this);
        toolBar.add(this.zoomComboBox);
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/jgnash/resource/zoom-out.png")));
        this.zoomOutButton.setToolTipText(this.getBundleString("zoom.out"));
        this.zoomOutButton.setFocusable(false);
        this.zoomOutButton.addActionListener(this);
        toolBar.add(this.zoomOutButton);
        JPanel reportController = this.report.getReportController();
        if (reportController != null) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)toolBar, "North");
            panel.add((Component)reportController, "Center");
            this.add((Component)panel, "North");
        } else {
            this.add((Component)toolBar, "North");
        }
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DynamicJasperReportPanel.this.pnlMainComponentResized();
            }
        });
        this.mainPanel.setLayout(new BorderLayout());
        scrollPane.setHorizontalScrollBarPolicy(32);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPanePanel.setLayout(new GridBagLayout());
        this.pageGluePanel.setLayout(new BorderLayout());
        pagePanel.setLayout(new GridBagLayout());
        this.spaceHoldPanel = new JPanel();
        this.spaceHoldPanel.setMinimumSize(new Dimension(5, 5));
        this.spaceHoldPanel.setOpaque(false);
        this.spaceHoldPanel.setPreferredSize(new Dimension(5, 5));
        this.spaceHoldPanel.setLayout(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        pagePanel.add((Component)this.spaceHoldPanel, gridBagConstraints);
        shadowPanel1.setBackground(Color.gray);
        shadowPanel1.setMinimumSize(new Dimension(5, 5));
        shadowPanel1.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        pagePanel.add((Component)shadowPanel1, gridBagConstraints);
        shadowPanel2.setMinimumSize(new Dimension(5, 5));
        shadowPanel2.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        pagePanel.add((Component)shadowPanel2, gridBagConstraints);
        shadowPanel3.setBackground(Color.gray);
        shadowPanel3.setMinimumSize(new Dimension(5, 5));
        shadowPanel3.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        pagePanel.add((Component)shadowPanel3, gridBagConstraints);
        shadowPanel4.setBackground(Color.gray);
        shadowPanel4.setMinimumSize(new Dimension(5, 5));
        shadowPanel4.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        pagePanel.add((Component)shadowPanel4, gridBagConstraints);
        shadowPanel5.setMinimumSize(new Dimension(5, 5));
        shadowPanel5.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        pagePanel.add((Component)shadowPanel5, gridBagConstraints);
        this.pageRenderer = new PageRenderer(this);
        this.pageRenderer.setBackground(Color.white);
        this.pageRenderer.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pageRenderer.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pagePanel.add((Component)this.pageRenderer, gridBagConstraints);
        this.pageGluePanel.add((Component)pagePanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.scrollPanePanel.add((Component)this.pageGluePanel, gridBagConstraints);
        scrollPane.setViewportView(this.scrollPanePanel);
        this.mainPanel.add((Component)scrollPane, "Center");
        this.add((Component)this.mainPanel, "Center");
        this.zoomComboBox.setSelectedIndex(this.defaultZoomIndex);
    }

    private void zoomStateChange() {
        this.actualSizeButton.setSelected(false);
        this.fitPageButton.setSelected(false);
        this.fitWidthButton.setSelected(false);
    }

    private void pnlMainComponentResized() {
        if (this.fitPageButton.isSelected()) {
            this.fitPage();
            this.fitPageButton.setSelected(true);
        } else if (this.fitWidthButton.isSelected()) {
            this.setRealZoomRatio(((float)this.scrollPanePanel.getVisibleRect().getWidth() - 20.0f) / (float)this.jPrint.getPageWidth());
            this.fitWidthButton.setSelected(true);
        }
    }

    private void actualSizeAction() {
        if (this.actualSizeButton.isSelected()) {
            this.fitPageButton.setSelected(false);
            this.fitWidthButton.setSelected(false);
            this.zoomComboBox.setSelectedIndex(-1);
            this.setZoomRatio(1.0f);
            this.actualSizeButton.setSelected(true);
        }
    }

    private void fitWidthAction() {
        if (this.fitWidthButton.isSelected()) {
            this.actualSizeButton.setSelected(false);
            this.fitPageButton.setSelected(false);
            this.zoomComboBox.setSelectedIndex(-1);
            this.setRealZoomRatio(((float)this.scrollPanePanel.getVisibleRect().getWidth() - 20.0f) / (float)this.jPrint.getPageWidth());
            this.fitWidthButton.setSelected(true);
        }
    }

    private void fitPageAction() {
        if (this.fitPageButton.isSelected()) {
            this.actualSizeButton.setSelected(false);
            this.fitWidthButton.setSelected(false);
            this.zoomComboBox.setSelectedIndex(-1);
            this.fitPage();
            this.fitPageButton.setSelected(true);
        }
    }

    private void saveAction() {
        int retValue;
        Preferences p = Preferences.userNodeForPackage(DynamicJasperReportPanel.class);
        JFileChooser fileChooser = new JFileChooser();
        for (JRSaveContributor saveContributor : this.saveContributors) {
            fileChooser.addChoosableFileFilter((FileFilter)saveContributor);
        }
        if (p.get(LAST_CONTRIBUTOR, null) != null) {
            String last = p.get(LAST_CONTRIBUTOR, null);
            for (JRSaveContributor saveContributor : this.saveContributors) {
                if (!saveContributor.getDescription().equals(last)) continue;
                fileChooser.setFileFilter((FileFilter)saveContributor);
                break;
            }
        } else if (!this.saveContributors.isEmpty()) {
            fileChooser.setFileFilter((FileFilter)this.saveContributors.get(0));
        }
        if (p.get(LAST_DIRECTORY, null) != null) {
            fileChooser.setCurrentDirectory(new File(p.get(LAST_DIRECTORY, null)));
        }
        if ((retValue = fileChooser.showSaveDialog(this)) == 0) {
            FileFilter fileFilter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            p.put(LAST_DIRECTORY, file.getParent());
            JRSaveContributor contributor = null;
            if (fileFilter instanceof JRSaveContributor) {
                contributor = (JRSaveContributor)fileFilter;
            } else {
                for (JRSaveContributor saveContributor : this.saveContributors) {
                    if (!saveContributor.accept(file)) continue;
                    contributor = saveContributor;
                    break;
                }
                if (contributor == null) {
                    JOptionPane.showMessageDialog(this, this.getBundleString("error.saving"));
                }
            }
            if (contributor != null) {
                p.put(LAST_CONTRIBUTOR, contributor.getDescription());
                try {
                    if (contributor.getDescription().contains("CSV")) {
                        System.out.println("Formating for csv file");
                        JasperPrint print = this.report.createJasperPrint(true);
                        contributor.save(print, file);
                    } else {
                        contributor.save(this.jPrint, file);
                    }
                }
                catch (JRException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, this.getBundleString("error.saving"));
                }
            }
        }
    }

    private void printAction() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicJasperReportPanel.this.printButton.setEnabled(false);
                DynamicJasperReportPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                class PrintWorker
                extends SwingWorker<Void, Void> {
                    final /* synthetic */ DynamicJasperReportPanel this$0;

                    PrintWorker(DynamicJasperReportPanel dynamicJasperReportPanel) {
                        this.this$0 = dynamicJasperReportPanel;
                    }

                    public Void doInBackground() {
                        try {
                            JasperPrintManager.printReport((JasperPrint)DynamicJasperReportPanel.access$300(this.this$0), (boolean)true);
                        }
                        catch (JRException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }

                    protected void done() {
                        try {
                            this.this$0.setCursor(Cursor.getPredefinedCursor(0));
                            this.this$0.printButton.setEnabled(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                new PrintWorker(DynamicJasperReportPanel.this).execute();
            }
        });
    }

    private void lastPageAction() {
        this.setPageIndex(this.jPrint.getPages().size() - 1);
        this.refreshPage();
    }

    private void nextPageAction() {
        this.setPageIndex(this.pageIndex + 1);
        this.refreshPage();
    }

    private void previousPageAction() {
        this.setPageIndex(this.pageIndex - 1);
        this.refreshPage();
    }

    private void firstPageAction() {
        this.setPageIndex(0);
        this.refreshPage();
    }

    private void forceRefresh() {
        if (this.jPrint != null) {
            this.refreshPage();
            this.frame.setReportName(this.report.getReportName());
            return;
        }
        this.zoom = 0.0f;
        this.realZoom = 0.0f;
        this.setZoomRatio(1.0f);
    }

    private void zoomInAction() {
        this.actualSizeButton.setSelected(false);
        this.fitPageButton.setSelected(false);
        this.fitWidthButton.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index < 0) {
            this.setZoomRatio((float)this.zooms[-index - 1] / 100.0f);
        } else if (index < this.zoomComboBox.getModel().getSize() - 1) {
            this.setZoomRatio((float)this.zooms[index + 1] / 100.0f);
        }
    }

    private void zoomOutAction() {
        this.actualSizeButton.setSelected(false);
        this.fitPageButton.setSelected(false);
        this.fitWidthButton.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index > 0) {
            this.setZoomRatio((float)this.zooms[index - 1] / 100.0f);
        } else if (index < -1) {
            this.setZoomRatio((float)this.zooms[-index - 2] / 100.0f);
        }
    }

    private void zoomAction() {
        float newZoom = this.getZoomRatio();
        if (newZoom < this.MIN_ZOOM) {
            newZoom = this.MIN_ZOOM;
        }
        if (newZoom > this.MAX_ZOOM) {
            newZoom = this.MAX_ZOOM;
        }
        this.setZoomRatio(newZoom);
    }

    private void pageSetupAction() {
        PageFormat oldFormat = this.report.getPageFormat();
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.pageDialog(oldFormat);
        if (format != oldFormat) {
            this.report.setPageFormat(format);
            this.refreshReport();
        }
    }

    protected void refreshReport() {
        new ReportWorker().execute();
    }

    private void setPageIndex(int index) {
        if (this.jPrint != null && this.jPrint.getPages() != null && !this.jPrint.getPages().isEmpty()) {
            if (index >= 0 && index < this.jPrint.getPages().size()) {
                this.pageIndex = index;
                this.firstButton.setEnabled(this.pageIndex > 0);
                this.previousButton.setEnabled(this.pageIndex > 0);
                this.nextButton.setEnabled(this.pageIndex < this.jPrint.getPages().size() - 1);
                this.lastButton.setEnabled(this.pageIndex < this.jPrint.getPages().size() - 1);
                this.frame.setStatus(MessageFormat.format(this.getBundleString("page"), this.pageIndex + 1, this.jPrint.getPages().size()));
            }
        } else {
            this.firstButton.setEnabled(false);
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
            this.frame.setStatus("");
        }
    }

    private void loadReport(JasperPrint jasperPrint) {
        this.jPrint = jasperPrint;
        this.setPageIndex(0);
    }

    private void refreshPage() {
        if (this.jPrint == null || this.jPrint.getPages() == null || this.jPrint.getPages().isEmpty()) {
            this.pageGluePanel.setVisible(false);
            this.saveButton.setEnabled(false);
            this.printButton.setEnabled(false);
            this.actualSizeButton.setEnabled(false);
            this.fitPageButton.setEnabled(false);
            this.fitWidthButton.setEnabled(false);
            this.zoomInButton.setEnabled(false);
            this.zoomOutButton.setEnabled(false);
            this.zoomComboBox.setEnabled(false);
            if (this.jPrint != null) {
                JOptionPane.showMessageDialog(this, this.getBundleString("no.pages"));
            }
            return;
        }
        this.pageGluePanel.setVisible(true);
        this.saveButton.setEnabled(true);
        this.printButton.setEnabled(true);
        this.actualSizeButton.setEnabled(true);
        this.fitPageButton.setEnabled(true);
        this.fitWidthButton.setEnabled(true);
        this.zoomInButton.setEnabled(this.zoom < this.MAX_ZOOM);
        this.zoomOutButton.setEnabled(this.zoom > this.MIN_ZOOM);
        this.zoomComboBox.setEnabled(true);
        Dimension dim = new Dimension((int)((float)this.jPrint.getPageWidth() * this.realZoom) + 8, (int)((float)this.jPrint.getPageHeight() * this.realZoom) + 8);
        this.pageGluePanel.setMaximumSize(dim);
        this.pageGluePanel.setMinimumSize(dim);
        this.pageGluePanel.setPreferredSize(dim);
        this.spaceHoldPanel.removeAll();
        this.pageRenderer.setIcon(null);
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    private void emptyContainer(Container container) {
        Component[] components = container.getComponents();
        if (components != null) {
            for (Component component1 : components) {
                if (!(component1 instanceof Container)) continue;
                this.emptyContainer((Container)component1);
            }
        }
        container.removeAll();
    }

    private float getZoomRatio() {
        float newZoom;
        try {
            newZoom = this.zoomFormat.parse((String)this.zoomComboBox.getEditor().getItem()).floatValue() / 100.0f;
        }
        catch (ParseException e) {
            newZoom = this.zoom;
        }
        return newZoom;
    }

    private void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.zoomComboBox.getEditor().setItem(this.zoomFormat.format(newZoom * 100.0f) + "%");
            if (this.zoom != newZoom) {
                this.zoom = newZoom;
                this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
                this.refreshPage();
            }
        }
    }

    private void setRealZoomRatio(float newZoom) {
        if (newZoom > 0.0f && this.realZoom != newZoom) {
            this.zoom = newZoom * 72.0f / (float)this.screenResolution;
            this.realZoom = newZoom;
            this.zoomComboBox.getEditor().setItem(this.zoomFormat.format(this.zoom * 100.0f) + "%");
            this.refreshPage();
        }
    }

    private JRGraphics2DExporter getGraphics2DExporter() throws JRException {
        return new JRGraphics2DExporter();
    }

    private void paintPage(Graphics2D g) {
        if (this.jPrint == null) {
            return;
        }
        try {
            if (this.exporter == null) {
                this.exporter = this.getGraphics2DExporter();
            } else {
                this.exporter.reset();
            }
            this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.jPrint);
            this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)g.create());
            this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)this.pageIndex);
            this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)Float.valueOf(this.realZoom));
            this.exporter.setParameter(JRExporterParameter.OFFSET_X, (Object)1);
            this.exporter.setParameter(JRExporterParameter.OFFSET_Y, (Object)1);
            this.exporter.exportReport();
        }
        catch (Exception e) {
            e.printStackTrace();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(DynamicJasperReportPanel.this, DynamicJasperReportPanel.this.getBundleString("error.displaying"));
                }
            });
        }
    }

    private void fitPage() {
        float widthRatio;
        float heightRatio = ((float)this.scrollPanePanel.getVisibleRect().getHeight() - 20.0f) / (float)this.jPrint.getPageHeight();
        this.setRealZoomRatio(heightRatio < (widthRatio = ((float)this.scrollPanePanel.getVisibleRect().getWidth() - 20.0f) / (float)this.jPrint.getPageWidth()) ? heightRatio : widthRatio);
    }

    private void fontAction() {
        int newSize;
        int oldSize = this.report.getBaseFontSize();
        if (oldSize != (newSize = ((Integer)this.fontSizeComboBox.getSelectedItem()).intValue())) {
            this.report.setBaseFontSize(newSize);
            this.refreshReport();
        }
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e.getSource() == DynamicJasperReportPanel.this.saveButton) {
                    DynamicJasperReportPanel.this.saveAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.printButton) {
                    DynamicJasperReportPanel.this.printAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.pageSetupButton) {
                    DynamicJasperReportPanel.this.pageSetupAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.firstButton) {
                    DynamicJasperReportPanel.this.firstPageAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.previousButton) {
                    DynamicJasperReportPanel.this.previousPageAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.nextButton) {
                    DynamicJasperReportPanel.this.nextPageAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.lastButton) {
                    DynamicJasperReportPanel.this.lastPageAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.actualSizeButton) {
                    DynamicJasperReportPanel.this.actualSizeAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.fitPageButton) {
                    DynamicJasperReportPanel.this.fitPageAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.fitWidthButton) {
                    DynamicJasperReportPanel.this.fitWidthAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.zoomInButton) {
                    DynamicJasperReportPanel.this.zoomInAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.zoomOutButton) {
                    DynamicJasperReportPanel.this.zoomOutAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.zoomComboBox) {
                    DynamicJasperReportPanel.this.zoomAction();
                } else if (e.getSource() == DynamicJasperReportPanel.this.fontSizeComboBox) {
                    DynamicJasperReportPanel.this.fontAction();
                }
            }
        });
    }

    static /* synthetic */ JasperPrint access$300(DynamicJasperReportPanel x0) {
        return x0.jPrint;
    }

    private class ReportWorker
    extends SwingWorker<JasperPrint, Object> {
        private ReportWorker() {
        }

        @Override
        public JasperPrint doInBackground() {
            DynamicJasperReportPanel.this.frame.displayWaitMessage(Resource.get().getString("Message.PleaseWait"));
            return DynamicJasperReportPanel.this.report.createJasperPrint(false);
        }

        @Override
        protected void done() {
            try {
                DynamicJasperReportPanel.this.loadReport((JasperPrint)this.get());
                DynamicJasperReportPanel.this.forceRefresh();
                DynamicJasperReportPanel.this.frame.stopWaitMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class PageRenderer
    extends JLabel {
        private DynamicJasperReportPanel viewer = null;

        protected PageRenderer(DynamicJasperReportPanel viewer) {
            this.viewer = viewer;
        }

        @Override
        public void paintComponent(Graphics g) {
            this.viewer.paintPage((Graphics2D)g.create());
        }
    }
}

