/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class RunningAccountBalanceChart {
    private final Resource rb = Resource.get();
    private final DatePanel startDateField = new DatePanel();
    private final DatePanel endDateField = new DatePanel();
    private JCheckBox subAccountCheckBox;
    private final AccountListComboBox combo = new AccountListComboBox();

    public static void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                RunningAccountBalanceChart chart = new RunningAccountBalanceChart();
                JPanel p = chart.createPanel();
                GenericCloseDialog d = new GenericCloseDialog(p);
                d.setTitle(rb.getString("Title.AccountBalance"));
                d.pack();
                d.setModal(false);
                d.setVisible(true);
            }
        });
    }

    private JPanel createPanel() {
        Date end = DateUtils.lastDayOfMonth(this.endDateField.getDate());
        Date start = DateUtils.previousYear(end);
        this.startDateField.setDate(start);
        JButton refreshButton = new JButton(this.rb.getString("Button.Refresh"));
        refreshButton.setIcon(Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.subAccountCheckBox = new JCheckBox();
        this.subAccountCheckBox.setText(this.rb.getString("Button.IncludeSubcategory"));
        JFreeChart chart = this.createVerticalXYBarChart(this.combo.getSelectedAccount());
        final ChartPanel chartPanel = new ChartPanel(chart);
        FormLayout layout = new FormLayout("p, 4dlu, p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        FormLayout dLayout = new FormLayout("p, 4dlu, p, 8dlu, p, 4dlu, p, 8dlu, p", "");
        DefaultFormBuilder dBuilder = new DefaultFormBuilder(dLayout);
        dBuilder.append(this.rb.getString("Label.StartDate"), (Component)this.startDateField);
        dBuilder.append(this.rb.getString("Label.EndDate"), (Component)this.endDateField);
        dBuilder.append((Component)refreshButton);
        builder.append(this.rb.getString("Label.Account"), (Component)this.combo);
        builder.nextLine();
        builder.append(" ", (Component)this.subAccountCheckBox);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)dBuilder.getPanel(), 3);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"fill:p:g"));
        builder.append((Component)chartPanel, 3);
        final JPanel panel = builder.getPanel();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningAccountBalanceChart.this.updateSubAccountBox();
                Account a = RunningAccountBalanceChart.this.combo.getSelectedAccount();
                if (a == null) {
                    return;
                }
                chartPanel.setChart(RunningAccountBalanceChart.this.createVerticalXYBarChart(a));
                panel.validate();
            }
        };
        this.updateSubAccountBox();
        this.combo.addActionListener(listener);
        refreshButton.addActionListener(listener);
        return panel;
    }

    private void updateSubAccountBox() {
        Account a = this.combo.getSelectedAccount();
        if (a == null) {
            return;
        }
        if (a.getChildCount() == 0) {
            this.subAccountCheckBox.setEnabled(false);
        } else {
            this.subAccountCheckBox.setEnabled(true);
        }
    }

    private JFreeChart createVerticalXYBarChart(Account a) {
        SimpleDateFormat df = new SimpleDateFormat("MM/yy");
        TimeSeriesCollection data = this.createTimeSeriesCollection(a);
        DateAxis dateAxis = new DateAxis(this.rb.getString("Column.Date"));
        dateAxis.setTickUnit(new DateTickUnit(1, 1, (DateFormat)df));
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        Date start = DateUtils.firstDayOfMonth(this.startDateField.getDate());
        Date end = DateUtils.lastDayOfMonth(this.endDateField.getDate());
        dateAxis.setRange(start, end);
        NumberAxis valueAxis = new NumberAxis(this.rb.getString("Column.Balance"));
        StandardXYToolTipGenerator tooltipGenerator = new StandardXYToolTipGenerator("{1}, {2}", (DateFormat)df, NumberFormat.getNumberInstance());
        XYBarRenderer renderer = new XYBarRenderer(0.2);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)tooltipGenerator);
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)dateAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        String title = this.rb.getString("Title.EndMonthBalance") + " - " + a.getPathName();
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBackgroundPaint(null);
        return chart;
    }

    private TimeSeriesCollection createTimeSeriesCollection(Account account) {
        if (this.subAccountCheckBox.isSelected()) {
            Date start = DateUtils.firstDayOfMonth(this.startDateField.getDate());
            Date stop = DateUtils.lastDayOfMonth(this.endDateField.getDate());
            List<Date> list = DateUtils.lastDaysOfMonth(start, stop);
            TimeSeries t = new TimeSeries((Comparable)((Object)this.rb.getString("Column.Month")), this.rb.getString("Column.Month"), this.rb.getString("Column.Balance"), Month.class);
            for (Date date : list) {
                Date date2 = DateUtils.lastDayOfMonth(date);
                BigDecimal bd_TotalAmount = this.calculateTotal(date2, account, account.getCurrencyNode());
                t.add((RegularTimePeriod)new Month(date), (Number)bd_TotalAmount);
            }
            return new TimeSeriesCollection(t);
        }
        boolean negate = false;
        List<Object> list = Collections.emptyList();
        int count = account.getTransactionCount();
        if (count > 0) {
            Date start = account.getTransactionAt(0).getDate();
            Date stop = account.getTransactionAt(count - 1).getDate();
            list = DateUtils.lastDaysOfMonth(start, stop);
        }
        TimeSeries t = new TimeSeries((Comparable)((Object)this.rb.getString("Column.Month")), this.rb.getString("Column.Month"), this.rb.getString("Column.Balance"), Month.class);
        AccountType type = account.getAccountType();
        if (type == AccountType.INCOME || type == AccountType.CREDIT || type == AccountType.EQUITY || type == AccountType.LIABILITY) {
            negate = true;
        }
        for (Date date : list) {
            Date d = DateUtils.lastDayOfMonth(date);
            if (negate) {
                t.add((RegularTimePeriod)new Month(date), (Number)account.getBalance(d).negate());
                continue;
            }
            t.add((RegularTimePeriod)new Month(date), (Number)account.getBalance(d));
        }
        return new TimeSeriesCollection(t);
    }

    private BigDecimal calculateTotal(Date d, Account account, CurrencyNode baseCurrency) {
        boolean negate = false;
        AccountType type = account.getAccountType();
        if (type == AccountType.INCOME) {
            negate = true;
        }
        BigDecimal total = negate ? account.getBalance(d, baseCurrency).negate() : account.getBalance(d, baseCurrency);
        for (int y = 0; y < account.getChildCount(); ++y) {
            total = total.add(this.calculateTotal(d, account.getChildren().get(y), baseCurrency));
        }
        return total;
    }
}

