/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.reconcile;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.register.table.PackableTableModel;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public abstract class AbstractReconcileTableModel
extends AbstractTableModel
implements MessageListener,
PackableTableModel {
    private static final long serialVersionUID = 6081316944824965273L;
    final Account account;
    private final Date openingDate;
    private List<RecTransaction> list = Collections.synchronizedList(new ArrayList());
    private final Resource rb = Resource.get();
    private String[] cNames = new String[]{this.rb.getString("Column.Clr"), this.rb.getString("Column.Date"), this.rb.getString("Column.Num"), this.rb.getString("Column.Payee"), this.rb.getString("Column.Amount")};
    private Class<?>[] cClass = new Class[]{String.class, Date.class, String.class, String.class, BigDecimal.class};
    private int[] columnWidths = new int[]{0, 0, 0, 99, 0};

    AbstractReconcileTableModel(Account account, Date openingDate) {
        assert (this.cNames.length == this.cClass.length);
        assert (account != null);
        this.account = account;
        this.openingDate = (Date)openingDate.clone();
        this.loadModel();
        MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION);
    }

    @Override
    public int[] getPreferredColumnWeights() {
        return (int[])this.columnWidths.clone();
    }

    private void loadModel() {
        for (Transaction t : this.account.getTransactions()) {
            if (!this.reconcilable(t)) continue;
            this.list.add(new RecTransaction(t));
        }
    }

    private boolean reconcilable(Transaction t) {
        return DateUtils.after(t.getDate(), this.openingDate) && this.isShowable(t);
    }

    abstract boolean isShowable(Transaction var1);

    @Override
    public int getColumnCount() {
        return this.cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.cNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.cClass[column];
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RecTransaction t = this.list.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (t.getReconciled().equals((Object)ReconciledState.RECONCILED)) {
                    return "\u2713";
                }
                return null;
            }
            case 1: {
                return t.getDate();
            }
            case 2: {
                return t.getNumber();
            }
            case 3: {
                return t.getPayee();
            }
            case 4: {
                return t.getAmount(this.account);
            }
        }
        return null;
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.ACCOUNT).equals(this.account)) {
            final Transaction transaction = (Transaction)event.getObject(MessageProperty.TRANSACTION);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case TRANSACTION_REMOVE: {
                            RecTransaction trans = AbstractReconcileTableModel.this.findTransaction(transaction);
                            if (trans == null) break;
                            int index = AbstractReconcileTableModel.this.list.indexOf(trans);
                            AbstractReconcileTableModel.this.list.remove(index);
                            AbstractReconcileTableModel.this.fireTableRowsDeleted(index, index);
                            break;
                        }
                        case TRANSACTION_ADD: {
                            if (!AbstractReconcileTableModel.this.isShowable(transaction)) break;
                            RecTransaction newTran = new RecTransaction(transaction);
                            int index = Collections.binarySearch(AbstractReconcileTableModel.this.list, newTran);
                            if (index >= 0) break;
                            index = -index - 1;
                            AbstractReconcileTableModel.this.list.add(index, newTran);
                            AbstractReconcileTableModel.this.fireTableRowsInserted(index, index);
                            break;
                        }
                    }
                }
            });
        }
    }

    public BigDecimal getReconciledTotal() {
        BigDecimal sum = BigDecimal.ZERO;
        for (RecTransaction t : this.list) {
            if (t.getReconciled() != ReconciledState.RECONCILED) continue;
            sum = sum.add(t.getAmount(this.account));
        }
        return sum;
    }

    private synchronized RecTransaction findTransaction(Transaction t) {
        if (t != null) {
            for (RecTransaction tran : this.list) {
                if (tran.transaction != t) continue;
                return tran;
            }
        }
        return null;
    }

    protected void toggleReconciledState(int index) {
        RecTransaction t = this.list.get(index);
        if (t.getReconciled() == ReconciledState.RECONCILED) {
            t.setReconciled(ReconciledState.NOT_RECONCILED);
        } else {
            t.setReconciled(ReconciledState.RECONCILED);
        }
        this.fireTableRowsUpdated(index, index);
    }

    protected void selectAll() {
        for (RecTransaction aList : this.list) {
            aList.setReconciled(ReconciledState.RECONCILED);
        }
        this.fireTableRowsUpdated(0, this.list.size() - 1);
    }

    protected void clearAll() {
        for (RecTransaction aList : this.list) {
            aList.setReconciled(ReconciledState.NOT_RECONCILED);
        }
        this.fireTableRowsUpdated(0, this.list.size() - 1);
    }

    protected void commitChanges() {
        Object[] transactions;
        Engine engine = EngineFactory.getEngine("default");
        for (Object transaction : transactions = this.list.toArray()) {
            RecTransaction tran = (RecTransaction)transaction;
            if (tran.getReconciled() == tran.transaction.getReconciled(this.account)) continue;
            engine.setTransactionReconciled(tran.transaction, this.account, tran.getReconciled());
        }
    }

    private class RecTransaction
    implements Comparable<RecTransaction> {
        private ReconciledState reconciled;
        Transaction transaction;

        protected RecTransaction(Transaction transaction) {
            assert (transaction != null);
            this.transaction = transaction;
            this.reconciled = transaction.getReconciled(AbstractReconcileTableModel.this.account);
        }

        public Date getDate() {
            return this.transaction.getDate();
        }

        public String getNumber() {
            return this.transaction.getNumber();
        }

        public String getPayee() {
            return this.transaction.getPayee();
        }

        public ReconciledState getReconciled() {
            return this.reconciled;
        }

        public void setReconciled(ReconciledState reconciled) {
            this.reconciled = reconciled;
        }

        BigDecimal getAmount(Account a) {
            if (this.transaction instanceof InvestmentTransaction && a.memberOf(AccountGroup.INVEST)) {
                return ((InvestmentTransaction)this.transaction).getMarketValue().add(this.transaction.getAmount(a));
            }
            return this.transaction.getAmount(a);
        }

        public int hashCode() {
            return this.transaction.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result = true;
            if (obj == null) {
                result = false;
            }
            if (!(obj instanceof RecTransaction)) {
                result = false;
            }
            RecTransaction other = (RecTransaction)obj;
            if (this.reconciled != other.reconciled) {
                result = false;
            }
            if (!(this.transaction == other.transaction || this.transaction != null && this.transaction.equals(other.transaction))) {
                result = false;
            }
            return result;
        }

        @Override
        public int compareTo(RecTransaction t) {
            return this.transaction.compareTo(t.transaction);
        }
    }
}

