/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.commodity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.ExchangeRate;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.net.currency.CurrencyUpdateFactory;
import jgnash.ui.components.ColoredDateTableCellRenderer;
import jgnash.ui.components.CurrencyComboBox;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class CurrencyExchangeDialog
extends JDialog
implements MessageListener,
ActionListener,
ListSelectionListener {
    private final Resource rb = Resource.get();
    private CurrencyComboBox baseCurrencyCombo;
    private CurrencyComboBox exchangeCurrencyCombo;
    private Timer timer;
    private static final int DELAY = 250;
    private CurrencyUpdateFactory.ExchangeRateUpdateWorker updateWorker;
    private JFloatField rateField = new JFloatField(0, 6, 2);
    private JButton updateButton;
    private JButton deleteButton;
    private JButton stopButton;
    private JButton clearButton;
    private JButton addButton;
    private JProgressBar progressBar;
    private JButton closeButton;
    private DatePanel dateField;
    private JTable table;
    private HistoryModel model;

    public static void showDialog(final JFrame parent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurrencyExchangeDialog d = new CurrencyExchangeDialog(parent);
                DialogUtils.addBoundsListener(d);
                d.setVisible(true);
            }
        });
    }

    private CurrencyExchangeDialog(JFrame parent) {
        super((Frame)parent, true);
        this.setTitle(this.rb.getString("Title.EditExchangeRates"));
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
    }

    private static Engine getEngine() {
        return EngineFactory.getEngine("default");
    }

    private void updateModel() {
        CurrencyNode base = (CurrencyNode)this.baseCurrencyCombo.getSelectedNode();
        CurrencyNode exchange = (CurrencyNode)this.exchangeCurrencyCombo.getSelectedNode();
        if (base != null && exchange != null) {
            ExchangeRate rate = CurrencyExchangeDialog.getEngine().getExchangeRateNode(base, exchange);
            this.model.setExchangeRate(rate);
        }
    }

    private void initComponents() {
        this.baseCurrencyCombo = new CurrencyComboBox();
        this.exchangeCurrencyCombo = new CurrencyComboBox();
        this.model = new HistoryModel();
        this.dateField = new DatePanel();
        this.baseCurrencyCombo.addActionListener(this);
        this.exchangeCurrencyCombo.addActionListener(this);
        this.table = new JTable(this.model);
        this.table.setPreferredScrollableViewportSize(new Dimension(150, 150));
        this.table.setDefaultRenderer(Date.class, new ColoredDateTableCellRenderer());
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setRowSorter(new TableRowSorter<HistoryModel>(this.model));
        this.table.setFillsViewportHeight(true);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.closeButton = new JButton(this.rb.getString("Button.Close"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.clearButton = new JButton(this.rb.getString("Button.Clear"));
        this.addButton = new JButton(this.rb.getString("Button.Add"));
        this.updateButton = new JButton(this.rb.getString("Button.UpdateOnline"));
        this.updateButton.setIcon(Resource.getIcon("/jgnash/resource/applications-internet.png"));
        this.progressBar = new JProgressBar();
        this.stopButton = new JButton(this.rb.getString("Button.Stop"));
        this.stopButton.setIcon(Resource.getIcon("/jgnash/resource/process-stop.png"));
        this.stopButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurrencyExchangeDialog.this.updateModel();
            }
        });
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("f:p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.Currencies"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.layoutTopPanel());
        builder.appendSeparator(this.rb.getString("Title.ExchangeRate"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"f:max(50dlu;p):g"));
        builder.append((Component)this.layoutMiddlePanel());
        builder.appendSeparator();
        builder.append((Component)this.layoutBottomPanel());
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildCloseBar((JButton)this.closeButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private JPanel layoutTopPanel() {
        FormLayout layout = new FormLayout("p, $lcgap, p, 4dlu, p, $lcgap, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(this.rb.getString("Word.Exchange"), (Component)this.baseCurrencyCombo);
        builder.append(this.rb.getString("Word.Into"), (Component)this.exchangeCurrencyCombo);
        return builder.getPanel();
    }

    private JPanel layoutMiddlePanel() {
        FormLayout layout = new FormLayout("p, $lcgap, max(55dlu;p), 6dlu, p, $lcgap, max(45dlu;p), p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(this.rb.getString("Label.Date"), (Component)this.dateField);
        builder.append(this.rb.getString("Label.ExchangeRate"), (Component)this.rateField);
        builder.appendUnrelatedComponentsGapRow();
        builder.nextRow();
        builder.append((Component)ButtonBarFactory.buildLeftAlignedBar((JButton)this.addButton, (JButton)this.deleteButton, (JButton)this.clearButton), 8);
        builder.nextRow();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextRow();
        builder.appendRow(RowSpec.decode((String)"f:p:g"));
        builder.append((Component)new JScrollPane(this.table), 8);
        return builder.getPanel();
    }

    private JPanel layoutBottomPanel() {
        FormLayout layout = new FormLayout("p, 8dlu, 60dlu:g, 8dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.updateButton, (Component)this.progressBar, (Component)this.stopButton);
        return builder.getPanel();
    }

    private void stopOnlineUpdate() {
        if (this.updateWorker != null && !this.updateWorker.isDone()) {
            this.updateWorker.cancel(false);
        }
    }

    private void updateForm() {
        int row = this.table.getSelectedRow();
        if (row >= 0) {
            ExchangeRateHistoryNode node = this.getSelectedExchangeRate().getHistory().get(row);
            this.rateField.setDecimal(node.getRate());
            this.dateField.setDate(node.getDate());
        }
    }

    private void addExchangeRate() {
        if (this.validateForm()) {
            CurrencyNode src = (CurrencyNode)this.baseCurrencyCombo.getSelectedNode();
            CurrencyNode dst = (CurrencyNode)this.exchangeCurrencyCombo.getSelectedNode();
            CurrencyExchangeDialog.getEngine().setExchangeRate(src.getSymbol(), dst.getSymbol(), this.rateField.getDecimal(), this.dateField.getDate());
            this.clearForm();
        }
    }

    private ExchangeRate getSelectedExchangeRate() {
        CurrencyNode src = (CurrencyNode)this.baseCurrencyCombo.getSelectedNode();
        CurrencyNode dst = (CurrencyNode)this.exchangeCurrencyCombo.getSelectedNode();
        return CurrencyExchangeDialog.getEngine().getExchangeRateNode(src, dst);
    }

    private void removeExchangeRates() {
        ExchangeRate rate = this.getSelectedExchangeRate();
        if (rate != null) {
            int i;
            int[] rows = this.table.getSelectedRows();
            List<ExchangeRateHistoryNode> history = rate.getHistory();
            ExchangeRateHistoryNode[] temp = new ExchangeRateHistoryNode[rows.length];
            for (i = 0; i < rows.length; ++i) {
                temp[i] = history.get(rows[i]);
            }
            for (i = rows.length - 1; i >= 0; --i) {
                EngineFactory.getEngine("default").removeExchangeRateHistory(rate, temp[i]);
            }
        }
    }

    private void clearForm() {
        this.table.clearSelection();
        this.rateField.setDecimal(null);
    }

    private boolean validateForm() {
        if (this.rateField.getText().length() == 0) {
            return false;
        }
        if (this.rateField.getDecimal().compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        return this.dateField.getDateField().getText().length() != 0;
    }

    private void updateExchangeRates() {
        this.updateButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.updateWorker = new CurrencyUpdateFactory.ExchangeRateUpdateWorker();
        this.createTimer();
        this.timer.start();
        this.updateWorker.execute();
    }

    private void createTimer() {
        this.timer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CurrencyExchangeDialog.this.progressBar.setValue(CurrencyExchangeDialog.this.updateWorker.getProgress());
                if (CurrencyExchangeDialog.this.updateWorker.isDone()) {
                    CurrencyExchangeDialog.this.progressBar.setValue(100);
                    CurrencyExchangeDialog.this.timer.stop();
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CurrencyExchangeDialog.this.timer = null;
                    CurrencyExchangeDialog.this.stopButton.setEnabled(false);
                    CurrencyExchangeDialog.this.updateButton.setEnabled(true);
                    CurrencyExchangeDialog.this.progressBar.setValue(0);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addExchangeRate();
        } else if (e.getSource() == this.clearButton) {
            this.clearForm();
        } else if (e.getSource() == this.deleteButton) {
            this.removeExchangeRates();
        } else if (e.getSource() == this.updateButton) {
            this.updateExchangeRates();
        } else if (e.getSource() == this.stopButton) {
            this.stopOnlineUpdate();
        } else if (e.getSource() == this.closeButton) {
            MessageBus.getInstance().unregisterListener(this, MessageChannel.COMMODITY);
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.baseCurrencyCombo) {
            this.updateModel();
        } else if (e.getSource() == this.exchangeCurrencyCombo) {
            this.updateModel();
        }
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case EXCHANGERATE_ADD: 
                    case EXCHANGERATE_REMOVE: {
                        ExchangeRate rate = (ExchangeRate)event.getObject(MessageProperty.EXCHANGERATE);
                        if (!rate.equals(CurrencyExchangeDialog.this.getSelectedExchangeRate())) break;
                        CurrencyExchangeDialog.this.updateModel();
                    }
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.updateForm();
        }
    }

    private class HistoryModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -2260325388942357562L;
        private ExchangeRate exchangeRate;
        private String[] cNames;
        private Class<?>[] cClass;
        private NumberFormat decimalFormat;
        private List<ExchangeRateHistoryNode> history;
        private boolean invert;

        public HistoryModel() {
            this.cNames = new String[]{CurrencyExchangeDialog.this.rb.getString("Column.Date"), CurrencyExchangeDialog.this.rb.getString("Column.ExchangeRate")};
            this.cClass = new Class[]{Date.class, String.class};
            this.history = new ArrayList<ExchangeRateHistoryNode>();
            this.invert = false;
            this.decimalFormat = NumberFormat.getInstance();
            if (this.decimalFormat instanceof DecimalFormat) {
                this.decimalFormat.setMinimumFractionDigits(6);
                this.decimalFormat.setMaximumFractionDigits(6);
            }
        }

        public void setExchangeRate(ExchangeRate exchangeRate) {
            this.exchangeRate = exchangeRate;
            this.history = this.exchangeRate.getHistory();
            CurrencyNode base = (CurrencyNode)CurrencyExchangeDialog.this.baseCurrencyCombo.getSelectedNode();
            this.invert = !exchangeRate.getRateId().startsWith(base.getSymbol());
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.cClass[column];
        }

        @Override
        public int getRowCount() {
            if (this.history != null) {
                return this.history.size();
            }
            return 0;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.history != null) {
                switch (col) {
                    case 0: {
                        return this.history.get(row).getDate();
                    }
                    case 1: {
                        if (this.invert) {
                            BigDecimal rate = this.history.get(row).getRate();
                            return this.decimalFormat.format(BigDecimal.ONE.divide(rate, rate.scale(), Engine.getRoundingMode()));
                        }
                        return this.decimalFormat.format(this.history.get(row).getRate());
                    }
                }
                return "Error";
            }
            return null;
        }
    }
}

