/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import jgnash.engine.Engine;
import jgnash.ui.UIApplication;
import jgnash.ui.components.MemoryMonitor;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

class ConsoleDialog {
    private static JTextArea console;
    private static JDialog dialog;
    private static boolean init;
    private static final Object consoleLock;

    private ConsoleDialog() {
    }

    private static void init() {
        if (!init) {
            init = true;
            final PrintStream oldOut = System.out;
            final PrintStream oldErr = System.err;
            PrintStream outStream = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(byte[] b, int off, int len) {
                    oldOut.write(b, off, len);
                    Object object = consoleLock;
                    synchronized (object) {
                        if (console != null) {
                            console.append(new String(b, off, len));
                        }
                    }
                }
            });
            PrintStream errStream = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(byte[] b, int off, int len) {
                    oldErr.write(b, off, len);
                    Object object = consoleLock;
                    synchronized (object) {
                        if (console != null) {
                            console.append(new String(b, off, len));
                        }
                    }
                }
            });
            System.setOut(outStream);
            System.setErr(errStream);
            Logger.getLogger(Engine.class.getName()).addHandler(new Handler(){

                @Override
                public void close() throws SecurityException {
                }

                @Override
                public void flush() {
                }

                @Override
                public void publish(final LogRecord record) {
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = consoleLock;
                            synchronized (object) {
                                if (console != null) {
                                    console.append(record.getMessage() + "\n");
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    private static void dumpHeap() {
        String base = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
        String filesep = System.getProperty("file.separator");
        File dumpFile = null;
        for (int i = 1; i < 1000 && (dumpFile = new File(base + filesep + "jGnashHeapDump" + i + ".bin")).exists(); ++i) {
        }
        if (dumpFile != null) {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
                System.gc();
                System.gc();
                System.gc();
                System.gc();
                bean.dumpHeap(dumpFile.getAbsolutePath(), true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void show() {
        if (dialog == null) {
            ConsoleDialog.init();
            Resource rb = Resource.get();
            JButton copyButton = new JButton(rb.getString("Button.CopyToClip"));
            copyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (console != null) {
                        console.selectAll();
                        console.copy();
                    }
                }
            });
            JButton gcButton = new JButton(rb.getString("Button.ForceGC"));
            gcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (console != null) {
                        System.gc();
                        System.gc();
                        System.gc();
                        System.gc();
                    }
                }
            });
            JButton heapButton = new JButton(rb.getString("Button.CreateHeapDump"));
            heapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (console != null) {
                        ConsoleDialog.dumpHeap();
                    }
                }
            });
            dialog = new JDialog((Window)((Object)UIApplication.getFrame()), Dialog.ModalityType.MODELESS);
            dialog.setTitle(rb.getString("Title.ConsoleWindow"));
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = consoleLock;
                            synchronized (object) {
                                ConsoleDialog.close();
                            }
                        }
                    });
                }
            });
            Object object = consoleLock;
            synchronized (object) {
                console = new JTextArea();
                console.setEditable(false);
                console.setFont(new Font("Monospaced", 0, console.getFont().getSize()));
            }
            JPanel panel = new JPanel();
            panel.setBorder(Borders.DIALOG_BORDER);
            panel.setLayout(new BorderLayout());
            panel.add((Component)new MemoryMonitor(), "North");
            panel.add((Component)new JScrollPane(console), "Center");
            JPanel buttonPanel = ButtonBarFactory.buildRightAlignedBar((JButton)heapButton, (JButton)gcButton, (JButton)copyButton);
            buttonPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
            panel.add((Component)buttonPanel, "South");
            dialog.getContentPane().add((Component)panel, "Center");
            dialog.pack();
            dialog.setMinimumSize(dialog.getSize());
            dialog.setLocationRelativeTo(null);
            dialog.setFocusableWindowState(false);
            dialog.setDefaultCloseOperation(2);
            DialogUtils.addBoundsListener(dialog);
            dialog.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close() {
        Object object = consoleLock;
        synchronized (object) {
            if (dialog != null) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
                dialog = null;
                console = null;
            }
        }
    }

    static {
        init = false;
        consoleLock = new Object();
    }
}

