/*
 * Decompiled with CFR 0.152.
 */
package jgnash.message;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jgnash.message.Message;
import jgnash.message.MessageBusRemoteClient;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.util.DefaultDaemonThreadFactory;

public class MessageBus {
    private Logger logger = Logger.getLogger(MessageBus.class.getName());
    private Map<MessageChannel, Set<WeakReference<MessageListener>>> map = new ConcurrentHashMap<MessageChannel, Set<WeakReference<MessageListener>>>();
    private final ExecutorService pool = Executors.newSingleThreadExecutor(new DefaultDaemonThreadFactory());
    private MessageBusRemoteClient messageBusClient = null;
    private static Map<String, MessageBus> busMap = new HashMap<String, MessageBus>();
    private static final String DEFAULT = "default";

    private MessageBus() {
    }

    public synchronized boolean setRemote(String host, int port) {
        this.disconnectFromServer();
        return this.connectToServer(host, port);
    }

    public synchronized void setLocal() {
        this.disconnectFromServer();
    }

    public static synchronized MessageBus getInstance() {
        return MessageBus.getInstance(DEFAULT);
    }

    public static synchronized MessageBus getInstance(String name) {
        MessageBus bus = busMap.get(name);
        if (bus == null) {
            bus = new MessageBus();
            busMap.put(name, bus);
        }
        return bus;
    }

    private void disconnectFromServer() {
        if (this.messageBusClient != null) {
            this.messageBusClient.disconnectFromServer();
            this.messageBusClient = null;
        }
    }

    private boolean connectToServer(String remoteHost, int remotePort) {
        assert (remoteHost != null & remotePort > 0);
        this.messageBusClient = new MessageBusRemoteClient(remoteHost, remotePort);
        boolean result = this.messageBusClient.connectToServer();
        if (!result) {
            this.messageBusClient = null;
        }
        return result;
    }

    public void registerListener(MessageListener listener, MessageChannel key) {
        Set<WeakReference<MessageListener>> set = this.map.get((Object)key);
        if (set == null) {
            set = new CopyOnWriteArraySet<WeakReference<MessageListener>>();
            this.map.put(key, set);
        }
        if (this.containsListener(listener, key)) {
            this.logger.warning("Tried to install duplicate listener");
            new Exception().printStackTrace();
        } else {
            set.add(new WeakReference<MessageListener>(listener));
        }
    }

    public void unregisterListener(MessageListener listener, MessageChannel key) {
        Set<WeakReference<MessageListener>> set = this.map.get((Object)key);
        if (set != null) {
            for (WeakReference<MessageListener> ref : set) {
                MessageListener l = (MessageListener)ref.get();
                if (l != null && l != listener) continue;
                set.remove(ref);
            }
        }
    }

    private boolean containsListener(MessageListener listener, MessageChannel key) {
        Set<WeakReference<MessageListener>> set = this.map.get((Object)key);
        if (set != null) {
            for (WeakReference<MessageListener> ref : set) {
                MessageListener l = (MessageListener)ref.get();
                if (l != listener) continue;
                return true;
            }
        }
        return false;
    }

    public void fireEvent(Message message) {
        Set<WeakReference<MessageListener>> set = this.map.get((Object)message.getChannel());
        if (set != null) {
            this.pool.execute(new MessageHandler(message, set));
        }
    }

    private void _shutdown() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
                if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static void shutdown() {
        MessageBus.getInstance()._shutdown();
    }

    private final class MessageHandler
    implements Runnable {
        final Message message;
        final Set<WeakReference<MessageListener>> set;

        MessageHandler(Message event, Set<WeakReference<MessageListener>> set) {
            this.message = event;
            this.set = set;
        }

        @Override
        public void run() {
            for (WeakReference<MessageListener> ref : this.set) {
                MessageListener l = (MessageListener)ref.get();
                if (l == null) continue;
                l.messagePosted(this.message);
            }
            if (!this.message.isRemote() && MessageBus.this.messageBusClient != null && this.message.getChannel() != MessageChannel.SYSTEM) {
                MessageBus.this.messageBusClient.sendRemoteMessage(this.message);
            }
        }
    }
}

