/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.db4o;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityNode;
import jgnash.engine.dao.AccountDAO;
import jgnash.engine.db4o.AbstractDb4oDAO;

class Db4oAccountDAO
extends AbstractDb4oDAO
implements AccountDAO {
    private Logger logger = Logger.getLogger(Db4oAccountDAO.class.getName());

    Db4oAccountDAO(ObjectContainer container, boolean isRemote) {
        super(container, isRemote);
    }

    @Override
    public RootAccount getRootAccount() {
        RootAccount root = null;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            ObjectSet list = this.container.query(RootAccount.class);
            if (list.size() == 1) {
                root = (RootAccount)list.get(0);
            }
            if (list.size() > 1) {
                this.logger.severe("More than one RootAccount found");
                root = (RootAccount)list.get(0);
                ArrayList<RootAccount> emptyList = new ArrayList<RootAccount>();
                for (RootAccount a : list) {
                    if (a.getChildCount() > 0) {
                        root = a;
                        continue;
                    }
                    emptyList.add(a);
                }
                for (RootAccount a : emptyList) {
                    this.container.delete((Object)a);
                }
            }
            this.container.ext().releaseSemaphore("Lock");
        }
        return root;
    }

    @Override
    public List<Account> getAccountList() {
        ObjectSet list = Collections.emptyList();
        ArrayList<Account> resultList = new ArrayList<Account>();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            list = this.container.query(Account.class);
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        for (Account a : list) {
            if (a.isMarkedForRemoval()) continue;
            resultList.add(a);
        }
        return resultList;
    }

    @Override
    public boolean addAccount(Account parent, Account child) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)child);
            this.container.set((Object)parent);
            this.commit();
            result = true;
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean addRootAccount(RootAccount account) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)account);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean addAccountSecurity(Account account, SecurityNode node) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)node);
            this.container.set((Object)account);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public List<Account> getIncomeAccountList() {
        ObjectSet list = Collections.emptyList();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            list = this.container.query((Predicate)new AccountTypePredicate(AccountType.INCOME));
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return list;
    }

    @Override
    public List<Account> getExpenseAccountList() {
        ObjectSet list = Collections.emptyList();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            list = this.container.query((Predicate)new AccountTypePredicate(AccountType.EXPENSE));
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return list;
    }

    @Override
    public List<Account> getInvestmentAccountList() {
        ObjectSet list = Collections.emptyList();
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            list = this.container.query((Predicate)new AccountGroupPredicate(AccountGroup.INVEST));
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return list;
    }

    @Override
    public Account getAccountByUuid(String uuid) {
        Account account = null;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            Query query = this.container.query();
            query.constrain(Account.class);
            query.descend("uuid").constrain((Object)uuid);
            ObjectSet result = query.execute();
            if (result.size() == 1) {
                account = (Account)result.get(0);
            }
            this.container.ext().releaseSemaphore("Lock");
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return account;
    }

    @Override
    public boolean updateAccount(Account account) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)account);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean setAccountProperty(Account account, Object object) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set(object);
            this.container.set((Object)account);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean removeAccountProperty(Account account, Object object) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.delete(object);
            this.container.ext().purge(object);
            this.container.set((Object)account);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public boolean toggleAccountVisability(Account account) {
        boolean result = false;
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.set((Object)account);
            this.commit();
            this.container.ext().releaseSemaphore("Lock");
            result = true;
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
        return result;
    }

    @Override
    public void refreshAccount(Account account) {
        if (this.container.ext().setSemaphore("Lock", 20000)) {
            this.container.ext().refresh((Object)account, 4);
        } else {
            this.logger.severe("Could not obtain global semaphore");
        }
    }

    private static class AccountTypePredicate
    extends Predicate<Account> {
        private static final long serialVersionUID = -7268308931621048944L;
        private AccountType type;

        AccountTypePredicate(AccountType type) {
            this.type = type;
        }

        public boolean match(Account account) {
            return account.instanceOf(this.type) && !account.isMarkedForRemoval();
        }
    }

    private static class AccountGroupPredicate
    extends Predicate<Account> {
        private static final long serialVersionUID = -860987774949510386L;
        private AccountGroup group;

        AccountGroupPredicate(AccountGroup group) {
            this.group = group;
        }

        public boolean match(Account account) {
            return account.memberOf(this.group) && !account.isMarkedForRemoval();
        }
    }
}

