/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconcileManager;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryAddX;
import jgnash.engine.TransactionEntryBuyX;
import jgnash.engine.TransactionEntryDividendX;
import jgnash.engine.TransactionEntryMergeX;
import jgnash.engine.TransactionEntryReinvestDivX;
import jgnash.engine.TransactionEntryRemoveX;
import jgnash.engine.TransactionEntryRocX;
import jgnash.engine.TransactionEntrySellX;
import jgnash.engine.TransactionEntrySplitX;
import jgnash.engine.TransactionTag;
import jgnash.text.CommodityFormat;
import jgnash.util.Resource;

public class TransactionFactory {
    public static InvestmentTransaction generateAddXTransaction(Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, Date date, String memo, boolean reconciled) {
        assert (investmentAccount != null && node != null && price != null && quantity != null);
        assert (date != null && memo != null);
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntryAddX entry = new TransactionEntryAddX(investmentAccount, node, price, quantity);
        entry.setMemo(memo);
        transaction.setPayee(TransactionFactory.buildPayee("Word.Add", node, price, quantity));
        transaction.addTransactionEntry(entry);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        return transaction;
    }

    public static InvestmentTransaction import1xBuyXTransaction(Account account, Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, BigDecimal exchangeRate, BigDecimal fee, Date date, String memo) {
        assert (account != null && investmentAccount != null && node != null && price != null && quantity != null);
        assert (exchangeRate != null && fee != null && date != null && memo != null);
        ArrayList<TransactionEntry> fees = new ArrayList<TransactionEntry>();
        if (fee.compareTo(BigDecimal.ZERO) > 0) {
            TransactionEntry e = new TransactionEntry(investmentAccount, fee.negate());
            e.setMemo(memo);
            e.setTransactionTag(TransactionTag.INVESTMENT_FEE);
            fees.add(e);
        }
        return TransactionFactory.generateBuyXTransaction(account, investmentAccount, node, price, quantity, exchangeRate, date, memo, false, fees);
    }

    public static InvestmentTransaction generateBuyXTransaction(Account account, Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, BigDecimal exchangeRate, Date date, String memo, boolean reconciled, Collection<TransactionEntry> fees) {
        assert (account != null && investmentAccount != null && node != null && price != null && quantity != null);
        assert (exchangeRate != null && date != null && memo != null && fees != null);
        for (TransactionEntry fee : fees) {
            assert (fee.getTransactionTag().equals((Object)TransactionTag.INVESTMENT_FEE));
        }
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntryBuyX entry = new TransactionEntryBuyX(account, investmentAccount, node, price, quantity, exchangeRate);
        entry.setMemo(memo);
        transaction.setPayee(TransactionFactory.buildPayee("Word.Buy", node, price, quantity));
        transaction.addTransactionEntry(entry);
        if (!fees.isEmpty()) {
            BigDecimal nonCashBalanceFees = BigDecimal.ZERO;
            for (TransactionEntry fee : fees) {
                transaction.addTransactionEntry(fee);
                nonCashBalanceFees = nonCashBalanceFees.add(fee.getAmount(investmentAccount).abs());
            }
            if (!account.equals(investmentAccount)) {
                byte scale = account.getCurrencyNode().getScale();
                BigDecimal exchangedAmount = nonCashBalanceFees.abs().multiply(exchangeRate).setScale((int)scale, Engine.getRoundingMode());
                TransactionEntry tran = new TransactionEntry(investmentAccount, account, nonCashBalanceFees, exchangedAmount.negate());
                tran.setMemo(memo);
                tran.setTransactionTag(TransactionTag.INVESTMENT_CASH_TRANSFER);
                transaction.addTransactionEntry(tran);
            }
        }
        ReconcileManager.reconcileTransaction(account, (Transaction)transaction, reconciled);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        Logger.getLogger(TransactionFactory.class.getName()).info(transaction.toString());
        return transaction;
    }

    public static InvestmentTransaction generateDividendXTransaction(Account incomeAccount, Account investmentAccount, Account cashAccount, SecurityNode node, BigDecimal dividend, BigDecimal incomeExchangedAmount, BigDecimal cashExchangedAmount, Date date, String memo, boolean reconciled) {
        assert (incomeAccount != null && investmentAccount != null && cashAccount != null);
        assert (node != null && dividend != null);
        assert (incomeExchangedAmount != null && date != null && memo != null);
        assert (incomeExchangedAmount.signum() <= 0);
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntryDividendX entry = new TransactionEntryDividendX(incomeAccount, investmentAccount, node, dividend, incomeExchangedAmount);
        entry.setMemo(memo);
        Resource rb = Resource.get();
        CommodityFormat format = CommodityFormat.getFullFormat();
        StringBuilder payee = new StringBuilder(rb.getString("Word.Dividend") + " : ");
        payee.append(node.getSymbol()).append(" @ ");
        payee.append(format.format(dividend, incomeAccount.getCurrencyNode()));
        transaction.setPayee(payee.toString());
        transaction.addTransactionEntry(entry);
        if (!cashAccount.equals(investmentAccount)) {
            TransactionEntry tran = new TransactionEntry(cashAccount, investmentAccount, cashExchangedAmount, dividend.negate());
            tran.setMemo(memo);
            tran.setTransactionTag(TransactionTag.INVESTMENT_CASH_TRANSFER);
            transaction.addTransactionEntry(tran);
        }
        ReconcileManager.reconcileTransaction(incomeAccount, (Transaction)transaction, reconciled);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        ReconcileManager.reconcileTransaction(cashAccount, (Transaction)transaction, reconciled);
        return transaction;
    }

    public static InvestmentTransaction generateRocXTransaction(Account incomeAccount, Account investmentAccount, Account cashAccount, SecurityNode node, BigDecimal dividend, BigDecimal incomeExchangedAmount, BigDecimal cashExchangedAmount, Date date, String memo, boolean reconciled) {
        assert (incomeAccount != null && investmentAccount != null && cashAccount != null);
        assert (node != null && dividend != null);
        assert (incomeExchangedAmount != null && date != null && memo != null);
        assert (incomeExchangedAmount.signum() <= 0);
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntryRocX entry = new TransactionEntryRocX(incomeAccount, investmentAccount, node, dividend, incomeExchangedAmount);
        entry.setMemo(memo);
        Resource rb = Resource.get();
        CommodityFormat format = CommodityFormat.getFullFormat();
        StringBuilder payee = new StringBuilder(rb.getString("Word.ReturnOfCapital") + " : ");
        payee.append(node.getSymbol()).append(" @ ");
        payee.append(format.format(dividend, incomeAccount.getCurrencyNode()));
        transaction.setPayee(payee.toString());
        transaction.addTransactionEntry(entry);
        if (!cashAccount.equals(investmentAccount)) {
            TransactionEntry tran = new TransactionEntry(cashAccount, investmentAccount, cashExchangedAmount, dividend.negate());
            tran.setMemo(memo);
            tran.setTransactionTag(TransactionTag.INVESTMENT_CASH_TRANSFER);
            transaction.addTransactionEntry(tran);
        }
        ReconcileManager.reconcileTransaction(incomeAccount, (Transaction)transaction, reconciled);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        ReconcileManager.reconcileTransaction(cashAccount, (Transaction)transaction, reconciled);
        return transaction;
    }

    public static Transaction generateDoubleEntryTransaction(Account creditAccount, Account debitAccount, BigDecimal creditAmount, BigDecimal debitAmount, Date date, String memo, String payee, String number) {
        assert (creditAccount != debitAccount);
        Transaction transaction = new Transaction();
        transaction.setDate(date);
        transaction.setNumber(number);
        transaction.setPayee(payee);
        transaction.setMemo(memo);
        TransactionEntry entry = new TransactionEntry(creditAccount, debitAccount, creditAmount, debitAmount);
        entry.setMemo(memo);
        transaction.addTransactionEntry(entry);
        return transaction;
    }

    public static Transaction generateDoubleEntryTransaction(Account creditAccount, Account debitAccount, BigDecimal amount, Date date, String memo, String payee, String number) {
        assert (creditAccount != debitAccount);
        Transaction transaction = new Transaction();
        transaction.setDate(date);
        transaction.setNumber(number);
        transaction.setPayee(payee);
        transaction.setMemo(memo);
        TransactionEntry entry = new TransactionEntry(creditAccount, debitAccount, amount);
        entry.setMemo(memo);
        transaction.addTransactionEntry(entry);
        return transaction;
    }

    public static InvestmentTransaction generateMergeXTransaction(Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, Date date, String memo, boolean reconciled) {
        assert (investmentAccount != null && node != null && price != null && quantity != null);
        assert (date != null && memo != null);
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntryMergeX entry = new TransactionEntryMergeX(investmentAccount, node, price, quantity);
        entry.setMemo(memo);
        transaction.setPayee(TransactionFactory.buildPayee("Word.Merge", node, price, quantity));
        transaction.addTransactionEntry(entry);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        return transaction;
    }

    public static InvestmentTransaction generateReinvDividendXTransaction(Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, Date date, String memo, boolean reconciled, Collection<TransactionEntry> fees, Collection<TransactionEntry> gains) {
        assert (investmentAccount != null);
        assert (node != null);
        assert (date != null && memo != null);
        assert (fees != null && gains != null);
        for (TransactionEntry fee : fees) {
            assert (fee.getTransactionTag().equals((Object)TransactionTag.INVESTMENT_FEE));
        }
        for (TransactionEntry gain : gains) {
            assert (gain.getTransactionTag().equals((Object)TransactionTag.GAIN_LOSS));
        }
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntryReinvestDivX entry = new TransactionEntryReinvestDivX(investmentAccount, node, price, quantity);
        entry.setMemo(memo);
        Resource rb = Resource.get();
        CommodityFormat format = CommodityFormat.getFullFormat();
        StringBuilder payee = new StringBuilder(rb.getString("Word.ReInvDiv") + " : ");
        payee.append(node.getSymbol()).append(" ");
        payee.append(quantity.toString());
        payee.append(" @ ");
        payee.append(format.format(quantity, node));
        transaction.setPayee(payee.toString());
        transaction.addTransactionEntry(entry);
        for (TransactionEntry fee : fees) {
            transaction.addTransactionEntry(fee);
        }
        if (!gains.isEmpty()) {
            BigDecimal totalGains = BigDecimal.ZERO;
            for (TransactionEntry gain : gains) {
                transaction.addTransactionEntry(gain);
                totalGains = totalGains.add(gain.getAmount(investmentAccount));
            }
            TransactionEntry gainsOffestEntry = new TransactionEntry(investmentAccount, totalGains.negate());
            gainsOffestEntry.setMemo(memo);
            gainsOffestEntry.setTransactionTag(TransactionTag.GAINS_OFFSET);
            assert (gainsOffestEntry.isSingleEntry());
            transaction.addTransactionEntry(gainsOffestEntry);
        }
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        return transaction;
    }

    public static InvestmentTransaction generateRemoveXTransaction(Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, Date date, String memo, boolean reconciled) {
        assert (investmentAccount != null && node != null && price != null && quantity != null);
        assert (date != null && memo != null);
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntryRemoveX entry = new TransactionEntryRemoveX(investmentAccount, node, price, quantity);
        entry.setMemo(memo);
        transaction.setPayee(TransactionFactory.buildPayee("Word.Remove", node, price, quantity));
        transaction.addTransactionEntry(entry);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        return transaction;
    }

    public static InvestmentTransaction import1xSellXTransaction(Account account, Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, BigDecimal exchange, BigDecimal fee, Date date, String memo) {
        assert (account != null && investmentAccount != null && node != null && price != null && quantity != null);
        assert (exchange != null && fee != null && date != null && memo != null);
        ArrayList<TransactionEntry> fees = new ArrayList<TransactionEntry>();
        if (fee.compareTo(BigDecimal.ZERO) > 0) {
            TransactionEntry e = new TransactionEntry(investmentAccount, fee.negate());
            e.setMemo(memo);
            e.setTransactionTag(TransactionTag.INVESTMENT_FEE);
            fees.add(e);
        }
        return TransactionFactory.generateSellXTransaction(account, investmentAccount, node, price, quantity, exchange, date, memo, false, fees, new ArrayList<TransactionEntry>());
    }

    public static InvestmentTransaction generateSellXTransaction(Account account, Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, BigDecimal exchangeRate, Date date, String memo, boolean reconciled, Collection<TransactionEntry> fees, Collection<TransactionEntry> gains) {
        assert (account != null && investmentAccount != null);
        assert (node != null && price != null && quantity != null);
        assert (exchangeRate != null && fees != null && date != null && memo != null);
        for (TransactionEntry fee : fees) {
            assert (fee.getTransactionTag().equals((Object)TransactionTag.INVESTMENT_FEE));
        }
        for (TransactionEntry gain : gains) {
            assert (gain.getTransactionTag().equals((Object)TransactionTag.GAIN_LOSS));
        }
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntrySellX entry = new TransactionEntrySellX(account, investmentAccount, node, price, quantity, exchangeRate);
        entry.setMemo(memo);
        transaction.setPayee(TransactionFactory.buildPayee("Word.Sell", node, price, quantity));
        transaction.addTransactionEntry(entry);
        if (!fees.isEmpty()) {
            BigDecimal nonCashBalanceFees = BigDecimal.ZERO;
            for (TransactionEntry fee : fees) {
                transaction.addTransactionEntry(fee);
                nonCashBalanceFees = nonCashBalanceFees.add(fee.getAmount(investmentAccount).abs());
                if (account.equals(investmentAccount)) continue;
                byte scale = account.getCurrencyNode().getScale();
                BigDecimal exchangedAmount = nonCashBalanceFees.abs().multiply(exchangeRate).setScale((int)scale, Engine.getRoundingMode());
                TransactionEntry tran = new TransactionEntry(investmentAccount, account, nonCashBalanceFees, exchangedAmount.negate());
                tran.setMemo(memo);
                tran.setTransactionTag(TransactionTag.INVESTMENT_CASH_TRANSFER);
                transaction.addTransactionEntry(tran);
            }
        }
        if (!gains.isEmpty()) {
            BigDecimal totalGains = BigDecimal.ZERO;
            for (TransactionEntry gain : gains) {
                transaction.addTransactionEntry(gain);
                totalGains = totalGains.add(gain.getAmount(investmentAccount));
            }
            TransactionEntry gainsOffestEntry = new TransactionEntry(investmentAccount, totalGains.negate());
            gainsOffestEntry.setMemo(memo);
            gainsOffestEntry.setTransactionTag(TransactionTag.GAINS_OFFSET);
            assert (gainsOffestEntry.isSingleEntry());
            transaction.addTransactionEntry(gainsOffestEntry);
        }
        ReconcileManager.reconcileTransaction(account, (Transaction)transaction, reconciled);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        Logger.getLogger(TransactionFactory.class.getName()).info(transaction.toString());
        return transaction;
    }

    public static Transaction generateSingleEntryTransaction(Account account, BigDecimal amount, Date date, boolean reconciled, String memo, String payee, String number) {
        Transaction transaction = new Transaction();
        transaction.setDate(date);
        transaction.setNumber(number);
        transaction.setPayee(payee);
        transaction.setMemo(memo);
        TransactionEntry entry = new TransactionEntry(account, amount);
        entry.setMemo(memo);
        assert (entry.isSingleEntry());
        transaction.addTransactionEntry(entry);
        ReconcileManager.reconcileTransaction(account, transaction, reconciled);
        return transaction;
    }

    public static InvestmentTransaction generateSplitXTransaction(Account investmentAccount, SecurityNode node, BigDecimal price, BigDecimal quantity, Date date, String memo, boolean reconciled) {
        assert (investmentAccount != null && node != null && price != null && quantity != null);
        assert (date != null && memo != null);
        InvestmentTransaction transaction = new InvestmentTransaction();
        transaction.setDate(date);
        transaction.setMemo(memo);
        TransactionEntrySplitX entry = new TransactionEntrySplitX(investmentAccount, node, price, quantity);
        entry.setMemo(memo);
        transaction.setPayee(TransactionFactory.buildPayee("Word.Split", node, price, quantity));
        transaction.addTransactionEntry(entry);
        ReconcileManager.reconcileTransaction(investmentAccount, (Transaction)transaction, reconciled);
        return transaction;
    }

    private static String buildPayee(String wordProperty, SecurityNode node, BigDecimal price, BigDecimal quantity) {
        Resource rb = Resource.get();
        CommodityFormat format = CommodityFormat.getFullFormat();
        StringBuilder payee = new StringBuilder();
        payee.append(rb.getString(wordProperty)).append(" : ");
        payee.append(node.getSymbol()).append(" ");
        payee.append(quantity.toString());
        payee.append(" @ ");
        payee.append(format.format(price, node));
        return payee.toString();
    }

    private TransactionFactory() {
    }
}

