/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.editor;

import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.NameAndType;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.Constant;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.ResizeableArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstantPool {
    private Map constantIndices = new HashMap();
    ResizeableArrayList constants;
    ResizeableArrayList resolved;

    public ConstantPool(Constant[] c) {
        this.constants = new ResizeableArrayList(c.length);
        this.resolved = new ResizeableArrayList(c.length);
        int i = 0;
        while (i < c.length) {
            this.constants.add(c[i]);
            this.resolved.add(null);
            if (c[i] != null) {
                this.constantIndices.put(c[i], new Integer(i));
            }
            ++i;
        }
    }

    public ConstantPool() {
        this.constants = new ResizeableArrayList();
        this.resolved = new ResizeableArrayList();
    }

    public Object constantAt(int idx) {
        if (idx == 0) {
            return null;
        }
        Object value = this.resolved.get(idx);
        if (value != null) {
            return value;
        }
        Constant c = (Constant)this.constants.get(idx);
        if (c == null) {
            return null;
        }
        value = c.value();
        if (value == null) {
            return null;
        }
        switch (c.tag()) {
            case 7: {
                Assert.isTrue(value instanceof Integer, "Invalid constant: " + c);
                int index = (Integer)value;
                Assert.isTrue(this.constantTag(index) == 1, "Invalid constant: " + c);
                String className = (String)this.constantAt(index);
                value = Type.getType(Type.classDescriptor(className));
                break;
            }
            case 8: {
                Assert.isTrue(value instanceof Integer, "Invalid constant: " + c);
                int index = (Integer)value;
                Assert.isTrue(this.constantTag(index) == 1, "Invalid constant: " + c);
                value = this.constantAt(index);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                Assert.isTrue(value instanceof int[], "Invalid constant: " + c);
                int[] v = (int[])value;
                Assert.isTrue(this.constantTag(v[0]) == 7, "Invalid constant: " + c);
                Assert.isTrue(this.constantTag(v[1]) == 12, "Invalid constant: " + c);
                Type clazz = (Type)this.constantAt(v[0]);
                NameAndType nameAndType = (NameAndType)this.constantAt(v[1]);
                value = new MemberRef(clazz, nameAndType);
                break;
            }
            case 12: {
                Assert.isTrue(value instanceof int[], "Invalid constant: " + c);
                int[] v = (int[])value;
                Assert.isTrue(this.constantTag(v[0]) == 1, "Invalid constant: " + c);
                Assert.isTrue(this.constantTag(v[1]) == 1, "Invalid constant: " + c);
                String name = (String)this.constantAt(v[0]);
                String type = (String)this.constantAt(v[1]);
                value = new NameAndType(name, Type.getType(type));
                break;
            }
        }
        this.resolved.ensureSize(idx + 1);
        this.resolved.set(idx, value);
        return value;
    }

    public int numConstants() {
        return this.constants.size();
    }

    public int constantTag(int index) {
        Constant c;
        if (index > 0 && index < this.constants.size() && (c = (Constant)this.constants.get(index)) != null) {
            return c.tag();
        }
        return 1;
    }

    public int constantIndex(int tag, Object value) {
        return this.addConstant(tag, value);
    }

    public int getClassIndex(Class c) {
        return this.addConstant(7, Type.getType(c));
    }

    public int getIntegerIndex(Integer i) {
        return this.addConstant(3, i);
    }

    public int getFloatIndex(Float f) {
        return this.addConstant(4, f);
    }

    public int getLongIndex(Long l) {
        return this.addConstant(5, l);
    }

    public int getDoubleIndex(Double d) {
        return this.addConstant(6, d);
    }

    public int getClassIndex(Type type) {
        Assert.isTrue(type.isObject(), "Type " + type + " is not an class type");
        this.getTypeIndex(type);
        return this.addConstant(7, type);
    }

    public int getTypeIndex(Type type) {
        return this.addConstant(1, type.descriptor());
    }

    public int getStringIndex(String s) {
        return this.addConstant(8, s);
    }

    public int getMemberRefIndex(MemberRef ref) {
        return this.addConstant(9, ref);
    }

    public int getNameAndTypeIndex(NameAndType nat) {
        return this.addConstant(12, nat);
    }

    public int getUTF8Index(String s) {
        return this.addConstant(1, s);
    }

    public int addConstant(int tag, Object value) {
        Constant c;
        if (value == null) {
            return 0;
        }
        switch (tag) {
            case 7: {
                Assert.isTrue(value instanceof Type, "Invalid value: " + value);
                int index = this.addConstant(1, ((Type)value).className());
                c = new Constant(7, new Integer(index));
                break;
            }
            case 8: {
                Assert.isTrue(value instanceof String, "Invalid value: " + value);
                int index = this.addConstant(1, value);
                c = new Constant(8, new Integer(index));
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                Assert.isTrue(value instanceof MemberRef, "Invalid value: " + value);
                int[] v = new int[]{this.addConstant(7, ((MemberRef)value).declaringClass()), this.addConstant(12, ((MemberRef)value).nameAndType())};
                c = new Constant(tag, v);
                break;
            }
            case 12: {
                Assert.isTrue(value instanceof NameAndType, "Invalid value: " + value);
                int[] v = new int[]{this.addConstant(1, ((NameAndType)value).name()), this.addConstant(1, ((NameAndType)value).type().descriptor())};
                c = new Constant(tag, v);
                break;
            }
            case 1: {
                String s = (String)value;
                c = new Constant(tag, s.intern());
                break;
            }
            default: {
                c = new Constant(tag, value);
            }
        }
        Integer index = (Integer)this.constantIndices.get(c);
        if (index == null) {
            index = new Integer(this.constants.size());
            this.constantIndices.put(c, index);
            this.constants.add(c);
            this.resolved.add(value);
            if (tag == 5 || tag == 6) {
                this.constants.add(null);
                this.resolved.add(null);
            }
        }
        return index;
    }

    public Constant[] constants() {
        Object[] a = this.constants.toArray();
        Constant[] array = new Constant[a.length];
        System.arraycopy(a, 0, array, 0, a.length);
        return array;
    }

    public List getConstantsList() {
        return Collections.unmodifiableList(this.constants);
    }
}

