/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.internal.Buffer;
import com.db4o.internal.BufferPair;
import com.db4o.internal.Comparable4;
import com.db4o.internal.IDHandler;
import com.db4o.internal.IllegalComparisonException;
import com.db4o.internal.Indexable4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.handlers.IntHandler;

public class FieldIndexKeyHandler
implements Indexable4 {
    private final Indexable4 _valueHandler;
    private final IntHandler _parentIdHandler;

    public FieldIndexKeyHandler(ObjectContainerBase objectContainerBase, Indexable4 indexable4) {
        this._parentIdHandler = new IDHandler(objectContainerBase);
        this._valueHandler = indexable4;
    }

    public int linkLength() {
        return this._valueHandler.linkLength() + 4;
    }

    public Object readIndexEntry(Buffer buffer) {
        int n = this.readParentID(buffer);
        Object object = this._valueHandler.readIndexEntry(buffer);
        if (n < 0) {
            object = null;
            n = -n;
        }
        return new FieldIndexKey(n, object);
    }

    private int readParentID(Buffer buffer) {
        return (Integer)this._parentIdHandler.readIndexEntry(buffer);
    }

    public void writeIndexEntry(Buffer buffer, Object object) {
        FieldIndexKey fieldIndexKey = (FieldIndexKey)object;
        int n = fieldIndexKey.parentID();
        Object object2 = fieldIndexKey.value();
        if (object2 == null) {
            n = -n;
        }
        this._parentIdHandler.write(n, buffer);
        this._valueHandler.writeIndexEntry(buffer, fieldIndexKey.value());
    }

    public Indexable4 valueHandler() {
        return this._valueHandler;
    }

    public Comparable4 prepareComparison(Object object) {
        FieldIndexKey fieldIndexKey = (FieldIndexKey)object;
        this._valueHandler.prepareComparison(fieldIndexKey.value());
        this._parentIdHandler.prepareComparison(fieldIndexKey.parentID());
        return this;
    }

    public int compareTo(Object object) {
        if (null == object) {
            throw new ArgumentNullException();
        }
        FieldIndexKey fieldIndexKey = (FieldIndexKey)object;
        try {
            int n = this._valueHandler.compareTo(fieldIndexKey.value());
            if (n != 0) {
                return n;
            }
        }
        catch (IllegalComparisonException illegalComparisonException) {
            // empty catch block
        }
        return this._parentIdHandler.compareTo(fieldIndexKey.parentID());
    }

    public void defragIndexEntry(BufferPair bufferPair) {
        this._parentIdHandler.defragIndexEntry(bufferPair);
        this._valueHandler.defragIndexEntry(bufferPair);
    }
}

