
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import se.datadosen.component.*;
import se.datadosen.jalbum.JCustomPanel;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.JAlbumWindow;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.util.Item;

public class TurtleGui extends se.datadosen.jalbum.CompiledScript {

	private Color getHoverColor(String s) {
		long[] rgb = {Integer.parseInt(s.substring(1, 3), 16), Integer.parseInt(s.substring(3, 5), 16), Integer.parseInt(s.substring(5, 7), 16)};
		int i;
		if (((double) (3 * rgb[0] + 4 * rgb[1] + rgb[2]) / 2040) < 0.85D) {
			for (i = 0; i < 3; i++) {
				if (rgb[i] < 128) {
					rgb[i] = Math.round(127 * Math.pow(((double) rgb[i]) / 127.0D, 2.0D));
				} else {
					rgb[i] = Math.round(255 - 127 * Math.pow(((double) (255 - rgb[i])) / 127.0D, 2.0D));
				}
				rgb[i] = Math.round(Math.floor(127 + rgb[i] * 0.5D));
			}
		} else {
			for (i = 0; i < 3; i++) {
				rgb[i] = Math.round((double) rgb[i] * 0.8D);
			}
		}
		return new Color((int) rgb[0], (int) rgb[1], (int) rgb[2]);
	}
	
	ControlPanel ui = new ControlPanel() {

		JCheckBox guiExists = new JCheckBox("", true);
		JCollapsiblePanel general = new JCollapsiblePanel() {

			JTextField slideshowDelay = new JSmartTextField("4", 3);
			JCheckBox slideshowLoop = new JCheckBox(texts.getString("ui.loop"));
			JCheckBox slideshowAuto = new JCheckBox(texts.getString("ui.autoStart"));
			JTextField newDaysCount = new JSmartTextField("0", 3);
			JCheckBox askAtLast = new JCheckBox(texts.getString("ui.askAtLast"), true);
			JCheckBox useBreadcrumbPath = new JCheckBox(texts.getString("ui.useBreadcrumbPath"), true);
			JCheckBox useUplink = new JCheckBox(texts.getString("ui.useUplink"), true);
			JTextField uplinkUrl = new JSmartTextField("../", 10);
			JCheckBox fixedShapeThumbs = new JCheckBox(texts.getString("ui.fixedShapeThumbs"), true);
			JCheckBox thumbnailsVisible = new JCheckBox(texts.getString("ui.thumbnailsVisible"));
			JCheckBox infoPanelVisible = new JCheckBox(texts.getString("ui.infoPanelVisible"));
			JCheckBox fitImages = new JCheckBox(texts.getString("ui.fitImages"));
			JCheckBox fitShrinkonly = new JCheckBox(texts.getString("ui.fitShrinkonly"));

			{
				setTitle(texts.getString("ui.general"));
				slideshowDelay.setToolTipText(texts.getString("ui.slideshowDelayInfo"));
				newDaysCount.setToolTipText(texts.getString("ui.newDaysCountInfo"));
				askAtLast.setToolTipText(texts.getString("ui.askAtLastInfo")+": "+texts.getString("up")+" | "+texts.getString("startOver")+" | "+texts.getString("stop"));
				useBreadcrumbPath.setToolTipText(texts.getString("ui.useBreadcrumbPathInfo"));
				useUplink.setToolTipText(texts.getString("ui.useUplinkInfo"));
				uplinkUrl.setToolTipText(texts.getString("ui.useUplinkInfo"));
				fixedShapeThumbs.setToolTipText(texts.getString("ui.fixedShapeThumbsInfo"));
				thumbnailsVisible.setToolTipText(texts.getString("ui.thumbnailsVisibleInfo"));
				infoPanelVisible.setToolTipText(texts.getString("ui.infoPanelVisibleInfo"));
				fitImages.setToolTipText(texts.getString("ui.fitImagesInfo"));
				fitShrinkonly.setToolTipText(texts.getString("ui.fitShrinkonlyInfo"));

				getContentPanel().setLayout(new RiverLayout());
				setExpanded(true);
				ComponentUtilities.whenSelectedEnable(useUplink, new JComponent[]{uplinkUrl});
				add(new JLabel(texts.getString("ui.slideshowDelay")));
				add("", slideshowDelay);
				add("", new JLabel("s"));
				add(" ", slideshowLoop);
				add(" ", slideshowAuto);
				add("br", new JLabel(texts.getString("ui.markFilesNew")));
				add("", newDaysCount);
				add("", new JLabel(texts.getString("ui.daysOld")));
				add("br", askAtLast);
				add("br", useBreadcrumbPath);
				add("br", useUplink);
				add("hfill", uplinkUrl);
				add("br", fixedShapeThumbs);
				add("br", thumbnailsVisible);
				add("br", infoPanelVisible);
				add("br", fitImages);
				add(" ", fitShrinkonly);
			}
		};
		
		JCollapsiblePanel splash = new JCollapsiblePanel() {

			JTextField splashDepthLevel = new JSmartTextField("2", 3);
			JTextField splashSize = new JSmartTextField(10);
			JTextField customLink = new JSmartTextField();
			JTextField customLinkText = new JSmartTextField();

			{
				setTitle(texts.getString("ui.splashScreen"));
				splashDepthLevel.setToolTipText(texts.getString("ui.splashDepthInfo"));
				splashSize.setToolTipText(texts.getString(
						"ui.splashSizeInfo"));
				customLink.setToolTipText(texts.getString("ui.customLinkInfo"));
				customLinkText.setToolTipText(texts.getString("ui.customLinkTextInfo"));

				getContentPanel().setLayout(new RiverLayout());
				Integer splashWidth = Integer.parseInt(engine.getImageSize().split("x")[0]);
				Integer splashHeight = Integer.parseInt(engine.getImageSize().split("x")[1]) * 2 / 3;
				splashSize.setText(splashWidth.toString() + "x" + splashHeight.toString());
				add(new JLabel(texts.getString("ui.splashDepth")));
				add("tab", splashDepthLevel);
				add("br", new JLabel(texts.getString("ui.splashSize")));
				add("tab", splashSize);
				add("br", new JLabel(texts.getString("ui.customLink")));
				add("tab hfill", customLink);
				add("br", new JLabel(texts.getString("ui.customLinkText")));
				add("tab hfill", customLinkText);
			}
		};
		
		JCollapsiblePanel design = new JCollapsiblePanel() {

			String[] fonts = {"Arial,Helvetica,sans-serif", "Verdana,Geneva,sans-serif", "\"Lucida Sans Unicode\",\"Lucida Grande\",sans-serif",
				"Georgia,\"Times New Roman\",serif", "\"Trebuchet MS\",Verdana,sans-serif",
				"\"Times New Roman\",Times,serif", "\"Courier New\",Courier,monospaced",
				"Tahoma,Geneva,sans-serif", "\"Comic Sans MS\",cursive"};
			JComboBox fontFamily = new JComboBox(fonts);
			JColorSelector backgroundColor = new JColorSelector(texts.getString("ui.backgroundColor"), new JSmartTextField(6));
			JColorSelector linkColor = new JColorSelector(texts.getString("ui.linkColor"), new JSmartTextField(6));
			JColorSelector hoverColor = new JColorSelector(texts.getString("ui.hoverColor"), new JSmartTextField(6));
			JColorSelector borderColor = new JColorSelector(texts.getString("ui.borderColor"), new JSmartTextField(6));
			JTextField borderWidth =  new JSmartTextField("0", 3);
			JComboBox reduceThumbs = new JComboBox(new Object[]{"100%", "75%", "66.6667%", "50%", "33.3333%", "25%"});

			{
				setTitle(texts.getString("ui.design"));
				backgroundColor.setToolTipText(texts.getString("ui.backgroundColorInfo"));
				linkColor.setToolTipText(texts.getString("ui.linkColorInfo"));
				hoverColor.setToolTipText(texts.getString("ui.hoverColorInfo"));

				getContentPanel().setLayout(new RiverLayout());
				add(new JLabel(texts.getString("ui.fontFamily")));
				add(" ", fontFamily);
				add("br", new JLabel(texts.getString("ui.backgroundColor")));
				add("tab", backgroundColor);
				add("tab", backgroundColor.getTextComponent());
				add("br", new JLabel(texts.getString("ui.linkColor")));
				add("tab", linkColor);
				add("tab", linkColor.getTextComponent());
				add("br", new JLabel(texts.getString("ui.hoverColor")));
				add("tab", hoverColor);
				add("tab", hoverColor.getTextComponent());
				add("br", new JLabel(texts.getString("ui.borderColor")));
				add("tab", borderColor);
				add("tab", borderColor.getTextComponent());
				add("tab", new JLabel(texts.getString("ui.borderWidth")));
				add("", borderWidth);
				add("", new JLabel("px"));
				add("br", new JLabel(texts.getString("ui.reduceThumbs")));
				add(" ", reduceThumbs);

				linkColor.addActionListener(new ActionListener() {

					public void actionPerformed(ActionEvent e) {
						hoverColor.setColor(getHoverColor(linkColor.getHTMLColor()));
					}
				});
			}
		};
		
		JCollapsiblePanel caption = new JCollapsiblePanel() {

			JTextArea imgCaptionTemplate = new JSmartTextArea(3, 40);
			JTextArea thumbCaptionTemplate = new JSmartTextArea(3, 40);

			{
				setTitle(texts.getString("ui.captionTemplates"));
				imgCaptionTemplate.setText("<h2>${fileTitle}</h2><div class=\"comment\">${comment}</div>");
				imgCaptionTemplate.setEditable(true);
				imgCaptionTemplate.setLineWrap(true);
				imgCaptionTemplate.setWrapStyleWord(true);
				thumbCaptionTemplate.setText("<span class=\"nr\">${imageNum}</span> <strong>${fileTitle}</strong> <small>${comment}</small>");
				thumbCaptionTemplate.setEditable(true);
				thumbCaptionTemplate.setLineWrap(true);
				thumbCaptionTemplate.setWrapStyleWord(true);

				getContentPanel().setLayout(new RiverLayout());
				add(new JLabel(texts.getString("ui.images")));
				JScrollPane iCaptionPane = new JScrollPane(imgCaptionTemplate);
				add("br hfill", iCaptionPane);
				add("br", new JLabel(texts.getString("ui.thumbnails")));
				JScrollPane tCaptionPane = new JScrollPane(thumbCaptionTemplate);
				add("br hfill", tCaptionPane);
			}
		};
		
		JCollapsiblePanel share = new JCollapsiblePanel() {

			JCheckBox likeFacebook = new JCheckBox(texts.getString("ui.facebookLikeButton"));
			JCheckBox tweetTwitter = new JCheckBox(texts.getString("ui.tweetButton"));
			JCheckBox shareFacebook = new JCheckBox("Facebook");
			JCheckBox shareTwitter = new JCheckBox("Twitter");
			JCheckBox shareDigg = new JCheckBox("Digg");
			JCheckBox shareDelicious = new JCheckBox("Delicious");
			JCheckBox shareMyspace = new JCheckBox("MySpace");
			JCheckBox shareStumbleupon = new JCheckBox("StumbleUpon");
			JCheckBox shareEmail = new JCheckBox("Email");

			{
				setTitle(texts.getString("ui.sharing"));
				likeFacebook.setToolTipText(texts.getString("ui.facebookLikeButtonInfo"));
				tweetTwitter.setToolTipText(texts.getString("ui.tweetButtonInfo"));

				getContentPanel().setLayout(new RiverLayout());
				add(likeFacebook);
				add("br", tweetTwitter);
				ControlPanel shares = new ControlPanel(texts.getString("shareOn"));
				shares.add(shareFacebook);
				shares.add("tab", shareTwitter);
				shares.add("tab", shareDigg);
				shares.add("br", shareDelicious);
				shares.add("tab", shareMyspace);
				shares.add("tab", shareStumbleupon);
				shares.add("tab", shareEmail);
				add("br hfill", shares);
			}
		};
		
		JCollapsiblePanel meta = new JCollapsiblePanel() {

			JCheckBox showMeta = new JCheckBox(texts.getString("ui.showMetadata"));
			JCheckBox showMetaLabel = new JCheckBox(texts.getString("ui.showLabel"), true);
			JTextArea metadata = new JSmartTextArea(8, 40);

			{
				setTitle(texts.getString("ui.photoData"));
				showMeta.setToolTipText(texts.getString("ui.showMetadataInfo"));
				showMetaLabel.setToolTipText(texts.getString("ui.showLabelInfo"));
				metadata.setText("photographer|artist|Artist|Owner|Copyright|Iptc.By-line|Iptc.Copyright Notice, Xmp.creator, Xmp.title, objectName, Xmp.subject, Xmp.description, Iptc.keywords, Xmp.format, Xmp.rights, Xmp.Identifier, Xmp.Label, Country/Primary Location, Province/State, City, Sub-location, originalDate|Date/Time Original|Date/Time|CreateDate|ModifyDate, camera|Model, lens|Lens|Xmp.Lens-Information|Canon Makernote.Unknown tag (0x0095), focalLength35mm|focusDistance|Focal Length|Focallength, SubjectDistance, meteringMode|Metering Mode, isoEquivalent|ISO Speed Ratings, exposureTime|Exposure Time|Shutter Speed Value|ShutterSpeedValue, Aperture Value|aperture|F-Number|FNumber|Aperturevalue, Exposure Bias Value, Exposure Program|Exposureprogram|Exposure Mode, Xmp.SceneType, White Balance|WhiteBalance, Xmp.ColorSpace, Xmp.LightSource, flash|Flash, resolution");
				metadata.setEditable(true);
				metadata.setLineWrap(true);
				metadata.setWrapStyleWord(true);

				getContentPanel().setLayout(new RiverLayout());
				JScrollPane metaPane = new JScrollPane(metadata);
				ComponentUtilities.whenSelectedEnable(showMeta, new JComponent[]{showMetaLabel, metadata});
				add(showMeta);
				add("tab", showMetaLabel);
				add("br hfill", metaPane);
			}
		};
		
		JCollapsiblePanel map = new JCollapsiblePanel() {

			JCheckBox showMap = new JCheckBox(texts.getString("ui.showMap"));
			JComboBox mapType = new JComboBox(new Object[]{
						new Item("Map", texts.getString("ui.map")),
						new Item("Satellite", texts.getString("ui.satellite")),
						new Item("Hybrid", texts.getString("ui.hybrid")),
						new Item("Terrain", texts.getString("ui.terrain"))
					});
			JSlider mapZoom = new JSlider(JSlider.HORIZONTAL, 1, 20, 18);
			JCheckBox mapAll = new JCheckBox(texts.getString("ui.allMarkers"));
			JTextField googleMapsKey = new JSmartTextField(36);

			{
				setTitle(texts.getString("ui.map"));
				showMap.setToolTipText(texts.getString("ui.showMapInfo"));

				mapAll.setToolTipText(texts.getString("ui.allMarkersInfo"));
				mapZoom.setOrientation(JSlider.HORIZONTAL);
				mapZoom.setMinimum(0);
				mapZoom.setMaximum(20);
				mapZoom.setValue(18);
				mapZoom.setMajorTickSpacing(10);
				mapZoom.setMinorTickSpacing(1);
				mapZoom.setPaintTicks(true);
				mapZoom.setPaintLabels(true);
				mapZoom.setSnapToTicks(true);
				googleMapsKey.setToolTipText(texts.getString("ui.gmapsKeyInfo"));

				getContentPanel().setLayout(new RiverLayout());
				ComponentUtilities.whenSelectedEnable(showMap, new JComponent[]{mapAll, mapType, mapZoom, googleMapsKey});
				add(showMap);
				add(" ", mapAll);
				add("br", new JLabelFor(texts.getString("ui.initialView"), mapType));
				add("tab", mapType);
				add("br", new JLabelFor(texts.getString("ui.initialZoom"), mapZoom));
				add("tab", mapZoom);
				add("br", new JLabelFor(texts.getString("ui.gmapsKey"), googleMapsKey));
				add("br hfill", googleMapsKey);
			}
		};
		
		JCollapsiblePanel shop = new JCollapsiblePanel() {

			JCheckBox showShop = new JCheckBox(texts.getString("ui.sellThroughPaypal"));
			JTextField shopId = new JSmartTextField(10);
			JTextField shopCurrency = new JSmartTextField("EUR", 4);
			JTextField shopHandling = new JSmartTextField(4);
			JTextArea shopOptions = new JSmartTextArea(6, 40);

			{
				setTitle(texts.getString("ui.sellingPhotos"));
				showShop.setToolTipText(texts.getString("ui.sellThroughPaypalInfo"));
				shopId.setToolTipText(texts.getString("ui.paypalEmailInfo"));
				shopCurrency.setToolTipText(texts.getString("ui.currencyInfo"));
				shopHandling.setToolTipText(texts.getString("ui.handlingInfo"));
				shopOptions.setToolTipText(texts.getString("ui.shopOptionsInfo"));
				shopOptions.setText("5x3.75\" Print=0.07\n6x4\" Print=0.1\n6x4.5\" Print=0.15\n7.5x5\" Print=0.3\n9x6\" Print=0.4\n12x8\" Print=1.0\n15x10\" Print=2.0");
				shopOptions.setEditable(true);
				shopOptions.setLineWrap(true);
				shopOptions.setWrapStyleWord(true);

				getContentPanel().setLayout(new RiverLayout());
				JScrollPane shopPane = new JScrollPane(shopOptions);
				ComponentUtilities.whenSelectedEnable(showShop, new JComponent[]{shopId, shopCurrency, shopHandling, shopOptions});
				add(showShop);
				add("br", new JLabelFor(texts.getString("ui.paypalEmail"), shopId));
				add("hfill", shopId);
				add("br", new JLabelFor(texts.getString("ui.currency"), shopCurrency));
				add("", shopCurrency);
				add(" ", new JLabelFor(texts.getString("ui.handling"), shopHandling));
				add("", shopHandling);
				add("br", new JLabelFor(texts.getString("ui.shopOptions"), shopOptions));
				add("br hfill", shopPane);
			}
		};
		
		JCollapsiblePanel av = new JCollapsiblePanel() {

			JCheckBox audioAutoPlay = new JCheckBox(texts.getString("ui.startMusic"));
			JCheckBox audioLoop = new JCheckBox(texts.getString("ui.loop"));
			JCheckBox videoAutoPlay = new JCheckBox(texts.getString("ui.startVideo"));
			JTextField videoSize = new JSmartTextField("640x480", 10);

			{
				setTitle(texts.getString("ui.audioVideo"));
				getContentPanel().setLayout(new RiverLayout());
				add(audioAutoPlay);
				add("tab", audioLoop);
				add("br", videoAutoPlay);
				add("tab", new JLabel(texts.getString("ui.videoSize")));
				add("", videoSize);
			}
		};
		
		JCollapsiblePanel advanced = new JCollapsiblePanel() {

			JCheckBox enableMouseWheel = new JCheckBox(texts.getString("ui.enableMouseWheel"),true);
			JCheckBox rightClickProtect = new JCheckBox(texts.getString("ui.rightClickProtect"));
			JTextField googleSiteID = new JSmartTextField();
			JTextField uploadPath = new JSmartTextField();
			JCheckBox noscriptContent = new JCheckBox(texts.getString("ui.noscriptContent"));
			
			{
				setTitle(texts.getString("ui.advanced"));
				enableMouseWheel.setToolTipText(texts.getString("ui.enableMouseWheelInfo"));
				rightClickProtect.setToolTipText(texts.getString("ui.rightClickProtectInfo"));
				googleSiteID.setToolTipText(texts.getString("ui.googleSiteIDInfo"));
				uploadPath.setToolTipText(texts.getString("ui.uploadPathInfo"));
				noscriptContent.setToolTipText(texts.getString("ui.noscriptContentInfo"));
				getContentPanel().setLayout(new RiverLayout());
				add(enableMouseWheel);
				add("br", rightClickProtect);
				add("br", new JLabelFor(texts.getString("ui.googleSiteID"), googleSiteID));
				add("tab hfill", googleSiteID);
				add("br", new JLabelFor(texts.getString("ui.uploadPath"), uploadPath));
				add("tab hfill", uploadPath);
				add("br", noscriptContent);
			}
		};

		{
			ControlPanel cont = new ControlPanel();
			cont.add("right", new JLinkLabel("file://" + skinDirectory.toString().replace('\\', '/') + "/help/index.html", texts.getString("help")));
			cont.add("br hfill", general);
			cont.add("br hfill", splash);
			cont.add("br hfill", design);
			cont.add("br hfill", caption);
			cont.add("br hfill", share);
			cont.add("br hfill", meta);
			cont.add("br hfill", map);
			cont.add("br hfill", shop);
			cont.add("br hfill", av);
			cont.add("br hfill", advanced);
			cont.add("br center", new JLabel("Jalbum " + internalVersion));
			cont.add(new JLinkLabel("http://jalbum.net/software/download/current", texts.getString("ui.upgrade"), texts.getString("ui.downloadJalbum")));
			cont.add(new JLabel("|  " + skin + " skin " + (new SkinProperties(skinDirectory).getProperty(SkinProperties.VERSION))));
			cont.add(new JLinkLabel("http://jalbum.net/skins/skin/" + skin, texts.getString("ui.upgrade"), texts.getString("ui.downloadSkin")));
			cont.add(new JLabel("|"));
			cont.add(new JLinkLabel("http://www.longtailvideo.com/players/jw-flv-player", "Flash Video Player"));
			JScrollPane panel = new JScrollPane(cont);
			panel.setViewportBorder(BorderFactory.createEmptyBorder());
			add("hfill vfill", panel);
		}
	};

	class CustomUI extends JCustomPanel {

		JTextArea _shopOptions = new JSmartTextArea(4, 10);
		JScrollPane _shopPane = new JScrollPane(_shopOptions);
		JTextField _location = new JSmartTextField(10);

		public CustomUI(JAlbumContext context) {
			super(context);
			setBackground(SystemColor.text);
			setOpaque(true);
			_shopOptions.setToolTipText(texts.getString("ui.shopOptionsInfo"));
			_shopOptions.setText(
					"");
			_shopOptions.setEditable(
					true);
			_shopOptions.setLineWrap(
					true);
			_shopOptions.setWrapStyleWord(
					true);
			_location.setToolTipText(texts.getString(
					"ui.gpsLocationInfo"));

			add(new JLabel(texts.getString("ui.gpsLocation")));
			add("br hfill", _location);
			add("br", new JLabel(texts.getString("ui.shopOptions")));
			add("br hfill", _shopPane);

			FocusListener fl = new FocusAdapter() {

				public void focusLost(FocusEvent e) {
					saveUI();
				}
			};
			ActionListener al = new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					saveUI();
				}
			};
			_shopOptions.addFocusListener(fl);

			init();
		}
	}

	public TurtleGui(JAlbumWindow window, JAlbumContext context) {
		super(context.getEngine());
		PluginContext pc = context.getPluginContext();
		EditPanel editPanel = pc.getEditPanel();
		CustomUI customUI = new CustomUI(context);
		editPanel.addCustomTab(texts.getString("ui.imageData"), customUI);

		window.setSkinUI(ui);
		window.pack();

	}
}
