/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.MultipleResizableCirclePanel;
import net.jalbum.filters.RedEyeCircle;
import net.jalbum.filters.RedEyeControl;
import net.jalbum.filters.RedEyeFilter;
import net.jalbum.filters.ResizableObject;
import se.datadosen.jalbum.Msg;

public class RedEyeFilterPlugin
extends MultipleResizableCirclePanel {
    private static final long serialVersionUID = 2930029844322497620L;
    protected RedEyeControl redEyeControl;
    protected RedEyeCircle redEyeCircle;
    protected RedEyeFilter redEye;

    public RedEyeFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.redEye.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.redEye.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/redeye.png"));
        this.author = "David Fichtmueller";
        this.version = "0.1 beta";
        this.description = Msg.getString((Object)this, (String)"filters.redEye.description");
        this.category = FilterProperties.FilterCategory.OTHER;
        this.prescale = true;
        this.postscale = false;
        this.emptyClickCreatesNewObject = true;
        this.namePrefix = "RedEyeCircle ";
        this.redEye = new RedEyeFilter();
        this.redEyeControl = new RedEyeControl(this);
        this.multipleResizableCircleControl = this.redEyeControl;
        this.multipleResizableObjectControl = this.redEyeControl;
        this.resizableObjectControl = this.redEyeControl;
    }

    public void init() {
        this.redEyeCircle = new RedEyeCircle();
        this.redEyeCircle.setName(this.namePrefix + this.counter);
        this.redEyeCircle.setParentPanel(this);
        this.objectVector.clear();
        this.objectVector.add(this.redEyeCircle);
        this.resizableCircle = this.redEyeCircle;
        this.resizableObject = this.redEyeCircle;
        this.hoveredOverObject = this.redEyeCircle;
        this.redEyeControl.adjustResizableObject(this.resizableObject);
    }

    public JPanel getControls() {
        return this.redEyeControl;
    }

    public void addObject() {
        this.resizableObject.setState(10);
        this.redEyeCircle = new RedEyeCircle(this.width, this.height);
        this.redEyeCircle.setParentPanel(this);
        this.objectVector.add(0, this.redEyeCircle);
        this.redEyeCircle.setName(this.namePrefix + this.counter);
        this.resizableCircle = this.redEyeCircle;
        this.resizableObject = this.resizableCircle;
        this.hoveredOverObject = this.redEyeCircle;
        ++this.counter;
        this.redEyeControl.adjustResizableObject(this.resizableObject);
        this.redEyeControl.checkButtons();
    }

    public boolean removeObject() {
        if (this.objectVector.size() > 1) {
            super.removeObject();
        } else {
            ResizableObject temp = this.resizableObject;
            this.addObject();
            this.objectVector.remove(temp);
        }
        this.redEyeControl.checkButtons();
        this.redEyeControl.adjustResizableObject(this.resizableObject);
        this.renderPreview();
        return true;
    }

    public boolean removeObject(int index) {
        boolean temp = super.removeObject(index);
        this.renderPreview();
        return temp;
    }

    public boolean removeObject(String name) {
        boolean temp = super.removeObject(name);
        this.renderPreview();
        return temp;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        BufferedImage out = new BufferedImage(bi.getWidth(), bi.getHeight(), bi.getType());
        out.setData(bi.getData());
        if (this.redEye == null) {
            this.redEye = new RedEyeFilter();
        }
        for (int i = 0; i < this.objectVector.size(); ++i) {
            out = this.renderObject((ResizableObject)this.objectVector.get(i), out);
        }
        return out;
    }

    protected BufferedImage renderObject(ResizableObject object, BufferedImage bi) {
        if (!object.isInitial()) {
            this.redEye.setRadius((int)(((RedEyeCircle)object).getRadius() * (double)(this.width - 1)));
            this.redEye.setX((int)(((RedEyeCircle)object).getX1() * (double)(this.width - 1)));
            this.redEye.setY((int)(((RedEyeCircle)object).getY1() * (double)(this.height - 1)));
            this.redEye.setMaxGap((int)(((RedEyeCircle)object).getMaxGap() * ((RedEyeCircle)object).getX1() * (double)(this.width - 1)));
            this.redEye.setValue1(((RedEyeCircle)object).getValue1());
            this.redEye.setValue2(((RedEyeCircle)object).getValue2());
            bi = this.redEye.filter(bi);
        }
        return bi;
    }

    public void dispose() {
        super.dispose();
        this.redEye = null;
        this.redEyeCircle = null;
    }

    public void mouseReleased(MouseEvent arg0) {
        super.mouseReleased(arg0);
        this.applyFilter = !this.resizableObject.isInitial();
        this.redEyeControl.checkButtons();
        this.renderPreview();
    }

    public void keyPressed(KeyEvent arg0) {
        super.keyPressed(arg0);
        this.renderPreview();
    }

    public double getValue1() {
        return ((RedEyeCircle)this.resizableObject).getValue1();
    }

    public void adjustValue1(double value1) {
        ((RedEyeCircle)this.resizableObject).setValue1(value1);
        this.renderPreview();
    }

    public double getValue2() {
        return ((RedEyeCircle)this.resizableObject).getValue2();
    }

    public void adjustValue2(double value2) {
        ((RedEyeCircle)this.resizableObject).setValue2(value2);
        this.renderPreview();
    }

    public double getValueFactor() {
        return ((RedEyeCircle)this.resizableObject).getValueFactor();
    }

    public void adjustValueFactor(double valueFactor) {
        ((RedEyeCircle)this.resizableObject).setValueFactor(valueFactor);
    }

    public double getMaxGap() {
        return ((RedEyeCircle)this.resizableObject).getMaxGap();
    }

    public void adjustMaxGap(double maxGap) {
        ((RedEyeCircle)this.resizableObject).setMaxGap(maxGap);
        this.renderPreview();
    }

    public RedEyeCircle getRedEyeCircle() {
        return this.redEyeCircle;
    }

    public void setRedEyeCircle(RedEyeCircle redEyeCircle) {
        this.redEyeCircle = redEyeCircle;
    }

    public RedEyeFilter getRedEye() {
        return this.redEye;
    }

    public void setRedEye(RedEyeFilter redEye) {
        this.redEye = redEye;
    }
}

