/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.jalbum.editor.JTextPad;

public class SpecialMacHandler
implements ApplicationListener {
    public SpecialMacHandler() {
        SpecialMacHandler.setSystemProperties();
        SpecialMacHandler.registerAsApplicationListener(this);
    }

    private static void registerAsApplicationListener(ApplicationListener l) {
        Application app = Application.getApplication();
        app.addApplicationListener(l);
    }

    private static void setSystemProperties() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "jAlbum Textpad");
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        System.setProperty("apple.awt.antialiasing", "on");
        System.setProperty("apple.awt.interpolation", "bilinear");
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleOpenFile(ApplicationEvent applicationEvent) {
        File f = new File(applicationEvent.getFilename());
        JTextPad tp = JTextPad.getInstance();
        tp.openDocument(f);
        applicationEvent.setHandled(true);
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(true);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        panel.add(new JLabel("jAlbum Textpad 2.2"));
        panel.add(new JLabel("By David Ekholm, jAlbum"));
        panel.add(new JLabel("Thanks to Robert Futrell for providing the excellent"));
        panel.add(new JLabel("text editor engine RSyntaxTextArea!"));
        JOptionPane.showMessageDialog(null, panel, "About jAlbum Textpad", 1);
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(true);
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        JTextPad.getInstance().exitAction.actionPerformed(null);
    }
}

