/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.XMPUtils;
import com.adobe.xmp.impl.Utils;
import com.adobe.xmp.impl.XMPDateTimeImpl;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNode;
import com.adobe.xmp.impl.XMPNodeUtils;
import com.adobe.xmp.impl.xpath.XMPPath;
import com.adobe.xmp.impl.xpath.XMPPathParser;
import com.adobe.xmp.options.ParseOptions;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.properties.XMPAliasInfo;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class XMPNormalizer {
    private static Map dcArrayForms;

    private XMPNormalizer() {
    }

    static XMPMeta process(XMPMetaImpl xMPMetaImpl, ParseOptions parseOptions) throws XMPException {
        XMPNode xMPNode = xMPMetaImpl.getRoot();
        XMPNormalizer.touchUpDataModel(xMPMetaImpl);
        XMPNormalizer.moveExplicitAliases(xMPNode, parseOptions);
        XMPNormalizer.tweakOldXMP(xMPNode);
        XMPNormalizer.deleteEmptySchemas(xMPNode);
        return xMPMetaImpl;
    }

    private static void tweakOldXMP(XMPNode xMPNode) throws XMPException {
        if (xMPNode.getName() != null && xMPNode.getName().length() >= 36) {
            String string = xMPNode.getName().toLowerCase();
            if (string.startsWith("uuid:")) {
                string = string.substring(5);
            }
            if (Utils.checkUUIDFormat(string)) {
                XMPPath xMPPath = XMPPathParser.expandXPath("http://ns.adobe.com/xap/1.0/mm/", "InstanceID");
                XMPNode xMPNode2 = XMPNodeUtils.findNode(xMPNode, xMPPath, true, null);
                if (xMPNode2 != null) {
                    xMPNode2.setOptions(null);
                    xMPNode2.setValue("uuid:" + string);
                    xMPNode2.removeChildren();
                    xMPNode2.removeQualifiers();
                    xMPNode.setName(null);
                } else {
                    throw new XMPException("Failure creating xmpMM:InstanceID", 9);
                }
            }
        }
    }

    private static void touchUpDataModel(XMPMetaImpl xMPMetaImpl) throws XMPException {
        XMPNodeUtils.findSchemaNode(xMPMetaImpl.getRoot(), "http://purl.org/dc/elements/1.1/", true);
        Iterator iterator = xMPMetaImpl.getRoot().iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode;
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if ("http://purl.org/dc/elements/1.1/".equals(xMPNode2.getName())) {
                XMPNormalizer.normalizeDCArrays(xMPNode2);
                continue;
            }
            if ("http://ns.adobe.com/exif/1.0/".equals(xMPNode2.getName())) {
                XMPNormalizer.fixGPSTimeStamp(xMPNode2);
                xMPNode = XMPNodeUtils.findChildNode(xMPNode2, "exif:UserComment", false);
                if (xMPNode == null) continue;
                XMPNormalizer.repairAltText(xMPNode);
                continue;
            }
            if ("http://ns.adobe.com/xmp/1.0/DynamicMedia/".equals(xMPNode2.getName())) {
                xMPNode = XMPNodeUtils.findChildNode(xMPNode2, "xmpDM:copyright", false);
                if (xMPNode == null) continue;
                XMPNormalizer.migrateAudioCopyright(xMPMetaImpl, xMPNode);
                continue;
            }
            if (!"http://ns.adobe.com/xap/1.0/rights/".equals(xMPNode2.getName()) || (xMPNode = XMPNodeUtils.findChildNode(xMPNode2, "xapRights:UsageTerms", false)) == null) continue;
            XMPNormalizer.repairAltText(xMPNode);
        }
    }

    private static void normalizeDCArrays(XMPNode xMPNode) throws XMPException {
        for (int i = 1; i <= xMPNode.getChildrenLength(); ++i) {
            XMPNode xMPNode2 = xMPNode.getChild(i);
            PropertyOptions propertyOptions = (PropertyOptions)dcArrayForms.get(xMPNode2.getName());
            if (propertyOptions == null) continue;
            if (xMPNode2.getOptions().isSimple()) {
                XMPNode xMPNode3 = new XMPNode(xMPNode2.getName(), propertyOptions);
                xMPNode2.setName("[]");
                xMPNode3.addChild(xMPNode2);
                xMPNode.replaceChild(i, xMPNode3);
                if (!propertyOptions.isArrayAltText() || xMPNode2.getOptions().getHasLanguage()) continue;
                XMPNode xMPNode4 = new XMPNode("xml:lang", "x-default", null);
                xMPNode2.addQualifier(xMPNode4);
                continue;
            }
            xMPNode2.getOptions().setOption(7680, false);
            xMPNode2.getOptions().mergeWith(propertyOptions);
            if (!propertyOptions.isArrayAltText()) continue;
            XMPNormalizer.repairAltText(xMPNode2);
        }
    }

    private static void repairAltText(XMPNode xMPNode) throws XMPException {
        if (xMPNode == null || !xMPNode.getOptions().isArray()) {
            return;
        }
        xMPNode.getOptions().setArrayOrdered(true).setArrayAlternate(true).setArrayAltText(true);
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if (xMPNode2.getOptions().isCompositeProperty()) {
                iterator.remove();
                continue;
            }
            if (xMPNode2.getOptions().getHasLanguage()) continue;
            String string = xMPNode2.getValue();
            if (string == null || string.length() == 0) {
                iterator.remove();
                continue;
            }
            XMPNode xMPNode3 = new XMPNode("xml:lang", "x-repair", null);
            xMPNode2.addQualifier(xMPNode3);
        }
    }

    private static void moveExplicitAliases(XMPNode xMPNode, ParseOptions parseOptions) throws XMPException {
        if (!xMPNode.getHasAliases()) {
            return;
        }
        xMPNode.setHasAliases(false);
        boolean bl = parseOptions.getStrictAliasing();
        Iterator iterator = xMPNode.getUnmodifiableChildren().iterator();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if (!xMPNode2.getHasAliases()) continue;
            Iterator iterator2 = xMPNode2.iterateChildren();
            while (iterator2.hasNext()) {
                Object object;
                XMPNode xMPNode3 = (XMPNode)iterator2.next();
                if (!xMPNode3.isAlias()) continue;
                xMPNode3.setAlias(false);
                XMPAliasInfo xMPAliasInfo = XMPMetaFactory.getSchemaRegistry().findAlias(xMPNode3.getName());
                if (xMPAliasInfo == null) continue;
                XMPNode xMPNode4 = XMPNodeUtils.findSchemaNode(xMPNode, xMPAliasInfo.getNamespace(), null, true);
                xMPNode4.setImplicit(false);
                XMPNode xMPNode5 = XMPNodeUtils.findChildNode(xMPNode4, xMPAliasInfo.getPrefix() + xMPAliasInfo.getPropName(), false);
                if (xMPNode5 == null) {
                    if (xMPAliasInfo.getAliasForm().isSimple()) {
                        object = xMPAliasInfo.getPrefix() + xMPAliasInfo.getPropName();
                        xMPNode3.setName((String)object);
                        xMPNode4.addChild(xMPNode3);
                        iterator2.remove();
                        continue;
                    }
                    xMPNode5 = new XMPNode(xMPAliasInfo.getPrefix() + xMPAliasInfo.getPropName(), xMPAliasInfo.getAliasForm().toPropertyOptions());
                    xMPNode4.addChild(xMPNode5);
                    XMPNormalizer.transplantArrayItemAlias(iterator2, xMPNode3, xMPNode5);
                    continue;
                }
                if (xMPAliasInfo.getAliasForm().isSimple()) {
                    if (bl) {
                        XMPNormalizer.compareAliasedSubtrees(xMPNode3, xMPNode5, true);
                    }
                    iterator2.remove();
                    continue;
                }
                object = null;
                if (xMPAliasInfo.getAliasForm().isArrayAltText()) {
                    int n = XMPNodeUtils.lookupLanguageItem(xMPNode5, "x-default");
                    if (n != -1) {
                        object = xMPNode5.getChild(n);
                    }
                } else if (xMPNode5.hasChildren()) {
                    object = xMPNode5.getChild(1);
                }
                if (object == null) {
                    XMPNormalizer.transplantArrayItemAlias(iterator2, xMPNode3, xMPNode5);
                    continue;
                }
                if (bl) {
                    XMPNormalizer.compareAliasedSubtrees(xMPNode3, (XMPNode)object, true);
                }
                iterator2.remove();
            }
            xMPNode2.setHasAliases(false);
        }
    }

    private static void transplantArrayItemAlias(Iterator iterator, XMPNode xMPNode, XMPNode xMPNode2) throws XMPException {
        if (xMPNode2.getOptions().isArrayAltText()) {
            if (xMPNode.getOptions().getHasLanguage()) {
                throw new XMPException("Alias to x-default already has a language qualifier", 203);
            }
            XMPNode xMPNode3 = new XMPNode("xml:lang", "x-default", null);
            xMPNode.addQualifier(xMPNode3);
        }
        iterator.remove();
        xMPNode.setName("[]");
        xMPNode2.addChild(xMPNode);
    }

    private static void fixGPSTimeStamp(XMPNode xMPNode) throws XMPException {
        XMPNode xMPNode2 = XMPNodeUtils.findChildNode(xMPNode, "exif:GPSTimeStamp", false);
        if (xMPNode2 == null) {
            return;
        }
        try {
            XMPDateTime xMPDateTime = XMPUtils.convertToDate(xMPNode2.getValue());
            if (xMPDateTime.getYear() != 0 || xMPDateTime.getMonth() != 0 || xMPDateTime.getDay() != 0) {
                return;
            }
            XMPNode xMPNode3 = XMPNodeUtils.findChildNode(xMPNode, "exif:DateTimeOriginal", false);
            if (xMPNode3 == null) {
                xMPNode3 = XMPNodeUtils.findChildNode(xMPNode, "exif:DateTimeDigitized", false);
            }
            XMPDateTime xMPDateTime2 = XMPUtils.convertToDate(xMPNode3.getValue());
            Calendar calendar = xMPDateTime.getCalendar();
            calendar.set(1, xMPDateTime2.getYear());
            calendar.set(2, xMPDateTime2.getMonth());
            calendar.set(5, xMPDateTime2.getDay());
            xMPDateTime = new XMPDateTimeImpl(calendar);
            xMPNode2.setValue(XMPUtils.convertFromDate(xMPDateTime));
        }
        catch (XMPException xMPException) {
            return;
        }
    }

    private static void deleteEmptySchemas(XMPNode xMPNode) {
        Iterator iterator = xMPNode.iterateChildren();
        while (iterator.hasNext()) {
            XMPNode xMPNode2 = (XMPNode)iterator.next();
            if (xMPNode2.hasChildren()) continue;
            iterator.remove();
        }
    }

    private static void compareAliasedSubtrees(XMPNode xMPNode, XMPNode xMPNode2, boolean bl) throws XMPException {
        XMPNode xMPNode3;
        XMPNode xMPNode4;
        if (!xMPNode.getValue().equals(xMPNode2.getValue()) || xMPNode.getChildrenLength() != xMPNode2.getChildrenLength()) {
            throw new XMPException("Mismatch between alias and base nodes", 203);
        }
        if (!(bl || xMPNode.getName().equals(xMPNode2.getName()) && xMPNode.getOptions().equals(xMPNode2.getOptions()) && xMPNode.getQualifierLength() == xMPNode2.getQualifierLength())) {
            throw new XMPException("Mismatch between alias and base nodes", 203);
        }
        Iterator iterator = xMPNode.iterateChildren();
        Iterator iterator2 = xMPNode2.iterateChildren();
        while (iterator.hasNext() && iterator2.hasNext()) {
            xMPNode4 = (XMPNode)iterator.next();
            xMPNode3 = (XMPNode)iterator2.next();
            XMPNormalizer.compareAliasedSubtrees(xMPNode4, xMPNode3, false);
        }
        iterator = xMPNode.iterateQualifier();
        iterator2 = xMPNode2.iterateQualifier();
        while (iterator.hasNext() && iterator2.hasNext()) {
            xMPNode4 = (XMPNode)iterator.next();
            xMPNode3 = (XMPNode)iterator2.next();
            XMPNormalizer.compareAliasedSubtrees(xMPNode4, xMPNode3, false);
        }
    }

    private static void migrateAudioCopyright(XMPMeta xMPMeta, XMPNode xMPNode) {
        try {
            XMPNode xMPNode2 = XMPNodeUtils.findSchemaNode(((XMPMetaImpl)xMPMeta).getRoot(), "http://purl.org/dc/elements/1.1/", true);
            String string = xMPNode.getValue();
            String string2 = "\n\n";
            XMPNode xMPNode3 = XMPNodeUtils.findChildNode(xMPNode2, "dc:rights", false);
            if (xMPNode3 == null || !xMPNode3.hasChildren()) {
                string = string2 + string;
                xMPMeta.setLocalizedText("http://purl.org/dc/elements/1.1/", "rights", "", "x-default", string, null);
            } else {
                String string3;
                int n;
                Object object;
                int n2 = XMPNodeUtils.lookupLanguageItem(xMPNode3, "x-default");
                if (n2 < 0) {
                    object = xMPNode3.getChild(1).getValue();
                    xMPMeta.setLocalizedText("http://purl.org/dc/elements/1.1/", "rights", "", "x-default", (String)object, null);
                    n2 = XMPNodeUtils.lookupLanguageItem(xMPNode3, "x-default");
                }
                if ((n = (string3 = ((XMPNode)(object = xMPNode3.getChild(n2))).getValue()).indexOf(string2)) < 0) {
                    if (!string.equals(string3)) {
                        ((XMPNode)object).setValue(string3 + string2 + string);
                    }
                } else if (!string3.substring(n + 2).equals(string)) {
                    ((XMPNode)object).setValue(string3.substring(0, n + 2) + string);
                }
            }
            xMPNode.getParent().removeChild(xMPNode);
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    private static void initDCArrays() {
        dcArrayForms = new HashMap();
        PropertyOptions propertyOptions = new PropertyOptions();
        propertyOptions.setArray(true);
        dcArrayForms.put("dc:contributor", propertyOptions);
        dcArrayForms.put("dc:language", propertyOptions);
        dcArrayForms.put("dc:publisher", propertyOptions);
        dcArrayForms.put("dc:relation", propertyOptions);
        dcArrayForms.put("dc:subject", propertyOptions);
        dcArrayForms.put("dc:type", propertyOptions);
        PropertyOptions propertyOptions2 = new PropertyOptions();
        propertyOptions2.setArray(true);
        propertyOptions2.setArrayOrdered(true);
        dcArrayForms.put("dc:creator", propertyOptions2);
        dcArrayForms.put("dc:date", propertyOptions2);
        PropertyOptions propertyOptions3 = new PropertyOptions();
        propertyOptions3.setArray(true);
        propertyOptions3.setArrayOrdered(true);
        propertyOptions3.setArrayAlternate(true);
        propertyOptions3.setArrayAltText(true);
        dcArrayForms.put("dc:description", propertyOptions3);
        dcArrayForms.put("dc:rights", propertyOptions3);
        dcArrayForms.put("dc:title", propertyOptions3);
    }

    static {
        XMPNormalizer.initDCArrays();
    }
}

