/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.options.PropertyOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class XMPNode
implements Comparable {
    private String name;
    private String value;
    private XMPNode parent;
    private List children = null;
    private List qualifier = null;
    private PropertyOptions options = null;
    private boolean implicit;
    private boolean hasAliases;
    private boolean alias;
    private boolean hasValueChild;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XMPNode(String string, String string2, PropertyOptions propertyOptions) {
        this.name = string;
        this.value = string2;
        this.options = propertyOptions;
    }

    public XMPNode(String string, PropertyOptions propertyOptions) {
        this(string, null, propertyOptions);
    }

    public void clear() {
        this.options = null;
        this.name = null;
        this.value = null;
        this.children = null;
        this.qualifier = null;
    }

    public XMPNode getParent() {
        return this.parent;
    }

    public XMPNode getChild(int n) {
        return (XMPNode)this.getChildren().get(n - 1);
    }

    public void addChild(XMPNode xMPNode) throws XMPException {
        this.assertChildNotExisting(xMPNode.getName());
        xMPNode.setParent(this);
        this.getChildren().add(xMPNode);
    }

    public void addChild(int n, XMPNode xMPNode) throws XMPException {
        this.assertChildNotExisting(xMPNode.getName());
        xMPNode.setParent(this);
        this.getChildren().add(n - 1, xMPNode);
    }

    public void replaceChild(int n, XMPNode xMPNode) {
        xMPNode.setParent(this);
        this.getChildren().set(n - 1, xMPNode);
    }

    public void removeChild(int n) {
        this.getChildren().remove(n - 1);
        this.cleanupChildren();
    }

    public void removeChild(XMPNode xMPNode) {
        this.getChildren().remove(xMPNode);
        this.cleanupChildren();
    }

    protected void cleanupChildren() {
        if (this.children.isEmpty()) {
            this.children = null;
        }
    }

    public void removeChildren() {
        this.children = null;
    }

    public int getChildrenLength() {
        return this.children != null ? this.children.size() : 0;
    }

    public XMPNode findChildByName(String string) {
        return this.find(this.getChildren(), string);
    }

    public XMPNode getQualifier(int n) {
        return (XMPNode)this.getQualifier().get(n - 1);
    }

    public int getQualifierLength() {
        return this.qualifier != null ? this.qualifier.size() : 0;
    }

    public void addQualifier(XMPNode xMPNode) throws XMPException {
        this.assertQualifierNotExisting(xMPNode.getName());
        xMPNode.setParent(this);
        xMPNode.getOptions().setQualifier(true);
        this.getOptions().setHasQualifiers(true);
        if (xMPNode.isLanguageNode()) {
            this.options.setHasLanguage(true);
            this.getQualifier().add(0, xMPNode);
        } else if (xMPNode.isTypeNode()) {
            this.options.setHasType(true);
            this.getQualifier().add(!this.options.getHasLanguage() ? 0 : 1, xMPNode);
        } else {
            this.getQualifier().add(xMPNode);
        }
    }

    public void removeQualifier(XMPNode xMPNode) {
        PropertyOptions propertyOptions = this.getOptions();
        if (xMPNode.isLanguageNode()) {
            propertyOptions.setHasLanguage(false);
        } else if (xMPNode.isTypeNode()) {
            propertyOptions.setHasType(false);
        }
        this.getQualifier().remove(xMPNode);
        if (this.qualifier.isEmpty()) {
            propertyOptions.setHasQualifiers(false);
            this.qualifier = null;
        }
    }

    public void removeQualifiers() {
        PropertyOptions propertyOptions = this.getOptions();
        propertyOptions.setHasQualifiers(false);
        propertyOptions.setHasLanguage(false);
        propertyOptions.setHasType(false);
        this.qualifier = null;
    }

    public XMPNode findQualifierByName(String string) {
        return this.find(this.qualifier, string);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public Iterator iterateChildren() {
        if (this.children != null) {
            return this.getChildren().iterator();
        }
        return Collections.EMPTY_LIST.listIterator();
    }

    public boolean hasQualifier() {
        return this.qualifier != null && this.qualifier.size() > 0;
    }

    public Iterator iterateQualifier() {
        if (this.qualifier != null) {
            final Iterator iterator = this.getQualifier().iterator();
            return new Iterator(){

                public boolean hasNext() {
                    return iterator.hasNext();
                }

                public Object next() {
                    return iterator.next();
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove() is not allowed due to the internal contraints");
                }
            };
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Object clone() {
        PropertyOptions propertyOptions;
        try {
            propertyOptions = new PropertyOptions(this.getOptions().getOptions());
        }
        catch (XMPException xMPException) {
            propertyOptions = new PropertyOptions();
        }
        XMPNode xMPNode = new XMPNode(this.name, this.value, propertyOptions);
        this.cloneSubtree(xMPNode);
        return xMPNode;
    }

    public void cloneSubtree(XMPNode xMPNode) {
        block4: {
            try {
                XMPNode xMPNode2;
                Iterator iterator = this.iterateChildren();
                while (iterator.hasNext()) {
                    xMPNode2 = (XMPNode)iterator.next();
                    xMPNode.addChild((XMPNode)xMPNode2.clone());
                }
                iterator = this.iterateQualifier();
                while (iterator.hasNext()) {
                    xMPNode2 = (XMPNode)iterator.next();
                    xMPNode.addQualifier((XMPNode)xMPNode2.clone());
                }
            }
            catch (XMPException xMPException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public String dumpNode(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(512);
        this.dumpNode(stringBuffer, bl, 0, 0);
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        if (this.getOptions().isSchemaNode()) {
            return this.value.compareTo(((XMPNode)object).getValue());
        }
        return this.name.compareTo(((XMPNode)object).getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public PropertyOptions getOptions() {
        if (this.options == null) {
            this.options = new PropertyOptions();
        }
        return this.options;
    }

    public void setOptions(PropertyOptions propertyOptions) {
        this.options = propertyOptions;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean bl) {
        this.implicit = bl;
    }

    public boolean getHasAliases() {
        return this.hasAliases;
    }

    public void setHasAliases(boolean bl) {
        this.hasAliases = bl;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean bl) {
        this.alias = bl;
    }

    public boolean getHasValueChild() {
        return this.hasValueChild;
    }

    public void setHasValueChild(boolean bl) {
        this.hasValueChild = bl;
    }

    public void sort() {
        Object object;
        if (this.hasQualifier()) {
            int n;
            object = this.getQualifier().toArray(new XMPNode[this.getQualifierLength()]);
            for (n = 0; ((Object)object).length > n && ("xml:lang".equals(((XMPNode)object[n]).getName()) || "rdf:type".equals(((XMPNode)object[n]).getName())); ++n) {
                ((XMPNode)object[n]).sort();
            }
            Arrays.sort((Object[])object, n, ((Object)object).length);
            ListIterator<Object> listIterator = this.qualifier.listIterator();
            for (int i = 0; i < ((Object)object).length; ++i) {
                listIterator.next();
                listIterator.set(object[i]);
                ((XMPNode)object[i]).sort();
            }
        }
        if (this.hasChildren()) {
            if (!this.getOptions().isArray()) {
                Collections.sort(this.children);
            }
            object = this.iterateChildren();
            while (object.hasNext()) {
                ((XMPNode)object.next()).sort();
            }
        }
    }

    private void dumpNode(StringBuffer stringBuffer, boolean bl, int n, int n2) {
        Object object;
        int n3;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\t');
        }
        if (this.parent != null) {
            if (this.getOptions().isQualifier()) {
                stringBuffer.append('?');
                stringBuffer.append(this.name);
            } else if (this.getParent().getOptions().isArray()) {
                stringBuffer.append('[');
                stringBuffer.append(n2);
                stringBuffer.append(']');
            } else {
                stringBuffer.append(this.name);
            }
        } else {
            stringBuffer.append("ROOT NODE");
            if (this.name != null && this.name.length() > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(this.name);
                stringBuffer.append(')');
            }
        }
        if (this.value != null && this.value.length() > 0) {
            stringBuffer.append(" = \"");
            stringBuffer.append(this.value);
            stringBuffer.append('\"');
        }
        if (this.getOptions().containsOneOf(-1)) {
            stringBuffer.append("\t(");
            stringBuffer.append(this.getOptions().toString());
            stringBuffer.append(" : ");
            stringBuffer.append(this.getOptions().getOptionsString());
            stringBuffer.append(')');
        }
        stringBuffer.append('\n');
        if (bl && this.hasQualifier()) {
            Object[] objectArray = this.getQualifier().toArray(new XMPNode[this.getQualifierLength()]);
            for (n3 = 0; objectArray.length > n3 && ("xml:lang".equals(objectArray[n3].getName()) || "rdf:type".equals(((XMPNode)objectArray[n3]).getName())); ++n3) {
            }
            Arrays.sort(objectArray, n3, objectArray.length);
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                object = objectArray[n3];
                super.dumpNode(stringBuffer, bl, n + 2, n3 + 1);
            }
        }
        if (bl && this.hasChildren()) {
            Object[] objectArray = this.getChildren().toArray(new XMPNode[this.getChildrenLength()]);
            if (!this.getOptions().isArray()) {
                Arrays.sort(objectArray);
            }
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                object = objectArray[n3];
                super.dumpNode(stringBuffer, bl, n + 1, n3 + 1);
            }
        }
    }

    private boolean isLanguageNode() {
        return "xml:lang".equals(this.name);
    }

    private boolean isTypeNode() {
        return "rdf:type".equals(this.name);
    }

    private List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList(0);
        }
        return this.children;
    }

    public List getUnmodifiableChildren() {
        return Collections.unmodifiableList(new ArrayList(this.getChildren()));
    }

    private List getQualifier() {
        if (this.qualifier == null) {
            this.qualifier = new ArrayList(0);
        }
        return this.qualifier;
    }

    protected void setParent(XMPNode xMPNode) {
        this.parent = xMPNode;
    }

    private XMPNode find(List list, String string) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XMPNode xMPNode = (XMPNode)iterator.next();
                if (!xMPNode.getName().equals(string)) continue;
                return xMPNode;
            }
        }
        return null;
    }

    private void assertChildNotExisting(String string) throws XMPException {
        if (!"[]".equals(string) && this.findChildByName(string) != null) {
            throw new XMPException("Duplicate property or field node '" + string + "'", 203);
        }
    }

    private void assertQualifierNotExisting(String string) throws XMPException {
        if (!"[]".equals(string) && this.findQualifierByName(string) != null) {
            throw new XMPException("Duplicate '" + string + "' qualifier", 203);
        }
    }

    static {
        $assertionsDisabled = !XMPNode.class.desiredAssertionStatus();
    }
}

