/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.impl.ByteBuffer;
import com.adobe.xmp.impl.FixASCIIControlsReader;
import com.adobe.xmp.impl.Latin1Converter;
import com.adobe.xmp.impl.ParameterAsserts;
import com.adobe.xmp.impl.ParseRDF;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNormalizer;
import com.adobe.xmp.options.ParseOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMPMetaParser {
    private static final Object XMP_RDF = new Object();
    private static DocumentBuilderFactory factory = XMPMetaParser.createDocumentBuilderFactory();

    private XMPMetaParser() {
    }

    public static XMPMeta parse(Object object, ParseOptions parseOptions) throws XMPException {
        ParameterAsserts.assertNotNull(object);
        parseOptions = parseOptions != null ? parseOptions : new ParseOptions();
        Document document = XMPMetaParser.parseXml(object, parseOptions);
        boolean bl = parseOptions.getRequireXMPMeta();
        Object[] objectArray = XMPMetaParser.findRootNode(document, bl);
        if (objectArray != null && objectArray[1] == XMP_RDF) {
            XMPMetaImpl xMPMetaImpl = ParseRDF.parse((Node)objectArray[0]);
            return XMPNormalizer.process(xMPMetaImpl, parseOptions);
        }
        return new XMPMetaImpl();
    }

    private static Document parseXml(Object object, ParseOptions parseOptions) throws XMPException {
        if (object instanceof InputStream) {
            return XMPMetaParser.parseXmlFromInputStream((InputStream)object, parseOptions);
        }
        if (object instanceof byte[]) {
            return XMPMetaParser.parseXmlFromBytebuffer(new ByteBuffer((byte[])object), parseOptions);
        }
        return XMPMetaParser.parseXmlFromString((String)object, parseOptions);
    }

    private static Document parseXmlFromInputStream(InputStream inputStream, ParseOptions parseOptions) throws XMPException {
        if (!parseOptions.getAcceptLatin1() && !parseOptions.getFixControlChars()) {
            return XMPMetaParser.parseInputSource(new InputSource(inputStream));
        }
        try {
            ByteBuffer byteBuffer = new ByteBuffer(inputStream);
            return XMPMetaParser.parseXmlFromBytebuffer(byteBuffer, parseOptions);
        }
        catch (IOException iOException) {
            throw new XMPException("Error reading the XML-file", 204, iOException);
        }
    }

    private static Document parseXmlFromBytebuffer(ByteBuffer byteBuffer, ParseOptions parseOptions) throws XMPException {
        InputSource inputSource = new InputSource(byteBuffer.getByteStream());
        try {
            return XMPMetaParser.parseInputSource(inputSource);
        }
        catch (XMPException xMPException) {
            if (xMPException.getErrorCode() == 201) {
                if (parseOptions.getAcceptLatin1()) {
                    byteBuffer = Latin1Converter.convert(byteBuffer);
                }
                if (parseOptions.getFixControlChars()) {
                    try {
                        String string = byteBuffer.getEncoding();
                        FixASCIIControlsReader fixASCIIControlsReader = new FixASCIIControlsReader(new InputStreamReader(byteBuffer.getByteStream(), string));
                        return XMPMetaParser.parseInputSource(new InputSource(fixASCIIControlsReader));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new XMPException("Unsupported Encoding", 9, xMPException);
                    }
                }
                inputSource = new InputSource(byteBuffer.getByteStream());
                return XMPMetaParser.parseInputSource(inputSource);
            }
            throw xMPException;
        }
    }

    private static Document parseXmlFromString(String string, ParseOptions parseOptions) throws XMPException {
        InputSource inputSource = new InputSource(new StringReader(string));
        try {
            return XMPMetaParser.parseInputSource(inputSource);
        }
        catch (XMPException xMPException) {
            if (xMPException.getErrorCode() == 201 && parseOptions.getFixControlChars()) {
                inputSource = new InputSource(new FixASCIIControlsReader(new StringReader(string)));
                return XMPMetaParser.parseInputSource(inputSource);
            }
            throw xMPException;
        }
    }

    private static Document parseInputSource(InputSource inputSource) throws XMPException {
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(null);
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new XMPException("XML parsing failure", 201, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMPException("XML Parser not correctly configured", 0, parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new XMPException("Error reading the XML-file", 204, iOException);
        }
    }

    private static Object[] findRootNode(Node node, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (3 == node.getNodeType() || 7 == node.getNodeType()) continue;
            String string = node.getNamespaceURI();
            String string2 = node.getLocalName();
            if (("xmpmeta".equals(string2) || "xapmeta".equals(string2)) && "adobe:ns:meta/".equals(string)) {
                return XMPMetaParser.findRootNode(node, false);
            }
            if (!bl && "RDF".equals(string2) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string)) {
                return new Object[]{node, XMP_RDF};
            }
            Object[] objectArray = XMPMetaParser.findRootNode(node, bl);
            if (objectArray == null) continue;
            return objectArray;
        }
        return null;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setExpandEntityReferences(true);
        return documentBuilderFactory;
    }
}

