/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPSchemaRegistry;
import com.adobe.xmp.XMPVersionInfo;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPMetaParser;
import com.adobe.xmp.impl.XMPSchemaRegistryImpl;
import com.adobe.xmp.impl.XMPSerializerHelper;
import com.adobe.xmp.options.ParseOptions;
import com.adobe.xmp.options.SerializeOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class XMPMetaFactory {
    private static XMPSchemaRegistry schema = new XMPSchemaRegistryImpl();
    private static XMPVersionInfo versionInfo = null;

    private XMPMetaFactory() {
    }

    public static XMPSchemaRegistry getSchemaRegistry() {
        return schema;
    }

    public static XMPMeta create() {
        return new XMPMetaImpl();
    }

    public static XMPMeta parse(InputStream inputStream) throws XMPException {
        return XMPMetaFactory.parse(inputStream, null);
    }

    public static XMPMeta parse(InputStream inputStream, ParseOptions parseOptions) throws XMPException {
        return XMPMetaParser.parse(inputStream, parseOptions);
    }

    public static XMPMeta parseFromString(String string) throws XMPException {
        return XMPMetaFactory.parseFromString(string, null);
    }

    public static XMPMeta parseFromString(String string, ParseOptions parseOptions) throws XMPException {
        return XMPMetaParser.parse(string, parseOptions);
    }

    public static XMPMeta parseFromBuffer(byte[] byArray) throws XMPException {
        return XMPMetaFactory.parseFromBuffer(byArray, null);
    }

    public static XMPMeta parseFromBuffer(byte[] byArray, ParseOptions parseOptions) throws XMPException {
        return XMPMetaParser.parse(byArray, parseOptions);
    }

    public static void serialize(XMPMeta xMPMeta, OutputStream outputStream) throws XMPException {
        XMPMetaFactory.serialize(xMPMeta, outputStream, null);
    }

    public static void serialize(XMPMeta xMPMeta, OutputStream outputStream, SerializeOptions serializeOptions) throws XMPException {
        XMPMetaFactory.assertImplementation(xMPMeta);
        XMPSerializerHelper.serialize((XMPMetaImpl)xMPMeta, outputStream, serializeOptions);
    }

    public static byte[] serializeToBuffer(XMPMeta xMPMeta, SerializeOptions serializeOptions) throws XMPException {
        XMPMetaFactory.assertImplementation(xMPMeta);
        return XMPSerializerHelper.serializeToBuffer((XMPMetaImpl)xMPMeta, serializeOptions);
    }

    public static String serializeToString(XMPMeta xMPMeta, SerializeOptions serializeOptions) throws XMPException {
        XMPMetaFactory.assertImplementation(xMPMeta);
        return XMPSerializerHelper.serializeToString((XMPMetaImpl)xMPMeta, serializeOptions);
    }

    private static void assertImplementation(XMPMeta xMPMeta) {
        if (!(xMPMeta instanceof XMPMetaImpl)) {
            throw new UnsupportedOperationException("The serializing service works onlywith the XMPMeta implementation of this library");
        }
    }

    public static void reset() {
        schema = new XMPSchemaRegistryImpl();
    }

    public static XMPVersionInfo getVersionInfo() {
        if (versionInfo == null) {
            try {
                Properties properties = new Properties();
                properties.load(XMPMetaFactory.class.getResourceAsStream("version.properties"));
                final int n = Integer.parseInt(properties.getProperty("implementation.version.major"));
                final int n2 = Integer.parseInt(properties.getProperty("implementation.version.minor"));
                final int n3 = Integer.parseInt(properties.getProperty("implementation.version.micro"));
                final boolean bl = Boolean.valueOf(properties.getProperty("implementation.version.debug"));
                final String string = properties.getProperty("implementation.version");
                final int n4 = Integer.parseInt(properties.getProperty("implementation.version.engbuild"));
                versionInfo = new XMPVersionInfo(){

                    public int getMajor() {
                        return n;
                    }

                    public int getMinor() {
                        return n2;
                    }

                    public int getMicro() {
                        return n3;
                    }

                    public boolean isDebug() {
                        return bl;
                    }

                    public int getBuild() {
                        return n4;
                    }

                    public String getMessage() {
                        return string;
                    }

                    public String toString() {
                        return string;
                    }
                };
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return versionInfo;
    }
}

