/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import se.datadosen.util.IO;

public class SmartResourceBundle
implements Serializable {
    private static final int MAX_BUNDLES_SEARCHED = 3;
    protected Map resources = new HashMap();
    protected SmartResourceBundle parent = null;
    private Locale locale = null;

    protected SmartResourceBundle() {
    }

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        Object obj = this.resources.get(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(SmartResourceBundle parent) {
        this.parent = parent;
    }

    public static final SmartResourceBundle getBundle(File dir, String baseName) {
        return SmartResourceBundle.getBundle(dir, baseName, Locale.getDefault());
    }

    public static final SmartResourceBundle getBundle(File dir, String baseName, Locale locale) {
        Vector names = SmartResourceBundle.calculateBundleNames(baseName, locale);
        SmartResourceBundle bundle = null;
        SmartResourceBundle last = null;
        try {
            for (int i = 0; i < names.size(); ++i) {
                File bundleFile = new File(dir, names.get(i) + ".properties");
                if (!bundleFile.exists()) continue;
                bundle = new SmartResourceBundle();
                bundle.resources = IO.readMapFile(bundleFile);
                if (i > 0) {
                    bundle.locale = locale;
                }
                bundle.setParent(last);
                last = bundle;
            }
            if (bundle == null) {
                throw new MissingResourceException("Resource file: " + new File(dir, names.get(0) + ".properties").getAbsolutePath(), null, null);
            }
            return bundle;
        }
        catch (IOException ex) {
            throw new MissingResourceException("Cannot read bundle file: " + ex, baseName, null);
        }
    }

    public static final SmartResourceBundle getBundle(Class caller, String baseName) {
        return SmartResourceBundle.getBundle(caller, baseName, Locale.getDefault());
    }

    public static final SmartResourceBundle getBundle(Class callerClass, String baseName, Locale locale) {
        Vector names = SmartResourceBundle.calculateBundleNames(baseName, locale);
        SmartResourceBundle bundle = null;
        SmartResourceBundle last = null;
        File base = null;
        try {
            URL baseURL = new URL(callerClass.getResource("").getPath());
            if (baseURL.getProtocol().equals("file")) {
                base = new File(URLDecoder.decode(baseURL.getPath().replaceAll(".jar!", ""), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        try {
            for (int i = 0; i < names.size(); ++i) {
                int bytesRead;
                InputStream is;
                File f;
                if (base != null && (f = new File(base, names.get(i) + ".properties")).exists()) {
                    is = new FileInputStream(f);
                } else {
                    is = callerClass.getResourceAsStream(names.get(i) + ".properties");
                    if (is == null) continue;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[65536];
                while ((bytesRead = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                is.close();
                bos.close();
                bundle = new SmartResourceBundle();
                bundle.resources = IO.readMap(bos.toByteArray());
                if (i > 0) {
                    bundle.locale = locale;
                }
                bundle.setParent(last);
                last = bundle;
            }
            if (bundle == null) {
                throw new MissingResourceException("Resource: " + callerClass.getName() + ": " + baseName + ".properties", null, null);
            }
            return bundle;
        }
        catch (IOException ex) {
            throw new MissingResourceException("Cannot read bundle: " + ex, baseName, null);
        }
    }

    private static Vector calculateBundleNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        result.addElement(temp.toString());
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.addElement(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.addElement(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    public Set getKeys() {
        if (this.parent != null) {
            HashSet allKeys = new HashSet(this.parent.getKeys());
            allKeys.addAll(this.resources.keySet());
            return allKeys;
        }
        return this.resources.keySet();
    }

    public static void main(String[] args) {
    }
}

