/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NoValidSkinException;
import se.datadosen.util.IO;

public class SkinManager {
    public static final String JALBUM_SKIN_EXTENSION = ".jaskin";
    private int initiallyIgnoredCount;
    private Set<String> ignoreDirs = new HashSet<String>(){
        {
            this.add("__MACOSX");
            this.add(".svn");
            SkinManager.this.initiallyIgnoredCount = this.size();
        }
    };
    private ProgressMonitor progressMonitor;

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public void addIgnoreDir(String dir) {
        this.ignoreDirs.add(dir);
    }

    private boolean isIgnored(String path) {
        for (String ignoreDir : this.ignoreDirs) {
            if (!path.contains(ignoreDir)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String doInstallSkin(File skinFile, File skinsDir) throws ZipException, IOException {
        String string;
        ZipFile zf = new ZipFile(skinFile);
        try {
            if (this.progressMonitor != null) {
                this.progressMonitor.setMinimum(1);
                this.progressMonitor.setMaximum(zf.size());
            }
            File destDir = skinsDir;
            String currentPath = null;
            String skinName = null;
            int counter = 1;
            HashSet<File> visitedRoots = new HashSet<File>();
            Enumeration<? extends ZipEntry> files = zf.entries();
            while (files.hasMoreElements()) {
                ZipEntry e = files.nextElement();
                String p = this.pathOf(e);
                if (!this.isIgnored(p)) {
                    if (!p.equals(currentPath)) {
                        currentPath = p;
                        String n = this.rootOf(e);
                        if (skinName == null) {
                            skinName = n;
                        }
                        destDir = new File(skinsDir, currentPath);
                        File skinDir = new File(skinsDir, n);
                        if (!visitedRoots.contains(skinDir)) {
                            if (skinDir.exists()) {
                                IO.recycle(skinDir);
                            }
                            visitedRoots.add(skinDir);
                        }
                        destDir.mkdirs();
                    }
                    File destFile = new File(destDir, this.nameOf(e));
                    if (e.isDirectory()) {
                        if (!this.isIgnored(this.nameOf(e))) {
                            destFile.mkdir();
                        }
                    } else {
                        Object var18_17;
                        BufferedInputStream in = new BufferedInputStream(zf.getInputStream(e));
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destFile));
                        try {
                            byte[] buffer;
                            int bytesRead;
                            while ((bytesRead = in.read(buffer = new byte[65536])) != -1) {
                                out.write(buffer, 0, bytesRead);
                            }
                            var18_17 = null;
                        }
                        catch (Throwable throwable) {
                            var18_17 = null;
                            in.close();
                            out.close();
                            throw throwable;
                        }
                        in.close();
                        out.close();
                        {
                        }
                    }
                    if (e.getTime() != -1L) {
                        destFile.setLastModified(e.getTime());
                    }
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.setProgress(counter);
                    if (this.progressMonitor.isCanceled()) break;
                }
                ++counter;
            }
            string = skinName;
            Object var20_19 = null;
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            zf.close();
            throw throwable;
        }
        zf.close();
        return string;
    }

    public void installSkin(File skinFile) {
        Config config = Config.getConfig();
        this.installSkin(skinFile, config.chainedSkinsDir.getDirectory());
    }

    public void installSkin(final File skinFile, final File skinsDir) {
        try {
            skinsDir.mkdirs();
            final Set skins = this.listSkins(skinFile);
            Object[] a = skins.toArray();
            JCheckBox[] selections = new JCheckBox[a.length];
            ControlPanel skinPanel = new ControlPanel();
            ((RiverLayout)skinPanel.getLayout()).setHgap(0);
            skinPanel.add(new JLabel(Msg.get("sm.skinInstallerInfo")));
            for (int i = 0; i < a.length; ++i) {
                String skinName = a[i].toString();
                File skinDir = new File(skinsDir, skinName);
                selections[i] = new JCheckBox(skinName, true);
                skinPanel.add("br", selections[i]);
                if (!skinDir.exists()) continue;
                JLabel label = new JLabel("(" + Msg.get("sm.alreadyInstalledWarning") + ")");
                skinPanel.add(label);
            }
            int answer = JOptionPane.showConfirmDialog(null, skinPanel, Msg.get("sm.skinManagerTitle"), 2, 1);
            if (answer != 0) {
                return;
            }
            for (int i = 0; i < selections.length; ++i) {
                if (selections[i].isSelected()) continue;
                this.addIgnoreDir(selections[i].getText());
            }
            UIManager.put("ProgressMonitor.progressText", Msg.get("sm.skinManagerTitle"));
            final ProgressMonitor pm = new ProgressMonitor(null, Msg.get("sm.installingSkinInfo") + "...", null, 1, 1);
            this.setProgressMonitor(pm);
            Thread installThread = new Thread("Skin install thread"){

                public void run() {
                    try {
                        String skinName = SkinManager.this.doInstallSkin(skinFile, skinsDir);
                        if (!pm.isCanceled() && SkinManager.this.ignoreDirs.size() - SkinManager.this.initiallyIgnoredCount < skins.size()) {
                            JOptionPane.showMessageDialog(null, Msg.get("sm.skinInstalledInfo"), Msg.get("sm.skinManagerTitle"), 1);
                            JAlbumContext context = JAlbumContext.getInstance();
                            if (context.getFrame() != null && skinName != null) {
                                JAlbumFrame window = context.getFrame();
                                window.mainSettingsPanel.scanSkins();
                                window.mainSettingsPanel.skin.setSelectedItem(skinName);
                            }
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("sm.skinManagerTitle"), 0);
                    }
                }
            };
            installThread.setDaemon(true);
            installThread.start();
        }
        catch (NoValidSkinException ex) {
            JOptionPane.showMessageDialog(null, Msg.get("sm.notAValidSkinFileError"), Msg.get("sm.skinManagerTitle"), 0);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), Msg.get("sm.skinManagerTitle"), 0);
        }
    }

    private String pathOf(ZipEntry e) {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.lastIndexOf(47)) == -1) {
            return "";
        }
        return s.substring(0, i);
    }

    private String nameOf(ZipEntry e) {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.lastIndexOf(47)) == -1) {
            return s;
        }
        return s.substring(i + 1);
    }

    public Set listSkins(File skinFile) throws NoValidSkinException, ZipException, IOException {
        ZipFile zf = new ZipFile(skinFile);
        TreeSet<String> names = new TreeSet<String>();
        Enumeration<? extends ZipEntry> files = zf.entries();
        while (files.hasMoreElements()) {
            ZipEntry e = files.nextElement();
            String rootName = this.rootOf(e);
            if (this.ignoreDirs.contains(rootName)) continue;
            names.add(rootName);
        }
        if (names.size() == 0) {
            throw new NoValidSkinException();
        }
        return names;
    }

    private String rootOf(ZipEntry e) throws NoValidSkinException {
        int i;
        String s = e.getName();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((i = s.indexOf(47)) == -1) {
            if (e.isDirectory()) {
                return s;
            }
            throw new NoValidSkinException();
        }
        return s.substring(0, i);
    }
}

