/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FilterPluginList;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.util.IO;

class PluginManager {
    private static final String PLUGIN_POSTFIX = "Plugin.class";
    private static List<JAlbumPlugin> plugins = new ArrayList<JAlbumPlugin>();

    PluginManager() {
    }

    static void loadPlugins() {
        File[] jars;
        PluginManager.loadPlugins(Config.getConfig().pluginsDir, "");
        File extDir = new File(Config.getConfig().progDir, "ext");
        for (File jar : jars = PluginManager.buildFileList(extDir)) {
            PluginManager.loadPlugins(jar);
        }
        FilterPluginList.getInstance().sort();
    }

    private static final File[] buildFileList(File dir) {
        Object[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                return s.endsWith(".jar") || s.endsWith(".zip");
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        Arrays.sort(files);
        return files;
    }

    private static void loadPlugins(File jarFile) {
        try {
            ZipFile zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> files = zf.entries();
            while (files.hasMoreElements()) {
                ZipEntry e = files.nextElement();
                if (!e.getName().endsWith(PLUGIN_POSTFIX)) continue;
                String s = e.getName();
                String className = s.substring(0, s.length() - 6).replace('/', '.');
                PluginManager.createPlugin(className);
            }
        }
        catch (ZipException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadPlugins(File dir, String javaPackage) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                PluginManager.loadPlugins(f, javaPackage.length() == 0 ? f.getName() : javaPackage + "." + f.getName());
                continue;
            }
            if (!f.getName().endsWith(PLUGIN_POSTFIX)) continue;
            String className = javaPackage.length() == 0 ? IO.baseName(f) : javaPackage + "." + IO.baseName(f);
            PluginManager.createPlugin(className);
        }
    }

    private static void createPlugin(String className) {
        ClassLoader cl = PluginManager.class.getClassLoader();
        try {
            Class<?> c = cl.loadClass(className);
            if (PluginManager.isPlugin(c)) {
                Object o = c.newInstance();
                plugins.add((JAlbumPlugin)o);
            }
            if (PluginManager.isImageFilter(c)) {
                FilterPluginList.getInstance().addFilterClass(className);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private static boolean isPlugin(Class c) {
        while (c != null) {
            for (Class<?> in : c.getInterfaces()) {
                if (!in.equals(JAlbumPlugin.class)) continue;
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    private static boolean isImageFilter(Class c) {
        while (c != null) {
            for (Class<?> in : c.getInterfaces()) {
                if (!in.equals(JAlbumImageFilter.class)) continue;
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    public static void initPlugins() {
        for (JAlbumPlugin plugin : plugins) {
            try {
                plugin.init(JAlbumContext.getInstance().getPluginContext());
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    public static boolean onExit() {
        boolean okToExit = true;
        for (JAlbumPlugin plugin : plugins) {
            try {
                boolean ok = plugin.onExit();
                if (ok) continue;
                okToExit = false;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        return okToExit;
    }
}

