/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.VersionNumber;

public class JDonateDialog
extends JDialog {
    private static final String SUPRESS_DONATE_DIALOG_FOR = "supressDonateDialogFor";
    private static final String DONATE_DIALOG_LAST_SHOWN = "donateDialogLastShown";
    JCheckBox dontShowAgain = new JCheckBox(Msg.get("ui.dontShowAgain"));
    Action donateAction = new AbstractAction(Msg.get("ui.donate")){

        public void actionPerformed(ActionEvent e) {
            JDonateDialog.this.onClosing();
            try {
                BrowserLauncher.openURL(JAlbumSite.getInstance().getSupportingUrl() + "?referrer=jalbumDonateDialog");
                JDonateDialog.this.setVisible(false);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JDonateDialog.this, (Throwable)ex);
            }
        }
    };
    Action laterAction = new AbstractAction(Msg.get("ui.later")){

        public void actionPerformed(ActionEvent e) {
            JDonateDialog.this.onClosing();
            JDonateDialog.this.setVisible(false);
        }
    };

    public JDonateDialog(JAlbumFrame owner) {
        super(owner, Msg.get("ui.supportingJAlbumMenu"), true);
        this.init();
    }

    private void onClosing() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(JDonateDialog.class);
            if (this.dontShowAgain.isSelected()) {
                prefs.put(SUPRESS_DONATE_DIALOG_FOR, AlbumBean.getInternalVersion());
            }
            prefs.putLong(DONATE_DIALOG_LAST_SHOWN, new Date().getTime());
        }
        catch (Throwable t) {
            System.err.println(t);
        }
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JDonateDialog.this.onClosing();
            }
        });
        JLogoPanel panel = new JLogoPanel(Icons.getImage("decorations.dorhandstanding"));
        this.setContentPane(panel);
        panel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setOpaque(false);
        buttonPanel.add(new JButton(this.laterAction));
        JButton donateButton = new JButton(this.donateAction);
        this.getRootPane().setDefaultButton(donateButton);
        buttonPanel.add(donateButton);
        panel.add((Component)buttonPanel, "South");
        JPanel centerPanel = new JPanel(new RiverLayout());
        centerPanel.setOpaque(false);
        WrappableJLabel message = new WrappableJLabel(Msg.get("ui.donateInfo"));
        message.setPreferredWidth(360);
        centerPanel.add("hfill vfill", message);
        centerPanel.add("p", this.dontShowAgain);
        panel.add((Component)centerPanel, "Center");
        panel.setBorder(BorderFactory.createEmptyBorder(4, 110, 10, 10));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public static boolean shouldShow() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(JDonateDialog.class);
            String supressedVersion = prefs.get(SUPRESS_DONATE_DIALOG_FOR, "1.0");
            if (new VersionNumber(AlbumBean.getInternalVersion()).compareTo(new VersionNumber(supressedVersion)) <= 0) {
                return false;
            }
            AccountManager.AccountStatus status = JAlbumContext.getInstance().getFrame().accountStatusPanel.getStatus();
            if (status != null && (status.isDonor() || !status.isFree())) {
                return false;
            }
            long lastShown = prefs.getLong(DONATE_DIALOG_LAST_SHOWN, 0L);
            if (new Date().getTime() - lastShown < 1440000L) {
                return false;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private static class JLogoPanel
    extends JPanel {
        Image image;

        public JLogoPanel(Image im) {
            this.image = im;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Insets in = this.getInsets();
            g.drawImage(this.image, 0, this.getHeight() - this.image.getHeight(null), null);
        }
    }
}

