/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;

public class JAlbumSite {
    private static JAlbumSite theInstance;
    private static final String PAD_URL = "http://jalbum.net/pad.xml";
    private String padContent;
    private String clientVersion;
    private static Properties properties;
    private Exception lastException;
    private static final int CONNECT_TIMEOUT = 5000;

    public boolean isAvailable() {
        return properties != null;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void update() throws ElementException, IOException {
        URL padUrl;
        String url = System.getProperty("padUrl", PAD_URL);
        File padFile = new File(Config.getConfig().progDir, "/system/pad.xml");
        if (padFile.exists()) {
            padUrl = padFile.toURL();
            System.out.println("JAlbumSite: Using PAD from " + padUrl);
        } else {
            padUrl = new URL(url + "?java.version=" + IO.urlEncode(System.getProperty("java.version")) + "&jalbum.version=" + IO.urlEncode(AlbumBean.getInternalVersion()) + "&os.name=" + IO.urlEncode(System.getProperty("os.name")));
        }
        URLConnection urlConnection = padUrl.openConnection();
        urlConnection.setConnectTimeout(5000);
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        this.padContent = IO.readAll(in);
        Element programVersion = Elements.getElementByName("Program_Version", this.padContent, false);
        if (programVersion == null) {
            throw new IOException(Msg.get("ui.cannotFindVersionInformationError") + " " + padUrl);
        }
        this.clientVersion = programVersion.getContent();
        Element extensionData = Elements.getElementByName("JalbumExtension_Data", this.padContent, false);
        properties = extensionData == null ? new Properties() : AttributeTokenizer.getProperties(extensionData.getContent());
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getMyJAlbumActivationUrl() {
        return this.getProperty("myJAlbumActivationUrl");
    }

    public String getMyJAlbumAltActivationUrl() {
        return this.getProperty("myJAlbumAltActivationUrl");
    }

    public String getMyJAlbumInfoUrl() {
        return this.getProperty("myJAlbumInfoUrl");
    }

    public String getMyJAlbumQuotaUrl() {
        return this.getProperty("myJAlbumQuotaUrl");
    }

    public String getMyJAlbumPasswordProtectUrl(String hostName) {
        String path = this.getProperty("myJAlbumPasswordProtectPath");
        if (path == null) {
            return null;
        }
        return IO.combinePaths("http://" + hostName, path);
    }

    public String getMyJAlbumUpgradeUrl() {
        return JAlbumSite.getProperty("myJAlbumUpgradeUrl", this.getMyJAlbumInfoUrl());
    }

    public int getMyJAlbumFileClusterSize() {
        return Integer.parseInt(JAlbumSite.getProperty("myJAlbumFileClusterSize", "8192"));
    }

    public String getAddAlbumUrl() {
        return this.getProperty("addAlbumUrl");
    }

    public String getUpdateAlbumUrl() {
        return this.getProperty("updateAlbumUrl");
    }

    public String getAddAlbumInfoUrl() {
        return this.getProperty("addAlbumInfoUrl");
    }

    public String getCommunityUrl() {
        return this.getProperty("communityUrl");
    }

    public String getSupportingUrl() {
        return JAlbumSite.getProperty("supportingUrl", "http://jalbum.net/support");
    }

    public String getHelpUrl() {
        return JAlbumSite.getProperty("helpUrl", "http://jalbum.net/help");
    }

    public String getAboutUsUrl() {
        return JAlbumSite.getProperty("aboutUsUrl", "http://jalbum.net/about");
    }

    public String getUpgradeUrl() {
        return JAlbumSite.getProperty("upgradeUrl", "http://jalbum.net/software/download");
    }

    public String getSkinUrl(String skin) {
        String res = JAlbumSite.getProperty("skinUrl", "http://jalbum.net/skins/skin/");
        return IO.combinePaths(res, skin);
    }

    public String getWidgetsUrl() {
        return JAlbumSite.getProperty("widgetsUrl", "http://jalbum.net/widgets");
    }

    public static String getGeneratorUrl() {
        return JAlbumSite.getProperty("generatorUrl", "http://jalbum.net");
    }

    public String getHomeUrl() {
        return JAlbumSite.getProperty("homeUrl", "http://jalbum.net");
    }

    public String getDefaultWidgets() {
        return JAlbumSite.getProperty("defaultWidgets", "");
    }

    public String getSignupUrl() {
        return JAlbumSite.getProperty("signupUrl", "http://jalbum.net/signup");
    }

    public String getVerifyCidUrl() {
        return JAlbumSite.getProperty("verifyCidUrl", "http://jalbum.net/integration/verify-cid");
    }

    public String getProtectedPathsUrl() {
        return this.getProperty("protectedPathsUrl");
    }

    public String getForgotPasswordUrl() {
        return JAlbumSite.getProperty("forgotPasswordUrl", "http://jalbum.net/forgot-password");
    }

    public String getWhySignInUrl() {
        return JAlbumSite.getProperty("whySignInUrl", "http://jalbum.net/signup");
    }

    public String getPublishLandingUrl() {
        return JAlbumSite.getProperty("publishLandingUrl", "http://jalbum.net/published/album");
    }

    public String getPublishedExternalAlbumUrl() {
        return this.getProperty("publishedExternalAlbumUrl");
    }

    public String getUploaderCodeUrl() {
        return this.getProperty("uploaderCodeUrl");
    }

    public String getOnStartCodeUrl() {
        return this.getProperty("onStartCodeUrl");
    }

    public String getOnStartCodeClassName() {
        return this.getProperty("onStartCodeClassName");
    }

    private static String getProperty(String property, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        return value != null ? value : defaultValue;
    }

    private String getProperty(String property) {
        if (properties == null) {
            return null;
        }
        return properties.getProperty(property);
    }

    private Properties getProperties() {
        return properties;
    }

    private JAlbumSite() {
        try {
            this.update();
        }
        catch (Exception ex) {
            this.lastException = ex;
        }
    }

    private JAlbumSite(boolean isTrue) throws ElementException, IOException {
        this.update();
    }

    public static JAlbumSite getInstance() {
        if (theInstance == null) {
            theInstance = new JAlbumSite();
        }
        return theInstance;
    }

    public static JAlbumSite getTrueInstance() throws ElementException, IOException {
        block3: {
            block2: {
                if (theInstance == null) break block2;
                if (properties != null) break block3;
            }
            theInstance = new JAlbumSite(true);
        }
        return theInstance;
    }
}

