/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.Stopwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCopier {
    private static JAlbumFileFilter jAlbumFilter = new JAlbumFileFilter();
    private JFrame parentWindow;
    private JCopyDialog dialog;
    private boolean aborted;
    private boolean done;
    private List<File> copiedFiles = new ArrayList<File>();
    private int items;
    private long processedBytes;
    private long totalBytes;
    private Stopwatch timer = new Stopwatch();

    public FileCopier(JFrame window) {
        this.parentWindow = window;
        this.dialog = new JCopyDialog(window, Msg.get("ui.copy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> copyFiles(final List<File> files, final AlbumObject dest) {
        Thread copierThread = new Thread("copier"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    FileCopier.this.doCopyFiles(files, dest);
                }
                catch (OperationAbortedException ex) {
                }
                catch (Exception ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Debug.showFriendlyErrorDialog(FileCopier.this.parentWindow, ex);
                        }
                    });
                }
                FileCopier fileCopier = FileCopier.this;
                synchronized (fileCopier) {
                    FileCopier.this.dialog.setVisible(false);
                    FileCopier.this.done = true;
                    FileCopier.this.notify();
                }
            }
        };
        copierThread.setDaemon(true);
        copierThread.start();
        FileCopier fileCopier = this;
        synchronized (fileCopier) {
            try {
                this.wait(1500L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (!this.done) {
            this.dialog.pack();
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.parentWindow);
            this.dialog.setVisible(true);
        }
        return this.copiedFiles;
    }

    private void doCopyFiles(List<File> files, AlbumObject ao) throws IOException, OperationAbortedException {
        this.copiedFiles = new ArrayList<File>();
        this.aborted = false;
        this.items = 0;
        this.processedBytes = 0L;
        this.totalBytes = 0L;
        this.timer.reset();
        File dest = ao.getFile();
        this.dialog.setHeader(Msg.get("ui.calculatingSize") + "...");
        this.totalBytes = this.calculateTotalSize(files);
        this.dialog.setHeader(Msg.get("ui.copyingItems", this.items, dest.getName()));
        this.timer.start();
        for (File f : files) {
            if (ao.containsName(f.getName())) {
                throw new IOException(Msg.get("edit.objectAlreadyExists", f.getName()));
            }
            if (f.isDirectory()) {
                if (f.equals(ao.getFile()) || IO.isSubdirectoryOf(ao.getFile(), f)) {
                    throw new IOException(Msg.get("ui.invalidFolderCopyError", f.getName()));
                }
                this.copiedFiles.add(new File(dest, f.getName()));
                this.copyDir(f, dest);
                continue;
            }
            this.copyPlainFile(f, dest);
            this.copiedFiles.add(new File(dest, f.getName()));
        }
    }

    private void copyDir(File src, File dest) throws IOException {
        File dir = new File(dest, src.getName());
        dir.mkdir();
        File[] files = src.listFiles(jAlbumFilter);
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.copyDir(f, dir);
                    continue;
                }
                this.copyPlainFile(f, dir);
            }
        }
    }

    private void copyPlainFile(File src, File dest) throws IOException {
        File thumbFile;
        if (this.aborted) {
            throw new OperationAbortedException();
        }
        IO.copyFile(src, dest);
        this.processedBytes += src.length();
        if (!FileFilters.isFileSupported(src) && (thumbFile = IO.thumbFile(src)).exists()) {
            IO.copyFile(thumbFile, dest);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileCopier.this.updateProgress();
            }
        });
    }

    public void abort() {
        this.aborted = true;
    }

    private long calculateTotalSize(List<File> files) {
        long size = 0L;
        for (File f : files) {
            ++this.items;
            size += f.isDirectory() ? this.calculateDirSize(f) : f.length();
        }
        return size;
    }

    private long calculateDirSize(File dir) {
        long size = 0L;
        if (this.aborted) {
            throw new OperationAbortedException();
        }
        File[] files = dir.listFiles(jAlbumFilter);
        if (files != null) {
            for (File f : files) {
                ++this.items;
                if (f.isDirectory()) {
                    size += this.calculateDirSize(f);
                    continue;
                }
                size += f.length();
            }
        }
        return size;
    }

    public void updateProgress() {
        if (this.totalBytes > 0L) {
            this.dialog.setPercentDone((int)(100L * this.processedBytes / this.totalBytes));
        }
        String timeLeftString = "";
        long elapsed = this.timer.getMillis();
        if (elapsed > 3000L) {
            long totalMillis = this.totalBytes * elapsed / this.processedBytes;
            int secsLeft = (int)(totalMillis - elapsed) / 1000;
            if (secsLeft < 1) {
                secsLeft = 1;
            }
            timeLeftString = " - " + FileCopier.formatTimeLeft(secsLeft);
        }
        this.dialog.lowerLabel.setText(Msg.get("progress.processingInfo2", DataSizeFormatter.format(this.processedBytes), DataSizeFormatter.format(this.totalBytes)) + timeLeftString);
    }

    private static String formatTimeLeft(int secsLeft) {
        int value;
        String unit = secsLeft > 3600 ? ((value = secsLeft / 3600) > 1 ? "ui.hours" : "ui.hour") : (secsLeft > 60 ? ((value = secsLeft / 60) > 1 ? "ui.minutes" : "ui.minute") : ((value = secsLeft) > 1 ? "ui.seconds" : "ui.second"));
        return Msg.get("ui.timeEstimate", value, Msg.get(unit));
    }

    private class JCopyDialog
    extends JDialog {
        JLabel upperLabel;
        JLabel icon;
        JProgressBar progressBar;
        JButton abortButton;
        JLabel lowerLabel;

        public JCopyDialog(JFrame owner, String title) {
            super(owner, title, true);
            this.upperLabel = new JLabel();
            this.icon = new JLabel(Icons.getIcon("large.documents"));
            this.progressBar = new JProgressBar(0, 100);
            this.abortButton = new JPlainButton(Icons.getIcon("small.abort"), (Icon)Icons.getIcon("small.abort1"));
            this.lowerLabel = new JLabel(" ");
            this.init();
        }

        private void init() {
            this.setResizable(false);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    FileCopier.this.abort();
                }
            });
            this.abortButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JCopyDialog.this.setVisible(false);
                    FileCopier.this.abort();
                }
            });
            if (Platform.isMac()) {
                this.setSmallerFont(this.upperLabel);
                this.setSmallerFont(this.lowerLabel);
            }
            JPanel outer = new JPanel(new BorderLayout(8, 0));
            outer.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 2));
            this.setContentPane(outer);
            outer.add((Component)this.icon, "West");
            JPanel content = new JPanel(new RiverLayout());
            outer.add((Component)content, "Center");
            content.add("hfill", this.upperLabel);
            content.add("br hfill", this.progressBar);
            content.add("", this.abortButton);
            content.add("br hfill", this.lowerLabel);
            this.setMinimumSize(new Dimension(400, 1));
        }

        public void setHeader(String s) {
            this.upperLabel.setText(s);
        }

        public void setPercentDone(int percent) {
            this.progressBar.setValue(percent);
        }

        private void setSmallerFont(JComponent comp) {
            Font f = comp.getFont();
            comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
        }
    }

    private static class JAlbumFileFilter
    implements FileFilter {
        private JAlbumFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || FileFilters.isFileSupported(f) || FileFilters.hasIcon(f);
        }
    }
}

