/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import se.datadosen.component.JMapTable;
import se.datadosen.component.JPlainToggleButton;
import se.datadosen.component.JRatingSlider;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Platform;

public class JPropertyPanel
extends JPanel {
    private JTabbedPane tabs = new JTabbedPane();
    private JPanel general = new JPanel();
    JMapTable userVariablesTable = new JMapTable();
    private static final int LEN = 14;
    private JSmallTextField fileName = new JSmallTextField(14);
    private JSmallTextField title = new JSmallTextField(14);
    private JSmallTextField date = new JSmallTextField(14);
    private JSmallTextField time = new JSmallTextField(14);
    private JRatingSlider rating = new JRatingSlider(5);
    private AlbumObject ao;
    private JPlainToggleButton advancedModeButton = new JPlainToggleButton(Icons.getIcon("tiny.plus"));
    JEditPanel editPanel;
    Action previousImage = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JPropertyPanel.this.editPanel.previousImageAction.actionPerformed(e);
        }
    };
    Action nextImage = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            JPropertyPanel.this.editPanel.nextImageAction.actionPerformed(e);
        }
    };

    public JPropertyPanel(JEditPanel editPanel) {
        this.editPanel = editPanel;
        this.init();
    }

    public void addTab(String title, Component component) {
        this.tabs.insertTab(title, null, component, null, 1);
    }

    public void removeTab(Component component) {
        this.tabs.remove(component);
    }

    public void setFocusable(boolean focusable) {
        this.fileName.setFocusable(focusable);
        this.title.setFocusable(focusable);
        this.date.setFocusable(focusable);
        this.time.setFocusable(focusable);
    }

    public void setAlbumObject(AlbumObject ao) {
        TableCellEditor cellEditor;
        this.save();
        this.ao = ao;
        if (ao == null) {
            return;
        }
        this.fileName.setText(ao.getName());
        if (ao instanceof AlbumObjectImpl) {
            File file = ((AlbumObjectImpl)ao).getFile();
            Date fileDate = new Date(file.lastModified());
            DateFormat datePart = DateFormat.getDateInstance(3);
            DateFormat timePart = DateFormat.getTimeInstance(3);
            this.date.setText(datePart.format(fileDate));
            this.time.setText(timePart.format(fileDate));
        }
        AlbumObjectProperties aoprop = ao.getProperties();
        this.title.setText((String)aoprop.get("title"));
        Integer r = (Integer)aoprop.get("rating");
        if (r != null) {
            this.rating.setValue(r);
        } else {
            this.rating.setValue(0);
        }
        if (this.userVariablesTable.isEditing() && (cellEditor = this.userVariablesTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
        this.userVariablesTable.clear();
        Map userVariables = (Map)aoprop.get("userVariables");
        if (userVariables != null) {
            this.userVariablesTable.putAll(userVariables);
        }
    }

    public void componentShown() {
        this.requestFocusInWindow();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.text);
        this.setOpaque(true);
        this.tabs.putClientProperty("Quaqua.TabbedPane.contentBorderPainted", Boolean.FALSE);
        this.tabs.putClientProperty("Quaqua.Component.visualMargin", new Insets(3, -3, -4, -3));
        this.userVariablesTable.setHeaderNames(Msg.get("ui.userVariablesNameColumn"), Msg.get("ui.userVariablesValueColumn"));
        this.general.setOpaque(true);
        this.general.setBackground(SystemColor.text);
        this.general.setLayout(new RiverLayout(4, 0));
        this.general.add("br", JPropertyPanel.emptyArea(1));
        this.general.add("br", new JSmallLabel(Msg.get("edit.name")));
        this.general.add("tab hfill", this.fileName);
        this.general.add("br", new JSmallLabel(Msg.get("edit.titleLabel")));
        this.general.add("tab hfill", this.title);
        this.general.add("br", new JSmallLabel(Msg.get("edit.date")));
        this.general.add("tab hfill", this.date);
        this.general.add("br", new JSmallLabel(Msg.get("edit.time")));
        this.general.add("tab hfill", this.time);
        this.general.add("br", new JSmallLabel(Msg.get("edit.rating")));
        this.general.add("tab hfill", this.rating);
        this.advancedModeButton.setToolTipText(Msg.get("ui.advancedPanel"));
        this.advancedModeButton.setSelectedIcon(Icons.getIcon("tiny.minus"));
        this.advancedModeButton.setRealBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        this.tabs.addTab(Msg.get("ui.mainPanel"), this.general);
        this.add((Component)this.tabs, "Center");
        JPanel jp = new JPanel(new FlowLayout(4, 0, 0));
        jp.setOpaque(false);
        jp.add(this.advancedModeButton);
        this.add((Component)jp, "South");
        final JScrollPane scroller = new JScrollPane(this.userVariablesTable, 20, 31);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        scroller.setPreferredSize(new Dimension(30, 30));
        this.advancedModeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JPropertyPanel.this.advancedModeButton.isSelected()) {
                    JPropertyPanel.this.tabs.addTab(Msg.get("ui.variables"), scroller);
                } else {
                    JPropertyPanel.this.tabs.remove(scroller);
                }
                JPropertyPanel.this.editPanel.vSplitPane.setBottomComponent(JPropertyPanel.this);
                JPropertyPanel.this.editPanel.vSplitPane.validate();
            }
        });
        this.rating.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AlbumObjectProperties aop = JPropertyPanel.this.ao.getProperties();
                aop.put("rating", JPropertyPanel.this.rating.getValue());
                aop.save();
            }
        });
        FocusListener fl = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                JPropertyPanel.this.save();
            }
        };
        this.fileName.addFocusListener(fl);
        this.title.addFocusListener(fl);
        this.date.addFocusListener(fl);
        this.time.addFocusListener(fl);
        this.userVariablesTable.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (JPropertyPanel.this.ao == null) {
                    return;
                }
                if (JPropertyPanel.this.userVariablesTable.isEditing()) {
                    return;
                }
                Map vars = JPropertyPanel.this.userVariablesTable.getMap();
                AlbumObjectProperties props = JPropertyPanel.this.ao.getProperties();
                if (vars.size() == 0) {
                    props.remove("userVariables");
                } else {
                    props.put("userVariables", vars);
                }
                props.save();
            }
        });
    }

    private static void setSmallerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(f.getSize2D() - 2.0f));
    }

    void save() {
        if (this.ao == null) {
            return;
        }
        if (!this.fileName.getText().equals(this.ao.getName())) {
            this.ao.setName(this.fileName.getText());
        }
        if (this.ao instanceof AlbumObjectImpl) {
            AlbumObjectProperties props = this.ao.getProperties();
            String t = (String)props.get("title");
            if (t == null) {
                t = "";
            }
            if (!this.title.getText().equals(t)) {
                props.put("title", this.title.getText());
                props.save();
            }
            File file = ((AlbumObjectImpl)this.ao).getFile();
            Date fileDate = new Date(file.lastModified());
            DateFormat datePart = DateFormat.getDateInstance(3);
            DateFormat timePart = DateFormat.getTimeInstance(3);
            if (!this.date.getText().equals(datePart.format(fileDate)) || !this.time.getText().equals(timePart.format(fileDate))) {
                DateFormat dateTimeFormat = DateFormat.getDateTimeInstance(3, 3);
                try {
                    Date newDate = dateTimeFormat.parse(this.date.getText() + " " + this.time.getText());
                    file.setLastModified(newDate.getTime());
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
            if (this.userVariablesTable.isFocusOwner()) {
                Map vars = this.userVariablesTable.getMap();
                if (vars.size() == 0) {
                    props.remove("userVariables");
                } else {
                    props.put("userVariables", vars);
                }
                props.save();
            }
        }
    }

    private static Component emptyArea(int size) {
        return Box.createRigidArea(new Dimension(size, size));
    }

    public static class JSmallTextField
    extends JSmartTextField {
        private Border originalBorder;
        private Border emptyBorder;

        public JSmallTextField() {
            this.init();
        }

        public JSmallTextField(int length) {
            super(length);
            this.init();
        }

        private void init() {
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            }
            this.setOpaque(false);
            this.originalBorder = this.getBorder();
            Insets in = this.originalBorder.getBorderInsets(this);
            this.emptyBorder = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            this.setBorder(this.emptyBorder);
            this.registerKeyboardAction(null, KeyStroke.getKeyStroke(33, 0), 0);
            this.registerKeyboardAction(null, KeyStroke.getKeyStroke(34, 0), 0);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JSmallTextField.this.getFocusCycleRootAncestor().transferFocus();
                }
            });
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    JSmallTextField.this.setBorder(JSmallTextField.this.originalBorder);
                }

                public void focusLost(FocusEvent e) {
                    JSmallTextField.this.setBorder(JSmallTextField.this.emptyBorder);
                }
            });
        }
    }

    public static class JSmallLabel
    extends JLabel {
        public JSmallLabel(String text) {
            super(text);
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(1, this.getFont().getSize2D() - 2.0f));
            }
            this.setOpaque(false);
        }
    }
}

