/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;

class FileNameEditor
extends JAlbumObject.LabelEditor {
    private AlbumObject ao;
    private boolean editing;
    private JLabel label = new JLabel();
    private JTextField nameField = new JTextField();

    public FileNameEditor(JAlbumObject jao) {
        super(jao);
        this.ao = jao.ao;
        this.init();
    }

    private void init() {
        this.refresh();
        this.label.setFont(labelFont);
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        int labelW = this.jao.context.iconBounds.width;
        int labelH = this.label.getPreferredSize().height;
        this.label.setPreferredSize(new Dimension(labelW, labelH));
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FileNameEditor.this.setEditing(false);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    FileNameEditor.this.nameField.setText(FileNameEditor.this.ao.getName());
                    FileNameEditor.this.setEditing(false);
                }
            }
        });
        this.nameField.setFont(this.label.getFont());
        this.nameField.setText(this.label.getText());
        int nameFieldW = this.jao.context.iconBounds.width;
        int nameFieldH = this.nameField.getPreferredSize().height;
        this.nameField.setPreferredSize(new Dimension(nameFieldW, nameFieldH));
        this.setLayout(new FlowLayout(1, 0, 3));
        this.setOpaque(false);
        this.add(this.label);
        this.nameField.setVisible(false);
        this.add(this.nameField);
        int maxWidth = Math.max(this.label.getPreferredSize().width, this.nameField.getPreferredSize().width);
        int maxHeight = Math.max(this.label.getPreferredSize().height, this.nameField.getPreferredSize().height);
        this.setPreferredSize(new Dimension(maxWidth, maxHeight + 3));
    }

    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        if (this.nameField.hasFocus()) {
            this.jao.requestFocusInWindow();
        }
        this.nameField.setVisible(editing);
        this.label.setVisible(!editing);
        if (editing) {
            this.nameField.setText(this.ao.getName());
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.ao.getName().length());
            this.validate();
            this.nameField.requestFocusInWindow();
        } else {
            String newName = this.nameField.getText();
            if (!newName.equals(this.ao.getName())) {
                this.setFileName(newName);
            }
            this.refresh();
            this.validate();
            this.repaint();
        }
    }

    void refresh() {
        this.label.setText(this.ao.getName());
    }

    boolean isEditing() {
        return this.editing;
    }

    void setSelected(boolean selected) {
        if (selected) {
            this.label.setForeground(SystemColor.textHighlightText);
            this.label.setBackground(SystemColor.textHighlight);
        } else {
            this.label.setForeground(SystemColor.textText);
            this.label.setBackground(SystemColor.text);
        }
    }

    private void setFileName(String name) {
        if (!this.ao.setName(name)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

