/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;
import net.tomahawk.XFileDialog;
import se.datadosen.component.FileChooser;

public class JXFileChooser
implements FileChooser {
    private File currentDir = new File("");
    private String dialogTitle = "";
    private int dialogType = 0;
    private boolean multiSelection = false;
    private int fileSelectionMode;
    private ActionListener listener;
    private File[] selectedFiles;
    private boolean showThumbnails = false;

    public JXFileChooser() {
        XFileDialog.setTraceLevel((int)0);
    }

    public void setCurrentDirectory(File dir) {
        this.currentDir = dir;
    }

    public File getCurrentDirectory() {
        return this.currentDir;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public void setDialogType(int dialogType) {
        this.dialogType = dialogType;
    }

    public void setMultiSelectionEnabled(boolean b) {
        this.multiSelection = b;
    }

    public void setFileSelectionMode(int mode) {
        this.fileSelectionMode = mode;
    }

    public void addActionListener(ActionListener l) {
        this.listener = l;
    }

    public void setFileView(FileView fileView) {
        this.showThumbnails = fileView != null;
    }

    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(1);
        return this.showDialog(parent, null);
    }

    public int showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogType(0);
        return this.showDialog(parent, null);
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (!(parent instanceof Frame)) {
            parent = SwingUtilities.windowForComponent(parent);
        }
        XFileDialog dlg = new XFileDialog((Frame)parent);
        dlg.setThumbnail(this.showThumbnails);
        dlg.setTitle(this.dialogTitle);
        dlg.setDirectory(this.currentDir.getAbsolutePath());
        String[] filenames = null;
        if (this.multiSelection) {
            filenames = this.fileSelectionMode == 1 ? dlg.getFolders() : dlg.getFiles();
        } else {
            String filename = this.fileSelectionMode == 1 ? dlg.getFolder() : dlg.getFile();
            if (filename != null) {
                filenames = new String[]{filename};
            }
        }
        if (filenames == null) {
            return 1;
        }
        this.currentDir = new File(dlg.getDirectory());
        ArrayList<File> files = new ArrayList<File>();
        for (String name : filenames) {
            File f = new File(name);
            if (!f.isAbsolute()) {
                f = new File(this.currentDir, name);
            }
            files.add(f);
        }
        this.selectedFiles = files.toArray(new File[files.size()]);
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, 0, "ApproveSelection"));
        }
        return 0;
    }

    public File getSelectedFile() {
        return this.selectedFiles[0];
    }

    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }
}

