/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JLabel;

public class JLinkLabel
extends JLabel {
    private Color defaultColor = this.getForeground();
    private MouseListener mouseListener;
    private transient Vector actionListeners;
    private String url;
    private Exception exception;

    public JLinkLabel() {
        this("");
    }

    public JLinkLabel(String text) {
        this.setText(text);
        this.mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JLinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent e) {
                JLinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }

            public void mouseClicked(MouseEvent e) {
                JLinkLabel.this.doClick();
            }
        };
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setForeground(this.url != null ? Color.blue : this.defaultColor);
            if (this.mouseListener != null) {
                this.removeMouseListener(this.mouseListener);
                this.addMouseListener(this.mouseListener);
            }
        } else {
            this.setForeground(SystemColor.textInactiveText);
            this.removeMouseListener(this.mouseListener);
        }
    }

    public void doClick() {
        if (this.actionListeners != null) {
            this.fireActionPerformed(new ActionEvent(this, 0, null));
            return;
        }
        try {
            BrowserLauncher.openURL(this.url);
        }
        catch (Exception ex) {
            this.exception = ex;
        }
    }

    public JLinkLabel(String url, String text) {
        this(text);
        this.setURL(url);
    }

    public JLinkLabel(String url, String text, String tooltip) {
        this(text);
        this.setURL(url);
        this.setToolTipText(tooltip);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.url == null) {
            return;
        }
        Insets in = this.getInsets();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int x = in.left;
        int baseline = -1;
        try {
            baseline = this.getBaseline(this.getWidth(), this.getHeight());
        }
        catch (NoSuchMethodError ex) {
            // empty catch block
        }
        if (baseline == -1) {
            baseline = in.top + fm.getHeight() - fm.getDescent();
        }
        int y = baseline + 1;
        g.drawLine(x, y, x + fm.stringWidth(this.getText()), y);
    }

    public void setURL(String newURL) {
        this.url = newURL;
        if (this.url != null) {
            this.setForeground(Color.blue);
            this.removeMouseListener(this.mouseListener);
            this.addMouseListener(this.mouseListener);
        } else {
            this.setForeground(this.defaultColor);
            this.removeMouseListener(this.mouseListener);
        }
    }

    public String getURL() {
        return this.url;
    }

    public Exception getIOException() {
        return this.exception;
    }

    public void clearIOException() {
        this.exception = null;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            Vector listeners = this.actionListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
            }
        }
    }
}

