/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import us.monoid.web.AbstractContent;
import us.monoid.web.Content;
import us.monoid.web.JSONResource;
import us.monoid.web.TextResource;
import us.monoid.web.XPathQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLResource
extends TextResource {
    protected Document document;

    public Document doc() throws IOException {
        if (this.document == null) {
            InputSource is;
            if (this.text == null) {
                is = new InputSource(this.inputStream);
                is.setEncoding(this.getCharSet().name());
            } else {
                is = new InputSource(new StringReader(this.text));
            }
            try {
                this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        return this.document;
    }

    public JSONResource json(XPathQuery path) throws Exception {
        String uri = path.eval(this, String.class);
        return this.json(uri);
    }

    public JSONResource json(XPathQuery path, Content aContent) throws Exception {
        String uri = path.eval(this, String.class);
        return this.json(uri, (AbstractContent)aContent);
    }

    public TextResource text(XPathQuery path) throws Exception {
        String uri = path.eval(this, String.class);
        return this.text(uri);
    }

    public TextResource text(XPathQuery path, Content aContent) throws Exception {
        String uri = path.eval(this, String.class);
        return this.text(uri, (AbstractContent)aContent);
    }

    public XMLResource xml(XPathQuery path) throws Exception {
        String uri = path.eval(this, String.class);
        return this.xml(uri);
    }

    public XMLResource xml(XPathQuery path, Content aContent) throws Exception {
        String uri = path.eval(this, String.class);
        return this.xml(uri, (AbstractContent)aContent);
    }

    public NodeList get(String xPath) throws Exception {
        XPathQuery xp = new XPathQuery(xPath);
        return xp.eval(this);
    }

    public <T> T get(String xPath, Class<T> returnType) throws Exception {
        XPathQuery xp = new XPathQuery(xPath);
        return xp.eval(this, returnType);
    }

    @Override
    String getAcceptedTypes() {
        return "text/xml;application/xml;application/*+xml";
    }
}

