/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import us.monoid.json.JSONException;
import us.monoid.json.JSONObject;
import us.monoid.json.JSONTokener;
import us.monoid.web.AbstractContent;
import us.monoid.web.AbstractResource;
import us.monoid.web.Content;
import us.monoid.web.JSONPathQuery;
import us.monoid.web.TextResource;
import us.monoid.web.XMLResource;

public class JSONResource
extends AbstractResource {
    JSONObject json;

    public JSONObject object() throws IOException, JSONException {
        if (this.json == null) {
            this.json = this.unmarshal();
        }
        return this.json;
    }

    protected JSONObject unmarshal() throws IOException, JSONException {
        JSONObject json = new JSONObject(new JSONTokener(new InputStreamReader(this.inputStream, "UTF-8")));
        return json;
    }

    public JSONResource json(JSONPathQuery path) throws Exception {
        Object jsonValue = path.eval(this);
        return this.json(jsonValue.toString());
    }

    public JSONResource json(JSONPathQuery path, Content content) throws Exception {
        Object jsonValue = path.eval(this);
        return this.json(jsonValue.toString(), (AbstractContent)content);
    }

    public TextResource text(JSONPathQuery path) throws Exception {
        Object jsonValue = path.eval(this);
        return this.text(URI.create(jsonValue.toString()));
    }

    public XMLResource xml(JSONPathQuery path) throws Exception {
        Object jsonValue = path.eval(this);
        return this.xml(jsonValue.toString());
    }

    public XMLResource xml(JSONPathQuery path, Content content) throws Exception {
        Object jsonValue = path.eval(this);
        return this.xml(jsonValue.toString(), (AbstractContent)content);
    }

    public Object get(String path) throws Exception {
        return new JSONPathQuery(path).eval(this);
    }

    public Object get(JSONPathQuery aQuery) throws Exception {
        return aQuery.eval(this);
    }

    String getAcceptedTypes() {
        return "application/json";
    }
}

