/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import marcoschmidt.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.w3c.dom.Node;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFilters {
    public static final String MEDIA_FILE = "Media file";
    public static final String FLASH_VIDEO = "Flash Video";
    public static final String AUDIO_FILE = "Audio file";
    public static final String WEB_PAGE_TEMPLATE = "Web page template";
    private static final Set<String> classicTypes = new HashSet<String>();
    private static final Set<String> imageIOTypes = new HashSet<String>();
    private static final Set<String> sanselanTypes = new HashSet<String>();
    private static Map<String, FileType> otherTypes;
    private static final String FOLDER_KEY = "folder";
    private static final int STANDARD_SCALE_MODIFIER = 1;
    private static final int STANDARD_SUBSAMPLING = 1;

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine) throws IOException, ImageFormatException {
        FileFilters.saveJPEG(img, file, engine, null);
    }

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData) throws IOException, ImageFormatException {
        FileFilters.saveJPEG(img, file, engine, metaData, (float)engine.getQualityPercent() / 100.0f);
    }

    public static byte[] saveJPEG(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData, float compressionQuality) throws IOException, ImageFormatException {
        String formatName;
        if (file != null && file.exists()) {
            file.delete();
        }
        String string = formatName = file != null ? IO.extensionOf(file) : "jpeg";
        if (!"png".equals(formatName) && img.getTransparency() != 1) {
            BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 4);
            Graphics2D g = bi.createGraphics();
            g.drawImage(img, 0, 0, engine.getImageBackgroundColor(), null);
            g.dispose();
            img = bi;
        }
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(formatName);
        while (it.hasNext()) {
            ImageOutputStream ios;
            ImageWriter iw = it.next();
            ImageWriteParam param = iw.getDefaultWriteParam();
            if (engine.isProgressiveMode() && !param.canWriteProgressive() && it.hasNext()) continue;
            if (!"png".equals(formatName)) {
                param.setCompressionMode(2);
                param.setCompressionQuality(compressionQuality);
                if (engine.isProgressiveMode() && param.canWriteProgressive()) {
                    param.setProgressiveMode(1);
                }
            }
            ByteArrayOutputStream bos = null;
            if (file != null) {
                ios = ImageIO.createImageOutputStream(file);
                if (ios == null) {
                    throw new IOException("Can't write to image file " + file.getAbsolutePath());
                }
            } else {
                bos = new ByteArrayOutputStream();
                ios = ImageIO.createImageOutputStream(bos);
            }
            iw.setOutput(ios);
            if (metaData != null) {
                ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(img);
                IIOMetadata metaDefault = iw.getDefaultImageMetadata(type, param);
                Node sofDefault = FileFilters.lookupNode(metaDefault, "sof");
                FileFilters.replaceSOFMarker(metaData, sofDefault);
            }
            iw.write(null, new IIOImage(img, null, metaData), param);
            iw.dispose();
            ios.close();
            return bos != null ? bos.toByteArray() : null;
        }
        return null;
    }

    public static IIOMetadata getMetaData(File file) throws IOException {
        IIOMetadata meta = null;
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> it = FileFilters.getImageReaders(iis);
        if (it.hasNext()) {
            block3: {
                ImageReader ir = it.next();
                ir.setInput(iis);
                try {
                    meta = ir.getImageMetadata(ir.getMinIndex());
                }
                catch (IOException ex) {
                    if (ex.getMessage() == null || !ex.getMessage().endsWith("without prior JFIF!")) break block3;
                    iis = ImageIO.createImageInputStream(new PatchInputStream(new BufferedInputStream(new FileInputStream(file))));
                    ir.setInput(iis);
                    meta = ir.getImageMetadata(ir.getMinIndex());
                }
            }
            iis.close();
        }
        return meta;
    }

    public static boolean isFileSupported(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileFilters.getExtensionOf(file);
        return classicTypes.contains(extension) || imageIOTypes.contains(extension) || sanselanTypes.contains(extension);
    }

    public static boolean isMediaFile(File file) {
        boolean mediaFile = FileFilters.hasIcon(file);
        if (file.isDirectory()) {
            return false;
        }
        return mediaFile;
    }

    public static String getFileCategory(File f) {
        FileType type = (FileType)FileFilters.getOtherTypes().get(FileFilters.getExtensionOf(f));
        if (type != null) {
            return type.name;
        }
        return null;
    }

    public static FileType getFileType(File f) {
        return (FileType)FileFilters.getOtherTypes().get(FileFilters.getExtensionOf(f));
    }

    public static boolean hasIcon(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (FileFilters.isFileSupported(file)) {
            return false;
        }
        String ext = FileFilters.getExtensionOf(file);
        return FileFilters.getOtherTypes().containsKey(ext);
    }

    public static File getIconFor(File f) {
        return FileFilters.getIconFor(f, null);
    }

    public static File getIconFor(File f, AlbumBean engine) {
        File iconFile;
        Config c = Config.getConfig();
        String ext = f.isDirectory() ? FOLDER_KEY : FileFilters.getExtensionOf(f);
        FileType ft = (FileType)FileFilters.getOtherTypes().get(ext);
        if (ft == null) {
            return null;
        }
        if (engine != null && (iconFile = new File(engine.srcResDir, ft.icon)).exists()) {
            return iconFile;
        }
        return new File(c.progDir, "res/" + ft.icon);
    }

    public static String getExtensionOf(File f) {
        if (f == null) {
            throw new RuntimeException("File can't be null!");
        }
        String name = f.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1).toLowerCase();
    }

    private static BufferedImage ensureBuffered(Image img, int iw, int ih) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi = new BufferedImage(iw, ih, 4);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    private static ImageInfo getImageInfo(File file) throws IOException {
        ImageInfo ii = new ImageInfo();
        FileInputStream fis = new FileInputStream(file);
        ii.setCollectComments(false);
        ii.setInput(fis);
        if (!ii.check()) {
            throw new IOException(Msg.get("engine.unsupportedFileFormatError") + file.getName());
        }
        fis.close();
        return ii;
    }

    public static BasicImageInfo getBasicImageInfo(File f) throws IOException {
        BasicImageInfo info = new BasicImageInfo();
        String ext = IO.extensionOf(f).toLowerCase();
        if (ext.equals("gif")) {
            ImageInfo ii = FileFilters.getImageInfo(f);
            info.width = ii.getWidth();
            info.height = ii.getHeight();
            info.formatName = ii.getFormatName();
        } else if (sanselanTypes.contains(ext)) {
            try {
                org.apache.sanselan.ImageInfo sImageInfo = Sanselan.getImageInfo((File)f);
                if (sImageInfo == null) {
                    throw new IOException("Unsupported file format for " + f);
                }
                info.width = sImageInfo.getWidth();
                info.height = sImageInfo.getHeight();
                info.formatName = sImageInfo.getFormatName();
            }
            catch (ImageReadException ex) {
                throw new IOException(ex);
            }
        } else {
            FileImageInputStream iis = new FileImageInputStream(f);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            while (it.hasNext()) {
                ImageReader reader = it.next();
                if ("ch.randelshofer.media.jpeg.CMYKJPEGImageReader".equals(reader.getClass().getName())) continue;
                reader.setInput(iis, true, true);
                int minIndex = reader.getMinIndex();
                info.width = reader.getWidth(minIndex);
                info.height = reader.getHeight(minIndex);
                info.formatName = reader.getFormatName();
                reader.dispose();
                iis.close();
                return info;
            }
            throw new IOException("Unsupported file format for " + f);
        }
        return info;
    }

    public static BufferedImage loadImage(File file, AlbumBean engine) throws IOException, ImageFormatException {
        if (!FileFilters.getExtensionOf(file).equals("thm") && !FileFilters.isFileSupported(file)) {
            file = FileFilters.getIconFor(file, engine);
        }
        return FileFilters.loadImage(file, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage classicLoad(File file) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
            BufferedImage img = decoder.decodeAsBufferedImage();
            JPEGDecodeParam p = decoder.getJPEGDecodeParam();
            in.close();
            if (p.getEncodedColorID() != 3 && p.getEncodedColorID() != 2) {
                throw new ImageFormatException("Image must be stored in RGB color model");
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        catch (Throwable t) {
            ImageIcon tmpIcon = new ImageIcon(file.getAbsolutePath());
            Image tmpImg = tmpIcon.getImage();
            BufferedImage bufferedImage = FileFilters.ensureBuffered(tmpImg, tmpIcon.getIconWidth(), tmpIcon.getIconHeight());
            return bufferedImage;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static BufferedImage loadImage(File file) throws IOException {
        return FileFilters.loadImage(file, 1);
    }

    private static Iterator<ImageReader> getImageReaders(Object iis) {
        ArrayList<ImageReader> readers = new ArrayList<ImageReader>();
        Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
        ImageReader cmykReader = null;
        while (it.hasNext()) {
            ImageReader r = it.next();
            if ("ch.randelshofer.media.jpeg.CMYKJPEGImageReader".equals(r.getClass().getName())) {
                cmykReader = r;
                continue;
            }
            readers.add(r);
        }
        if (cmykReader != null) {
            readers.add(cmykReader);
        }
        return readers.iterator();
    }

    public static BufferedImage loadImage(File file, int subsampling) throws IOException {
        BufferedImage im = FileFilters.doLoadImage(file, subsampling);
        int type = im.getType();
        switch (type) {
            case 5: 
            case 6: {
                return im;
            }
        }
        return FileFilters.unifyColorModel(im);
    }

    static BufferedImage unifyColorModel(BufferedImage img) {
        int iw = img.getWidth();
        int ih = img.getHeight();
        int newType = img.getTransparency() == 1 ? 5 : 6;
        BufferedImage bi = new BufferedImage(iw, ih, newType);
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return bi;
    }

    private static BufferedImage doLoadImage(File file, int subsampling) throws IOException {
        ImageReader reader = null;
        ImageInputStream iis = null;
        boolean loadFailed = false;
        try {
            String ext = IO.extensionOf(file).toLowerCase();
            if (sanselanTypes.contains(ext)) {
                BufferedImage bufferedImage = Sanselan.getBufferedImage((File)file);
                return bufferedImage;
            }
            iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> it = FileFilters.getImageReaders(iis);
            while (it.hasNext()) {
                try {
                    BufferedImage bi;
                    reader = it.next();
                    reader.setInput(iis, true, true);
                    ImageReadParam param = reader.getDefaultReadParam();
                    param.setSourceSubsampling(subsampling, subsampling, 0, 0);
                    Iterator<ImageTypeSpecifier> i = reader.getImageTypes(0);
                    while (i.hasNext()) {
                        ImageTypeSpecifier type = i.next();
                        if (!type.getColorModel().getColorSpace().isCS_sRGB()) continue;
                        param.setDestinationType(type);
                        break;
                    }
                    BufferedImage bufferedImage = bi = reader.read(0, param);
                    return bufferedImage;
                }
                catch (Exception ex) {
                }
            }
            loadFailed = true;
        }
        catch (ImageReadException ex) {
            throw new IOException(ex);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            if (iis != null) {
                iis.close();
            }
        }
        if (loadFailed) {
            return FileFilters.classicLoad(file);
        }
        return null;
    }

    public static int calculateSubsamplingByScale(File file, Dimension imageDim) throws IOException {
        return FileFilters.calculateSubsamplingByScale(file, imageDim, 1);
    }

    public static int calculateSubsamplingByScale(File file, Dimension imageDim, int scaleModifier) throws IOException {
        if (System.getProperty("subsampling") != null) {
            return Integer.parseInt(System.getProperty("subsampling"));
        }
        BasicImageInfo info = FileFilters.getBasicImageInfo(file);
        int scale = Math.min(info.width / imageDim.width, info.height / imageDim.height);
        if ((scale -= scaleModifier) < 1) {
            scale = 1;
        }
        return scale;
    }

    static Map getOtherTypes() {
        if (otherTypes != null) {
            return otherTypes;
        }
        otherTypes = new HashMap<String, FileType>();
        try {
            Element type;
            Config c = Config.getConfig();
            String content = IO.readTextFile(new File(c.progDir, "system/filetypes.xml"));
            String docrest = content = Elements.stripComments(content);
            Element root = Elements.getElementByName("filetypes", docrest, false);
            if (root != null) {
                otherTypes.put(FOLDER_KEY, new FileType("Folder", root.getAttribute("foldericon", "folder.png"), null));
            }
            while ((type = Elements.getElementByName("type", docrest, false)) != null) {
                Element ext;
                FileType ft = new FileType(type.getAttribute("name"), type.getAttribute("icon"), type.getAttribute("mimeType"));
                String extrest = type.getContent();
                while ((ext = Elements.getElementByName("ext", extrest, false)) != null) {
                    otherTypes.put(ext.getContent(), ft);
                    extrest = ext.getPostElement();
                }
                docrest = type.getPostElement();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return otherTypes;
    }

    private static boolean replaceSOFMarker(IIOMetadata meta, Node sof) throws IIOInvalidTreeException {
        String format = meta.getNativeMetadataFormatName();
        Node root = meta.getAsTree(format);
        Node backup = root.cloneNode(true);
        Node markerSequence = FileFilters.lookupNode(root, "markerSequence");
        if (markerSequence == null) {
            return false;
        }
        Node sofOld = FileFilters.lookupNode(markerSequence, "sof");
        if (sofOld != null) {
            markerSequence.removeChild(sofOld);
        }
        markerSequence.appendChild(sof);
        try {
            meta.setFromTree(format, root);
        }
        catch (IIOInvalidTreeException e) {
            meta.setFromTree(format, backup);
            return false;
        }
        return true;
    }

    private static Node lookupNode(IIOMetadata meta, String name) {
        String format = meta.getNativeMetadataFormatName();
        Node root = meta.getAsTree(format);
        return FileFilters.lookupNode(root, name);
    }

    private static Node lookupNode(Node n, String name) {
        if (n == null) {
            return null;
        }
        if (name.equals(n.getNodeName())) {
            return n;
        }
        Node res = FileFilters.lookupNode(n.getFirstChild(), name);
        if (res != null) {
            return res;
        }
        return FileFilters.lookupNode(n.getNextSibling(), name);
    }

    static {
        classicTypes.add("jpg");
        classicTypes.add("jpeg");
        classicTypes.add("jpe");
        classicTypes.add("gif");
        classicTypes.add("png");
        String[] types = ImageIO.getReaderFormatNames();
        imageIOTypes.addAll(Arrays.asList(types));
        sanselanTypes.add("tiff");
        sanselanTypes.add("tif");
        sanselanTypes.add("psd");
        sanselanTypes.add("pnm");
        sanselanTypes.add("pgm");
        sanselanTypes.add("pbm");
        sanselanTypes.add("ppm");
    }

    private static class PatchInputStream
    extends FilterInputStream {
        private static final int[] JFIF = new int[]{255, 224, 0, 16, 74, 70, 73, 70, 0, 1, 2, 0, 0, 1, 0, 1, 0, 0};
        int position = 0;

        public PatchInputStream(InputStream in) {
            super(in);
        }

        public int read() throws IOException {
            int result = this.position < 2 ? this.in.read() : (this.position < 2 + JFIF.length ? JFIF[this.position - 2] : this.in.read());
            ++this.position;
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int max = off + len;
            int bytesread = 0;
            for (int i = off; i < max; ++i) {
                int bi = this.read();
                if (bi == -1) {
                    if (bytesread != 0) break;
                    bytesread = -1;
                    break;
                }
                b[i] = (byte)bi;
                ++bytesread;
            }
            return bytesread;
        }
    }

    public static class FileType {
        public String name;
        public String icon;
        public String mimeType;

        public FileType(String name, String iconName, String mimeType) {
            this.name = name;
            this.icon = iconName;
            this.mimeType = mimeType;
        }

        public String toString() {
            return "{Name=" + this.name + " icon=" + this.icon + " mimeType=" + this.mimeType + "}";
        }
    }

    public static class BasicImageInfo {
        public int width;
        public int height;
        public String formatName;
    }
}

