/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ToolFileFilter;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;

class JExternalToolsMenu
extends JMenu {
    private JAlbumFrame ui;
    ChainedDirectory toolsDir;

    public JExternalToolsMenu(JAlbumFrame ui) {
        this.ui = ui;
        this.init();
    }

    private void init() {
        this.toolsDir = Config.getConfig().chainedToolsDir;
        this.toolsDir.setSortFileList(true);
        this.rebuildMenu();
    }

    protected void rebuildMenu() {
        File[] tools;
        this.removeAll();
        for (File f : tools = this.toolsDir.listFiles(new ToolFileFilter())) {
            this.add(new ToolAction(f));
        }
    }

    class ToolAction
    extends AbstractAction {
        protected final File toolFile;

        public ToolAction(File toolFile) {
            super(IO.baseName(toolFile));
            this.toolFile = toolFile;
            this.putValue("ShortDescription", toolFile.getAbsolutePath());
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JExternalToolsMenu.this.ui.ui2Engine();
            }
            catch (BeanBinderException ex) {
                Debug.showStackTraceDialog(JExternalToolsMenu.this, ex);
            }
            new Thread("ScriptingThread"){
                {
                    this.setDaemon(true);
                }

                public void run() {
                    try {
                        ((JExternalToolsMenu)JExternalToolsMenu.this).ui.engine.init();
                        if (ToolAction.this.toolFile.exists()) {
                            ((JExternalToolsMenu)JExternalToolsMenu.this).ui.engine.processBeanShellFile(ToolAction.this.toolFile);
                        }
                    }
                    catch (ElementException ex) {
                        Debug.showCopyableError(JExternalToolsMenu.this.ui, ex, Msg.get("ui.scriptingError"));
                    }
                    catch (OperationAbortedException ex) {
                        ((JExternalToolsMenu)JExternalToolsMenu.this).ui.statusBar.setText(Msg.get("ui.operationAborted"));
                    }
                    catch (Exception ex) {
                        Debug.showStackTraceDialog(JExternalToolsMenu.this.ui, ex);
                    }
                }
            }.start();
        }
    }
}

