/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Container;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;

public class FileAddBehaviorInfo {
    private static final String FILE_ADD_BEHAVIOR_INFO_SHOWN = "fileAddBehaviorInfoShown";
    private static boolean shownThisSession = false;

    public static boolean shouldShow() {
        Preferences prefs = Preferences.userNodeForPackage(FileAddBehaviorInfo.class);
        return !shownThisSession && !prefs.getBoolean(FILE_ADD_BEHAVIOR_INFO_SHOWN, false) && Msg.isTranslated("ui.fileAddBehaviorInfo");
    }

    public static void setShouldShow(boolean shouldShow) {
        shownThisSession = !shouldShow;
        Preferences prefs = Preferences.userNodeForPackage(FileAddBehaviorInfo.class);
        prefs.putBoolean(FILE_ADD_BEHAVIOR_INFO_SHOWN, !shouldShow);
    }

    public static void showDialog(JFrame parent) {
        JCheckBox dontShowAgain = new JCheckBox(Msg.get("ui.dontShowAgain"));
        WrappableJLabel message = new WrappableJLabel(Msg.get("ui.fileAddBehaviorInfo", Icons.getIconResource("pointer.copy"), Icons.getIconResource("pointer.link"), Icons.getIconResource("pointer.move")));
        message.setPreferredWidth(420);
        ControlPanel panel = new ControlPanel();
        ((Container)panel).add("hfill vfill", message);
        ((Container)panel).add("p", dontShowAgain);
        JOptionPane.showMessageDialog(parent, panel, Msg.get("ui.addPhotos"), 1);
        shownThisSession = true;
        if (dontShowAgain.isSelected()) {
            FileAddBehaviorInfo.setShouldShow(false);
        }
    }
}

