/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.FileNamerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumObjectFactory
implements Serializable,
PropertyChangeListener {
    AlbumBean engine;
    protected AlbumFileFilter filter;
    private boolean cacheThumbnails = true;
    private boolean includeExcluded = true;
    private boolean includeMissing = true;

    public AlbumObjectFactory(AlbumBean engine) {
        this.engine = engine;
        engine.addPropertyChangeListener("directory", this);
    }

    public AlbumObject createInstance(File file) {
        return new AlbumObjectImpl(file, null, this);
    }

    public AlbumObject createInstance(File file, AlbumObject parent) {
        return new AlbumObjectImpl(file, parent, this);
    }

    public AlbumObject createInstance(File file, FileNamerContext context) {
        return new AlbumObjectImpl(file, context.getFolder(), this);
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public boolean isIncludeExcluded() {
        return this.includeExcluded;
    }

    public void setIncludeExcluded(boolean includeExcluded) {
        this.includeExcluded = includeExcluded;
    }

    public boolean isIncludeMissing() {
        return this.includeMissing;
    }

    public void setIncludeMissing(boolean includeMissing) {
        this.includeMissing = includeMissing;
    }

    public AlbumFileFilter getFilter() {
        if (this.filter == null) {
            this.filter = new AlbumFileFilter(this.engine, this.engine.getInterpretedOutputDirectory(), this.engine.getIgnorePattern());
        }
        return this.filter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.filter = null;
    }

    Collection<? extends AlbumObject> createChildren(FileCollection fc, AlbumObjectImpl parent) {
        File[] files;
        ArrayList<AlbumObject> children = new ArrayList<AlbumObject>();
        for (File f : files = fc.listFiles(this.getFilter(), this.isIncludeExcluded(), this.isIncludeMissing())) {
            AlbumObject ao = this.createInstance(f, parent);
            if (fc.isExcluded(f)) {
                ao.setIncluded(false);
            }
            children.add(ao);
        }
        return children;
    }
}

