/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import bsh.UtilEvalError;
import com.adobe.xmp.XMPException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDescriptor;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.GpsDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.xmp.XmpDirectory;
import info.cqs.remotefs.RemoteFSException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.beans.ExceptionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.metadata.IIOMetadata;
import javax.swing.ImageIcon;
import marcoschmidt.ImageInfo;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterRenderer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumEngine;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.CircularFolderReferenceException;
import se.datadosen.jalbum.CloseableURLClassLoader;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.FileNamer;
import se.datadosen.jalbum.ImageProcessor;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAFilterNode;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.Main;
import se.datadosen.jalbum.MetaObjectCache;
import se.datadosen.jalbum.ModifiesSize;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NotADirectoryException;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PageNamer;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.SEOAlbumObjectFactory;
import se.datadosen.jalbum.SEOFileNamer;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.StandardFileNamer;
import se.datadosen.jalbum.StandardPageNamer;
import se.datadosen.jalbum.TemplateParser;
import se.datadosen.jalbum.TitleSource;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.tags.ElementException;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.FileFilters;
import se.datadosen.util.FormattedDate;
import se.datadosen.util.IO;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.Replacer;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Scope;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.Template;
import se.datadosen.util.annotations.Unbound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumBean
implements ImageObserver,
AlbumEngine,
Cloneable {
    public static final String PRODUCT_DISPLAY_VERSION = "10";
    public static final String PRODUCT_INTERNAL_VERSION = "10.4.3";
    public static final String HEADLESS_SETTINGS_NAME = "headless-settings.jap";
    public static final String ORDER_BY_DATE = "OrderByDate";
    public static final String ORDER_BY_NAME = "OrderByName";
    public static final String ORDER_BY_SIMPLE_NAME = "OrderBySimpleName";
    public static final String CUSTOM_ORDER_FILE = "albumfiles.txt";
    public static final String LINK_ORIGINALS = "LinkOriginals";
    public static final String LINK_ORIGINALS_VIA_SCALED = "LinkOriginalsViaScaled";
    public static final String LINK_HI_RES_VIA_SCALED = "LinkHiResViaScaled";
    public static final String LINK_SCALED = "LinkScaled";
    public static final String SCALE_SMOOTH = "ScaleSmooth";
    public static final String SCALE_MEDIUM = "ScaleMedium";
    public static final String SCALE_FAST = "ScaleFast";
    static final String GIFS_DIR = "gifs";
    private static final String STYLES_FILE = "styles.css";
    static Image filmImage = new ImageIcon(JAlbumObject.class.getResource("images/bigfilm.png")).getImage();
    private static final String DEFAULT_INDEX_PAGE_NAME = "index";
    private static final int MAX_ROWS = 999;
    protected static final Map application = new PrintSafeHashMap();
    public HashMap evalStats = new HashMap();
    private ImageInfoFormatter formatter = new ImageInfoFormatter();
    private Config cfg = Config.getConfig();
    Object using;
    private Map album;
    Scope globalVariables;
    Map<File, Scope> fileVariables;
    Template indexTemplate;
    Template slideTemplate;
    private boolean mediaRSS = true;
    private boolean widgetInjection = true;
    private boolean excludeBacklinks = false;
    private boolean suppressIEWarnings = true;
    private SkinProperties skinProperties;
    private String userName = "";
    static final String mediaRSSPath = "album.rss";
    private long startTime;
    private int processedFiles;
    private int totalFiles;
    private String directory = "";
    private String thumbSize = "124x124";
    private String imageSize = "640x480";
    private Color imageBackgroundColor = Color.white;
    Dimension thumbDim = new Dimension(124, 124);
    Dimension imageDim = new Dimension(640, 480);
    private int cols = 6;
    private int rows = 4;
    private int limit = 0;
    private int qualityPercent = 85;
    private boolean highThumbnailCompressionQuality = false;
    private int sharpenPercent = 25;
    private boolean progressiveMode = false;
    private boolean classicReaders = false;
    private boolean useThumbForFolderIcon = true;
    private int cpuCores = Runtime.getRuntime().availableProcessors();
    private boolean slides = true;
    private boolean makeThumbs = true;
    private int albumWidth = 560;
    private int albumHeight = 420;
    private transient Vector albumBeanListeners;
    private PropertyChangeSupport changeSupport;
    private String dateFormat = "";
    private String scalingMethod = "ScaleMedium";
    private boolean hardwareScaling = false;
    private boolean subdirs = true;
    private boolean appendImages = false;
    private boolean updatedDirsOnly = false;
    private boolean excludeByDefault = false;
    private boolean keepMetaData = false;
    private String indexPageName = "index";
    private String framesetPageName;
    private boolean urlEncode = false;
    private String imageOrdering = "OrderByDate";
    private Comparator customImageOrdering;
    private boolean metaData = true;
    private String outputDirectory = "album";
    private String imageLinking = "LinkScaled";
    private boolean copyOriginals = true;
    private String skin = "Turtle";
    private String style = "Black.css";
    private String resourceDirectory = "res";
    private String thumbDirectory = "thumbs";
    private String closeupDirectory = "slides";
    private String slideDirectory = "slides";
    private String hiResDirectory = "hi-res";
    private String thumbnailPrefix = "";
    private String closeupPrefix = "";
    private String pageExtension = ".html";
    private boolean includeDirectories = true;
    private Map userVariables = new PrintSafeHashMap();
    private Map skinVariables = new PrintSafeHashMap();
    private boolean frames;
    private String accountProfileName = "";
    private String remoteDirectory = "album";
    private boolean reverseOrder;
    private LinkedList<JAFilterNode> filters = new LinkedList();
    private String characterEncoding;
    private String textEncoding;
    private boolean writeUTF8 = true;
    boolean _useScaledImagesAsOriginals = false;
    private boolean directoriesFirst = true;
    private String ignorePattern = "\\..*";
    private String includePattern = "";
    boolean readXmp = true;
    boolean textFileComment = true;
    boolean jpegComment = false;
    boolean iptcCaption = true;
    boolean exifUserComment = true;
    TitleSource titleSource = TitleSource.IPTCObjectName;
    boolean highQualityThumbs = true;
    private boolean superimposeFilmIcon = true;
    boolean exifImageDescription = false;
    private DateFormat df = new SimpleDateFormat();
    private DateFormat mediaRssDf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    private File skinDir;
    private File slidesDir;
    private File resDir;
    public File srcResDir;
    private File rootImageDir;
    private File projectDir;
    private transient AlbumObject root;
    private File rootOutputDir;
    private boolean includeHiResImages;
    private Dimension hiResDim;
    private PageNamer pageNamer;
    private FileNamer fileNamer;
    private boolean visibleOnProfilePage;
    private boolean notifyFollowers;
    private boolean showInRecentAlbumsList;
    private String webPassword;
    private LicenseManager licenseManager;
    private boolean searchEngineFriendlyNames;
    ExecutorService threadPool;
    int currentRows;
    int indexNum;
    int imagesPerIndex;
    int indexImageCount;
    Scope indexVariables;
    Interpreter interpreter;
    TemplateParser parser;
    private ImageProcessor imageProcessor;
    private CloseableURLClassLoader classLoader;
    AlbumObject[] currentObjects;

    public int getAlbumHeight() {
        return this.albumHeight;
    }

    public void setAlbumHeight(int albumHeight) {
        this.albumHeight = albumHeight;
    }

    public int getAlbumWidth() {
        return this.albumWidth;
    }

    public void setAlbumWidth(int albumWidth) {
        this.albumWidth = albumWidth;
    }

    public boolean isMakeThumbs() {
        return this.makeThumbs;
    }

    public void setMakeThumbs(boolean makeThumbs) {
        this.makeThumbs = makeThumbs;
    }

    public LicenseManager getLicenseManager() {
        if (this.licenseManager == null) {
            this.licenseManager = JAlbumContext.getInstance().getLicenseManager();
        }
        return this.licenseManager;
    }

    void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public PageNamer getPageNamer() {
        return this.pageNamer;
    }

    public void setPageNamer(PageNamer pageNamer) {
        this.pageNamer = pageNamer;
    }

    public FileNamer getFileNamer() {
        return this.fileNamer;
    }

    public void setFileNamer(FileNamer fileNamer) {
        this.fileNamer = fileNamer;
    }

    public static String getDisplayVersion() {
        return PRODUCT_DISPLAY_VERSION;
    }

    public static String getInternalVersion() {
        return PRODUCT_INTERNAL_VERSION;
    }

    public AlbumBean() {
        File systemDir;
        File headlessSettingsFile;
        this.skinDir = this.cfg.chainedSkinsDir.getFile(this.skin);
        this.projectDir = new File("");
        this.includeHiResImages = true;
        this.hiResDim = new Dimension(2048, 2048);
        this.visibleOnProfilePage = true;
        this.notifyFollowers = true;
        this.showInRecentAlbumsList = true;
        this.webPassword = "";
        this.threadPool = null;
        this.imageProcessor = new StandardImageProcessor();
        JAlbumContext context = JAlbumContext.getInstance();
        if (context.getAlbumObjectfactory() == null) {
            context.setEngine(this);
            AlbumObjectFactory factory = new AlbumObjectFactory(this);
            context.setAlbumObjectfactory(factory);
        }
        this.includeHiResImages = Config.getConfig().isIncludeHiResImagesDefault();
        this.textEncoding = System.getProperty("file.encoding");
        if (this.textEncoding.equals("MacRoman") || this.textEncoding.equals("Cp1252")) {
            this.setTextEncoding("ISO-8859-1");
        }
        this.initInterpreter();
        if (JAlbumContext.getInstance().getFrame() == null && (headlessSettingsFile = new File(systemDir = new File(Config.getConfig().progDir, "system"), HEADLESS_SETTINGS_NAME)).exists()) {
            Properties props = new Properties();
            try {
                FileInputStream fis = new FileInputStream(headlessSettingsFile);
                props.load(fis);
                fis.close();
                this.setProperties(props);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public SkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    void initInterpreter() {
        this.interpreter = new Interpreter();
        this.setClassLoader();
    }

    void setClassLoader() {
        File skinPluginsDir = new File(this.skinDir, "plugins");
        File skinLibDir = new File(this.skinDir, "lib");
        try {
            LinkedList<URL> all = new LinkedList<URL>();
            if (skinPluginsDir.exists()) {
                all.add(skinPluginsDir.toURI().toURL());
            }
            if (skinLibDir.exists()) {
                all.addAll(Main.buildURLList(skinLibDir));
            }
            all.add(this.cfg.pluginsDir.toURI().toURL());
            URL[] allURLs = all.toArray(new URL[0]);
            this.classLoader = new CloseableURLClassLoader(allURLs, this.getClass().getClassLoader());
            this.interpreter.setClassLoader((ClassLoader)this.classLoader);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void unloadCurrentSkin() {
        if (JAlbumContext.getInstance().getFrame() != null) {
            JAlbumContext.getInstance().getFrame().setSkinUI(null);
        }
        this.classLoader.close();
        this.setSkin("");
    }

    public AlbumBean clone() {
        try {
            return (AlbumBean)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setImageProcessor(ImageProcessor processor) {
        this.imageProcessor = processor;
    }

    private String getImageSettingsHash() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("imageSize", this.getImageSize());
        props.put("thumbSize", this.getThumbSize());
        props.put("scalingMethod", this.getScalingMethod());
        props.put("sharpenPercent", this.getSharpenPercent());
        props.put("qualityPercent", this.getQualityPercent());
        if (this.highThumbnailCompressionQuality) {
            props.put("highThumbnailCompressionQuality", this.highThumbnailCompressionQuality);
        }
        props.put("progressiveMode", this.isProgressiveMode());
        props.put("keepMetaData", this.isKeepMetaData());
        props.put("filterStack", this.filters);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(bos));
        e.setExceptionListener(new ExceptionListener(){

            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        });
        e.writeObject(props);
        e.close();
        Thread.currentThread().setContextClassLoader(threadCL);
        try {
            String line;
            String s = bos.toString("UTF-8");
            BufferedReader in = new BufferedReader(new StringReader(s));
            in.readLine();
            in.readLine();
            StringBuilder buf = new StringBuilder();
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            return DigestUtil.md5(buf.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    @Override
    public void setDirectory(String newDirectory) {
        String oldDirectory = this.directory;
        this.directory = newDirectory;
        if (!this.directory.equals(oldDirectory)) {
            this.firePropertyChange("directory", oldDirectory, newDirectory);
        }
    }

    public void setProjectDir(File projectDir) {
        this.projectDir = projectDir;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    public void setThumbSize(String newThumbSize) throws ParameterException {
        this.thumbSize = newThumbSize;
        this.thumbDim = AlbumBean.parseSize(this.thumbSize);
        this.thumbSize = "" + this.thumbDim.width + "x" + this.thumbDim.height;
    }

    public String getThumbSize() {
        return this.thumbSize;
    }

    public void setImageSize(String newImageSize) throws ParameterException {
        this.imageSize = newImageSize;
        this.imageDim = AlbumBean.parseSize(this.imageSize);
        this.imageSize = "" + this.imageDim.width + "x" + this.imageDim.height;
    }

    public String getImageSize() {
        return this.imageSize;
    }

    public void setCols(int newCols) {
        if (newCols == 0) {
            return;
        }
        this.cols = newCols;
    }

    public int getCols() {
        return this.cols;
    }

    public void setQualityPercent(int newQualityPercent) {
        this.qualityPercent = newQualityPercent;
    }

    public int getQualityPercent() {
        return this.qualityPercent;
    }

    public boolean isHighThumbnailCompressionQuality() {
        return this.highThumbnailCompressionQuality;
    }

    public void setHighThumbnailCompressionQuality(boolean max) {
        this.highThumbnailCompressionQuality = max;
    }

    public void setSharpenPercent(int newSharpenPercent) {
        this.sharpenPercent = newSharpenPercent;
    }

    public int getSharpenPercent() {
        return this.sharpenPercent;
    }

    public void setProgressiveMode(boolean newProgressiveMode) {
        this.progressiveMode = newProgressiveMode;
    }

    public boolean isProgressiveMode() {
        return this.progressiveMode;
    }

    public void useScaledImagesAsOriginals(boolean use) {
        this._useScaledImagesAsOriginals = use;
    }

    public void setClassicReaders(boolean newClassicReaders) {
        this.classicReaders = newClassicReaders;
    }

    public boolean isClassicReaders() {
        return this.classicReaders;
    }

    public void setUseThumbForFolderIcon(boolean newUseThumbForFolderIcon) {
        this.useThumbForFolderIcon = newUseThumbForFolderIcon;
    }

    public boolean isUseThumbForFolderIcon() {
        return this.useThumbForFolderIcon;
    }

    public void setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public void setSlides(boolean newSlides) {
        this.slides = newSlides;
    }

    public boolean isSlides() {
        return this.slides;
    }

    public void setDateFormat(String newDateFormat) {
        this.dateFormat = newDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public DateFormat getDateFormatAsObject() {
        return this.df;
    }

    public ImageInfoFormatter getImageInfoFormatter() {
        return this.formatter;
    }

    public Color getImageBackgroundColor() {
        return this.imageBackgroundColor;
    }

    public void setImageBackgroundColor(Color backgroundColor) {
        this.imageBackgroundColor = backgroundColor;
    }

    public void processTemplateFile(File source, File dest) throws IOException, ElementException {
        String data = IO.readTextFile(source);
        data = this.processTemplate(data);
        if (this.suppressIEWarnings) {
            data = this.injectSuppressWarningsCode(data);
        }
        IO.writeTextFile(data, dest, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    public String processTemplate(String template) throws ElementException {
        String data = template;
        Replacer replacer = AlbumBean.fillReplacer(new Replacer(), this.parser.getVariables());
        data = replacer.replace(data);
        data = this.parser.parseElements(data);
        return data;
    }

    public void processTemplateFile(File source, File dest, Map vars) throws IOException, ElementException {
        this.processTemplateFile(source, dest, vars, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    private void processTemplateFile(File source, File dest, Map vars, String encoding) throws IOException, ElementException {
        String data = IO.readTextFile(source);
        Replacer replacer = AlbumBean.fillReplacer(new Replacer(), vars);
        data = replacer.replace(data);
        this.parser.reset();
        this.parser.putAll(vars);
        data = this.parser.parseElements(data);
        if (this.suppressIEWarnings) {
            data = this.injectSuppressWarningsCode(data);
        }
        IO.writeTextFile(data, dest, encoding);
    }

    public File[] listFiles(File dir, boolean includeDirs, File outputDir) throws IOException {
        FileCollection fc = new FileCollection(this, dir);
        fc.setDoSort(true);
        AlbumFileFilter filter = includeDirs ? new AlbumFileFilter(this, outputDir, this.ignorePattern) : new AlbumFileFilter(this, null, this.ignorePattern);
        return fc.listFiles(filter);
    }

    private void cleanIfRequested(File dir) throws IOException {
        dir.mkdir();
        if (this.cfg.isCleanOutputFiles() && !this.appendImages) {
            this.cleanDirectory(dir);
        }
    }

    private void cleanDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Parameter is not a directory: " + dir);
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() || files[i].lastModified() >= this.startTime) continue;
            files[i].delete();
        }
    }

    private void cleanDirectoryTree(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Parameter is not a directory: " + dir);
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.cleanDirectoryTree(files[i]);
            }
            if (files[i].lastModified() >= this.startTime) continue;
            files[i].delete();
        }
    }

    private AlbumObject[] limitTo(AlbumObject[] arr, int max) {
        if (max > 0 && max < arr.length) {
            AlbumObject[] limited = new AlbumObject[max];
            for (int i = 0; i < max; ++i) {
                limited[i] = arr[i];
            }
            return limited;
        }
        return arr;
    }

    private static List<AlbumObject> excludePages(List<AlbumObject> all) {
        ArrayList<AlbumObject> filtered = new ArrayList<AlbumObject>();
        for (AlbumObject ao : all) {
            if (ao.getCategory() == Category.webPage) continue;
            filtered.add(ao);
        }
        return filtered;
    }

    private static AlbumObject[] excludeFolders(AlbumObject[] all) {
        boolean foundFolders = false;
        ArrayList<AlbumObject> filtered = new ArrayList<AlbumObject>();
        for (AlbumObject ao : all) {
            if (!ao.isFolder()) {
                filtered.add(ao);
                continue;
            }
            foundFolders = true;
        }
        return foundFolders ? filtered.toArray(new AlbumObject[filtered.size()]) : all;
    }

    private static AlbumObject[] excludeHidden(AlbumObject[] all) {
        boolean foundHidden = false;
        ArrayList<AlbumObject> filtered = new ArrayList<AlbumObject>();
        for (AlbumObject ao : all) {
            if (!ao.isHidden()) {
                filtered.add(ao);
                continue;
            }
            foundHidden = true;
        }
        return foundHidden ? filtered.toArray(new AlbumObject[filtered.size()]) : all;
    }

    private static AlbumObject[] toArray(List<AlbumObject> all) {
        int nIncluded = 0;
        for (AlbumObject ao : all) {
            if (!ao.isIncluded()) continue;
            ++nIncluded;
        }
        AlbumObject[] included = new AlbumObject[nIncluded];
        int i = 0;
        for (AlbumObject ao : all) {
            if (!ao.isIncluded()) continue;
            included[i++] = ao;
        }
        return included;
    }

    private void makeAlbumForFolder(AlbumObject folder, File outputDir, int level) throws IllegalArgumentException, IOException, OperationAbortedException, ElementException {
        File gifsDir;
        if (!folder.isFolder()) {
            throw new IllegalArgumentException(Msg.get("engine.invalidDirectoryError"));
        }
        List<AlbumObject> children = folder.getChildren();
        AlbumObject[] reallyAllObjects = AlbumBean.toArray(children);
        AlbumObject[] allObjects = AlbumBean.toArray(AlbumBean.excludePages(children));
        AlbumObject[] objects = AlbumBean.excludeFolders(allObjects);
        if (!this.subdirs && !this.includeDirectories) {
            allObjects = objects;
        }
        objects = this.limitTo(objects, this.limit);
        allObjects = this.limitTo(allObjects, this.limit);
        outputDir.mkdirs();
        if (level == 0) {
            File projectResDir;
            if (this.resDir != null) {
                File commonStyleFile;
                File stylesResDir = new File(this.skinDir, "styles/" + IO.baseName(this.style));
                IO.copyDirectoryContent(this.srcResDir, this.resDir, true);
                if (stylesResDir.exists()) {
                    IO.copyDirectoryContent(stylesResDir, this.resDir, true);
                }
                if ((commonStyleFile = new File(this.skinDir, "common.css")).exists()) {
                    this.processTemplateFile(commonStyleFile, new File(this.resDir, "common.css"), this.globalVariables);
                }
                File styleFile = new File(this.skinDir, "styles/" + this.style);
                File destFile = new File(this.resDir, STYLES_FILE);
                if (this.style != null && styleFile.exists() && styleFile.length() > 0L) {
                    this.processTemplateFile(styleFile, destFile, this.globalVariables);
                } else {
                    destFile.delete();
                }
            }
            if ((projectResDir = new File(this.rootImageDir, "res")).exists() && !projectResDir.equals(this.resDir)) {
                IO.copyDirectoryContent(projectResDir, this.resDir, true);
            }
        }
        if ((gifsDir = new File(this.skinDir, GIFS_DIR)).exists()) {
            File outputGifsDir = new File(outputDir, GIFS_DIR);
            this.cleanIfRequested(outputGifsDir);
            IO.copyDirectoryContent(gifsDir, outputGifsDir, true);
        }
        AlbumBeanEvent eventObject = new AlbumBeanEvent(this, folder.getFile(), IO.relativePath(folder.getFile(), this.rootImageDir.getParentFile()), Msg.get("engine.readingMetadataInfo"), 0, objects.length, this.processedFiles, this.totalFiles);
        this.fireImageProcessingStarted(eventObject);
        Collection<AlbumObject> errorObjects = this.registerVariables(reallyAllObjects, outputDir);
        allObjects = this.excludeErrors(allObjects, errorObjects);
        objects = this.excludeErrors(objects, errorObjects);
        eventObject = new AlbumBeanEvent(this, folder.getFile(), IO.relativePath(folder.getFile(), this.rootImageDir.getParentFile()), Msg.get("engine.makingIndexPages"), 0, objects.length, this.processedFiles, this.totalFiles);
        this.fireImageProcessingStarted(eventObject);
        Scope dirVars = this.makeIndexPages(folder, outputDir, this.includeDirectories ? allObjects : objects, objects, level);
        for (AlbumObject ao : reallyAllObjects) {
            if (ao.getCategory() != Category.webPage) continue;
            File targetPage = new File(outputDir, IO.baseName(ao.getFile()) + this.getPageExtension());
            ao.getVars().setOuter(dirVars);
            this.processTemplateFile(ao.getFile(), targetPage, ao.getVars());
        }
        if (this.slideTemplate != null || this.imageLinking != LINK_ORIGINALS) {
            this.slidesDir = new File(outputDir, this.slideDirectory);
            this.slidesDir.mkdir();
        }
        this.adjustImageLinks(outputDir, objects);
        Counter c = new Counter(0);
        ArrayList<ImageProcessingTask> tasks = new ArrayList<ImageProcessingTask>();
        for (int i = 0; i < this.cpuCores; ++i) {
            tasks.add(new ImageProcessingTask(c, folder.getFile(), outputDir, objects));
        }
        try {
            List results = this.threadPool.invokeAll(tasks);
            for (Future result : results) {
                result.get();
            }
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException ex) {
            Throwable t = ex.getCause();
            if (!(t instanceof OperationAbortedException)) {
                t.printStackTrace(System.err);
            }
            if (t instanceof ElementException) {
                throw (ElementException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        AlbumObject representing = folder.getRepresentingAlbumObject();
        if (representing != null && representing.getParent() == folder && representing.isDisplayableImage() && !representing.isIncluded()) {
            this.registerVariables(representing, outputDir, true);
            this.imageProcessor.processImage(this, representing, outputDir);
        }
        Scope dirVars2 = new Scope(dirVars);
        dirVars2.put("imageDirectory", folder);
        this.processBeanShellFile(new File(this.skinDir, "postdir.bsh"), dirVars2);
        this.processBeanShellFile(new File(this.cfg.progDir, "system/postdir.bsh"), dirVars2);
        AlbumBean.removeIfEmpty(new File(outputDir, this.thumbDirectory));
        AlbumBean.removeIfEmpty(new File(outputDir, this.slideDirectory));
        if (this.subdirs) {
            for (AlbumObject ao : allObjects) {
                File outputSubDir;
                File sourceSubDir;
                if (!ao.isFolder() || !this.needsToProcessDir(sourceSubDir = ao.getFile(), outputSubDir = new File(outputDir, sourceSubDir.getName()))) continue;
                this.makeAlbumForFolder(ao, outputSubDir, level + 1);
            }
        }
    }

    private boolean needsToProcessDir(File inputDir, File outputDir) throws IOException {
        boolean needToProcessDir = !this.updatedDirsOnly || !outputDir.exists() || this.deepLastModified(inputDir) >= IO.deepLastModified(outputDir);
        return needToProcessDir;
    }

    private long deepLastModified(File dir) throws IOException {
        long lastModified = dir.lastModified();
        FileCollection fc = new FileCollection(this, dir);
        AlbumFileFilter ff = new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern);
        ff.setIgnoreControlFiles(false);
        File[] content = fc.listFiles(ff);
        if (content != null) {
            for (File file : content) {
                long lm = file.lastModified();
                if (file.isDirectory()) {
                    lm = this.deepLastModified(file);
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    private static void removeIfEmpty(File dir) throws IOException {
        if (dir.exists() && dir.listFiles().length == 0) {
            dir.delete();
        }
    }

    private AlbumObject[] excludeErrors(AlbumObject[] objects, Collection<AlbumObject> errors) {
        if (errors.isEmpty()) {
            return objects;
        }
        LinkedList<AlbumObject> list = new LinkedList<AlbumObject>();
        for (int i = 0; i < objects.length; ++i) {
            list.addLast(objects[i]);
        }
        list.removeAll(errors);
        return list.toArray(new AlbumObject[list.size()]);
    }

    ImageInfo getImageInfo(File file) throws IOException {
        ImageInfo ii = new ImageInfo();
        FileInputStream fis = new FileInputStream(file);
        ii.setCollectComments(true);
        ii.setInput(fis);
        ii.setEncoding(this.textEncoding);
        if (!ii.check()) {
            throw new IOException(Msg.get("engine.unsupportedFileFormatError") + file.getName());
        }
        fis.close();
        return ii;
    }

    private String getOriginalPath(AlbumObject ao, File outputDir, File fromDir) throws IOException {
        File file = ao.getFile();
        Scope vars = ao.getVars();
        if (ao.getCategory() == Category.webPage) {
            file = new File(outputDir, IO.baseName(file) + this.getPageExtension());
        } else if (this.copyOriginals || this.getImageLinking(vars).equals(LINK_SCALED)) {
            file = new File(outputDir, file.getName());
        }
        String path = this.attemptRelativePath(file, fromDir);
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    private String attemptRelativePath(File file, File fromDir) {
        String rel = IO.relativePath(file, fromDir);
        File relativeFile = new File(rel);
        if (relativeFile.isAbsolute()) {
            int i;
            String uri = relativeFile.toURI().toString();
            String prefix = "file:";
            for (i = prefix.length(); i < uri.length() && uri.charAt(i) == '/'; ++i) {
            }
            return prefix + "///" + uri.substring(i);
        }
        return this.encode(rel);
    }

    static Map getFolderProperties(File dir) throws IOException {
        File mapFile = new File(dir, "meta.properties");
        if (mapFile.exists()) {
            Map props = IO.readMapFile(mapFile);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (!((String)e.getValue()).equals("")) continue;
                it.remove();
            }
            return props;
        }
        return new HashMap();
    }

    private File addImageLinks(AlbumObject ao, File outputDir, File fromDir, boolean inSlides) throws IOException {
        String thumbPath;
        String imagePath;
        File representingFile;
        String toSlides = inSlides ? "" : this.slideDirectory + "/";
        String fromSlides = inSlides ? "../" : "";
        String toHiRes = inSlides ? "../" + this.hiResDirectory + "/" : this.hiResDirectory + "/";
        File file = ao.getFile();
        Scope vars = ao.getVars();
        String fileName = this.encode(AlbumBean.getTargetName(file.getName()));
        String closeupPath = null;
        String originalPath = null;
        String hiResPath = null;
        String iconPath = null;
        String resPath = this.resDir != null ? IO.relativePath(this.resDir, fromDir) : fromSlides + GIFS_DIR;
        File thmFile = IO.thumbFile(file);
        if (file.isDirectory()) {
            closeupPath = fromSlides + this.encode(file.getName()) + "/" + this.getJAlbumWeb();
            representingFile = ao.getRepresentingIconFile();
            if (representingFile != null) {
                AlbumObject rep = ao.getRepresentingAlbumObject();
                String pathFromRoot = rep.getPathFromRoot();
                String path = "";
                int slashIndex = pathFromRoot.lastIndexOf(47);
                if (slashIndex == -1) {
                    String name = pathFromRoot;
                } else {
                    path = pathFromRoot.substring(0, slashIndex);
                    String name = pathFromRoot.substring(slashIndex + 1);
                }
                path = IO.relativePath(path, ao.getPathFromRoot());
                if (".".equals(path)) {
                    path = "";
                }
                path = IO.combinePaths(file.getName(), path);
                path = IO.combinePaths(path, this.thumbDirectory);
                path = IO.combinePaths(path, this.thumbnailPrefix + AlbumBean.getTargetName(representingFile.getName()));
                thumbPath = imagePath = this.encode(path);
            } else {
                representingFile = FileFilters.getIconFor(file, this);
                IO.copyFile(representingFile, this.resDir, false);
                iconPath = imagePath = resPath + '/' + representingFile.getName();
                thumbPath = imagePath;
            }
        } else if (!AlbumBean.isSupported(file)) {
            closeupPath = originalPath = this.getOriginalPath(ao, outputDir, fromDir);
            if (thmFile.exists()) {
                thumbPath = fromSlides + this.thumbDirectory + "/" + this.thumbnailPrefix + fileName;
                imagePath = toSlides + fileName;
                representingFile = thmFile;
            } else {
                representingFile = FileFilters.getIconFor(file, this);
                IO.copyFile(representingFile, this.resDir, false);
                iconPath = imagePath = resPath + '/' + representingFile.getName();
                thumbPath = imagePath;
            }
        } else {
            thumbPath = fromSlides + this.thumbDirectory + "/" + this.thumbnailPrefix + fileName;
            representingFile = thmFile.exists() ? thmFile : file;
            String il = this.getImageLinking(vars);
            if (this.slideTemplate != null || il.equals(LINK_ORIGINALS_VIA_SCALED) || il.equals(LINK_HI_RES_VIA_SCALED)) {
                closeupPath = toSlides + IO.baseName(fileName) + this.pageExtension;
            }
            if (il.equals(LINK_ORIGINALS)) {
                imagePath = this.getOriginalPath(ao, outputDir, fromDir);
                if (this.slideTemplate == null) {
                    closeupPath = imagePath;
                }
            } else if (il.equals(LINK_ORIGINALS_VIA_SCALED)) {
                imagePath = toSlides + fileName;
                originalPath = this.getOriginalPath(ao, outputDir, fromDir);
            } else if (il.equals(LINK_HI_RES_VIA_SCALED)) {
                imagePath = toSlides + fileName;
                hiResPath = toHiRes + fileName;
                if (!this.skinProperties.isTrueOriginalPath()) {
                    originalPath = hiResPath;
                }
            } else {
                imagePath = toSlides + fileName;
                if (this.slideTemplate == null) {
                    closeupPath = toSlides + fileName;
                }
            }
        }
        vars.put("thumbPath", thumbPath);
        if (iconPath != null) {
            vars.put("iconPath", iconPath);
        }
        vars.put("closeupPath", closeupPath);
        vars.put("imagePath", imagePath);
        if (AlbumBean.isSupported(file)) {
            vars.put("contentPath", imagePath);
        } else {
            vars.put("contentPath", originalPath);
        }
        if (originalPath != null) {
            vars.put("originalPath", originalPath);
        }
        if (hiResPath != null) {
            vars.put("hiResPath", hiResPath);
        }
        vars.put("representingFile", representingFile);
        return representingFile;
    }

    void addGlobals(Map vars) {
        vars.put("generator", "jAlbum 10");
        vars.put("generatorUrl", JAlbumSite.getGeneratorUrl());
        vars.put("internalVersion", AlbumBean.getInternalVersion());
        vars.put("promotion", JAlbumSite.getPromotion());
        vars.put("styleFile", STYLES_FILE);
        vars.put("skin", this.skin);
        if (this.style != null) {
            vars.put("style", this.style);
        }
        vars.put("maxImageWidth", new Integer(this.imageDim.width));
        vars.put("maxImageHeight", new Integer(this.imageDim.height));
        vars.put("maxThumbWidth", new Integer(this.thumbDim.width));
        vars.put("maxThumbHeight", new Integer(this.thumbDim.height));
        vars.put("rows", new Integer(this.rows));
        vars.put("cols", new Integer(this.cols));
        vars.put("engine", this);
        vars.put("window", JAlbumContext.getInstance().getFrame());
        vars.put("context", JAlbumContext.getInstance());
        vars.put("licenseManager", this.getLicenseManager());
        vars.put("excludeBacklinks", this.excludeBacklinks);
        if (JAlbumContext.getInstance().getFrame() != null) {
            vars.put("explorer", JAlbumContext.getInstance().getFrame().albumExplorer.explorer);
        }
        vars.put("rootFolder", this.root);
        vars.put("album", this.album);
        vars.put("application", application);
        vars.put("programDirectory", this.cfg.progDir.getAbsoluteFile());
        vars.put("skinDirectory", this.skinDir);
        vars.put("rootImageDirectory", this.rootImageDir);
        vars.put("rootOutputDirectory", this.rootOutputDir);
        if (this.resDir != null) {
            vars.put("resDirectory", this.resDir);
        }
        if (this.srcResDir != null) {
            vars.put("skinResDirectory", this.srcResDir);
        }
        vars.put("currentDate", this.df.format(new Date()));
        int tf = this.totalFiles;
        if (this.updatedDirsOnly) {
            try {
                this.rootImageDir = new File(this.directory);
                tf = this.countFiles(this.rootImageDir);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        vars.put("executedNormally", new Boolean(false));
        vars.put("totalAlbumImages", new Integer(tf));
        vars.put("textEncoding", this.writeUTF8 ? "UTF-8" : this.textEncoding);
        this.addInternationalTexts(vars);
        if (this.root != null) {
            AlbumObjectProperties props = this.root.getProperties();
            String title = (String)props.get("title");
            if (title == null || title.length() == 0) {
                title = this.root.getName();
            }
            vars.put("albumTitle", title);
            vars.put("albumDescription", this.root.getComment());
        }
        vars.putAll(this.skinVariables);
        vars.putAll(this.userVariables);
    }

    String readComment(File file, File imageDir, Metadata metadata) {
        File commentFile;
        String comment = null;
        if (metadata != null) {
            try {
                String iptcComment;
                Directory directory;
                if (metadata.containsDirectory(ExifDirectory.class)) {
                    String c;
                    this.formatter.setMetadata(metadata);
                    this.formatter.setDateFormat(this.df);
                    directory = metadata.getDirectory(ExifDirectory.class);
                    ExifDescriptor desc = new ExifDescriptor(directory);
                    if (this.exifUserComment) {
                        comment = desc.getUserCommentDescription();
                    }
                    if (this.exifImageDescription && !AlbumBean.exists(comment) && !AlbumBean.isCopyright(c = (String)this.formatter.format(270))) {
                        comment = c;
                    }
                }
                if (this.iptcCaption && metadata.containsDirectory(IptcDirectory.class) && AlbumBean.exists(iptcComment = (directory = metadata.getDirectory(IptcDirectory.class)).getString(632))) {
                    comment = iptcComment;
                }
            }
            catch (MetadataException ex) {
                // empty catch block
            }
        }
        if (this.jpegComment) {
            try {
                ImageInfo ii = this.getImageInfo(file);
                String jpegComment = "";
                int ncomm = ii.getNumberOfComments();
                for (int i = 0; i < ncomm; ++i) {
                    if (i > 0) {
                        jpegComment = jpegComment + ", ";
                    }
                    jpegComment = jpegComment + ii.getComment(i);
                }
                if (AlbumBean.exists(jpegComment) && !AlbumBean.isCopyright(jpegComment)) {
                    comment = jpegComment;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.textFileComment && (commentFile = new File(imageDir, "comments.properties")).exists()) {
            try {
                Map comments = IO.readMapFile(commentFile);
                String textFileComment = (String)comments.get(file.getName());
                if (textFileComment != null) {
                    comment = textFileComment;
                }
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
        return comment != null ? comment : "";
    }

    private void addInternationalTexts(Map vars) {
        try {
            Locale locale = this.skinVariables.containsKey("language") ? new Locale((String)this.skinVariables.get("language"), "") : Locale.getDefault();
            SmartResourceBundle texts = null;
            try {
                texts = SmartResourceBundle.getBundle(new File(this.skinDir, "texts"), "texts", locale);
            }
            catch (MissingResourceException ex) {
                texts = SmartResourceBundle.getBundle(this.skinDir, "texts", locale);
            }
            for (String k : texts.getKeys()) {
                vars.put("text." + k, texts.getString(k));
            }
            vars.put("texts", texts);
            vars.put("text", texts);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static boolean isCopyright(String s) {
        return s.startsWith("ACD Systems Digital Imaging") || s.startsWith("LEAD Technologies") || s.startsWith("AppleMark") || s.startsWith("Intel(R) JPEG Library") || s.startsWith("Created with The GIMP") || s.startsWith("ASCII") || s.startsWith("OLYMPUS DIGITAL CAMERA") || s.startsWith("KONICA MINOLTA") || s.startsWith("File written by Adobe Photoshop");
    }

    private void registerFolderVariables(AlbumObject ao, Scope vars) throws IOException {
        File file = ao.getFile();
        Map fp = AlbumBean.getFolderProperties(file);
        fp.remove("title");
        String desc = (String)fp.get("descript");
        if (desc != null) {
            fp.put("description", desc);
        }
        fp.remove("descript");
        vars.putAll(fp);
    }

    public void registerVariables(File file, File outputDir) throws IOException {
        AlbumObjectFactory factory = JAlbumContext.getInstance().getAlbumObjectfactory();
        AlbumObject ao = factory.createInstance(file);
        this.registerVariables(ao, outputDir, true);
    }

    void registerVariables(AlbumObject ao, File outputDir, boolean calculateSizes) throws IOException {
        String pageType;
        File file = ao.getFile();
        Scope vars = new Scope(this.globalVariables);
        if (Config.getConfig().isCompatibilityMode() || this.skinProperties.isCompatibilityMode()) {
            this.fileVariables.put(file, vars);
        }
        ao.setVars(vars);
        vars.put("currentObject", ao);
        vars.put("current", vars);
        switch (ao.getCategory()) {
            case folder: {
                pageType = DEFAULT_INDEX_PAGE_NAME;
                break;
            }
            case webPage: {
                pageType = "page";
                break;
            }
            default: {
                pageType = "slide";
            }
        }
        vars.put("pageType", pageType);
        vars.put("local", vars.getMap());
        vars.put("currentFile", file);
        vars.put("comment", ao.getComment());
        String fileName = file.getName();
        vars.put("fileName", fileName);
        vars.put("fileDate", new FormattedDate(file.lastModified(), this.df));
        this.addAlbumObjectProperties(ao, ao.getVars());
        vars.put("rating", (Object)ao.getRating());
        vars.put("flag", ao.getFlag().name());
        if (!ao.isFolder()) {
            vars.put("fileSize", new Long(file.length()));
            vars.put("label", IO.baseName(fileName));
            FileFilters.FileType ft = FileFilters.getFileType(file);
            if (ft != null) {
                vars.put("typeName", ft.name);
                if (ft.mimeType != null) {
                    vars.put("mimeType", ft.mimeType);
                }
            }
        } else {
            vars.put("folder", (Object)true);
            vars.put("label", fileName);
        }
        if (ao.getParent() != null) {
            if (AlbumBean.isSupported(file)) {
                if (this.metaData) {
                    try {
                        this.addImageInfo(ao, vars);
                        vars.put("orientation", RotationSupport.getOrientationAsString(file));
                    }
                    catch (MetadataException ex) {
                        System.err.println((Object)ex);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        System.err.println(ex);
                    }
                } else {
                    try {
                        vars.put("orientation", RotationSupport.getOrientationAsString(file));
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        System.err.println(ex);
                    }
                }
            }
            File representingFile = this.addImageLinks(ao, outputDir, outputDir, false);
            FileFilters.BasicImageInfo info = FileFilters.getBasicImageInfo(representingFile);
            int originalWidth = info.width;
            int originalHeight = info.height;
            vars.put("formatName", info.formatName);
            boolean rotated = false;
            String orientation = (String)vars.get("orientation");
            if (orientation != null && (orientation.equals("left") || orientation.equals("right")) && originalWidth > originalHeight) {
                rotated = true;
            }
            if (LINK_HI_RES_VIA_SCALED.equals(this.getImageLinking(vars))) {
                Dimension dim = AlbumBean.calcDimension(originalWidth, originalHeight, this.hiResDim);
                int hiResWidth = rotated ? dim.height : dim.width;
                int hiResHeight = rotated ? dim.width : dim.height;
                vars.put("hiResWidth", (Object)hiResWidth);
                vars.put("hiResHeight", (Object)hiResHeight);
            }
            vars.put("originalWidth", new Integer(originalWidth));
            vars.put("originalHeight", new Integer(originalHeight));
            if (calculateSizes) {
                this.addFilteredImageSizes(ao);
            }
        }
    }

    private void addAlbumObjectProperties(AlbumObject ao, Scope vars) {
        try {
            AlbumObjectProperties props = ao.getProperties();
            File file = ao.getFile();
            for (String key : props.keySet()) {
                vars.put(key, props.get(key));
            }
            if (ao.isFolder()) {
                this.registerFolderVariables(ao, vars);
            }
            String title = ao.getTitle();
            vars.put("title", title);
            if (title != null && title.length() > 0) {
                vars.put(ao.isFolder() ? "folderTitle" : "fileTitle", title);
            } else {
                vars.put("title", ao.isFolder() ? file.getName() : IO.baseName(file.getName()));
            }
            Map userVars = (Map)props.get("userVariables");
            if (userVars != null) {
                vars.putAll(userVars);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Collection<AlbumObject> registerVariables(AlbumObject[] objects, File outputDir) {
        ArrayList<AlbumObject> errorObjects = new ArrayList<AlbumObject>();
        Counter c = new Counter(0);
        ArrayList<RegisteringTask> tasks = new ArrayList<RegisteringTask>();
        for (int i = 0; i < this.cpuCores; ++i) {
            tasks.add(new RegisteringTask(c, objects, outputDir));
        }
        try {
            List results = this.threadPool.invokeAll(tasks);
            for (Future result : results) {
                errorObjects.addAll((Collection)result.get());
            }
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex.getCause());
        }
        return errorObjects;
    }

    public void processBeanShellFile(File f) throws ElementException, IOException {
        Scope gv = new Scope();
        this.addGlobals(gv);
        this.globalVariables = gv;
        this.processBeanShellFile(f, this.globalVariables);
    }

    void processBeanShellFile(File f, Map vars) throws ElementException, IOException {
        if (f.exists()) {
            String content = IO.readTextFile(f);
            this.processExpression(content, vars);
        }
    }

    Object processExpression(String expr) throws ElementException {
        Scope vars = new Scope(this.globalVariables);
        return this.processExpression(expr, vars);
    }

    Object processExpression(String expr, Map vars) throws ElementException {
        AlbumBean.setVars(vars, this.interpreter);
        return this.doProcessExpression(expr);
    }

    Object doProcessExpression(String expr) throws ElementException {
        try {
            return this.interpreter.eval(expr);
        }
        catch (ParseException e) {
            throw new ElementException(e.getMessage() + "\n\nDetails:\n" + e.getErrorSourceFile());
        }
        catch (TargetError e) {
            Throwable t = e.getTarget();
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            String s = "Exception caused by line " + e.getErrorLineNumber() + ": " + e.getTarget() + "\n\nDetails:\n" + e.getMessage();
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e.getTarget().printStackTrace(out);
            out.close();
            throw new ElementException(s + "\n\nStack trace:\n" + sw.toString());
        }
        catch (EvalError e) {
            throw new ElementException("Evaluation error on line " + e.getErrorLineNumber() + ":\n\nDetails:\n" + e.getMessage());
        }
    }

    public int countFiles(File dir) throws IOException {
        return this.countFiles(dir, new LinkedHashSet<File>());
    }

    private int countFiles(File dir, LinkedHashSet<File> visited) throws IOException {
        int counter = 0;
        if (dir instanceof LinkFile) {
            dir = ((LinkFile)dir).getTarget();
        }
        if (visited.contains(dir)) {
            throw new CircularFolderReferenceException(dir, visited);
        }
        visited.add(dir);
        FileCollection fc = new FileCollection(this, dir);
        File[] filesDirs = fc.listFiles(new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern));
        if (filesDirs == null) {
            visited.remove(dir);
            return 0;
        }
        for (int i = 0; i < filesDirs.length; ++i) {
            if (filesDirs[i].isDirectory()) {
                if (!this.subdirs) continue;
                counter += this.countFiles(filesDirs[i], visited);
                continue;
            }
            ++counter;
        }
        visited.remove(dir);
        return counter;
    }

    private int countChangedFiles(File inputDir, File outputDir) throws IOException {
        return this.countChangedFiles(inputDir, outputDir, new LinkedHashSet<File>());
    }

    private int countChangedFiles(File inputDir, File outputDir, LinkedHashSet<File> visited) throws IOException {
        int counter = 0;
        if (inputDir instanceof LinkFile) {
            inputDir = ((LinkFile)inputDir).getTarget();
        }
        if (visited.contains(inputDir)) {
            throw new CircularFolderReferenceException(inputDir, visited);
        }
        visited.add(inputDir);
        FileCollection fc = new FileCollection(this, inputDir);
        File[] inputSubFiles = fc.listFiles(new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern));
        if (inputSubFiles == null) {
            visited.remove(inputDir);
            return 0;
        }
        for (File inputSubFile : inputSubFiles) {
            if (inputSubFile.isDirectory()) {
                File outputSubDir = new File(outputDir, inputSubFile.getName());
                if (!this.subdirs || !this.needsToProcessDir(inputSubFile, outputSubDir)) continue;
                counter += this.countChangedFiles(inputSubFile, outputSubDir, visited);
                continue;
            }
            ++counter;
        }
        visited.remove(inputDir);
        return counter;
    }

    public void init() throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.prepareMakeAlbum(false);
    }

    @Override
    public void makeAlbum() throws IllegalArgumentException, IOException, OperationAbortedException, ElementException {
        this.makeAlbum(true, false);
    }

    @Override
    public void smartMakeAlbum() throws IllegalArgumentException, IOException, OperationAbortedException, ElementException {
        this.makeAlbum(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAlbum(boolean doMake, boolean smart) throws IllegalArgumentException, IOException, OperationAbortedException, ElementException {
        this.prepareMakeAlbum(doMake);
        if (doMake) {
            block13: {
                File framesetFile;
                String imageSettingsHash = null;
                String lastImageSettingsHash = null;
                AlbumObjectProperties lastProps = null;
                if (smart || !this.isAppendImages()) {
                    imageSettingsHash = this.getImageSettingsHash();
                    lastProps = this.root.getProperties();
                    lastProps.put("imageLinking", this.getImageLinking());
                    lastProps.save(true);
                    lastImageSettingsHash = (String)lastProps.get("imageSettingsHash");
                    if (smart) {
                        if (!imageSettingsHash.equals(lastImageSettingsHash)) {
                            this.setAppendImages(false);
                        } else {
                            this.setAppendImages(true);
                        }
                    }
                }
                if ((framesetFile = new File(this.skinDir, "frameset.htt")).exists()) {
                    this.frames = true;
                    this.framesetPageName = this.indexPageName;
                    this.indexPageName = this.indexPageName + "-frame";
                }
                try {
                    this.makeAlbumForFolder(this.root, this.rootOutputDir, 0);
                    this.globalVariables.put("executedNormally", (Object)true);
                    if (!this.isAppendImages()) {
                        lastProps.put("imageSettingsHash", imageSettingsHash);
                    }
                    long now = new Date().getTime();
                    lastProps = this.root.getProperties();
                    if (!lastProps.containsKey("createdDate")) {
                        lastProps.put("createdDate", now);
                    }
                    lastProps.put("lastMadeDate", now);
                    lastProps.save(true);
                    Object var10_8 = null;
                    if (!this.frames) break block13;
                    this.frames = false;
                    this.indexPageName = this.framesetPageName;
                    this.framesetPageName = null;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (this.frames) {
                        this.frames = false;
                        this.indexPageName = this.framesetPageName;
                        this.framesetPageName = null;
                    }
                    this.processBeanShellFile(new File(this.skinDir, "finally.bsh"), this.globalVariables);
                    this.processBeanShellFile(new File(this.cfg.progDir, "system/finally.bsh"), this.globalVariables);
                    this.rootImageDir = null;
                    this.root = null;
                    this.currentObjects = null;
                    if (this.threadPool != null) {
                        this.threadPool.shutdown();
                    }
                    throw throwable;
                }
            }
            this.processBeanShellFile(new File(this.skinDir, "finally.bsh"), this.globalVariables);
            this.processBeanShellFile(new File(this.cfg.progDir, "system/finally.bsh"), this.globalVariables);
            this.rootImageDir = null;
            this.root = null;
            this.currentObjects = null;
            if (this.threadPool != null) {
                this.threadPool.shutdown();
            }
        }
    }

    private void prepareMakeAlbum(boolean fullPreparation) throws IllegalArgumentException, IOException, OperationAbortedException, ElementException {
        this.startTime = System.currentTimeMillis();
        this.myAssert(this.directory != null, Msg.get("engine.missingDirectoryError"));
        this.myAssert(this.outputDirectory != null, Msg.get("engine.missingOutputDirectoryError"));
        this.myAssert(this.thumbSize != null, Msg.get("engine.missingThumbSizeError"));
        this.myAssert(this.imageSize != null, Msg.get("engine.missingImageSizeError"));
        this.rootImageDir = new File(this.directory);
        this.rootOutputDir = null;
        if (this.directory != null && this.directory.length() > 0 || fullPreparation) {
            if (!this.rootImageDir.isDirectory()) {
                throw new NotADirectoryException(Msg.get("engine.notADirectoryError"), this.rootImageDir);
            }
            this.rootOutputDir = this.getInterpretedOutputDirectory();
            if (!this.rootOutputDir.exists()) {
                this.rootOutputDir.mkdirs();
            }
        }
        this.skinProperties = new SkinProperties(this.skinDir);
        this.fileVariables = Config.getConfig().isCompatibilityMode() || this.skinProperties.isCompatibilityMode() ? new PrintSafeHashMap() : new HashMap<File, Scope>(){

            @Override
            public Scope get(Object key) {
                Thread.dumpStack();
                throw new OperationAbortedException(Msg.get("ui.CompatibilityModeError"));
            }
        };
        this.album = new PrintSafeHashMap();
        this.df = this.dateFormat != null && !this.dateFormat.equals("") ? new SimpleDateFormat(this.dateFormat) : new SimpleDateFormat();
        AlbumObjectFactory factory = this.searchEngineFriendlyNames ? new SEOAlbumObjectFactory(this) : new AlbumObjectFactory(this);
        factory.setIncludeMissing(false);
        this.root = factory.createInstance(this.rootImageDir);
        this.initInterpreter();
        this.parser = new TemplateParser(this);
        this.globalVariables = new Scope();
        if (!fullPreparation) {
            this.addGlobals(this.globalVariables);
            return;
        }
        this.srcResDir = new File(this.skinDir, "res");
        if (this.srcResDir.exists()) {
            this.resDir = new File(this.rootOutputDir, this.resourceDirectory);
            if (this.resDir.exists() && this.cfg.isCleanOutputFiles() && !this.appendImages) {
                this.cleanDirectoryTree(this.resDir);
            } else {
                this.resDir.mkdir();
            }
        } else {
            this.resDir = null;
            this.srcResDir = new File(this.skinDir, GIFS_DIR);
        }
        this.processedFiles = 0;
        this.totalFiles = this.countChangedFiles(this.rootImageDir, this.rootOutputDir);
        this.pageNamer = new StandardPageNamer(this);
        this.fileNamer = this.searchEngineFriendlyNames ? new SEOFileNamer() : new StandardFileNamer();
        this.indexTemplate = new Template(IO.readTextFile(new File(this.skinDir, "index.htt")));
        File slideTemplateFile = new File(this.skinDir, "slide.htt");
        this.slideTemplate = this.slides && slideTemplateFile.exists() && slideTemplateFile.length() > 0L ? new Template(IO.readTextFile(slideTemplateFile)) : null;
        this.addGlobals(this.globalVariables);
        this.parser.putAll(this.globalVariables);
        this.setUsing(null);
        this.processBeanShellFile(new File(this.cfg.progDir, "system/init.bsh"), this.globalVariables);
        this.processBeanShellFile(new File(this.skinDir, "init.bsh"), this.globalVariables);
        this.registerVariables(this.root, this.rootOutputDir, false);
        this.threadPool = Executors.newFixedThreadPool(this.cpuCores);
    }

    String makeEmbedCode() throws IOException, ElementException, ParameterException {
        this.prepareMakeAlbum(true);
        AlbumObject[] allObjects = AlbumBean.excludeHidden(AlbumBean.toArray(this.root.getChildren()));
        AlbumObject[] objects = AlbumBean.excludeFolders(allObjects);
        if (!this.subdirs && !this.includeDirectories) {
            allObjects = objects;
        }
        Collection<AlbumObject> errorObjects = this.registerVariables(allObjects, this.rootOutputDir);
        allObjects = this.excludeErrors(allObjects, errorObjects);
        objects = this.excludeErrors(objects, errorObjects);
        this.currentObjects = allObjects;
        Scope embedVars = new Scope(this.globalVariables);
        embedVars.put("albumWidth", (Object)this.albumWidth);
        embedVars.put("albumHeight", (Object)this.albumHeight);
        embedVars.put("albumURL", IO.urlEncode(this.calculateAlbumURL()));
        embedVars.put("files", AlbumBean.toFileArray(allObjects));
        embedVars.put("totalImages", new Integer(objects.length));
        embedVars.put("currentDate", this.df.format(new Date()));
        this.parser.reset();
        this.parser.putAll(embedVars);
        File embedFile = new File(this.skinDir, "embed.htt");
        if (!embedFile.exists()) {
            embedFile = new File(this.cfg.progDir, "system/embed.htt");
        }
        return this.processTemplate(IO.readTextFile(embedFile));
    }

    private String calculateAlbumURL() throws IOException {
        AlbumObjectProperties props = this.root.getProperties();
        if (props.containsKey("firstPublishedDate")) {
            String albumURL = (String)props.get("albumURL");
            if (albumURL == null) {
                throw new IOException("Album not yet uploaded");
            }
            return albumURL;
        }
        UploadBean uploadBean = null;
        try {
            AccountProfile ap = AccountManager.getInstance().findAccountByName(this.getAccountProfileName());
            if (ap == null) {
                ap = AccountManager.getInstance().getFirstMyjalbumAccount();
            }
            if (ap == null) {
                throw new IOException("Album not yet uploaded");
            }
            uploadBean = new UploadBean();
            uploadBean.setAccountProperties(ap);
            uploadBean.connect();
            UploadBean.PathFinder pathFinder = uploadBean.getPathFinder(ap, this);
            String url = pathFinder.getResolvedAlbumURL();
            if (url == null) {
                throw new IOException("Album not yet uploaded");
            }
            String string = url;
            Object var8_9 = null;
            if (uploadBean != null) {
                uploadBean.disconnect();
            }
            return string;
        }
        catch (RemoteFSException ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                block10: {
                    Object var8_10 = null;
                    if (uploadBean == null) break block10;
                    uploadBean.disconnect();
                }
                throw throwable;
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0x20) == 0;
    }

    private Scope makeIndexPages(AlbumObject folder, File outputDir, AlbumObject[] allObjects, AlbumObject[] objects, int level) throws IOException, ElementException {
        File framesetFile;
        int totalIndexes;
        allObjects = AlbumBean.excludeHidden(allObjects);
        File imageDir = folder.getFile();
        this.currentObjects = allObjects;
        this.imagesPerIndex = this.rows * this.cols;
        if (this.rows == 0) {
            this.imagesPerIndex = 999 * this.cols;
        }
        if ((totalIndexes = (int)Math.ceil((double)allObjects.length / (double)this.imagesPerIndex)) == 0) {
            totalIndexes = 1;
        }
        Scope dirVars = new Scope(this.globalVariables);
        dirVars.put("level", new Integer(level));
        this.addAlbumObjectProperties(folder, dirVars);
        dirVars.put("imageDirectory", imageDir);
        dirVars.put("currentFolder", folder);
        dirVars.put("currentObject", folder);
        dirVars.put("parentImageDirectory", folder.getParent() != null ? folder.getParent() : null);
        dirVars.put("outputDirectory", outputDir);
        dirVars.put("firstIndexPage", this.encode(this.pageNamer.getIndexName(imageDir, 0)));
        dirVars.put("lastIndexPage", this.encode(this.pageNamer.getIndexName(imageDir, totalIndexes - 1)));
        dirVars.put("files", AlbumBean.toFileArray(allObjects));
        dirVars.put("currentObjects", this.currentObjects);
        dirVars.put("fileVariables", this.fileVariables);
        dirVars.put("totalImages", new Integer(objects.length));
        dirVars.put("currentDate", this.df.format(new Date()));
        dirVars.put("pageType", DEFAULT_INDEX_PAGE_NAME);
        if (folder.getParent() != null && !this.frames) {
            String name = (String)folder.getVars().get("indexPage");
            if (name == null) {
                name = this.pageNamer.getIndexName(folder.getParent().getFile(), 0);
            }
            dirVars.put("parentIndexPage", "../" + name);
        } else {
            String parentWeb = this.getExistingWeb(outputDir.getParentFile());
            if (parentWeb != null) {
                dirVars.put("parentIndexPage", "../" + parentWeb);
            }
        }
        String rootPath = IO.relativePath(this.rootOutputDir, outputDir);
        dirVars.put("rootPath", rootPath);
        dirVars.put("resPath", this.resDir != null ? IO.relativePath(this.resDir, outputDir) : GIFS_DIR);
        dirVars.put("stylePath", this.resDir != null ? IO.relativePath(this.resDir, outputDir) + '/' + STYLES_FILE : STYLES_FILE);
        if (this.resDir == null) {
            File styleFile = new File(this.skinDir, "styles/" + this.style);
            if (this.style != null && styleFile.exists()) {
                this.processTemplateFile(styleFile, new File(outputDir, STYLES_FILE), dirVars);
            }
        }
        if ((framesetFile = new File(this.skinDir, "frameset.htt")).exists()) {
            this.processTemplateFile(framesetFile, new File(outputDir, this.framesetPageName + this.pageExtension), dirVars);
        }
        this.indexNum = 0;
        while (this.indexNum < totalIndexes) {
            this.indexVariables = new Scope(dirVars);
            this.indexVariables.put("indexPage", this.encode(this.pageNamer.getIndexName(imageDir, this.indexNum)));
            this.indexImageCount = Math.min(this.imagesPerIndex, allObjects.length - this.indexNum * this.imagesPerIndex);
            this.indexVariables.put("indexImageCount", new Integer(this.indexImageCount));
            this.currentRows = (int)Math.ceil((double)this.indexImageCount / (double)this.cols);
            this.indexVariables.put("currentRows", new Integer(this.currentRows));
            if (totalIndexes > 1) {
                this.indexVariables.put("indexNum", new Integer(this.indexNum + 1));
                this.indexVariables.put("totalIndexes", new Integer(totalIndexes));
                if (this.indexNum > 0) {
                    this.indexVariables.put("previousIndexPage", this.encode(this.pageNamer.getIndexName(imageDir, this.indexNum - 1)));
                }
                if (this.indexNum < totalIndexes - 1) {
                    this.indexVariables.put("nextIndexPage", this.encode(this.pageNamer.getIndexName(imageDir, this.indexNum + 1)));
                }
            }
            for (int i = this.indexNum * this.imagesPerIndex; i < allObjects.length && i < this.imagesPerIndex * (this.indexNum + 1); ++i) {
                Scope locals = allObjects[i].getVars();
                locals.setOuter(this.indexVariables);
                locals.put("imageNum", new Integer(i + 1));
                if (i > 0) {
                    locals.put("previous", allObjects[i - 1].getVars());
                }
                if (i < allObjects.length - 1) {
                    locals.put("next", allObjects[i + 1].getVars());
                }
                this.addFilteredImageSizes(allObjects[i]);
            }
            String template = this.indexTemplate.toString(this.indexVariables);
            this.parser.reset();
            this.parser.putAll(this.indexVariables);
            if (this.suppressIEWarnings) {
                template = this.injectSuppressWarningsCode(template);
            }
            if (this.mediaRSS) {
                template = this.injectMediaRssCode(template, false);
            }
            String indexContent = this.parser.parseElements(template);
            if (this.widgetInjection && this.skinProperties.isAutoWidgetInjection()) {
                indexContent = this.injectWidgetCode(indexContent, DEFAULT_INDEX_PAGE_NAME, rootPath);
            }
            File f = new File(outputDir, this.pageNamer.getIndexName(imageDir, this.indexNum));
            IO.writeChangedTextFile(indexContent, f, this.writeUTF8 ? "UTF-8" : this.textEncoding);
            if (this.mediaRSS) {
                File mediaRSSFile = new File(this.skinDir, mediaRSSPath);
                if (!mediaRSSFile.exists()) {
                    mediaRSSFile = new File(this.cfg.progDir, "system/album.rss");
                }
                if (mediaRSSFile.exists()) {
                    dirVars.put("mediarssPath", mediaRSSPath);
                    dirVars.put("mediarssDate", this.mediaRssDf.format(new Date()));
                    this.processTemplateFile(mediaRSSFile, new File(outputDir, mediaRSSPath), dirVars, "UTF-8");
                }
            } else {
                new File(outputDir, mediaRSSPath).delete();
            }
            ++this.indexNum;
        }
        return dirVars;
    }

    private String injectSuppressWarningsCode(String template) {
        int headIndex;
        String injectCode = "<!-- saved from url=(0014)about:internet -->";
        int i1 = template.indexOf("<head>");
        int i2 = template.indexOf("<HEAD>");
        if (i1 < 0) {
            i1 = Integer.MAX_VALUE;
        }
        if (i2 < 0) {
            i2 = Integer.MAX_VALUE;
        }
        if ((headIndex = Math.min(i1, i2)) < Integer.MAX_VALUE) {
            String firstPart = template.substring(0, headIndex);
            String lastPart = template.substring(headIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    private String injectMediaRssCode(String template, boolean slide) {
        int headIndex;
        String path = slide ? "../" : "";
        path = path.concat(mediaRSSPath);
        String injectCode = "<link rel=\"alternate\" href=\"" + path + "\" type=\"application/rss+xml\"" + (AlbumBean.isXHTML(template) ? "/>" : ">");
        int i1 = template.indexOf("</head>");
        int i2 = template.indexOf("</HEAD>");
        if (i1 < 0) {
            i1 = Integer.MAX_VALUE;
        }
        if (i2 < 0) {
            i2 = Integer.MAX_VALUE;
        }
        if ((headIndex = Math.min(i1, i2)) < Integer.MAX_VALUE) {
            String firstPart = template.substring(0, headIndex);
            String lastPart = template.substring(headIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    private String injectWidgetCode(String template, String pageType, String rootPath) {
        int i2;
        String injectCode = this.getWidgetInjectionCode(pageType, rootPath);
        int i1 = template.lastIndexOf("</body>");
        int bodyIndex = Math.max(i1, i2 = template.lastIndexOf("</BODY>"));
        if (bodyIndex > 0) {
            String firstPart = template.substring(0, bodyIndex);
            String lastPart = template.substring(bodyIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    String getWidgetInjectionCode(String pageType, String rootPath) {
        StringBuilder injectionCode = new StringBuilder();
        injectionCode.append("<div id=\"jalbumwidgetcontainer\"></div>\n");
        injectionCode.append("<script type=\"text/javascript\" charset=\"utf-8\"><!--//--><![CDATA[//><!--\n");
        injectionCode.append("_jaSkin = \"");
        injectionCode.append(this.skin);
        injectionCode.append("\";\n");
        injectionCode.append("_jaStyle = \"");
        injectionCode.append(this.style);
        injectionCode.append("\";\n");
        injectionCode.append("_jaVersion = \"");
        injectionCode.append(AlbumBean.getInternalVersion());
        injectionCode.append("\";\n");
        injectionCode.append("_jaGeneratorType = \"");
        injectionCode.append(System.getProperty("generatorType", "desktop"));
        injectionCode.append("\";\n");
        injectionCode.append("_jaLanguage = \"");
        injectionCode.append(Config.getConfig().getInterpretedLanguage());
        injectionCode.append("\";\n");
        injectionCode.append("_jaPageType = \"");
        injectionCode.append(pageType);
        injectionCode.append("\";\n");
        injectionCode.append("_jaRootPath = \"");
        injectionCode.append(rootPath);
        injectionCode.append("\";\n");
        if (this.userName != null && this.userName.length() > 0) {
            injectionCode.append("_jaUserName = \"");
            injectionCode.append(this.userName);
            injectionCode.append("\";\n");
        } else {
            injectionCode.append("_jaGuid = \"");
            injectionCode.append(JAlbum.getGUID());
            injectionCode.append("\";\n");
        }
        injectionCode.append("var script = document.createElement(\"script\");\n");
        injectionCode.append("script.type = \"text/javascript\";\n");
        injectionCode.append("script.src = \"http://jalbum.net/widgetapi/load.js\";\n");
        injectionCode.append("document.getElementById(\"jalbumwidgetcontainer\").appendChild(script);\n");
        injectionCode.append("//--><!]]></script>\n");
        return injectionCode.toString();
    }

    private static boolean isXHTML(String doc) {
        int doctypeIndex = doc.indexOf("<!DOCTYPE");
        if (doctypeIndex == -1) {
            return doc.contains("/>");
        }
        int endTagIndex = doc.indexOf(62, doctypeIndex);
        if (endTagIndex == -1) {
            return false;
        }
        return doc.substring(doctypeIndex, endTagIndex).toUpperCase().indexOf("XHTML") > 0;
    }

    private static Dimension getThumbDim(Scope locals) {
        return new Dimension((Integer)AlbumBean.interpretDataType(locals.get("maxThumbWidth")), (Integer)AlbumBean.interpretDataType(locals.get("maxThumbHeight")));
    }

    private static Dimension getImageDim(Scope locals) {
        return new Dimension((Integer)AlbumBean.interpretDataType(locals.get("maxImageWidth")), (Integer)AlbumBean.interpretDataType(locals.get("maxImageHeight")));
    }

    private void addFilteredImageSizes(AlbumObject ao) throws IOException {
        boolean hasIcon = !ao.isDisplayableImage();
        File repFile = IO.thumbFile(ao.getFile());
        Scope vars = ao.getVars();
        if (repFile.exists()) {
            hasIcon = false;
        }
        if ((repFile = ao.getRepresentingIconFile()) != null) {
            hasIcon = false;
        }
        int originalWidth = (Integer)vars.get("originalWidth");
        int originalHeight = (Integer)vars.get("originalHeight");
        String orientation = (String)vars.get("orientation");
        if (orientation == null && repFile != null) {
            orientation = RotationSupport.getOrientationAsString(repFile);
        }
        Dimension newDim = orientation != null && (orientation.equals("left") || orientation.equals("right")) && originalWidth > originalHeight ? new Dimension(originalHeight, originalWidth) : new Dimension(originalWidth, originalHeight);
        Dimension closeupDim = newDim;
        FilterList stack = (FilterList)ao.getProperties().get("filterList");
        FilterRenderer filterRenderer = null;
        if (stack != null) {
            filterRenderer = new FilterRenderer();
            filterRenderer.setFilterList(stack);
        }
        Dimension maxImageDim = AlbumBean.getImageDim(vars);
        Dimension maxThumbDim = AlbumBean.getThumbDim(vars);
        if (!this.getImageLinking(vars).equals(LINK_ORIGINALS)) {
            if (!hasIcon) {
                newDim = this.getFilteredSize(filterRenderer, newDim, vars, 1);
                newDim = closeupDim = AlbumBean.calcDimension(newDim.width, newDim.height, maxImageDim);
                newDim = this.getFilteredSize(filterRenderer, newDim, vars, 2);
                closeupDim = this.getFilteredSize(filterRenderer, newDim, vars, 3);
            }
            vars.put("imageWidth", new Integer(closeupDim.width));
            vars.put("imageHeight", new Integer(closeupDim.height));
        } else {
            vars.put("imageWidth", new Integer(originalWidth));
            vars.put("imageHeight", new Integer(originalHeight));
        }
        Dimension thumbDim = AlbumBean.calcDimension(newDim.width, newDim.height, maxThumbDim);
        if (!hasIcon) {
            newDim = this.getFilteredSize(filterRenderer, newDim, vars, 4);
            thumbDim = AlbumBean.calcDimension(newDim.width, newDim.height, maxThumbDim);
            thumbDim = this.getFilteredSize(filterRenderer, thumbDim, vars, 5);
        }
        vars.put("thumbWidth", new Integer(thumbDim.width));
        vars.put("thumbHeight", new Integer(thumbDim.height));
    }

    static Replacer fillReplacer(Replacer replacer, Map variables) {
        for (Map.Entry e : variables.entrySet()) {
            if (e.getValue() == null || e.getValue() instanceof Map) continue;
            replacer.add("$" + (String)e.getKey(), e.getValue().toString());
        }
        return replacer;
    }

    private String getJAlbumWeb() {
        return (this.framesetPageName != null ? this.framesetPageName : this.indexPageName) + this.pageExtension;
    }

    private String getExistingWeb(File dir) {
        String[] indexFiles = new String[]{this.getJAlbumWeb(), "index.htm", "index.html", "index.jsp", "index.asp", "index.php3"};
        for (int i = 0; i < indexFiles.length; ++i) {
            File test = new File(dir, indexFiles[i]);
            if (!test.exists()) continue;
            return indexFiles[i];
        }
        return null;
    }

    public static String jpegName(String name) {
        return AlbumBean.getTargetName(name);
    }

    public static String getTargetName(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        String ext = name.substring(dotIndex + 1).toLowerCase();
        if (!(ext.equals("jpg") || ext.equals("jpeg") || ext.equals("png"))) {
            if (ext.equals("gif")) {
                return name.substring(0, dotIndex) + ".png";
            }
            return name.substring(0, dotIndex) + ".jpg";
        }
        return name;
    }

    static File[] toFileArray(AlbumObject[] objects) {
        if (objects == null) {
            return null;
        }
        File[] files = new File[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            files[i] = objects[i].getFile();
        }
        return files;
    }

    private void adjustImageLinks(File outputDir, AlbumObject[] objects) throws IOException {
        if (this.slideTemplate != null) {
            File slidesDir = new File(outputDir, this.slideDirectory);
            String resPath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) : "../gifs";
            String stylePath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) + '/' + STYLES_FILE : "../styles.css";
            File[] files = AlbumBean.toFileArray(objects);
            for (int i = 0; i < objects.length; ++i) {
                Scope locals = objects[i].getVars();
                locals.put("resPath", resPath);
                locals.put("stylePath", stylePath);
                this.addImageLinks(objects[i], outputDir, new File(outputDir, this.slideDirectory), true);
                locals.put("files", files);
                locals.put("currentObjects", objects);
                if (i > 0) {
                    locals.put("previous", objects[i - 1].getVars());
                }
                if (i < objects.length - 1) {
                    locals.put("next", objects[i + 1].getVars());
                }
                locals.put("imageNum", new Integer(i + 1));
                locals.put("totalImages", new Integer(objects.length));
                if (i > 0) {
                    locals.put("previousPage", this.encode(this.pageNamer.getSlideName(objects[i - 1].getFile())));
                }
                locals.put("currentPage", this.encode(this.pageNamer.getSlideName(objects[i].getFile())));
                if (i < objects.length - 1) {
                    locals.put("nextPage", this.encode(this.pageNamer.getSlideName(objects[i + 1].getFile())));
                }
                locals.put("firstPage", this.encode(this.pageNamer.getSlideName(objects[0].getFile())));
                locals.put("lastPage", this.encode(this.pageNamer.getSlideName(objects[objects.length - 1].getFile())));
            }
        }
    }

    private static boolean isDirty(File dest, AlbumObject source) {
        if (!dest.exists()) {
            return true;
        }
        return source.getLastModified() > dest.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeSlide(AlbumObject ao, String rootPath) throws IOException, ElementException {
        Scope locals = ao.getVars();
        locals.put("currentDate", this.df.format(new Date()));
        locals.put("rootPath", rootPath);
        String template = this.slideTemplate.toString(locals);
        if (this.suppressIEWarnings) {
            template = this.injectSuppressWarningsCode(template);
        }
        if (this.mediaRSS) {
            template = this.injectMediaRssCode(template, true);
        }
        TemplateParser templateParser = this.parser;
        synchronized (templateParser) {
            this.parser.reset();
            this.parser.putAll(locals);
            String slideContent = this.parser.parseElements(template);
            if (this.widgetInjection && this.skinProperties.isAutoWidgetInjection()) {
                slideContent = this.injectWidgetCode(slideContent, "slide", rootPath);
            }
            File f = new File(this.slidesDir, this.pageNamer.getSlideName(ao.getFile()));
            IO.writeChangedTextFile(slideContent, f, this.writeUTF8 ? "UTF-8" : this.textEncoding);
        }
    }

    private void addImageInfo(AlbumObject ao, Map variables) throws MetadataException {
        XmpManager xmp;
        Directory dir;
        ExifDescriptor desc;
        Directory dir2;
        Metadata metadata = ao.getMetadata().getMetadata();
        if (metadata == null) {
            metadata = new Metadata();
        }
        this.formatter.setMetadata(metadata);
        this.formatter.setDateFormat(this.df);
        if (metadata.containsDirectory(ExifDirectory.class)) {
            dir2 = metadata.getDirectory(ExifDirectory.class);
            desc = new ExifDescriptor(dir2);
            variables.put("originalDate", this.formatter.format(36867));
            variables.put("resolution", this.formatter.format(40962) + " x " + this.formatter.format(40963));
            variables.put("flash", desc.getFlashDescription());
            variables.put("focalLength", this.formatter.format(37386));
            String focalLength35mm = (String)this.formatter.format(41989);
            if (focalLength35mm != null) {
                variables.put("focalLength35mm", focalLength35mm);
            }
            variables.put("exposureTime", this.formatter.format(33434));
            variables.put("aperture", this.formatter.format(33437));
            variables.put("focusDistance", this.formatter.format(37382));
            variables.put("meteringMode", desc.getDescription(37383));
            variables.put("cameraMake", this.formatter.format(271));
            variables.put("cameraModel", this.formatter.format(272));
            variables.put("sensorType", this.formatter.format(41495));
            variables.put("compressionLevel", this.formatter.format(37122));
            variables.put("originalWidthDpi", this.formatter.format(282));
            variables.put("originalHeightDpi", this.formatter.format(283));
            variables.put("isoEquivalent", this.formatter.format(34855));
            variables.put("orientation", dir2.getString(274));
        }
        if (metadata.containsDirectory(GpsDirectory.class)) {
            dir2 = metadata.getDirectory(GpsDirectory.class);
            desc = new GpsDescriptor(dir2);
            variables.put("gpsLongitude", desc.getGpsLongitudeDescription());
            variables.put("gpsLatitude", desc.getGpsLatitudeDescription());
            variables.put("gpsAltitude", desc.getGpsAltitudeDescription());
        }
        String author = "";
        String photographer = "";
        String objectName = "";
        String keywords = "";
        String copyright = "";
        String copyrightURL = "";
        String category = "";
        String headline = "";
        if (metadata.containsDirectory(IptcDirectory.class)) {
            dir = metadata.getDirectory(IptcDirectory.class);
            author = dir.getString(634);
            photographer = dir.getString(592);
            objectName = dir.getString(517);
            headline = dir.getString(617);
            keywords = dir.getString(537);
            copyright = dir.getString(628);
            category = dir.getString(527);
        }
        if (this.isReadXmp() && (xmp = ao.getXmpManager()) != null) {
            try {
                author = xmp.getCreator();
                keywords = xmp.getKeywords();
                copyright = xmp.getRights();
                copyrightURL = xmp.getRightsURL();
            }
            catch (XMPException ex) {
                // empty catch block
            }
        }
        variables.put("author", author);
        variables.put("writer", author);
        variables.put("creator", author);
        variables.put("photographer", photographer);
        variables.put("objectName", objectName);
        variables.put("headline", headline);
        variables.put("keywords", keywords);
        variables.put("copyright", copyright);
        variables.put("copyrightURL", copyrightURL);
        variables.put("category", category);
        if (metadata.containsDirectory(ExifDirectory.class) || metadata.containsDirectory(IptcDirectory.class)) {
            variables.put("meta", new MetaObjectCache(ao.getFile(), null));
        }
        if (metadata.containsDirectory(XmpDirectory.class)) {
            dir = (XmpDirectory)metadata.getDirectory(XmpDirectory.class);
            variables.put("xmp", new PrintSafeHashMap(dir.getRawProperties()));
        }
    }

    static Map getMetaObjectContent(Metadata imageInfo) {
        PrintSafeHashMap meta = new PrintSafeHashMap();
        Iterator dirs = imageInfo.getDirectoryIterator();
        while (dirs.hasNext()) {
            Directory dir = (Directory)dirs.next();
            String prefix = dir.getName() + ".";
            if (prefix.equalsIgnoreCase("exif.")) {
                prefix = "";
            }
            Iterator it = dir.getTagIterator();
            while (it.hasNext()) {
                Tag tag = (Tag)it.next();
                try {
                    meta.put(prefix + tag.getTagName(), tag.getDescription());
                }
                catch (MetadataException ex) {
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
            }
        }
        return meta;
    }

    private static boolean exists(String s) {
        return s != null && s.trim().length() > 0;
    }

    BufferedImage createBufferedImage(Image img) {
        int iw = img.getWidth(this);
        int ih = img.getHeight(this);
        return this.createBufferedImage(img, iw, ih);
    }

    private BufferedImage createBufferedImage(Image img, int iw, int ih) {
        int type = 4;
        if (img instanceof BufferedImage) {
            type = ((BufferedImage)img).getType();
        }
        BufferedImage bi = new BufferedImage(iw, ih, type);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return bi;
    }

    static Dimension calcDimension(int width, int height, Dimension boundingBox) {
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale + 0.5), (int)((double)height / maxScale + 0.5));
    }

    BufferedImage scaleToFit(Image image, Dimension boundingBox, String method) {
        return this.scaleToFit(image, boundingBox, method, (float)this.sharpenPercent / 100.0f);
    }

    BufferedImage scaleToFit(Image image, Dimension boundingBox, String method, float sharpenAmount) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return image instanceof BufferedImage ? (BufferedImage)image : this.createBufferedImage(image);
        }
        Dimension dim = AlbumBean.calcDimension(width, height, boundingBox);
        ImageScaler scaler = ImageScaler.getScaler(method, this.isHardwareScaling());
        BufferedImage bufImage = scaler.scale(image, dim.width, dim.height);
        image.flush();
        if ((double)sharpenAmount >= 0.05 && !SCALE_FAST.equals(method)) {
            BufferedImageOp sharpenOp = AlbumBean.getSharpenOperation((int)(sharpenAmount * 100.0f));
            bufImage = sharpenOp.filter(bufImage, null);
        }
        try {
            System.gc();
            Thread.sleep(20L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        return bufImage;
    }

    private static BufferedImageOp getSharpenOperation(int percent) {
        float[] sharpenKernel = new float[]{-0.083333336f, -0.25f, -0.083333336f, -0.25f, 2.3333333f, -0.25f, -0.083333336f, -0.25f, -0.083333336f};
        float[] originalKernel = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] resultingKernel = new float[9];
        float w = (float)((double)percent / 120.0);
        for (int i = 0; i < resultingKernel.length; ++i) {
            resultingKernel[i] = w * sharpenKernel[i] + (1.0f - w) * originalKernel[i];
        }
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, resultingKernel), 1, null);
        return op;
    }

    private void myAssert(boolean test, String msg) throws IllegalArgumentException {
        if (!test) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static Dimension parseSize(String sizeString) throws IllegalArgumentException {
        String size = sizeString.toLowerCase();
        StringTokenizer tokens = new StringTokenizer(size, "x ");
        int w = 0;
        try {
            w = Integer.parseInt(tokens.nextToken());
            int h = Integer.parseInt(tokens.nextToken());
            if (w < 0 || h < 0) {
                throw new Exception();
            }
            return new Dimension(w, h);
        }
        catch (Exception ex) {
            if (w != 0) {
                return new Dimension(w, w);
            }
            throw new IllegalArgumentException(Msg.get("engine.invalidSizeError", sizeString));
        }
    }

    private String encode(String s) {
        if (!this.urlEncode) {
            return s;
        }
        return IO.urlEncode(s);
    }

    private static boolean isSupported(AlbumObject ao) {
        return AlbumBean.isSupported(ao.getFile());
    }

    static boolean isSupported(File file) {
        return FileFilters.isFileSupported(file);
    }

    @Override
    public synchronized void removeAlbumBeanListener(AlbumBeanListener l) {
        if (this.albumBeanListeners != null && this.albumBeanListeners.contains(l)) {
            Vector v = (Vector)this.albumBeanListeners.clone();
            v.removeElement(l);
            this.albumBeanListeners = v;
        }
    }

    @Override
    public synchronized void addAlbumBeanListener(AlbumBeanListener l) {
        Vector v;
        Vector vector = v = this.albumBeanListeners == null ? new Vector(2) : (Vector)this.albumBeanListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.albumBeanListeners = v;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addFilter(JAFilter filter) {
        this.addFilter(filter, 2);
    }

    public Iterator<JAFilter> filterIterator(int stage) {
        Iterator all = this.filters.iterator();
        LinkedList<JAFilter> matching = new LinkedList<JAFilter>();
        while (all.hasNext()) {
            JAFilterNode node = (JAFilterNode)all.next();
            if (node.getStage() != stage) continue;
            matching.addLast(node.getFilter());
        }
        return matching.iterator();
    }

    public boolean addFilter(JAFilter filter, int stage) {
        this.filters.addLast(new JAFilterNode(filter, stage));
        return true;
    }

    public boolean removeFilter(JAFilter filter, int stage) {
        return this.filters.remove(new JAFilterNode(filter, stage));
    }

    public void removeAllFilters() {
        this.filters = new LinkedList();
    }

    private static BufferedImage copyImage(BufferedImage im) {
        BufferedImage bi = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)im, 0, 0, null);
        g.dispose();
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage processFilters(FilterRenderer filterRenderer, BufferedImage im, Scope vars, int stage) {
        vars.put("stage", new Integer(stage));
        vars.put("engine", this);
        if (filterRenderer != null && stage == 1) {
            im = filterRenderer.applyPrescaleFilters(im);
        } else if (filterRenderer != null && stage == 2) {
            im = filterRenderer.applyPostscaleFilters(im);
        }
        boolean isACopy = false;
        for (JAFilterNode node : this.filters) {
            JAFilter filter;
            if (node.getStage() != stage) continue;
            if (stage == 3 && !isACopy) {
                im = AlbumBean.copyImage(im);
                isACopy = true;
            }
            JAFilter jAFilter = filter = node.getFilter();
            synchronized (jAFilter) {
                im = filter.filter(im, vars);
            }
        }
        return im;
    }

    Dimension getFilteredSize(FilterRenderer fr, Dimension size, Scope vars, int stage) {
        vars.put("stage", new Integer(stage));
        if (fr != null) {
            if (stage == 1) {
                size = fr.getPrescaleFilteredSize(size);
            } else if (stage == 2) {
                size = fr.getPostscaleFilteredSize(size);
            }
        }
        for (JAFilterNode node : this.filters) {
            if (node.getStage() != stage || !(node.getFilter() instanceof ModifiesSize)) continue;
            size = ((ModifiesSize)((Object)node.getFilter())).getModifiedSize(size, vars);
        }
        return size;
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingStarted(e);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingFinished(e);
            }
        }
    }

    protected void fireErrorOccured(Throwable t, File f) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).errorOccured(t, f);
            }
        }
    }

    public void setSubdirs(boolean newSubdirs) {
        this.subdirs = newSubdirs;
    }

    public boolean isSubdirs() {
        return this.subdirs;
    }

    @Override
    public void setAppendImages(boolean newAppendImages) {
        this.appendImages = newAppendImages;
    }

    @Override
    @Unbound
    public boolean isAppendImages() {
        return this.appendImages;
    }

    public void setUpdatedDirsOnly(boolean newUpdatedDirsOnly) {
        this.updatedDirsOnly = newUpdatedDirsOnly;
    }

    public boolean isUpdatedDirsOnly() {
        return this.updatedDirsOnly;
    }

    public void setExcludeByDefault(boolean newExcludeByDefault) {
        this.excludeByDefault = newExcludeByDefault;
    }

    public boolean isExcludeByDefault() {
        return this.excludeByDefault;
    }

    public void setKeepMetaData(boolean newKeepMetaData) {
        this.keepMetaData = newKeepMetaData;
    }

    public boolean isKeepMetaData() {
        return this.keepMetaData;
    }

    @Override
    public void setStyle(String newStyle) {
        if (!newStyle.toLowerCase().endsWith(".css")) {
            newStyle = newStyle + ".css";
        }
        this.style = newStyle;
        if (JAlbumContext.getInstance().getFrame() == null) {
            try {
                File stylesDir = new File(this.skinDir, "styles");
                File hintsFile = new File(stylesDir, IO.baseName(newStyle) + ".jap");
                if (hintsFile.exists()) {
                    JAlbum.logger.info("Preparing album engine with hints from " + hintsFile);
                    this.setProperties(IO.readPropertyFile(hintsFile));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    public void setIndexPageName(String newIndexPageName) {
        this.indexPageName = newIndexPageName.trim();
    }

    public String getIndexPageName() {
        return this.indexPageName;
    }

    public void setUrlEncode(boolean newUrlEncode) {
        this.urlEncode = newUrlEncode;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public void setImageOrdering(String newImageOrdering) {
        this.imageOrdering = newImageOrdering.equals(ORDER_BY_DATE) ? ORDER_BY_DATE : (newImageOrdering.equals(ORDER_BY_NAME) ? ORDER_BY_NAME : ORDER_BY_SIMPLE_NAME);
        this.customImageOrdering = null;
    }

    public String getImageOrdering() {
        return this.imageOrdering;
    }

    public void setCustomImageOrdering(Comparator fileComparator) {
        this.customImageOrdering = fileComparator;
    }

    public Comparator getCustomImageOrdering() {
        return this.customImageOrdering;
    }

    public void setMediaRSS(boolean newMediaRSS) {
        this.mediaRSS = newMediaRSS;
    }

    public boolean isMediaRSS() {
        return this.mediaRSS;
    }

    public void setWidgetInjection(boolean newWidgetInjection) {
        this.widgetInjection = newWidgetInjection;
    }

    public boolean isWidgetInjection() {
        return this.widgetInjection;
    }

    public void setExcludeBacklinks(boolean newExcludeBacklinks) {
        this.excludeBacklinks = newExcludeBacklinks;
    }

    public boolean isExcludeBacklinks() {
        return this.excludeBacklinks;
    }

    public boolean isSuppressIEWarnings() {
        return this.suppressIEWarnings;
    }

    public void setSuppressIEWarnings(boolean supressIEWarnings) {
        this.suppressIEWarnings = supressIEWarnings;
    }

    @Unbound
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setMetaData(boolean newMetaData) {
        this.metaData = newMetaData;
    }

    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void setOutputDirectory(String newOutputDirectory) {
        this.outputDirectory = newOutputDirectory;
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Unbound
    public File getInterpretedOutputDirectory() {
        File f = new File(this.getOutputDirectory());
        if (!f.isAbsolute()) {
            f = new File(this.directory, this.outputDirectory);
            f = IO.resolvePath(f, "");
        }
        return f;
    }

    public void setRows(int newRows) {
        this.rows = newRows;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Unbound
    public int getLimit() {
        return this.limit;
    }

    public void setImageLinking(String newImageLinking) {
        if (newImageLinking.equals(LINK_ORIGINALS)) {
            this.imageLinking = LINK_ORIGINALS;
        } else if (newImageLinking.equals(LINK_ORIGINALS_VIA_SCALED)) {
            this.imageLinking = LINK_ORIGINALS_VIA_SCALED;
        } else if (newImageLinking.equals(LINK_HI_RES_VIA_SCALED)) {
            this.imageLinking = LINK_HI_RES_VIA_SCALED;
            this.includeHiResImages = true;
        } else {
            this.imageLinking = LINK_SCALED;
        }
    }

    public String getImageLinking() {
        return this.imageLinking;
    }

    String getImageLinking(Scope vars) {
        Boolean b = (Boolean)(vars != null ? vars.get("includeOriginal") : null);
        if (b != null && b.booleanValue() && (this.imageLinking.equals(LINK_SCALED) || this.imageLinking.equals(LINK_HI_RES_VIA_SCALED))) {
            return LINK_ORIGINALS_VIA_SCALED;
        }
        return this.imageLinking;
    }

    public void setCopyOriginals(boolean newCopyOriginals) {
        this.copyOriginals = newCopyOriginals;
    }

    public boolean isCopyOriginals() {
        return this.copyOriginals;
    }

    public boolean isIncludeHiResImages() {
        return this.includeHiResImages;
    }

    public void setIncludeHiResImages(boolean includeHiResImages) {
        this.includeHiResImages = includeHiResImages;
    }

    public boolean isNotifyFollowers() {
        return this.notifyFollowers;
    }

    public void setNotifyFollowers(boolean notifyFollowers) {
        this.notifyFollowers = notifyFollowers;
    }

    public String getWebPassword() {
        return this.webPassword;
    }

    public void setWebPassword(String webPassword) {
        this.webPassword = webPassword;
    }

    public boolean isShowInRecentAlbumsList() {
        return this.showInRecentAlbumsList;
    }

    public void setShowInRecentAlbumsList(boolean showInRecentAlbumsList) {
        this.showInRecentAlbumsList = showInRecentAlbumsList;
    }

    public boolean isVisibleOnProfilePage() {
        return this.visibleOnProfilePage;
    }

    public void setVisibleOnProfilePage(boolean visibleOnProfilePage) {
        this.visibleOnProfilePage = visibleOnProfilePage;
    }

    @Override
    public void setSkin(String newSkin) {
        this.skin = newSkin;
        this.skinDir = this.cfg.chainedSkinsDir.getFile(this.skin);
        this.srcResDir = new File(this.skinDir, "res");
        this.skinProperties = new SkinProperties(this.skinDir);
        if (this.interpreter != null) {
            this.setClassLoader();
        }
        if (JAlbumContext.getInstance().getFrame() == null) {
            try {
                File hintsFile;
                Properties props = new Properties();
                File headlessSettingsFile = new File(this.skinDir, HEADLESS_SETTINGS_NAME);
                if (headlessSettingsFile.exists()) {
                    System.out.println("Preparing album engine with settings from " + headlessSettingsFile);
                    FileInputStream fis = new FileInputStream(headlessSettingsFile);
                    props.load(fis);
                    fis.close();
                }
                if ((hintsFile = new File(this.skinDir, "hints.jap")).exists()) {
                    props.putAll((Map<?, ?>)IO.readPropertyFile(hintsFile));
                }
                this.setProperties(props);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public String getSkin() {
        return this.skin;
    }

    File getSkinDir() {
        return this.skinDir;
    }

    public void setPageExtension(String newPageExtension) {
        this.pageExtension = newPageExtension.trim();
    }

    public String getPageExtension() {
        return this.pageExtension;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public String getThumbnailDirectory() {
        return this.thumbDirectory;
    }

    public String getCloseupDirectory() {
        return this.closeupDirectory;
    }

    public String getSlideDirectory() {
        return this.slideDirectory;
    }

    public String getHiResDirectory() {
        return this.hiResDirectory;
    }

    public String getThumbnailPrefix() {
        return this.thumbnailPrefix;
    }

    public String getCloseupPrefix() {
        return this.closeupPrefix;
    }

    public void setTextFileComment(boolean newtextFileComment) {
        this.textFileComment = newtextFileComment;
    }

    public boolean isTextFileComment() {
        return this.textFileComment;
    }

    public void setReadXmp(boolean readXmp) {
        this.readXmp = readXmp;
    }

    public boolean isReadXmp() {
        return this.readXmp;
    }

    public void setJpegComment(boolean newjpegComment) {
        this.jpegComment = newjpegComment;
    }

    public boolean isJpegComment() {
        return this.jpegComment;
    }

    public void setIptcCaption(boolean newiptcCaption) {
        this.iptcCaption = newiptcCaption;
    }

    public boolean isIptcCaption() {
        return this.iptcCaption;
    }

    public void setExifUserComment(boolean newexifUserComment) {
        this.exifUserComment = newexifUserComment;
    }

    public boolean isExifUserComment() {
        return this.exifUserComment;
    }

    public TitleSource getTitleSource() {
        return this.titleSource;
    }

    public void setTitleSource(TitleSource titleSource) {
        this.titleSource = titleSource;
    }

    public void setHighQualityThumbs(boolean newhighQualityThumbs) {
        this.highQualityThumbs = newhighQualityThumbs;
    }

    public boolean isHighQualityThumbs() {
        return this.highQualityThumbs;
    }

    public boolean isSuperimposeFilmIcon() {
        return this.superimposeFilmIcon;
    }

    public void setSuperimposeFilmIcon(boolean superimposeFilmIcon) {
        this.superimposeFilmIcon = superimposeFilmIcon;
    }

    public void setExifImageDescription(boolean newexifImageDescription) {
        this.exifImageDescription = newexifImageDescription;
    }

    public boolean isExifImageDescription() {
        return this.exifImageDescription;
    }

    public void setIncludeDirectories(boolean newIncludeDirectories) {
        this.includeDirectories = newIncludeDirectories;
    }

    public boolean isIncludeDirectories() {
        return this.includeDirectories;
    }

    @Override
    public void setUserVariables(Map newUserVariables) {
        this.userVariables = newUserVariables;
        File f = new File(this.skinDir, "onload.bsh");
        if (f.exists()) {
            for (Map.Entry entry : this.userVariables.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                entry.setValue(AlbumBean.interpretDataType((String)entry.getValue()));
            }
        }
    }

    @Override
    public void setSkinVariables(Map newSkinVariables) {
        Set<String> mappedVars = this.setDataTypes(newSkinVariables, "SkinModel");
        for (Map.Entry entry : newSkinVariables.entrySet()) {
            if (mappedVars.contains((String)entry.getKey()) || !(entry.getValue() instanceof String)) continue;
            entry.setValue(AlbumBean.interpretDataType((String)entry.getValue()));
        }
        this.skinVariables = newSkinVariables;
    }

    private static void printClassLoaders(ClassLoader loader) {
        while (loader != null) {
            System.out.println(loader);
            if (loader instanceof URLClassLoader) {
                for (URL u : ((URLClassLoader)loader).getURLs()) {
                    System.out.println("\t" + u);
                }
            }
            loader = loader.getParent();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class smartLoadClass(String className) throws ClassNotFoundException {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            Class clazz;
            InputStream in = null;
            try {
                try {
                    if (this.interpreter == null) {
                        this.initInterpreter();
                    }
                    if (!this.interpreter.getClassManager().classExists(className)) {
                        in = this.interpreter.getClassManager().getResourceAsStream("/" + className.replace('.', '/') + ".java");
                        if (in == null) {
                            throw ex;
                        }
                        this.interpreter.eval((Reader)new InputStreamReader(in));
                    }
                    clazz = this.interpreter.getNameSpace().getClass(className);
                    Object var6_7 = null;
                }
                catch (UtilEvalError ex1) {
                    throw new RuntimeException(ex1);
                }
                catch (EvalError err) {
                    throw new RuntimeException(err);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                catch (IOException ex1) {
                    throw throwable;
                }
            }
            try {}
            catch (IOException ex1) {
                // empty catch block
                return clazz;
            }
            if (in == null) return clazz;
            in.close();
            return clazz;
        }
    }

    Set<String> setDataTypes(Map vars, String modelClassName) {
        String name = null;
        HashSet<String> names = new HashSet<String>();
        try {
            Class modelClass = this.smartLoadClass(modelClassName);
            Object instance = modelClass.newInstance();
            for (Field f : modelClass.getFields()) {
                Object res;
                name = f.getName();
                if (vars.containsKey(name)) {
                    Class<?> modelType;
                    Object value = vars.get(name);
                    Class<?> currentType = value.getClass();
                    if (currentType.equals(modelType = f.getType())) {
                        f.set(instance, value);
                    } else {
                        String stringValue = value.toString();
                        if (stringValue.length() > 0) {
                            if (modelType.equals(Boolean.TYPE)) {
                                f.setBoolean(instance, Boolean.parseBoolean(stringValue));
                            } else if (modelType.equals(Byte.TYPE)) {
                                f.setByte(instance, Byte.parseByte(stringValue));
                            } else if (modelType.equals(Character.TYPE)) {
                                f.setChar(instance, stringValue.charAt(0));
                            } else if (modelType.equals(Double.TYPE)) {
                                f.setDouble(instance, Double.parseDouble(stringValue));
                            } else if (modelType.equals(Float.TYPE)) {
                                f.setFloat(instance, Float.parseFloat(stringValue));
                            } else if (modelType.equals(Integer.TYPE)) {
                                f.setInt(instance, Integer.parseInt(stringValue));
                            } else if (modelType.equals(Long.TYPE)) {
                                f.setLong(instance, Long.parseLong(stringValue));
                            } else if (modelType.equals(Short.TYPE)) {
                                f.setShort(instance, Short.parseShort(stringValue));
                            }
                        }
                    }
                }
                if ((res = f.get(instance)) == null) {
                    res = "";
                }
                vars.put(name, res);
                names.add(name);
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Illegal value given for \"" + name + "\": " + ex.getMessage(), ex);
        }
        return names;
    }

    @Override
    public void setProperties(Properties props) {
        BeanBinder.setProperties((Object)this, props);
        HashMap sv = new HashMap(this.skinVariables);
        sv.putAll(JAlbumUtilities.getSkinVariables(props));
        this.setSkinVariables(sv);
        Map uv = this.getUserVariables();
        uv.putAll(JAlbumUtilities.getUserVariables(props));
        this.setUserVariables(uv);
    }

    private static Object interpretDataType(Object o) {
        if (!(o instanceof String)) {
            return o;
        }
        String s = (String)o;
        if (s.indexOf(0) == 34 && s.length() >= 2) {
            return s.substring(1, s.length() - 2);
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        try {
            return new Integer(s);
        }
        catch (NumberFormatException ex) {
            try {
                return new Double(s);
            }
            catch (NumberFormatException numberFormatException) {
                return s;
            }
        }
    }

    @Override
    public Map getUserVariables() {
        return this.userVariables;
    }

    @Override
    public Map getSkinVariables() {
        Set<String> mappedVars = this.setDataTypes(this.skinVariables, "SkinModel");
        for (Map.Entry entry : this.skinVariables.entrySet()) {
            if (mappedVars.contains((String)entry.getKey()) || !(entry.getValue() instanceof String)) continue;
            entry.setValue(AlbumBean.interpretDataType((String)entry.getValue()));
        }
        return this.skinVariables;
    }

    public void setRemoteDirectory(String newRemoteDirectory) {
        this.remoteDirectory = newRemoteDirectory.trim().replace('\\', '/');
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setAccountProfileName(String newAccountProfileName) {
        String oldName = this.accountProfileName;
        this.accountProfileName = newAccountProfileName;
        this.firePropertyChange("accountProfileName", oldName, newAccountProfileName);
    }

    public String getAccountProfileName() {
        return this.accountProfileName;
    }

    public void setReverseOrder(boolean newReverseOrder) {
        this.reverseOrder = newReverseOrder;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void setCharacterEncoding(String newCharacterEncoding) {
        this.characterEncoding = newCharacterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setTextEncoding(String newTextEncoding) {
        this.textEncoding = newTextEncoding;
        System.setProperty("file.encoding", this.textEncoding);
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setWriteUTF8(boolean newWriteUTF8) {
        this.writeUTF8 = newWriteUTF8;
    }

    public boolean isWriteUTF8() {
        return this.writeUTF8;
    }

    public void setDirectoriesFirst(boolean newDirectoriesFirst) {
        this.directoriesFirst = newDirectoriesFirst;
    }

    public boolean isDirectoriesFirst() {
        return this.directoriesFirst;
    }

    public void setIgnorePattern(String ignorePattern) {
        this.ignorePattern = ignorePattern;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    static void setVars(Map variables, Interpreter interpreter) throws ElementException {
        Iterator it = variables.entrySet().iterator();
        try {
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String name = (String)e.getKey();
                if (name.indexOf(46) != -1) continue;
                Object val = e.getValue();
                if (val instanceof Integer) {
                    interpreter.set(name, ((Integer)val).intValue());
                    continue;
                }
                if (val instanceof Long) {
                    interpreter.set(name, ((Long)val).longValue());
                    continue;
                }
                if (val instanceof Float) {
                    interpreter.set(name, ((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Double) {
                    interpreter.set(name, ((Double)val).doubleValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    interpreter.set(name, ((Boolean)val).booleanValue());
                    continue;
                }
                interpreter.set(name, val);
            }
        }
        catch (EvalError e) {
            throw new ElementException(e.getMessage());
        }
    }

    public void setUsing(Object using) {
        this.using = using;
    }

    public String getScalingMethod() {
        return this.scalingMethod;
    }

    public void setScalingMethod(String scalingMethod) {
        this.scalingMethod = scalingMethod;
    }

    public boolean isHardwareScaling() {
        return this.hardwareScaling;
    }

    public void setHardwareScaling(boolean hardwareScaling) {
        this.hardwareScaling = hardwareScaling;
    }

    public boolean isSearchEngineFriendlyNames() {
        return this.searchEngineFriendlyNames;
    }

    public void setSearchEngineFriendlyNames(boolean searchEngineFriendlyNames) {
    }

    class StandardImageProcessor
    implements ImageProcessor {
        StandardImageProcessor() {
        }

        public void processImages(AlbumBean engine, Counter c, File dir, File outputDir, AlbumObject[] objects) throws IOException, OperationAbortedException, ElementException {
            File thumbsDir = new File(outputDir, AlbumBean.this.thumbDirectory);
            thumbsDir.mkdir();
            File hiResDir = new File(outputDir, AlbumBean.this.hiResDirectory);
            if (AlbumBean.LINK_HI_RES_VIA_SCALED.equals(AlbumBean.this.getImageLinking())) {
                hiResDir.mkdir();
            } else if (hiResDir.exists()) {
                IO.deleteDir(hiResDir);
            }
            String rootPath = IO.relativePath(AlbumBean.this.rootOutputDir, thumbsDir);
            int i = c.next();
            while (i < objects.length) {
                AlbumObject ao = objects[i];
                if (AlbumBean.this.slideTemplate != null) {
                    AlbumBean.this.makeSlide(ao, rootPath);
                }
                AlbumBeanEvent eventObject = new AlbumBeanEvent(AlbumBean.this, dir, IO.relativePath(dir, AlbumBean.this.rootImageDir.getParentFile()), ao.getName(), i + 1, objects.length, AlbumBean.this.processedFiles, AlbumBean.this.totalFiles);
                AlbumBean.this.fireImageProcessingStarted(eventObject);
                this.processImage(engine, ao, outputDir);
                if (eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                eventObject = new AlbumBeanEvent(AlbumBean.this, dir, IO.relativePath(dir, AlbumBean.this.rootImageDir.getParentFile()), ao.getName(), i + 1, objects.length, ++AlbumBean.this.processedFiles, AlbumBean.this.totalFiles);
                AlbumBean.this.fireImageProcessingFinished(eventObject);
                if (eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                i = c.next();
            }
        }

        public void processImage(AlbumBean engine, AlbumObject ao, File outputDir) throws IOException {
            boolean mediaFile;
            File thumbsDir = new File(outputDir, AlbumBean.this.thumbDirectory);
            File hiResDir = new File(outputDir, AlbumBean.this.hiResDirectory);
            Scope locals = ao.getVars();
            Dimension imageDim = AlbumBean.getImageDim(locals);
            Dimension thumbDim = AlbumBean.getThumbDim(locals);
            String il = AlbumBean.this.getImageLinking(locals);
            if (ao.isIncluded() && !outputDir.equals(ao.getFile().getParentFile()) && ao.getCategory() != Category.webPage && (AlbumBean.this.copyOriginals && (il.equals(AlbumBean.LINK_ORIGINALS) || il.equals(AlbumBean.LINK_ORIGINALS_VIA_SCALED)) || (il.equals(AlbumBean.LINK_SCALED) || il.equals(AlbumBean.LINK_HI_RES_VIA_SCALED)) && !AlbumBean.isSupported(ao))) {
                IO.copyFile(ao.getFile(), outputDir, !AlbumBean.this.appendImages);
            }
            File file = ao.getFile();
            File repFile = IO.thumbFile(file);
            String category = FileFilters.getFileCategory(file);
            boolean bl = mediaFile = "Media file".equals(category) || "Flash Video".equals(category);
            if (repFile.exists()) {
                file = repFile;
            }
            if (repFile.exists() || AlbumBean.isSupported(ao)) {
                File thumbFile = new File(thumbsDir, AlbumBean.this.thumbnailPrefix + AlbumBean.getTargetName(ao.getName()));
                File scaledFile = new File(AlbumBean.this.slidesDir, AlbumBean.this.closeupPrefix + AlbumBean.getTargetName(ao.getName()));
                File hiResFile = new File(hiResDir, AlbumBean.getTargetName(ao.getName()));
                try {
                    BufferedImage original;
                    FilterList stack = (FilterList)ao.getProperties().get("filterList");
                    FilterRenderer filterRenderer = null;
                    if (stack != null) {
                        filterRenderer = new FilterRenderer();
                        filterRenderer.setFilterList(stack);
                    }
                    if (!AlbumBean.this.appendImages || AlbumBean.this.makeThumbs && AlbumBean.isDirty(thumbFile, ao) || !il.equals(AlbumBean.LINK_ORIGINALS) && AlbumBean.isDirty(scaledFile, ao) || il.equals(AlbumBean.LINK_HI_RES_VIA_SCALED) && AlbumBean.isDirty(hiResFile, ao)) {
                        int subsampling = 1;
                        if (!AlbumBean.this.scalingMethod.equals(AlbumBean.SCALE_SMOOTH)) {
                            Dimension dim = AlbumBean.LINK_HI_RES_VIA_SCALED.equals(il) ? AlbumBean.this.hiResDim : imageDim;
                            subsampling = FileFilters.calculateSubsamplingByScale(file, dim);
                        }
                        if ((original = AlbumBean.this._useScaledImagesAsOriginals && scaledFile.exists() ? FileFilters.loadImage(scaledFile) : FileFilters.loadImage(file, subsampling)).getWidth() > original.getHeight()) {
                            original = RotationSupport.adjustOrientation(original, (String)locals.get("orientation"));
                        }
                        if (!il.equals(AlbumBean.LINK_ORIGINALS) && ao.isIncluded()) {
                            String ext = IO.extensionOf(file).toLowerCase();
                            if (("jpeg".equals(ext) || "jpg".equals(ext)) && original.getWidth() <= imageDim.width && original.getHeight() <= imageDim.height && (stack == null || stack.getPosition() == 0) && AlbumBean.this.filters.size() == 0 && "normal".equals(locals.get("orientation"))) {
                                IO.copyFile(file, scaledFile, !AlbumBean.this.appendImages);
                                if (AlbumBean.LINK_HI_RES_VIA_SCALED.equals(AlbumBean.this.getImageLinking())) {
                                    IO.copyFile(file, hiResFile, !AlbumBean.this.appendImages);
                                }
                            } else {
                                BufferedImage bi;
                                if (AlbumBean.LINK_HI_RES_VIA_SCALED.equals(il) && AlbumBean.isDirty(hiResFile, ao) && !hiResFile.equals(file)) {
                                    bi = AlbumBean.this.scaleToFit(original, AlbumBean.this.hiResDim, AlbumBean.this.getScalingMethod(), 0.0f);
                                    FileFilters.saveJPEG(bi, hiResFile, AlbumBean.this);
                                    bi.flush();
                                }
                                bi = AlbumBean.this.processFilters(filterRenderer, original, locals, 1);
                                bi = AlbumBean.this.scaleToFit(bi, imageDim, AlbumBean.this.getScalingMethod());
                                bi = AlbumBean.this.processFilters(filterRenderer, bi, locals, 2);
                                original.flush();
                                original = bi;
                                BufferedImage tmpImage = AlbumBean.this.processFilters(filterRenderer, bi, locals, 3);
                                if (AlbumBean.this.superimposeFilmIcon && repFile.exists() && mediaFile) {
                                    if (tmpImage == bi) {
                                        tmpImage = AlbumBean.copyImage(bi);
                                    }
                                    Graphics g = tmpImage.getGraphics();
                                    g.drawImage(filmImage, 1, 2, null);
                                    g.dispose();
                                }
                                IIOMetadata meta = null;
                                if (AlbumBean.this.keepMetaData) {
                                    meta = FileFilters.getMetaData(file);
                                }
                                if (!scaledFile.equals(file)) {
                                    FileFilters.saveJPEG(tmpImage, scaledFile, AlbumBean.this, meta);
                                    String orientation = (String)locals.get("orientation");
                                    if (meta != null && !"normal".equals(orientation)) {
                                        RotationSupport.setOrientation(1, scaledFile);
                                    }
                                }
                            }
                        }
                    } else {
                        original = null;
                    }
                    if (AlbumBean.this.makeThumbs && !thumbFile.equals(file) && (!AlbumBean.this.appendImages || AlbumBean.isDirty(thumbFile, ao))) {
                        BufferedImage bi = AlbumBean.this.processFilters(filterRenderer, original, locals, 4);
                        BufferedImage thumb = AlbumBean.this.scaleToFit(bi, thumbDim, AlbumBean.this.highQualityThumbs ? AlbumBean.SCALE_SMOOTH : AlbumBean.this.getScalingMethod());
                        if (AlbumBean.this.superimposeFilmIcon && repFile.exists() && mediaFile) {
                            Graphics g = thumb.getGraphics();
                            g.drawImage(filmImage, 1, 2, null);
                            g.dispose();
                        }
                        bi = AlbumBean.this.processFilters(filterRenderer, thumb, locals, 5);
                        FileFilters.saveJPEG(bi, thumbFile, AlbumBean.this, null, AlbumBean.this.highThumbnailCompressionQuality ? 0.95f : (float)engine.getQualityPercent() / 100.0f);
                    }
                }
                catch (Exception ex) {
                    AlbumBean.this.fireErrorOccured(ex, ao.getFile());
                }
            }
        }
    }

    public static class Counter {
        private AtomicInteger x;

        public Counter(int startValue) {
            this.x = new AtomicInteger(startValue);
        }

        public int value() {
            return this.x.get();
        }

        public int next() {
            return this.x.getAndIncrement();
        }
    }

    class EvalStat {
        String expr;
        int invocations;
        Stopwatch stopwatch = new Stopwatch();

        EvalStat() {
        }

        public String toString() {
            return this.stopwatch + "\tInvocations: " + this.invocations + "\tExpr: " + this.expr.substring(0, this.expr.length() <= 40 ? this.expr.length() - 1 : 40);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageProcessingTask
    implements Callable<Object> {
        private Counter counter;
        private File dir;
        private File outputDir;
        private AlbumObject[] objects;

        public ImageProcessingTask(Counter counter, File dir, File outputDir, AlbumObject[] objects) {
            this.counter = counter;
            this.dir = dir;
            this.outputDir = outputDir;
            this.objects = objects;
        }

        @Override
        public Object call() throws Exception {
            AlbumBean.this.imageProcessor.processImages(AlbumBean.this, this.counter, this.dir, this.outputDir, this.objects);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisteringTask
    implements Callable<Collection<AlbumObject>> {
        private Counter counter;
        private AlbumObject[] objects;
        private File outputDir;
        private Collection<AlbumObject> errorObjects = new ArrayList<AlbumObject>();

        public RegisteringTask(Counter c, AlbumObject[] objects, File outputDir) {
            this.counter = c;
            this.objects = objects;
            this.outputDir = outputDir;
        }

        @Override
        public Collection<AlbumObject> call() throws Exception {
            int i = this.counter.next();
            while (i < this.objects.length) {
                AlbumObject ao = this.objects[i];
                try {
                    AlbumBean.this.registerVariables(ao, this.outputDir, false);
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    this.errorObjects.add(ao);
                    AlbumBean.this.fireErrorOccured(t, ao.getFile());
                }
                i = this.counter.next();
            }
            return this.errorObjects;
        }
    }
}

