/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.IOException;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.AlbumObjectProperties;

public class FastFile
extends File {
    private boolean directory;
    private boolean isDirectoryAsked;
    private long modificationDate = 0L;
    private File originalFile;
    private AlbumObjectMetadata meta;
    private AlbumObjectProperties properties;

    public FastFile(File f) {
        super(f instanceof LinkFile ? ((LinkFile)f).getLink().getAbsolutePath() : f.getAbsolutePath());
        this.originalFile = f;
    }

    public final boolean isDirectory() {
        if (!this.isDirectoryAsked) {
            this.directory = super.isDirectory();
            this.isDirectoryAsked = true;
        }
        return this.directory;
    }

    public final long lastModified() {
        if (this.modificationDate == 0L) {
            this.modificationDate = this.originalFile.lastModified();
        }
        return this.modificationDate;
    }

    public final boolean setLastModified(long modificationDate) {
        boolean ok = this.originalFile.setLastModified(modificationDate);
        if (ok) {
            this.modificationDate = modificationDate;
        }
        return ok;
    }

    public long getCameraDate() {
        if (this.meta == null) {
            try {
                this.meta = new AlbumObjectMetadata(this.originalFile);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.meta.getCameraDate();
    }

    public AlbumObjectProperties getProperties() {
        if (this.properties == null) {
            this.properties = new AlbumObjectProperties(this.originalFile);
        }
        return this.properties;
    }

    public final File unWrap() {
        return this.originalFile;
    }
}

