/*
 * Decompiled with CFR 0.152.
 */
package nl.tomcee.skinprops;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import net.miginfocom.swing.MigLayout;
import se.datadosen.jalbum.Frog;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.SkinProperties;

public class SkinPropsEditor
extends JFrame {
    static final String APP_NAME = "Skin Properties Editor";
    static final String VERSION = "1.7";
    static final String AUTHOR = "Tom";
    final String SIMPLE_NAME = this.getClass().getSimpleName();
    private JAlbumContext context = JAlbumContext.getInstance();
    private String skin = this.context.getSkinDir().getName();
    private String accountProfileName = this.context.getEngine().getAccountProfileName();
    private JTextField title = new JTextField("", 40);
    private JTextField supportForum = new JTextField("", 40);
    private JTextField author = new JTextField("", 40);
    private JCheckBox autoWidgetInjection = new JCheckBox();
    private JCheckBox compatibilityMode = new JCheckBox();
    private JTextField company = new JTextField("", 40);
    private JTextArea description = new JTextArea(){
        {
            this.setRows(5);
            this.setColumns(40);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setFont(new Font("Tahoma", 0, 11));
        }
    };
    private JScrollPane spDescription = new JScrollPane(){
        {
            this.setViewportView(SkinPropsEditor.this.description);
        }
    };
    private JTextField homePage = new JTextField("", 40);
    private JTextField requiredJalbumVersion = new JTextField("", 40);
    private JTextField requiredJavaVersion = new JTextField("", 40);
    private JTextField userName = new JTextField("", 40);
    private JTextField version = new JTextField("", 40);
    private JPanel panel;
    private SkinProperties skinProperties = this.context.getEngine().getSkinProperties();
    private Date currentDate = new Date();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private DefaultFormatterFactory dff = new DefaultFormatterFactory(new DateFormatter(this.formatter));
    private String now = this.formatter.format(this.currentDate);
    private JFormattedTextField creationDate = new JFormattedTextField(this.dff);
    private JFormattedTextField lastModifiedDate = new JFormattedTextField(this.dff);
    private JButton saveButton = new JButton("Save"){
        {
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SkinPropsEditor.this.saveSkinProps();
                    SkinPropsEditor.this.dispose();
                }
            });
        }
    };
    private JButton cancelButton = new JButton("Cancel"){
        {
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SkinPropsEditor.this.dispose();
                }
            });
        }
    };
    private JButton nowButton = new JButton("now!"){
        {
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SkinPropsEditor.this.lastModifiedDate.setText(SkinPropsEditor.this.now);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent evt) {
                    this.setText(SkinPropsEditor.this.now);
                }

                public void mouseExited(MouseEvent evt) {
                    this.setText("now!");
                }
            });
        }
    };

    private JMenuBar buildMenu() {
        JMenuBar menubar = new JMenuBar();
        JMenuItem aboutMenuItem = new JMenuItem("About");
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new Frog().ribbit();
                String aboutText = "<html><b>Skin Properties Editor<br>version: 1.7<br>author: Tom</b></html>";
                JOptionPane.showMessageDialog(SkinPropsEditor.this.rootPane, aboutText, "About: " + SkinPropsEditor.this.SIMPLE_NAME, 1, new ImageIcon(this.getClass().getResource("tclogo.gif")));
            }
        });
        menubar.add(aboutMenuItem);
        return menubar;
    }

    private JPanel createPanel() {
        this.panel = new JPanel(){
            {
                this.setLayout((LayoutManager)new MigLayout("wrap 2"));
                this.add(new JLabel("title"));
                this.add(SkinPropsEditor.this.title);
                this.add(new JLabel("version"));
                this.add(SkinPropsEditor.this.version);
                this.add(new JLabel("author"));
                this.add(SkinPropsEditor.this.author);
                this.add(new JLabel("creationDate"));
                this.add((Component)SkinPropsEditor.this.creationDate, "split 2");
                this.add(new JLabel("(YYYY-MM-DD)"));
                this.add(new JLabel("lastModifiedDate"));
                this.add((Component)SkinPropsEditor.this.lastModifiedDate, "split 3");
                this.add(new JLabel("(YYYY-MM-DD)"));
                this.add(SkinPropsEditor.this.nowButton);
                this.add(new JLabel("autoWidgetInjection"));
                this.add(SkinPropsEditor.this.autoWidgetInjection);
                this.add(new JLabel("compatibilityMode"));
                this.add(SkinPropsEditor.this.compatibilityMode);
                this.add(new JLabel("requiredJalbumVersion"));
                this.add(SkinPropsEditor.this.requiredJalbumVersion);
                this.add(new JLabel("requiredJavaVersion"));
                this.add(SkinPropsEditor.this.requiredJavaVersion);
                this.add(new JLabel("company"));
                this.add(SkinPropsEditor.this.company);
                this.add(new JLabel("username"));
                this.add(SkinPropsEditor.this.userName);
                this.add(new JLabel("homePage"));
                this.add(SkinPropsEditor.this.homePage);
                this.add(new JLabel("supportForum"));
                this.add(SkinPropsEditor.this.supportForum);
                this.add(new JLabel("description"));
                this.add(SkinPropsEditor.this.spDescription);
                this.add((Component)SkinPropsEditor.this.saveButton, "cell 1 13, split 2, align right");
                this.add(SkinPropsEditor.this.cancelButton);
            }
        };
        return this.panel;
    }

    private void getSkinProps() {
        this.title.setText(this.skinProperties.getProperty("title"));
        this.author.setText(this.skinProperties.getProperty("author"));
        this.autoWidgetInjection.setSelected(this.skinProperties.isAutoWidgetInjection());
        this.compatibilityMode.setSelected(this.skinProperties.isCompatibilityMode());
        this.company.setText(this.skinProperties.getProperty("company"));
        this.creationDate.setText(this.skinProperties.getProperty("creationDate"));
        this.description.setText(this.skinProperties.getProperty("description"));
        this.homePage.setText(this.skinProperties.getProperty("homePage"));
        this.supportForum.setText(this.skinProperties.getProperty("supportForum"));
        this.lastModifiedDate.setText(this.skinProperties.getProperty("lastModifiedDate"));
        this.requiredJalbumVersion.setText(this.skinProperties.getProperty("requiredJalbumVersion"));
        this.requiredJavaVersion.setText(this.skinProperties.getProperty("requiredJavaVersion"));
        this.userName.setText(this.skinProperties.getProperty("username"));
        this.version.setText(this.skinProperties.getProperty("version"));
        if (this.title.getText().equals("")) {
            this.title.setText(this.skin);
        }
        if (this.creationDate.getText().equals("")) {
            this.creationDate.setText(this.now);
        }
        if (this.lastModifiedDate.getText().equals("")) {
            this.lastModifiedDate.setText(this.now);
        }
        if (this.userName.getText().equals("") && !this.accountProfileName.equals("")) {
            this.userName.setText(this.accountProfileName.substring(this.accountProfileName.lastIndexOf("- ") + 2));
        }
        if (this.requiredJavaVersion.getText().equals("")) {
            this.requiredJavaVersion.setText("1.5");
        }
    }

    private void saveSkinProps() {
        this.skinProperties.setProperty("title", this.title.getText());
        this.skinProperties.setProperty("author", this.author.getText());
        this.skinProperties.setProperty("autoWidgetInjection", String.valueOf(this.autoWidgetInjection.isSelected()));
        this.skinProperties.setProperty("compatibilityMode", String.valueOf(this.compatibilityMode.isSelected()));
        this.skinProperties.setProperty("company", this.company.getText());
        this.skinProperties.setProperty("creationDate", this.creationDate.getText());
        this.skinProperties.setProperty("description", this.description.getText());
        this.skinProperties.setProperty("homePage", this.homePage.getText());
        this.skinProperties.setProperty("supportForum", this.supportForum.getText());
        this.skinProperties.setProperty("lastModifiedDate", this.lastModifiedDate.getText());
        this.skinProperties.setProperty("requiredJalbumVersion", this.requiredJalbumVersion.getText());
        this.skinProperties.setProperty("requiredJavaVersion", this.requiredJavaVersion.getText());
        this.skinProperties.setProperty("username", this.userName.getText());
        this.skinProperties.setProperty("version", this.version.getText());
        try {
            this.skinProperties.save();
            System.out.println(new Date() + " skin.properties saved succesfull.");
        }
        catch (IOException ex) {
            System.out.println(ex + " - failed to write skin.properties");
        }
    }

    public SkinPropsEditor() {
        this.setTitle(this.skin + " - " + APP_NAME);
        this.setIconImage(new ImageIcon(this.getClass().getResource("tclogo.gif")).getImage());
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.buildMenu());
        this.getSkinProps();
        this.getContentPane().add(this.createPanel());
        this.pack();
        this.setVisible(true);
        this.description.setCaretPosition(0);
        this.cancelButton.requestFocusInWindow();
    }
}

