/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import se.datadosen.jalbum.Config;
import se.datadosen.util.APP1Segment;
import se.datadosen.util.JpegFile;
import se.datadosen.util.Segment;

public class RotationSupport {
    public static final int LEFT_ROTATED = 6;
    public static final int NOT_ROTATED = 1;
    public static final int RIGHT_ROTATED = 8;
    public static final int UPSIDE_DOWN = 3;

    public static BufferedImage rotate180(BufferedImage bi) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
        tx.translate(-bi.getWidth(), -bi.getHeight());
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(bi, null);
    }

    public static BufferedImage rotateLeft(BufferedImage bi) {
        AffineTransform rot270Transform = AffineTransform.getRotateInstance(4.71238898038469);
        rot270Transform.translate(-bi.getWidth(), 0.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot270Transform, hints);
        return op.filter(bi, null);
    }

    public static BufferedImage rotateRight(BufferedImage bi) {
        AffineTransform rot90Transform = AffineTransform.getRotateInstance(1.5707963267948966);
        rot90Transform.translate(0.0, -bi.getHeight());
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot90Transform, hints);
        return op.filter(bi, null);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, Metadata meta) {
        if (meta == null) {
            return ii;
        }
        BufferedImage bi = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
        bi = RotationSupport.adjustOrientation(bi, meta);
        return new ImageIcon(bi);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, File file) {
        try {
            BufferedImage bi = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
            bi = RotationSupport.adjustOrientation(bi, RotationSupport.getOrientation(file));
            return new ImageIcon(bi);
        }
        catch (IOException ex) {
            return ii;
        }
    }

    private static BufferedImage createBufferedImage(Image img, int iw, int ih) {
        int type = 1;
        if (img instanceof BufferedImage) {
            type = ((BufferedImage)img).getType();
        }
        BufferedImage bi = new BufferedImage(iw, ih, type);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, Metadata meta) {
        if (meta == null) {
            return bi;
        }
        try {
            if (meta.containsDirectory(ExifDirectory.class)) {
                Directory exif = meta.getDirectory(ExifDirectory.class);
                int existingOrientation = exif.getInt(274);
                return RotationSupport.adjustOrientation(bi, existingOrientation);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return bi;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, File file) {
        try {
            return RotationSupport.adjustOrientation(bi, RotationSupport.getOrientation(file));
        }
        catch (Exception ex) {
            if (Config.getConfig().isDebugMode()) {
                System.err.println(ex);
            }
            return bi;
        }
    }

    public static int getOrientation(Metadata meta) {
        try {
            if (meta.containsDirectory(ExifDirectory.class)) {
                Directory exif = meta.getDirectory(ExifDirectory.class);
                return exif.getInt(274);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return 1;
    }

    public static String getOrientationAsString(Metadata meta) {
        return RotationSupport.asString(RotationSupport.getOrientation(meta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getOrientation(File file) throws IOException {
        int n;
        JpegFile f;
        block9: {
            int n2;
            block8: {
                f = null;
                try {
                    Segment s;
                    f = new JpegFile(file);
                    for (s = f.getFirstSegment(); s != null && s.getId() != -31; s = s.getNextSegment()) {
                    }
                    if (s != null) {
                        APP1Segment app1 = new APP1Segment(s);
                        int ifdCount = 0;
                        do {
                            if (++ifdCount > 50) {
                                System.out.println("RotationSupport: High ifdCount (" + ifdCount + ") for " + file);
                            }
                            if (app1.getEntryCount() > 30) {
                                System.out.println("RotationSupport: High EntryCount (" + app1.getEntryCount() + ") for " + file);
                            }
                            for (int i = 0; i < app1.getEntryCount(); ++i) {
                                APP1Segment.Entry ifd = app1.getEntry(i);
                                if (ifd.getTagNr() != 274) continue;
                                n2 = ifd.getValue();
                                Object var9_9 = null;
                                if (f == null) return n2;
                                break block8;
                            }
                        } while (app1.nextIFD());
                    }
                    n = 1;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (f == null) throw throwable;
                    f.close();
                    throw throwable;
                }
            }
            f.close();
            return n2;
        }
        Object var9_10 = null;
        if (f == null) return n;
        f.close();
        return n;
    }

    public static String getOrientationAsString(File file) {
        try {
            return RotationSupport.asString(RotationSupport.getOrientation(file));
        }
        catch (Exception ex) {
            return "normal";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setOrientation(int orientation, File file) throws IOException {
        boolean bl;
        block7: {
            JpegFile f = null;
            boolean reoriented = false;
            try {
                Segment s;
                f = new JpegFile(file, "rw");
                for (s = f.getFirstSegment(); s != null && s.getId() != -31; s = s.getNextSegment()) {
                }
                if (s != null) {
                    APP1Segment app1 = new APP1Segment(s);
                    boolean ifdNum = false;
                    block3: do {
                        for (int i = 0; i < app1.getEntryCount(); ++i) {
                            APP1Segment.Entry ifd = app1.getEntry(i);
                            if (ifd.getTagNr() != 274) continue;
                            ifd.setValue(orientation);
                            reoriented = true;
                            continue block3;
                        }
                    } while (app1.nextIFD());
                }
                if (!reoriented) {
                    throw new IOException("Couldn't find orientation tag in APP1 segment");
                }
                bl = reoriented;
                Object var10_10 = null;
                if (f == null) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var10_11 = null;
                    if (f == null) break block8;
                    f.close();
                }
                throw throwable;
            }
            f.close();
        }
        return bl;
    }

    private static String asString(int orientation) {
        return Orientation.fromValue(orientation).toString();
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, String existingOrientation) {
        return RotationSupport.adjustOrientation(bi, Orientation.fromName(existingOrientation).getValue());
    }

    public static BufferedImage adjustOrientation(BufferedImage bi, int existingOrientation) {
        if (existingOrientation == 6) {
            return RotationSupport.rotateRight(bi);
        }
        if (existingOrientation == 8) {
            return RotationSupport.rotateLeft(bi);
        }
        if (existingOrientation == 3) {
            return RotationSupport.rotate180(bi);
        }
        return bi;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        normal(1),
        right(8),
        upsideDown(3),
        left(6);

        private int value;

        private Orientation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public Orientation next() {
            int ordinal = this.ordinal();
            if (++ordinal >= Orientation.values().length) {
                ordinal = 0;
            }
            return Orientation.values()[ordinal];
        }

        public Orientation previous() {
            int ordinal = this.ordinal();
            if (--ordinal < 0) {
                ordinal = Orientation.values().length - 1;
            }
            return Orientation.values()[ordinal];
        }

        public static Orientation fromValue(int value) {
            for (Orientation o : Orientation.values()) {
                if (o.getValue() != value) continue;
                return o;
            }
            return null;
        }

        public static Orientation fromName(String name) {
            return name != null ? Enum.valueOf(Orientation.class, name) : normal;
        }
    }
}

