/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.apple.eio.FileManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFrame;
import org.jdesktop.jdic.fileutil.FileUtil;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.Platform;
import se.datadosen.util.Replacer;
import se.datadosen.util.StringCodec;

public class IO {
    private static boolean preserveLastModified = true;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String rfc3986Reserved = "!*'();@&=+$,?%#[]";
    public static final String reserved = "!*'();@&=+$,?%#[]`\" <>";
    private static int BUFSIZE = 65536;

    public static File ensureUnique(File dir, String name) {
        File target = new File(dir, name);
        int i = 1;
        while (target.exists()) {
            target = new File(dir, name + "-" + i);
            ++i;
        }
        return target;
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        byte[] buf = IO.readBytes(file);
        StringCodec codec = new StringCodec();
        return codec.decode(buf, encoding);
    }

    public static boolean isPreserveLastModified() {
        return preserveLastModified;
    }

    public static void setPreserveLastModified(boolean preserveLastModified) {
        IO.preserveLastModified = preserveLastModified;
    }

    public static String readTextFile(File file) throws IOException {
        return IO.readTextFile(file, System.getProperty("file.encoding"));
    }

    public static String readTextFile(String fileName) throws IOException {
        return IO.readTextFile(new File(fileName));
    }

    public static String readTextUrl(URL textUrl) throws IOException {
        int offset;
        URLConnection conn = textUrl.openConnection();
        int length = conn.getContentLength();
        if (length == -1) {
            throw new IOException("Couldn't connect to " + textUrl);
        }
        byte[] bytes = new byte[length];
        InputStream is = conn.getInputStream();
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read from " + textUrl);
        }
        is.close();
        StringCodec codec = new StringCodec();
        return codec.decode(bytes, System.getProperty("file.encoding"));
    }

    public static byte[] readBytes(File f) throws IOException {
        int offset;
        byte[] buf = new byte[(int)f.length()];
        FileInputStream in = new FileInputStream(f);
        int numRead = 0;
        for (offset = 0; offset < buf.length && (numRead = in.read(buf, offset, buf.length - offset)) >= 0; offset += numRead) {
        }
        in.close();
        if (offset < buf.length) {
            throw new IOException("Could not completely read file " + f.getName());
        }
        return buf;
    }

    public static void writeBytes(byte[] buf, File f) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        ((OutputStream)out).write(buf);
        ((OutputStream)out).close();
    }

    public static void writeTextFile(String content, File file) throws IOException {
        IO.writeTextFile(content, file, System.getProperty("file.encoding"));
    }

    public static void writeTextFile(String content, File file, String encoding) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        writer.write(content);
        writer.close();
    }

    public static boolean writeChangedTextFile(String content, File file, String encoding) throws IOException {
        if (!file.exists()) {
            IO.writeTextFile(content, file, encoding);
            return true;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
        writer.write(content);
        writer.close();
        byte[] outBytes = out.toByteArray();
        byte[] inBytes = IO.readBytes(file);
        if (!Arrays.equals(outBytes, inBytes)) {
            IO.writeBytes(outBytes, file);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(File file) throws IOException {
        Properties properties;
        block2: {
            FileInputStream fis = null;
            try {
                Properties props = new Properties();
                fis = new FileInputStream(file);
                props.load(fis);
                properties = props;
                Object var5_4 = null;
                if (fis == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (fis == null) break block3;
                    fis.close();
                }
                throw throwable;
            }
            fis.close();
        }
        return properties;
    }

    public static Map readMapFile(File file) throws IOException {
        return IO.readMap(IO.readBytes(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMap(byte[] bytes) throws IOException {
        HashMap<String, String> hashMap;
        block4: {
            Pattern backslashPattern = Pattern.compile("\\\\\\\\", 2);
            StringCodec codec = new StringCodec();
            String s = codec.decode(bytes, System.getProperty("file.encoding"));
            BufferedReader in = new BufferedReader(new StringReader(s));
            try {
                String line;
                HashMap<String, String> theMap = new HashMap<String, String>();
                while ((line = in.readLine()) != null) {
                    int equalsIndex;
                    if ((line = line.trim()).startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                    String key = line.substring(0, equalsIndex).trim();
                    String value = line.substring(equalsIndex + 1).trim();
                    while (IO.continueLine(line)) {
                        value = value.substring(0, value.length() - 1);
                        line = in.readLine();
                        if (line == null) break;
                        value = value + "\n" + line;
                    }
                    value = backslashPattern.matcher(value).replaceAll("\\\\");
                    theMap.put(key, value);
                }
                hashMap = theMap;
                Object var11_11 = null;
                if (in == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var11_12 = null;
                    if (in == null) break block5;
                    in.close();
                }
                throw throwable;
            }
            in.close();
        }
        return hashMap;
    }

    public static void writeMapFile(Map map, File f) throws IOException {
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        for (Map.Entry e : map.entrySet()) {
            out.println(e.getKey().toString() + "=" + backslashEncoder.replace(e.getValue().toString()));
        }
        out.close();
        String s = writer.getBuffer().toString();
        StringCodec codec = new StringCodec();
        byte[] bytes = codec.encode(s);
        if (!s.equals(codec.decode(bytes))) {
            bytes = codec.encode(s, "UTF-8");
        }
        IO.writeBytes(bytes, f);
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static void copyFilesUI(JFrame parent, File[] files, File dest) throws OperationAbortedException {
    }

    public static void copyFile(File src, File dest) throws IOException {
        IO.copyFile(src, dest, true);
    }

    public static void copyFile(String name, File dest) throws IOException {
        IO.copyFile(name, dest, true);
    }

    public static void copyFile(String name, File dest, boolean forceCopy) throws IOException {
        IO.copyFile(new File(name), dest, forceCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest, boolean forceCopy) throws IOException {
        block13: {
            if (src.isDirectory()) {
                File[] files;
                if (!dest.isDirectory()) {
                    throw new IOException("copyFile: Cannot copy directory onto single file");
                }
                for (File f : files = src.listFiles()) {
                    if (f.isDirectory()) {
                        File newDir = new File(dest, f.getName());
                        newDir.mkdir();
                        IO.copyFile(f, newDir, forceCopy);
                        continue;
                    }
                    IO.copyFile(f, dest, forceCopy);
                }
            } else {
                if (dest.isDirectory()) {
                    dest = new File(dest, src.getName());
                }
                if (src.equals(dest)) {
                    throw new IOException("File " + src + " cannot be copied onto iteslf");
                }
                if (src.getName().equalsIgnoreCase("Thumbs.db")) {
                    return;
                }
                if (!forceCopy && dest.exists() && src.lastModified() <= dest.lastModified()) {
                    return;
                }
                if (dest.exists() && !dest.canWrite()) {
                    return;
                }
                long lastModified = src.lastModified();
                try {
                    IO.classicCopyFile(src, dest);
                    Object var10_10 = null;
                    if (!preserveLastModified) break block13;
                    dest.setLastModified(lastModified);
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (preserveLastModified) {
                        dest.setLastModified(lastModified);
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void classicCopyFile(File src, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        try {
            int bytesRead;
            byte[] buffer = new byte[65536];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in.close();
            out.close();
            throw throwable;
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nioCopyFile(File src, File dest) throws IOException {
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel dstChannel = new FileOutputStream(dest).getChannel();
        try {
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            srcChannel.close();
            dstChannel.close();
            throw throwable;
        }
        srcChannel.close();
        dstChannel.close();
    }

    public static String readAll(Reader in) throws IOException {
        int bytesRead;
        char[] buffer = new char[65536];
        StringBuilder sb = new StringBuilder();
        while ((bytesRead = in.read(buffer)) != -1) {
            sb.append(buffer, 0, bytesRead);
        }
        in.close();
        return sb.toString();
    }

    public static boolean isSubdirectoryOf(File subdir, File dir) {
        File parent = subdir.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.equals(dir)) {
            return true;
        }
        return IO.isSubdirectoryOf(parent, dir);
    }

    public static void copyDirectoryContent(String srcPath, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(new File(srcPath), dest, forceCopy);
    }

    public static void copyDirectoryContent(File srcDir, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(srcDir, dest, forceCopy, null);
    }

    public static void copyDirectoryContent(File srcDir, File dest, boolean forceCopy, FileFilter filter) throws IOException {
        dest.mkdir();
        if (!srcDir.isDirectory()) {
            throw new IOException("Missing directory " + srcDir.getAbsolutePath());
        }
        File[] files = srcDir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                IO.copyDirectoryContent(files[i], new File(dest, files[i].getName()), forceCopy);
                continue;
            }
            if (!files[i].isFile()) continue;
            IO.copyFile(files[i].getAbsolutePath(), dest, forceCopy);
        }
    }

    public static String baseName(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        return dotIndex != -1 ? fullName.substring(0, dotIndex) : fullName;
    }

    public static File thumbFile(File file) {
        String base;
        File parent = file.getParentFile();
        File thumbFile = new File(parent, (base = IO.baseName(file.getName())) + ".thm");
        if (!thumbFile.exists()) {
            thumbFile = new File(parent, base + ".THM");
        }
        return thumbFile;
    }

    public static String baseName(File file) {
        return IO.baseName(file.getName());
    }

    public static String extensionOf(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1);
    }

    public static String extensionOf(File file) {
        return IO.extensionOf(file.getName());
    }

    public static String relativePath(File file, File rel) {
        return IO.relativePath(file.getAbsolutePath(), rel.getAbsolutePath(), File.separatorChar);
    }

    public static String relativePath(String fileString, String relString) {
        return IO.relativePath(fileString, relString, '/');
    }

    private static String normalize(String s, char separator) {
        if ("".equals(s)) {
            return "";
        }
        s = s.charAt(0) == separator ? s : separator + s;
        s = s.charAt(s.length() - 1) == separator ? s : s + separator;
        return s;
    }

    public static String relativePath(String fileString, String relString, char separator) {
        StringTokenizer tokens;
        int i;
        String originalFileString = fileString;
        fileString = IO.normalize(fileString, separator);
        relString = IO.normalize(relString, separator);
        char[] filePath = fileString.toCharArray();
        char[] relPath = relString.toCharArray();
        StringBuilder result = new StringBuilder();
        for (i = 0; i < filePath.length && i < relPath.length && filePath[i] == relPath[i]; ++i) {
        }
        if (i < relPath.length && i < filePath.length || relPath.length < filePath.length && filePath[i] != separator) {
            while (i > 0 && relPath[i - 1] != separator) {
                --i;
            }
        }
        if (i != 0) {
            tokens = new StringTokenizer(relString.substring(i), "" + separator);
            while (tokens.hasMoreTokens()) {
                tokens.nextToken();
                result.append("../");
            }
        }
        if (i > fileString.length()) {
            i = fileString.length();
        }
        if ((tokens = new StringTokenizer(fileString.substring(i), "" + separator)).hasMoreTokens()) {
            result.append(tokens.nextToken());
        } else if (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
        while (tokens.hasMoreTokens()) {
            result.append("/" + tokens.nextToken());
        }
        String res = result.toString();
        res = res.equals("") ? "." : res;
        return res.indexOf(58) != -1 ? originalFileString : res;
    }

    public static String urlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes = s.getBytes("UTF-8");
            s = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u007f' || reserved.contains(String.valueOf(chars[i]))) {
                sb.append('%');
                sb.append(hexDigits[(chars[i] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i] & 0xF]);
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static String combinePaths(String part1, String part2) {
        return IO.combinePaths(part1, part2, '/');
    }

    public static String combinePaths(String part1, String part2, char separator) {
        int start;
        int end;
        if (part1.length() == 0) {
            return part2;
        }
        if (part2.length() == 0) {
            return part1;
        }
        for (end = part1.length(); end > 0 && part1.charAt(end - 1) == separator; --end) {
        }
        if (part1.endsWith("" + separator + separator)) {
            ++end;
        }
        for (start = 0; start < part2.length() && part2.charAt(start) == separator; ++start) {
        }
        return part1.substring(0, end) + separator + part2.substring(start, part2.length());
    }

    public static int sizeof(Object o) {
        try {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(ba);
            oos.writeObject(o);
            return ba.toByteArray().length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static long deepLastModified(File dir) throws IOException {
        long lastModified = dir.lastModified();
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                long lm = files[i].lastModified();
                if (files[i].isDirectory()) {
                    lm = IO.deepLastModified(files[i]);
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    public static long deepLastModifiedFile(File dir) throws IOException {
        long lastModified = 0L;
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                long lm = files[i].lastModified();
                if (files[i].isDirectory()) {
                    lm = IO.deepLastModifiedFile(files[i]);
                    continue;
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    public static void close(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    IO.deleteDir(f);
                    continue;
                }
                f.delete();
            }
        }
        dir.delete();
    }

    public static boolean recycle(File dir) {
        return IO.recycle(dir, false);
    }

    public static boolean recycle(File dir, boolean recycleOnly) {
        try {
            if (Platform.isMac()) {
                return !FileManager.moveToTrash((File)dir);
            }
            FileUtil fu = new FileUtil();
            return fu.recycle(dir);
        }
        catch (Throwable t) {
            if (!recycleOnly) {
                IO.deleteDir(dir);
            }
            return false;
        }
    }

    public static File resolvePath(File f, String name) {
        if (f.getParentFile() == null) {
            return new File(f, name);
        }
        File parent = f.getParentFile();
        File ret = IO.resolvePath(parent, f.getName());
        if (".".equals(name)) {
            return ret;
        }
        if ("..".equals(name)) {
            return ret.getParentFile();
        }
        return new File(ret, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destDir) throws IOException {
        BufferedOutputStream dest = null;
        FileInputStream fis = new FileInputStream(zipFile);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[BUFSIZE];
                File destFile = new File(destDir, entry.getName());
                if (entry.getName().endsWith("/")) {
                    destFile.mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(destFile);
                dest = new BufferedOutputStream(fos, BUFSIZE);
                while ((count = zis.read(data, 0, BUFSIZE)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                destFile.setLastModified(entry.getTime());
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            zis.close();
            throw throwable;
        }
        zis.close();
    }
}

