/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.DiskSpaceEvent;
import info.cqs.remotefs.DiskSpaceListener;
import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSDelegate;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import org.apache.sanselan.formats.jpeg.xmp.JpegXmpRewriter;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumManifest;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DownloadWorkers;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.RecoveryTool;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.jalbum.RemoteFileImpl;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.TransferProtocol;
import se.datadosen.jalbum.UploadWorkers;
import se.datadosen.jalbum.event.ByteProgressEvent;
import se.datadosen.jalbum.event.FileProgressEvent;
import se.datadosen.jalbum.event.ProgressEvent;
import se.datadosen.jalbum.event.TransferListener;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.Replacer;
import se.datadosen.util.ReportingThread;
import se.datadosen.util.Stopwatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadBean
implements RemoteFSProgressMonitor {
    private static final String HI_RES_NAME = "hi-res";
    private static final String TIME_DIFF_TEST_NAME = "timedifftester";
    private static final String AUTOUNZIP_EXTENSION = "zipstream";
    private static final String ZIPPED_ALBUM_NAME = "album.zipstream";
    private static final String ZIPPED_TEST_NAME = "test.zipstream";
    private static final String FILETREE_NAME = ":filetree";
    static final String LIFEBOAT_NAME = "lifeboat.zip";
    private transient Vector uploadListeners;
    private transient Vector albumBeanListeners;
    private RemoteFSDelegate remoteFSBean = RemoteFSBean.createInstance();
    long processedBytes;
    private long totalBytes;
    private int processedFiles;
    private int totalFiles;
    private Long spaceLeft;
    private ProgressEvent eventObject;
    private AlbumBean engine;
    String remoteAlbumPath;
    private String baseDirectory = "";
    private String ftpServer = "";
    private String initialPath = "";
    private String ftpUser = "";
    private String ftpPassword = "";
    private boolean myjalbum;
    private boolean ftpForceUTF8 = false;
    private TransferProtocol protocol = TransferProtocol.ftp;
    private boolean passiveMode = true;
    private int ftpPort = 21;
    private boolean fireProgressEvents = true;
    private long timeDifference = 0L;
    private AccountProfile account;
    private String absoluteURL = null;

    public String getAbsoluteURL() {
        return this.absoluteURL;
    }

    public void setAbsoluteURL(String absoluteURL) {
        this.absoluteURL = absoluteURL;
    }

    public UploadBean() {
        this.remoteFSBean.addDiskSpaceListener(new DiskSpaceListener(){

            public void diskSpaceAffected(DiskSpaceEvent e) {
                try {
                    if (SignInManager.getInstance().isSignedIn()) {
                        String userName = SignInManager.getInstance().getUserName();
                        AccountProfile account = AccountManager.getInstance().findJAlbumAccountByUserName(userName);
                        if (account != null && account.getFtpServer().equals(e.serverName)) {
                            JAlbumContext.getInstance().getFrame().accountStatusPanel.updateAction.actionPerformed(null);
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
    }

    public static void showErrorDialog(Component owner, RemoteFSException ex, String messagePrefix, String title) {
        String message = messagePrefix != null ? messagePrefix + ": " : "";
        message = message + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
        JOptionPane.showMessageDialog(owner, message, title, 0);
    }

    protected void finalize() throws Throwable {
        if (this.remoteFSBean.isConnected()) {
            this.remoteFSBean.disconnect();
        }
    }

    public RemoteFSDelegate getRemoteFS() {
        return this.remoteFSBean;
    }

    private void deleteDirectory2(String remotePath) throws RemoteFSException, IOException {
        this.remoteFSBean.setDirectory(remotePath);
        String relativeRemotePath = this.toRelative(remotePath);
        RemoteFile[] files = this.remoteFSBean.getFiles(RemoteFSBean.noDotDotDotFileFilter);
        for (int i = 0; i < files.length; ++i) {
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, relativeRemotePath, files[i].getName(), 0, 1, 0, 1);
            this.fireImageProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            String fullPath = IO.combinePaths(remotePath, files[i].getName());
            if (files[i].isDirectory()) {
                this.deleteDirectory2(fullPath);
            } else {
                this.remoteFSBean.removeFile(fullPath);
            }
            this.fireImageProcessingFinished(eventObject);
        }
        this.remoteFSBean.toParentDirectory();
        this.remoteFSBean.removeDirectory(remotePath);
    }

    public void deleteAlbum(AlbumObject root, String remoteDir) throws ParameterException, RemoteFSException, IOException {
        this.deleteDirectory(remoteDir);
        AlbumObjectProperties props = root.getProperties();
        props.remove("accountProfileName");
        props.remove("remotePath");
        props.remove("albumURL");
        props.remove("albumId");
        props.remove("lastPublishedDate");
        props.save();
    }

    public void deleteDirectory(String remoteDir) throws ParameterException, RemoteFSException, IOException {
        if (remoteDir.length() == 0) {
            throw new ParameterException("Cannot delete ftp root (security)");
        }
        String remotePath = this.toAbsolute(remoteDir);
        try {
            this.remoteFSBean.removeDirectory(remotePath);
            return;
        }
        catch (RemoteFSException remoteFSException) {
            this.deleteDirectory2(remotePath);
            return;
        }
    }

    public void setFtpServer(String newFtpServer) {
        int pathIndex;
        this.ftpServer = newFtpServer.trim();
        int colonIndex = this.ftpServer.indexOf("://");
        if (colonIndex != -1) {
            this.ftpServer = this.ftpServer.substring(colonIndex + 3);
        }
        if ((pathIndex = this.ftpServer.indexOf("/")) != -1) {
            this.initialPath = this.ftpServer.substring(pathIndex + 1);
            this.ftpServer = this.ftpServer.substring(0, pathIndex);
        } else {
            this.initialPath = "";
        }
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    private String getInitialPath() {
        return this.initialPath;
    }

    public void setFtpPort(int newFtpPort) throws RemoteFSException {
        this.ftpPort = newFtpPort;
    }

    public int getFtpPort() throws RemoteFSException {
        return this.ftpPort;
    }

    public void setFtpUser(String newFtpUser) {
        this.ftpUser = newFtpUser.trim();
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpPassword(String newFtpPassword) {
        this.ftpPassword = newFtpPassword.trim();
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public boolean isMyjalbum() {
        return this.myjalbum;
    }

    public void setMyjalbum(boolean myjalbum) {
        this.myjalbum = myjalbum;
    }

    public boolean isFtpForceUTF8() throws RemoteFSException {
        return this.ftpForceUTF8;
    }

    public void setFtpForceUTF8(boolean force) throws RemoteFSException {
        this.ftpForceUTF8 = force;
    }

    public TransferProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TransferProtocol protocol) {
        this.protocol = protocol;
    }

    public void setPassiveMode(boolean newPassiveMode) throws RemoteFSException {
        this.passiveMode = newPassiveMode;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public void setAccountProperties(AccountProfile account) {
        Properties props;
        try {
            props = BeanBinder.getProperties(account);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        BeanBinder.setProperties((Object)this, props);
        this.account = account;
    }

    AccountProfile getAccountProperties() {
        return this.account;
    }

    public void connect() throws RemoteFSException, IOException {
        this.remoteFSBean.setProtocol(this.getProtocol());
        this.remoteFSBean.setProgressMonitor(this);
        this.remoteFSBean.setForceUTF8(this.isFtpForceUTF8());
        this.remoteFSBean.setPassiveMode(this.isPassiveMode());
        this.remoteFSBean.setPort(this.getFtpPort());
        this.remoteFSBean.connect(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
        if (this.initialPath.length() > 0) {
            this.remoteFSBean.setDirectory(this.initialPath);
        }
        this.baseDirectory = this.remoteFSBean.getDirectory();
    }

    public void disconnect() {
        try {
            this.remoteFSBean.disconnect();
            this.account = null;
            this.absoluteURL = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        try {
            return this.remoteFSBean.isConnected();
        }
        catch (RemoteFSException ex) {
            return false;
        }
    }

    public void testConnection(AlbumBean engine) throws IOException, RemoteFSException {
        this.remoteFSBean.testConnection(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    private void deleteFiles(Set<RemoteFile> toDelete, AlbumManifest manifest) throws IOException, RemoteFSException {
        String lastPath = "";
        int fileNum = 1;
        for (RemoteFile rf : toDelete) {
            String path;
            int i;
            String newPath = IO.combinePaths(this.remoteAlbumPath, rf.getFullPath());
            int slashIndex = newPath.lastIndexOf(47);
            if (slashIndex >= 0) {
                newPath = newPath.substring(0, slashIndex);
            }
            if (!newPath.equals(lastPath)) {
                try {
                    this.remoteFSBean.setDirectory(newPath);
                }
                catch (RemoteFSException ex) {
                    // empty catch block
                }
                lastPath = newPath;
            }
            if ((i = (path = rf.getFullPath()).lastIndexOf(47)) > 0) {
                path = path.substring(0, i);
            }
            FileProgressEvent eventObject = new FileProgressEvent((Object)this, path, Msg.get("upload.deletingUnusedFiles"), fileNum, toDelete.size());
            this.fireFileProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            try {
                this.remoteFSBean.removeFile(rf.getName());
            }
            catch (RemoteFSException ex) {
                // empty catch block
            }
            manifest.removeFile(rf);
            this.fireFileProcessingFinished(eventObject);
            ++fileNum;
        }
    }

    public static long getTotalSize(Set<RemoteFile> files, int clusterSize) {
        long total = 0L;
        for (RemoteFile rf : files) {
            total += (rf.size() + (long)clusterSize - 1L) / (long)clusterSize * (long)clusterSize;
        }
        return total;
    }

    InputStream processRSSFile(File f) throws IOException {
        String content = IO.readTextFile(f);
        if (this.absoluteURL != null) {
            Replacer r = new Replacer();
            r.add("$absoluteURL", this.absoluteURL);
            content = r.replace(content);
        }
        return new ByteArrayInputStream(content.getBytes("UTF-8"));
    }

    private String toAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return IO.combinePaths(this.baseDirectory, path);
    }

    String toRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String rel = IO.relativePath(path, this.baseDirectory);
        if (rel.startsWith("..")) {
            return path;
        }
        return rel;
    }

    public Set<RemoteFile> getExistingAlbumFiles(String remoteDirectory) throws IOException, RemoteFSException {
        this.remoteFSBean.setProgressMonitor(this);
        this.eventObject = new FileProgressEvent((Object)this, "", Msg.get("upload.comparingFilesInfo"), 0, 1);
        String remoteDir = this.toAbsolute(remoteDirectory);
        try {
            AlbumManifest manifest = new AlbumManifest(this.remoteFSBean, remoteDir);
            return manifest.getContent();
        }
        catch (RemoteFSException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            this.timeDifference = this.calcTimeDifference(remoteDir);
            Set<RemoteFile> existingFiles = this.getFileTree(remoteDir);
            return existingFiles;
        }
        catch (ParseException ex) {
            ex.printStackTrace(System.err);
            return this.collectExistingFiles(remoteDir);
        }
        catch (RemoteFSException ex) {
            return this.collectExistingFiles(remoteDir);
        }
    }

    private Set<RemoteFile> getFileTree(String remoteDir) throws IOException, RemoteFSException, ParseException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.remoteFSBean.getUnmonitored(IO.combinePaths(remoteDir, FILETREE_NAME), bos);
        bos.flush();
        bos.close();
        byte[] rawbytes = bos.toByteArray();
        String content = new String(rawbytes, "UTF-8");
        TreeSet<RemoteFile> files = new TreeSet<RemoteFile>();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Scanner sc = new Scanner(content);
        int pathStart = remoteDir.length() + 1;
        while (sc.hasNextLine()) {
            String rights = sc.next();
            if (rights.charAt(0) == 'd') {
                sc.nextLine();
                continue;
            }
            sc.next();
            sc.next();
            sc.next();
            long size = sc.nextLong();
            Date date = dateFormatter.parse(sc.next());
            sc.next();
            sc.next();
            String pathFromRoot = sc.nextLine().substring(1);
            files.add(new RemoteFileImpl(pathFromRoot.substring(pathStart), size, date.getTime() - this.timeDifference));
        }
        return files;
    }

    public AlbumManifest uploadAlbum(JAlbumContext context, boolean fullUpdate) throws RemoteFSException, IOException {
        this.engine = context.getEngine();
        return this.uploadAlbum(context, fullUpdate, this.getExistingAlbumFiles(this.engine.getRemoteDirectory()));
    }

    public AlbumManifest uploadAlbum(JAlbumContext context, boolean fullUpdate, Set<RemoteFile> existingFiles) throws RemoteFSException, IOException, OperationAbortedException {
        this.engine = context.getEngine();
        File dir = this.engine.getInterpretedOutputDirectory();
        if (!dir.isDirectory()) {
            throw new IOException(Msg.get("publish.invalidOutputDirectoryError"));
        }
        this.processedBytes = 0L;
        this.eventObject = new FileProgressEvent((Object)this, dir.getName(), Msg.get("upload.comparingFilesInfo"), 0, 1);
        this.remoteAlbumPath = this.toAbsolute(this.engine.getRemoteDirectory());
        Set<RemoteFile> localFiles = this.getAllLocalFiles(new File[]{dir}, dir);
        AlbumManifest manifest = new AlbumManifest(existingFiles);
        TreeSet<RemoteFile> toDelete = new TreeSet<RemoteFile>();
        toDelete.addAll(existingFiles);
        toDelete.removeAll(localFiles);
        if (this.engine.isIncludeHiResImages()) {
            AlbumObject root = context.getAlbumObjectfactory().createInstance(new File(this.engine.getDirectory()));
            toDelete.removeAll(this.getVirtualHiresFiles(root));
        }
        TreeSet<File> skipFiles = new TreeSet<File>();
        Iterator<RemoteFile> it = existingFiles.iterator();
        while (it.hasNext()) {
            RemoteFile rf = it.next();
            if (localFiles.contains(rf)) {
                File local = new File(dir, rf.getFullPath());
                if (local.lastModified() / 1000L * 1000L > rf.getModificationDate().getTime() / 1000L * 1000L || local.getName().equals("album.rss")) continue;
                skipFiles.add(local);
                continue;
            }
            if (rf.getFullPath().contains("hi-res/")) continue;
            it.remove();
        }
        if (existingFiles instanceof AlbumManifest.ManifestBasedSet) {
            this.deleteFiles(toDelete, manifest);
            manifest.write(this.remoteFSBean, this.remoteAlbumPath);
        }
        this.totalBytes = this.getTotalFileSize(dir.listFiles(new UploadFileFilter()), skipFiles);
        this.remoteFSBean.setProgressMonitor(this);
        Stopwatch uploadWatch = new Stopwatch("Album upload");
        uploadWatch.start();
        try {
            if (Config.getConfig().isZipstreaming() && this.hasZipstreamingSupport()) {
                System.out.println("Zip stream support detected");
                this.uploadFilesZipped(this.toFileSet(dir.listFiles(new UploadFileFilter())), dir, skipFiles, this.remoteAlbumPath, manifest);
            } else {
                this.uploadFiles(this.toFileNodeList(dir.listFiles(new UploadFileFilter()), skipFiles), this.remoteAlbumPath, manifest);
                manifest.write(this.remoteFSBean, this.remoteAlbumPath);
            }
            uploadWatch.print();
            return manifest;
        }
        catch (IOException ex) {
            if (this.remoteFSBean.isConnected()) {
                this.remoteFSBean.disconnect();
            }
            this.remoteFSBean.reconnect();
            manifest.write(this.remoteFSBean, this.remoteAlbumPath);
            throw ex;
        }
        catch (RemoteFSException ex) {
            manifest.write(this.remoteFSBean, this.remoteAlbumPath);
            throw ex;
        }
        catch (OperationAbortedException ex) {
            manifest.write(this.remoteFSBean, this.remoteAlbumPath);
            throw ex;
        }
    }

    public void uploadFiles(File[] filesDirs, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
        this.processedBytes = 0L;
        this.totalBytes = this.getTotalFileSize(filesDirs, null);
        this.remoteFSBean.setProgressMonitor(this);
        this.uploadFiles(this.toFileNodeList(filesDirs, null), this.toAbsolute(remotePath), null);
    }

    private Set<File> toFileSet(File[] files) {
        TreeSet<File> set = new TreeSet<File>();
        for (File f : files) {
            set.add(f);
        }
        return set;
    }

    private List<FileNode> toFileNodeList(File[] files, Set<File> skipFiles) {
        ArrayList<FileNode> fileNodes = null;
        if (files != null) {
            fileNodes = new ArrayList<FileNode>();
            for (File f : files) {
                if (skipFiles != null && skipFiles.contains(f)) continue;
                FileNode node = new FileNode(f);
                if (f.isDirectory()) {
                    node.setChildren(this.toFileNodeList(f.listFiles(new UploadFileFilter()), skipFiles));
                }
                fileNodes.add(node);
            }
        }
        return fileNodes;
    }

    public void downloadFile(RemoteFSNode node, File destination) throws RemoteFSException, IOException, OperationAbortedException {
        this.processedBytes = 0L;
        this.totalBytes = node.getSize();
        this.eventObject = new ByteProgressEvent(this, node.oldRemotePath(), node.getRemoteName(), 0L, this.totalBytes);
        this.remoteFSBean.setDirectory(((RemoteFSNode)node.getParent()).remotePath());
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destination));
        this.remoteFSBean.get(node.getRemoteName(), os);
        os.close();
        this.processedBytes += node.getSize();
        this.fireFileProcessingFinished(this.eventObject);
    }

    public void downloadFiles(String remotePath, File destination) throws RemoteFSException, IOException, OperationAbortedException {
        Stopwatch stopwatch = new Stopwatch("Folder download");
        stopwatch.start();
        this.processedBytes = 0L;
        Set<RemoteFile> existingFiles = this.collectExistingFiles(this.toAbsolute(remotePath));
        this.totalBytes = UploadBean.getTotalSize(existingFiles, 1);
        this.eventObject = new ByteProgressEvent(this, this.totalBytes);
        DownloadWorkers workers = new DownloadWorkers(this, (ByteProgressEvent)this.eventObject, existingFiles, this.toAbsolute(remotePath), Config.getConfig().getMaxSimultaneousTransfers(), destination);
        try {
            workers.downloadFiles();
            stopwatch.print();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(UploadBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadLifeboat(JAlbumContext context, AlbumObject root) throws IOException, RemoteFSException {
        this.engine = context.getEngine();
        this.remoteFSBean.setDirectory(this.toAbsolute(this.engine.getRemoteDirectory()));
        PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream in = new PipedInputStream(out);
        Thread putterThread = new Thread("putter thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    UploadBean.this.fireProgressEvents = false;
                    UploadBean.this.remoteFSBean.put(in, UploadBean.LIFEBOAT_NAME);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (RemoteFSException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    UploadBean.this.fireProgressEvents = true;
                }
            }
        };
        putterThread.start();
        try {
            RecoveryTool.createLifeboat(context, root, out);
        }
        finally {
            try {
                putterThread.join();
            }
            catch (InterruptedException ex) {}
        }
    }

    private void createDirectories(String path) throws IOException, RemoteFSException {
        if (!path.endsWith("/")) {
            path = path + '/';
        }
        int fromIndex = 0;
        boolean newPath = false;
        int i = 0;
        while ((i = path.indexOf(47, fromIndex)) != -1) {
            String p = path.substring(0, i);
            if (p.length() != 0 && (newPath || !this.remoteFSBean.existsDirectory(p))) {
                this.remoteFSBean.createDirectory(p);
                newPath = true;
            }
            fromIndex = i + 1;
        }
    }

    private long calcTimeDifference(String remoteDir) {
        long diff = 0L;
        try {
            try {
                this.remoteFSBean.setDirectory(remoteDir);
            }
            catch (RemoteFSException ex) {
                this.createDirectories(remoteDir);
            }
            String s = "The purpose of this file is to synchronize the clock of the server with jAlbum. It can be safely removed";
            byte[] bytes = s.getBytes("ISO-8859-1");
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.remoteFSBean.put(in, TIME_DIFF_TEST_NAME);
            in.close();
            Date localTime = new Date();
            RemoteFile[] files = this.remoteFSBean.getFiles();
            this.remoteFSBean.removeFile(TIME_DIFF_TEST_NAME);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().equals(TIME_DIFF_TEST_NAME)) continue;
                diff = files[i].getModificationDate().getTime() - localTime.getTime();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (RemoteFSException ex) {
            ex.printStackTrace(System.err);
        }
        return diff;
    }

    private void uploadFiles(List<FileNode> list, String remotePath, AlbumManifest manifest) throws RemoteFSException, IOException, OperationAbortedException {
        this.eventObject = new ByteProgressEvent(this, this.totalBytes);
        UploadWorkers workers = new UploadWorkers(this, (ByteProgressEvent)this.eventObject, manifest, Config.getConfig().getMaxSimultaneousTransfers());
        try {
            workers.uploadFiles(list, remotePath);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(UploadBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int countHiresImages(AlbumObject folder, Map<String, RemoteFile> content) {
        int counter = 0;
        for (AlbumObject ao : folder.getChildren()) {
            String path;
            RemoteFile test;
            if (!ao.isIncluded()) continue;
            if (ao.isFolder()) {
                counter += this.countHiresImages(ao, content);
                continue;
            }
            if (!ao.isDisplayableImage() || (test = content.get(path = IO.combinePaths(folder.getPathFromRoot(), "hi-res/" + ao.getName()))) != null && test.getModificationDate().getTime() / 1000L * 1000L >= ao.getLastModified() / 1000L * 1000L) continue;
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadHiresFiles(AlbumObject root, AlbumManifest manifest, Long spaceLeft) throws RemoteFSException, IOException, OperationAbortedException {
        this.processedBytes = 0L;
        this.processedFiles = 0;
        this.spaceLeft = spaceLeft;
        this.remoteFSBean.setProgressMonitor(this);
        try {
            this.fireProgressEvents = false;
            HashMap<String, RemoteFile> content = new HashMap<String, RemoteFile>();
            for (RemoteFile rf : manifest.getContent()) {
                content.put(rf.getFullPath(), rf);
            }
            this.totalFiles = this.countHiresImages(root, content);
            this.doUploadHiresFiles(root, this.remoteAlbumPath, manifest, content);
        }
        finally {
            manifest.write(this.remoteFSBean, this.remoteAlbumPath);
            this.fireProgressEvents = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUploadHiresFiles(AlbumObject folder, String remotePath, AlbumManifest manifest, Map<String, RemoteFile> content) throws RemoteFSException, IOException, OperationAbortedException {
        ArrayList<AlbumObject> albumObjects = new ArrayList<AlbumObject>();
        for (AlbumObject ao : folder.getChildren()) {
            String fullPath;
            RemoteFile test;
            if (!ao.isIncluded() || !ao.isDisplayableImage() || (test = content.get(IO.relativePath(fullPath = IO.combinePaths(remotePath, "hi-res/" + ao.getName()), this.remoteAlbumPath))) != null && test.getModificationDate().getTime() / 1000L * 1000L >= ao.getLastModified() / 1000L * 1000L) continue;
            albumObjects.add(ao);
        }
        if (albumObjects.size() > 0) {
            try {
                this.remoteFSBean.setDirectory(remotePath);
            }
            catch (RemoteFSException ex) {
                return;
            }
            try {
                this.remoteFSBean.createDirectory(HI_RES_NAME);
            }
            catch (RemoteFSException ex) {
                // empty catch block
            }
            ImagePreparer preparer = new ImagePreparer(albumObjects);
            try {
                AlbumObject ao;
                JpegXmpRewriter rewriter = new JpegXmpRewriter();
                while ((ao = preparer.next()) != null) {
                    ByteArrayInputStream is;
                    this.eventObject = new FileProgressEvent((Object)this, remotePath, ao.getName(), this.processedFiles, this.totalFiles);
                    this.fireFileProcessingStarted(this.eventObject);
                    if (this.eventObject.isAborted()) {
                        preparer.interrupt();
                        throw new OperationAbortedException();
                    }
                    String fullPath = IO.combinePaths(remotePath, "hi-res/" + ao.getName());
                    String relPath = IO.relativePath(fullPath, this.remoteAlbumPath);
                    if (this.spaceLeft != null) {
                        RemoteFile existingFile = content.get(relPath);
                        if (existingFile != null) {
                            this.spaceLeft = this.spaceLeft + existingFile.size();
                        }
                        this.spaceLeft = this.spaceLeft - (long)preparer.getEncodedJPEG().length;
                        if (this.spaceLeft < 0L) {
                            throw new RemoteFSException("Your quota has been exceeded");
                        }
                    }
                    if (this.engine.isKeepXmpData() && ao.getXmpManager() != null) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ao.getXmpManager().save(preparer.getEncodedJPEG(), bos);
                        bos.close();
                        is = new ByteArrayInputStream(bos.toByteArray());
                    } else {
                        is = new ByteArrayInputStream(preparer.getEncodedJPEG());
                    }
                    this.remoteFSBean.put(is, "hi-res/" + ao.getName());
                    ((InputStream)is).close();
                    manifest.putFile(new RemoteFileImpl(relPath, preparer.getEncodedJPEG().length, ao.getLastModified()));
                    this.processedBytes += (long)preparer.getEncodedJPEG().length;
                    ++this.processedFiles;
                    this.fireFileProcessingFinished(this.eventObject);
                    if (!this.eventObject.isAborted()) continue;
                    preparer.interrupt();
                    throw new OperationAbortedException();
                }
            }
            finally {
                if (preparer != null) {
                    preparer.interrupt();
                }
            }
        }
        for (AlbumObject ao : folder.getChildren()) {
            if (!ao.isIncluded() || !ao.isFolder()) continue;
            this.doUploadHiresFiles(ao, IO.combinePaths(remotePath, ao.getName()), manifest, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadZipEntry(String path, InputStream in, ZipOutputStream out, boolean fireEvents) throws IOException {
        ZipEntry ze = new ZipEntry(path);
        out.putNextEntry(ze);
        try {
            byte[] b = new byte[32768];
            int bytesRead = 0;
            this.eventObject.processed = this.processedBytes;
            while (bytesRead >= 0) {
                bytesRead = in.read(b);
                if (bytesRead <= 0) continue;
                out.write(b, 0, bytesRead);
                if (!fireEvents) continue;
                this.eventObject.processed += (long)bytesRead;
                this.fireFileProcessingProgress(this.eventObject);
            }
            out.closeEntry();
        }
        finally {
            in.close();
        }
    }

    private void uploadFilesZipped(Set<File> filesDirs, File root, Set<File> skipFiles, ZipOutputStream out, AlbumManifest manifest) throws RemoteFSException, IOException {
        if (skipFiles != null) {
            filesDirs.removeAll(skipFiles);
        }
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                Set<File> children = this.toFileSet(f.listFiles(new UploadFileFilter()));
                if (skipFiles != null) {
                    children.removeAll(skipFiles);
                }
                out.putNextEntry(new ZipEntry(IO.relativePath(f, root) + '/'));
                if (children.size() <= 0) continue;
                this.uploadFilesZipped(children, root, skipFiles, out, manifest);
                continue;
            }
            this.eventObject = new ByteProgressEvent(this, f.getParentFile().getName(), f.getName(), this.processedBytes, this.totalBytes);
            this.fireFileProcessingStarted(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            String path = IO.relativePath(f, root);
            if (f.getName().equals("album.rss") && this.account != null) {
                this.uploadZipEntry(path, this.processRSSFile(f), out, true);
            } else {
                this.uploadZipEntry(path, new FileInputStream(f), out, true);
                if (manifest != null) {
                    manifest.putFile(new RemoteFileImpl(IO.relativePath(f, root), f.length(), f.lastModified()));
                }
            }
            this.fireFileProcessingFinished(this.eventObject);
            if (this.eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            this.processedBytes += f.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFilesZipped(Set<File> filesDirs, File root, Set<File> skipFiles, String remotePath, AlbumManifest manifest) throws RemoteFSException, IOException, OperationAbortedException {
        this.remoteFSBean.setDirectory(remotePath);
        PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream in = new PipedInputStream(out);
        Thread putterThread = new Thread("putter thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    UploadBean.this.fireProgressEvents = false;
                    UploadBean.this.remoteFSBean.put(in, UploadBean.ZIPPED_ALBUM_NAME);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (RemoteFSException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    UploadBean.this.fireProgressEvents = true;
                }
            }
        };
        putterThread.start();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(1);
        try {
            this.uploadFilesZipped(filesDirs, root, skipFiles, zout, manifest);
            this.uploadZipEntry("manifest.jmf", new ByteArrayInputStream(manifest.getBytes()), zout, false);
            zout.finish();
        }
        finally {
            zout.close();
            try {
                putterThread.join();
            }
            catch (InterruptedException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasZipstreamingSupport() throws IOException, RemoteFSException {
        String testFileName = "" + new Date().getTime() + ".tmp";
        PipedOutputStream out = new PipedOutputStream();
        final PipedInputStream in = new PipedInputStream(out);
        ReportingThread putterThread = new ReportingThread("putter thread"){

            protected void runWithTry() throws Throwable {
                UploadBean.this.remoteFSBean.put(in, UploadBean.ZIPPED_TEST_NAME);
            }
        };
        putterThread.start();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.setLevel(1);
        try {
            zout.putNextEntry(new ZipEntry(testFileName));
            zout.closeEntry();
            zout.finish();
        }
        finally {
            zout.close();
            try {
                putterThread.join();
            }
            catch (InterruptedException ex) {}
        }
        try {
            this.remoteFSBean.removeFile(testFileName);
            return true;
        }
        catch (RemoteFSException ex) {
            if (putterThread.finishedNormally()) {
                this.remoteFSBean.removeFile(ZIPPED_TEST_NAME);
            }
            return false;
        }
    }

    private Set<RemoteFile> collectExistingFiles(String remotePath) throws RemoteFSException, IOException {
        return this.collectExistingFiles(remotePath, remotePath, new TreeSet<RemoteFile>());
    }

    private Set<RemoteFile> collectExistingFiles(String root, String remotePath, Set<RemoteFile> existing) throws RemoteFSException, IOException {
        RemoteFile[] rFiles;
        try {
            this.remoteFSBean.setDirectory(remotePath);
        }
        catch (RemoteFSException ex) {
            this.remoteFSBean.createDirectory(remotePath);
            return existing;
        }
        for (RemoteFile remoteFile : rFiles = this.remoteFSBean.getFiles(RemoteFSBean.noDotDotDotFileFilter)) {
            String fullPath = IO.combinePaths(remotePath, remoteFile.getName());
            if (remoteFile.isDirectory()) {
                this.collectExistingFiles(root, fullPath, existing);
                continue;
            }
            existing.add(new RemoteFileImpl(IO.relativePath(fullPath, root), remoteFile.size(), remoteFile.getModificationDate().getTime() - this.timeDifference));
        }
        return existing;
    }

    private long getTotalFileSize(File[] filesDirs, Set<File> skipFiles) {
        long size = 0L;
        if (filesDirs == null) {
            return 0L;
        }
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                size += this.getTotalFileSize(f.listFiles(new UploadFileFilter()), skipFiles);
                continue;
            }
            if (skipFiles != null && skipFiles.contains(f)) continue;
            size += f.length();
        }
        return size;
    }

    private Set<RemoteFile> getVirtualHiresFiles(AlbumObject root) {
        return this.getVirtualHiresFiles(root, new TreeSet<RemoteFile>());
    }

    private Set<RemoteFile> getVirtualHiresFiles(AlbumObject folder, TreeSet<RemoteFile> remoteFiles) {
        String pathFromRoot = folder.getPathFromRoot();
        List<AlbumObject> children = folder.getChildren();
        for (AlbumObject ao : children) {
            if (!ao.isIncluded()) continue;
            if (ao.isFolder()) {
                this.getVirtualHiresFiles(ao, remoteFiles);
                continue;
            }
            if (!ao.isDisplayableImage()) continue;
            String fullPath = IO.combinePaths(pathFromRoot, "hi-res/" + ao.getName());
            remoteFiles.add(new RemoteFileImpl(fullPath));
        }
        return remoteFiles;
    }

    private Set<RemoteFile> getAllLocalFiles(File[] filesDirs, File root) {
        return this.getAllFiles(filesDirs, new TreeSet<RemoteFile>(), root);
    }

    private Set<RemoteFile> getAllFiles(File[] filesDirs, Set<RemoteFile> allFiles, File root) {
        for (File f : filesDirs) {
            if (f.isDirectory()) {
                this.getAllFiles(f.listFiles(new UploadFileFilter()), allFiles, root);
                continue;
            }
            allFiles.add(new RemoteFileImpl(f, root));
        }
        return allFiles;
    }

    public synchronized void addTransferListener(TransferListener l) {
        Vector v;
        Vector vector = v = this.uploadListeners == null ? new Vector(2) : (Vector)this.uploadListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.uploadListeners = v;
        }
    }

    public synchronized void removeTransferListener(TransferListener l) {
        if (this.uploadListeners != null && this.uploadListeners.contains(l)) {
            Vector v = (Vector)this.uploadListeners.clone();
            v.removeElement(l);
            this.uploadListeners = v;
        }
    }

    protected void fireFileProcessingStarted(ProgressEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TransferListener)listeners.elementAt(i)).fileProcessingStarted(e);
            }
        }
    }

    protected void fireFileProcessingProgress(ProgressEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TransferListener)listeners.elementAt(i)).fileProcessingProgress(e);
            }
        }
    }

    protected void fireFileProcessingFinished(ProgressEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TransferListener)listeners.elementAt(i)).fileProcessingFinished(e);
            }
        }
    }

    public synchronized void addAlbumBeanListener(AlbumBeanListener l) {
        Vector v;
        Vector vector = v = this.albumBeanListeners == null ? new Vector(2) : (Vector)this.albumBeanListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.albumBeanListeners = v;
        }
    }

    public synchronized void removeAlbumBeanListener(AlbumBeanListener l) {
        if (this.albumBeanListeners != null && this.albumBeanListeners.contains(l)) {
            Vector v = (Vector)this.albumBeanListeners.clone();
            v.removeElement(l);
            this.albumBeanListeners = v;
        }
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingStarted(e);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingFinished(e);
            }
        }
    }

    protected void fireErrorOccured(Exception param1, File param2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((TransferListener)listeners.elementAt(i)).errorOccured(param1, param2);
            }
        }
    }

    @Override
    public void bytesTransferred(long bytes) {
        if (this.fireProgressEvents && this.eventObject != null) {
            this.eventObject.processed = this.processedBytes + bytes;
            this.fireFileProcessingProgress(this.eventObject);
        }
    }

    public PathFinder getPathFinder(AccountProfile account, AlbumBean engine) throws IOException, RemoteFSException {
        return new PathFinder(account, engine);
    }

    public PathFinder getPathFinder(AlbumObject root, AlbumBean engine) throws IOException, RemoteFSException {
        if (root.getProperties().containsKey("albumURL")) {
            return new PathFinder(root);
        }
        return new PathFinder(this.account, engine);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileNode {
        private File file;
        private AtomicBoolean doProcess;
        private List<FileNode> children;
        private boolean processed;

        public FileNode(File file) {
            this.file = file;
            this.doProcess = new AtomicBoolean(true);
        }

        public File getFile() {
            return this.file;
        }

        public List<FileNode> getChildren() {
            return this.children;
        }

        public void setChildren(List<FileNode> children) {
            this.children = children;
        }

        public boolean doProcess() {
            return this.doProcess.getAndSet(false);
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImagePreparer
    extends Thread {
        private Iterator<AlbumObject> it;
        private AlbumObject ao;
        private byte[] encodedJPEG;
        private byte[] encodedJPEGToReturn;
        private IOException exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ImagePreparer(List<AlbumObject> albumObjects) {
            super("Image preparer");
            this.it = albumObjects.iterator();
            ImagePreparer imagePreparer = this;
            synchronized (imagePreparer) {
                this.start();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImagePreparer imagePreparer = this;
            synchronized (imagePreparer) {
                this.notify();
                try {
                    while (this.it.hasNext()) {
                        this.ao = this.it.next();
                        AlbumImage ai = new AlbumImage(this.ao.getFile(), UploadBean.this.engine);
                        ai = ai.scaleToFit(new Dimension(2048, 2048), 0.0f);
                        this.encodedJPEG = FileFilters.saveJPEG(ai.getBufferedImage(), null, UploadBean.this.engine, null, 0.9f);
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (IOException ex) {
                    this.exception = ex;
                }
                this.ao = null;
                this.encodedJPEG = null;
            }
        }

        synchronized AlbumObject next() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
            AlbumObject ret = this.ao;
            this.encodedJPEGToReturn = this.encodedJPEG;
            this.notify();
            return ret;
        }

        byte[] getEncodedJPEG() throws IOException {
            return this.encodedJPEGToReturn;
        }
    }

    public class PathFinder {
        String resolvedWebRootDirectory;
        String resolvedRemoteDirectory;
        String resolvedAlbumURL;
        AccountProfile account;
        AlbumBean engine;

        private PathFinder(AccountProfile account, AlbumBean engine) throws IOException, RemoteFSException {
            this.account = account;
            this.engine = engine;
            if (!UploadBean.this.isConnected()) {
                throw new RuntimeException("Not connected");
            }
            this.resolveDirectories();
            this.resolveAlbumURL();
        }

        private PathFinder(AlbumObject root) {
            AlbumObjectProperties props = root.getProperties();
            this.resolvedAlbumURL = (String)props.get("albumURL");
            this.resolvedRemoteDirectory = (String)props.get("remotePath");
        }

        private void resolveDirectories() throws IOException, RemoteFSException {
            String remoteDirectory;
            String webRootDirectory = this.account.getFtpWebRootDirectory();
            if (webRootDirectory.equals("VALUE_UNSET")) {
                this.resolvedWebRootDirectory = "";
                RemoteFile[] files = UploadBean.this.remoteFSBean.getFiles(UploadBean.this.toAbsolute(UploadBean.this.getBaseDirectory()));
                HashSet<String> webRootNames = new HashSet<String>();
                webRootNames.add("public_html");
                webRootNames.add("htdocs");
                webRootNames.add("wwwroot");
                webRootNames.add("httpdocs");
                webRootNames.add("www");
                for (RemoteFile f : files) {
                    if (!f.isDirectory() || !webRootNames.contains(f.getName())) continue;
                    this.resolvedWebRootDirectory = f.getName();
                    break;
                }
            } else {
                this.resolvedWebRootDirectory = webRootDirectory;
            }
            if ((remoteDirectory = this.engine.getRemoteDirectory()).length() > 0 && UploadBean.this.remoteFSBean.existsDirectory(UploadBean.this.toAbsolute(remoteDirectory))) {
                this.resolvedRemoteDirectory = remoteDirectory;
                return;
            }
            String projectName = new File(this.engine.getDirectory()).getName();
            this.resolvedRemoteDirectory = IO.combinePaths(this.resolvedWebRootDirectory, projectName);
        }

        private void resolveAlbumURL() {
            String uri = IO.relativePath(this.resolvedRemoteDirectory, this.resolvedWebRootDirectory);
            if (uri.startsWith("..")) {
                return;
            }
            if (uri.equals(".")) {
                uri = "";
            }
            uri = !"index".equals(this.engine.getIndexPageName()) ? IO.combinePaths(uri, this.engine.getIndexPageName() + this.engine.getPageExtension()) : IO.combinePaths(uri, "/");
            this.resolvedAlbumURL = IO.combinePaths(this.account.getWebRootURL(), uri);
        }

        public String getResolvedRemoteDirectory() {
            return this.resolvedRemoteDirectory;
        }

        public String getResolvedAlbumURL() {
            return this.resolvedAlbumURL;
        }

        public boolean albumExists() throws IOException, RemoteFSException {
            try {
                return UploadBean.this.remoteFSBean.existsDirectory(UploadBean.this.toAbsolute(this.resolvedRemoteDirectory));
            }
            catch (RemoteFSException ex) {
                try {
                    RemoteFile[] files = UploadBean.this.remoteFSBean.getFiles(UploadBean.this.toAbsolute(this.resolvedRemoteDirectory));
                    return true;
                }
                catch (RemoteFSException remoteFSException) {
                    return false;
                }
            }
        }
    }

    static class UploadFileFilter
    implements FileFilter {
        private Pattern pattern;

        public UploadFileFilter(String ignorePattern) {
            this.pattern = Pattern.compile(ignorePattern);
        }

        public UploadFileFilter() {
            this.pattern = this.pattern = Pattern.compile("");
        }

        public boolean accept(File file) {
            String name = file.getName();
            Matcher m = this.pattern.matcher(name);
            return !m.matches() && !name.endsWith(".jap") && !name.equals(".DS_Store") && !name.equals(".jalbum");
        }
    }
}

