/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.datadosen.jalbum.MiniConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    private static final MiniConfig config = MiniConfig.getMiniConfig();
    private static ClassLoader jAlbumClassLoader;

    public static void main(String[] args) throws ClassNotFoundException {
        Main.installUpdates();
        try {
            ClassLoader classLoader = Main.getJAlbumClassLoader();
            Class<?> clazz = classLoader.loadClass("se.datadosen.jalbum.JAlbum");
            Thread.currentThread().setContextClassLoader(classLoader);
            Method method = clazz.getMethod("main", args.getClass());
            method.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace();
        }
    }

    public static ClassLoader getJAlbumClassLoader() {
        if (jAlbumClassLoader == null) {
            File libDir = new File(Main.config.progDir, "lib");
            ArrayList<URL> all = new ArrayList<URL>();
            all.addAll(Main.buildURLList(libDir));
            all.addAll(Main.buildURLList(Main.config.chainedExtDir));
            try {
                all.add(Main.config.pluginsDir.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
            URL[] allURLs = all.toArray(new URL[0]);
            jAlbumClassLoader = new URLClassLoader(allURLs, Main.class.getClassLoader());
        }
        return jAlbumClassLoader;
    }

    static List<File> buildFileList(File dir) {
        Object[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                return s.endsWith(".jar") || s.endsWith(".zip") || s.endsWith(".jaext");
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        Arrays.sort(files);
        return Arrays.asList(files);
    }

    public static List<URL> buildURLList(File dir) {
        List<File> files = Main.buildFileList(dir);
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File f : files) {
                urls.add(f.toURI().toURL());
            }
            return urls;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void installUpdates() {
        File libDir = new File(Main.config.progDir, "lib");
        if (!libDir.exists()) {
            return;
        }
        for (File newFile : libDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".downloaded");
            }
        })) {
            String name = newFile.getName();
            String base = name.substring(0, name.lastIndexOf(46));
            File jarFile = new File(libDir, base);
            File oldFile = new File(libDir, base + ".old");
            if (jarFile.exists()) {
                if (oldFile.exists()) {
                    oldFile.delete();
                }
                jarFile.renameTo(oldFile);
            }
            if (!newFile.renameTo(jarFile)) continue;
            System.out.println("Installed update of " + jarFile);
        }
    }
}

