/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.jalbum.resty.web.AbstractContent;
import net.jalbum.resty.web.RobustResty;
import net.jalbum.resty.web.XMLResource;
import org.jdesktop.swingworker.SwingWorker;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.datadosen.component.CenterLayout;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JNotification;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.MarginIcon;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Notifier;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.jalbum.Widget;
import se.datadosen.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWidgetSettingsPanel
extends ControlPanel {
    JAlbumContext context;
    List<Widget> widgets;
    RefreshWorker refreshWorker = new RefreshWorker();
    private JProgressSpinner spinner = new JProgressSpinner(28);
    Action saveAsDefaultAction = new AbstractAction(Msg.get("ui.saveAsDefaultMenu")){

        public void actionPerformed(ActionEvent e) {
            new UpdateStatusWorker(null, JWidgetSettingsPanel.this.widgets).execute();
        }
    };

    public JWidgetSettingsPanel(JAlbumContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.context.getFrame().addPropertyChangeListener("rootFolder", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (JWidgetSettingsPanel.this.isShowing()) {
                    JWidgetSettingsPanel.this.refresh();
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && JWidgetSettingsPanel.this.isShowing()) {
                    JWidgetSettingsPanel.this.refresh();
                }
            }
        });
        SignInManager.getInstance().addPropertyChangeListener("signIn", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (JWidgetSettingsPanel.this.isShowing()) {
                    JWidgetSettingsPanel.this.refresh();
                }
            }
        });
    }

    private static List<Widget> parseWidgetXML(NodeList nodes) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            String sActive = (String)xpath.evaluate("@active", n, XPathConstants.STRING);
            Boolean active = sActive.length() != 0 ? Boolean.valueOf(sActive) : null;
            Widget w = new Widget((String)xpath.evaluate("@id", n, XPathConstants.STRING), (String)xpath.evaluate("name", n, XPathConstants.STRING), (String)xpath.evaluate("description", n, XPathConstants.STRING), (String)xpath.evaluate("icon", n, XPathConstants.STRING), active);
            widgets.add(w);
        }
        return widgets;
    }

    private void refresh() {
        if (this.refreshWorker.isDone()) {
            this.refreshWorker = new RefreshWorker();
        }
        if (this.refreshWorker.getState() == SwingWorker.StateValue.STARTED) {
            return;
        }
        if (this.getComponentCount() == 0) {
            JPanel spinnerPanel = new JPanel(new CenterLayout());
            spinnerPanel.add(this.spinner);
            this.add("hfill vfill", spinnerPanel);
            this.validate();
            this.spinner.workStarted();
        }
        this.refreshWorker.execute();
    }

    private void showLocalChangeHint() {
        JNotification tip = new JNotification(Msg.get("ui.widgetsUpdatedLocally"), JNotification.Type.TIP);
        tip.setPriority(JNotification.Priority.HIGH);
        tip.setExpiration(6);
        if (!tip.equals(this.context.getFrame().notificationManager.getActiveNotification())) {
            this.context.getFrame().showNotification(tip);
        }
    }

    private void showPublicChangeHint(String albumUrl) {
        JNotification tip = new JNotification(Msg.get("ui.widgetsUpdated", albumUrl), JNotification.Type.TIP);
        tip.setPriority(JNotification.Priority.HIGH);
        tip.setExpiration(10);
        if (!tip.equals(this.context.getFrame().notificationManager.getActiveNotification())) {
            this.context.getFrame().showNotification(tip);
        }
    }

    private static class JWarningPanel
    extends JPanel {
        public JWarningPanel(JComponent content) {
            this.setLayout(new BorderLayout(10, 10));
            this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.yellow));
            this.setBackground(new Color(255, 255, 205));
            this.add((Component)new JLabel(new MarginIcon(new Insets(6, 6, 6, 6), Icons.getIcon("warning"))), "Before");
            content.setOpaque(false);
            this.add((Component)content, "Center");
        }
    }

    private class JWidgetPanel
    extends JPanel {
        private Widget widget;
        JLabel name;
        JLabel description;
        JCheckBox active;

        public JWidgetPanel(Widget w) {
            super(new BorderLayout(12, 12));
            this.widget = w;
            this.setOpaque(false);
            try {
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                this.name = new JLabel(w.getName());
                this.name.setIcon(new ImageIcon(new URL(w.getIcon())));
                Font f = this.name.getFont();
                this.name.setFont(f.deriveFont(1, 16.0f));
                this.description = new JLabel(w.getDescription());
                this.add((Component)this.name, "Before");
                this.add((Component)this.description, "Last");
                if (w.getActive() != null) {
                    this.active = new JCheckBox();
                    this.active.setSelected(w.getActive());
                    this.active.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            JWidgetPanel.this.widget.setActive(JWidgetPanel.this.active.isSelected());
                            AlbumObject root = JWidgetSettingsPanel.this.context.getExplorer().getRootFolder();
                            AlbumObjectProperties props = root.getProperties();
                            props.put("widgets", JWidgetSettingsPanel.this.widgets);
                            props.put("widgetsLocalChange", new Date());
                            if (root.getName().length() > 0) {
                                props.save(true);
                            }
                            if (props.containsKey("albumURL") && root.getName().length() > 0) {
                                new UpdateStatusWorker(root, JWidgetPanel.this.widget).execute();
                            } else {
                                JWidgetSettingsPanel.this.showLocalChangeHint();
                            }
                        }
                    });
                    this.add((Component)this.active, "After");
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpdateStatusWorker
    extends SwingWorker<List<Widget>, Object> {
        private AlbumObjectProperties props;
        private List<Widget> widgets;

        public UpdateStatusWorker(AlbumObject albumRoot, List<Widget> widgets) {
            this.init(albumRoot, widgets);
        }

        public UpdateStatusWorker(AlbumObject albumRoot, Widget widget) {
            this.widgets = new ArrayList<Widget>();
            this.widgets.add(widget);
            this.init(albumRoot, this.widgets);
        }

        private void init(AlbumObject albumRoot, List<Widget> widgets) {
            if (albumRoot != null) {
                this.props = albumRoot.getProperties();
            }
            this.widgets = widgets;
        }

        protected List<Widget> doInBackground() throws Exception {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workStarted();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.pushText(Msg.get("ui.updating"));
            RobustResty r = new RobustResty();
            HashMap<String, String> data = new HashMap<String, String>();
            SignInManager mgr = SignInManager.getInstance();
            if (mgr.isSignedIn()) {
                data.put("cid", AccountManager.getCid(mgr.getUserName(), mgr.getPassword()));
            }
            if (this.props != null && this.props.containsKey("albumURL")) {
                data.put("albumUrl", Notifier.urlEncode((String)this.props.get("albumURL")));
            }
            for (Widget widget : this.widgets) {
                data.put("widget." + widget.getId(), Boolean.toString(widget.getActive()));
            }
            data.put("lang", Config.getConfig().getInterpretedLanguage());
            XMLResource xml = r.xml(JAlbumSite.getInstance().getWidgetsAPIUrl(), (AbstractContent)RobustResty.form(data));
            String errorCode = (String)xml.get("/reply/errorCode", String.class);
            if (errorCode.length() > 0) {
                if (Config.getConfig().isDebugMode()) {
                    System.err.println("Caught exception in reply from Widget API: " + errorCode);
                }
                if (this.props != null) {
                    JWidgetSettingsPanel.this.showLocalChangeHint();
                }
            } else if (this.props != null) {
                this.props.remove("widgetsLocalChange");
                this.props.save(true);
                JWidgetSettingsPanel.this.showPublicChangeHint((String)this.props.get("albumURL"));
            }
            NodeList nodes = (NodeList)xml.get("/reply/widgets/widget", NodeList.class);
            return JWidgetSettingsPanel.parseWidgetXML(nodes);
        }

        protected void done() {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workDone();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.popText(Msg.get("ui.updating"));
            try {
                this.get();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                Debug.showErrorDialog(JWidgetSettingsPanel.this.context.getFrame(), ex.getCause());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RefreshWorker
    extends SwingWorker<List<Widget>, Object> {
        Action enableWidgetSupportAction = new AbstractAction(Msg.get("ui.widgetSupport")){

            public void actionPerformed(ActionEvent e) {
                JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.setSelected(true);
                JWidgetSettingsPanel.this.refresh();
            }
        };

        protected List<Widget> doInBackground() throws Exception {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workStarted();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.pushText(Msg.get("ui.fetchingWidgetStatus"));
            AlbumObject root = JWidgetSettingsPanel.this.context.getExplorer().getRootFolder();
            AlbumObjectProperties props = root.getProperties();
            if (props.containsKey("widgetsLocalChange") && props.containsKey("widgets")) {
                return (List)props.get("widgets");
            }
            RobustResty r = new RobustResty();
            HashMap<String, String> data = new HashMap<String, String>();
            SignInManager mgr = SignInManager.getInstance();
            if (mgr.isSignedIn() && JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.isSelected()) {
                data.put("cid", AccountManager.getCid(mgr.getUserName(), mgr.getPassword()));
            }
            if (props.containsKey("albumURL")) {
                data.put("albumUrl", Notifier.urlEncode((String)props.get("albumURL")));
            }
            data.put("lang", Config.getConfig().getInterpretedLanguage());
            XMLResource xml = r.xml(JAlbumSite.getInstance().getWidgetsAPIUrl(), (AbstractContent)RobustResty.form(data));
            String scope = (String)xml.get("/reply/widgets/@scope", String.class);
            if (scope.length() > 0 && Config.getConfig().isDebugMode()) {
                System.out.println("Scope for Widget API reply: " + scope);
            }
            NodeList nodes = (NodeList)xml.get("/reply/widgets/widget", NodeList.class);
            List widgets = JWidgetSettingsPanel.parseWidgetXML(nodes);
            props.put("widgets", widgets);
            if (root.getName().length() > 0 && widgets.size() > 0 && ((Widget)widgets.get(0)).getActive() != null) {
                props.save(true);
            }
            return widgets;
        }

        protected void done() {
            JWidgetSettingsPanel.this.context.getFrame().progressSpinner.workDone();
            JWidgetSettingsPanel.this.spinner.workDone();
            JWidgetSettingsPanel.this.context.getFrame().statusBar.popText(Msg.get("ui.fetchingWidgetStatus"));
            try {
                JWarningPanel wp;
                JLabel text;
                JPanel content;
                JWidgetSettingsPanel.this.removeAll();
                if (!SignInManager.getInstance().isSignedIn()) {
                    content = new JPanel();
                    text = new JLabel(Msg.get("ui.widgetsDisabledNotSignedIn"));
                    content.add(text);
                    content.add(new JButton(JWidgetSettingsPanel.this.context.getFrame().actions.signInAction));
                    wp = new JWarningPanel(content);
                    JWidgetSettingsPanel.this.add("p hfill", wp);
                }
                if (!JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.isSelected()) {
                    content = new JPanel();
                    text = new JLabel(Msg.get("ui.widgetSupportDisabled"));
                    content.add(text);
                    content.add(new JButton(this.enableWidgetSupportAction));
                    wp = new JWarningPanel(content);
                    JWidgetSettingsPanel.this.add("p hfill", wp);
                }
                try {
                    JWidgetSettingsPanel.this.widgets = (List)this.get();
                }
                catch (ExecutionException ex) {
                    AlbumObject root;
                    AlbumObjectProperties props;
                    List widgets;
                    if (Config.getConfig().isDebugMode()) {
                        System.err.println("Caught exception in reply from Widget API: " + ex.getCause().toString());
                    }
                    if ((widgets = (List)(props = (root = JWidgetSettingsPanel.this.context.getExplorer().getRootFolder()).getProperties()).get("widgets")) == null || widgets.get(0) == null) {
                        throw ex;
                    }
                    JWidgetSettingsPanel.this.widgets = widgets;
                }
                Box widgetList = new Box(1);
                boolean first = true;
                for (Widget w : JWidgetSettingsPanel.this.widgets) {
                    if (!first) {
                        widgetList.add(JAlbumBorders.createSeparator());
                    }
                    widgetList.add(new JWidgetPanel(w));
                    first = false;
                }
                ControlPanel selectWidgetsPanel = new ControlPanel(Msg.get("ui.selectWidgets"));
                selectWidgetsPanel.setLayout(new BorderLayout());
                selectWidgetsPanel.add(widgetList);
                JWidgetSettingsPanel.this.add("br hfill", selectWidgetsPanel);
                SignInManager mgr = SignInManager.getInstance();
                JWidgetSettingsPanel.this.saveAsDefaultAction.setEnabled(mgr.isSignedIn() && JWidgetSettingsPanel.this.context.getFrame().settingsWindow.widgetInjection.isSelected());
                JWidgetSettingsPanel.this.add("p", new JLinkLabel(JAlbumSite.getInstance().getWidgetsUrl(), Msg.get("ui.moreAboutWidgets")));
                JWidgetSettingsPanel.this.add("hfill", Box.createHorizontalGlue());
                JWidgetSettingsPanel.this.add(new JButton(JWidgetSettingsPanel.this.saveAsDefaultAction));
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof IOException) {
                    JWidgetSettingsPanel.this.add("p hfill", new JWarningPanel(new JLabel(Msg.get("ui.fetchingWidgetStatusError") + ": " + ex.getCause().toString())));
                }
                Debug.showErrorDialog(JWidgetSettingsPanel.this.context.getFrame(), ex.getCause());
            }
            JWidgetSettingsPanel.this.validate();
            JWidgetSettingsPanel.this.repaint();
        }
    }
}

