/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComboBox;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.util.IO;
import se.datadosen.util.Item;

public class JAlbumUtilities {
    static Properties importProject(File projectFile) throws IOException {
        String directory;
        projectFile = projectFile.getAbsoluteFile();
        Properties props = IO.readPropertyFile(projectFile);
        if (!(projectFile.equals(JAlbumFrame.defaultProjectFile) || props.containsKey("directory") && !"true".equals(props.getProperty("ignoreDirectory")))) {
            props.setProperty("directory", projectFile.getParentFile().getAbsolutePath());
        }
        if ("true".equals(props.get("sameDirectory")) && (directory = props.getProperty("directory")) != null) {
            props.put("outputDirectory", directory);
            props.remove("sameDirectory");
        }
        if (!props.containsKey("homepageAddress")) {
            String text;
            String upLinkUrl;
            if ("true".equals(props.getProperty("skin.useUplink"))) {
                upLinkUrl = props.getProperty("skin.uplinkUrl");
                if (upLinkUrl != null) {
                    props.setProperty("homepageAddress", upLinkUrl);
                }
            } else {
                upLinkUrl = props.getProperty("skin.upLinkMain");
                if (upLinkUrl != null) {
                    props.setProperty("homepageAddress", upLinkUrl);
                }
            }
            if ((text = props.getProperty("skin.upLinkMainTxtA")) != null) {
                props.setProperty("homepageLinkText", text);
            }
            if ((upLinkUrl = props.getProperty("skin.uplinkURL")) != null) {
                props.setProperty("homepageAddress", upLinkUrl);
            }
            if ((upLinkUrl = props.getProperty("skin.homeLink")) != null) {
                props.setProperty("homepageAddress", upLinkUrl);
            }
            if ((upLinkUrl = props.getProperty("skin.homePageURL")) != null) {
                props.setProperty("homepageAddress", upLinkUrl);
            }
            if ((text = props.getProperty("skin.homePageLinkText")) != null) {
                props.setProperty("homepageLinkText", text);
            }
        }
        return props;
    }

    private JAlbumUtilities() {
    }

    public static void fillCombo(JComboBox combo, File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            return;
        }
        JAlbumUtilities.fillCombo(combo, new ChainedDirectory(dir), filter);
    }

    public static void fillCombo(JComboBox combo, ChainedDirectory dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(((File)o1).getName(), ((File)o2).getName());
            }
        });
        for (File f : files) {
            if (f.getName().toLowerCase().endsWith(".css")) {
                combo.addItem(new Item(f.getName(), IO.baseName(f)));
                continue;
            }
            combo.addItem(f.getName());
        }
    }

    public static Map getUserVariables(Properties props) {
        return JAlbumUtilities.getPrefixedVariables(props, "user.");
    }

    public static Map getSkinVariables(Properties props) {
        return JAlbumUtilities.getPrefixedVariables(props, "skin.");
    }

    public static Map getOrdinaryVariables(Properties props) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (e.getKey().toString().indexOf(46) != -1) continue;
            theMap.put(e.getKey().toString(), e.getValue().toString());
        }
        return theMap;
    }

    private static Map getPrefixedVariables(Properties props, String prefix) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> item : props.entrySet()) {
            String name = item.getKey().toString();
            if (!name.startsWith(prefix)) continue;
            theMap.put(name.substring(prefix.length()), item.getValue().toString());
        }
        return theMap;
    }

    public static boolean hasWebPages(AlbumObject folder) {
        if (!folder.isFolder()) {
            return false;
        }
        for (AlbumObject ao : folder.getChildren()) {
            if (ao.getCategory() != Category.webPage || !ao.isIncluded()) continue;
            return true;
        }
        return false;
    }

    public static long deepLastModified(AlbumObject folder) throws IOException {
        long lastModified = folder.getLastModified();
        for (AlbumObject ao : folder.getChildren()) {
            long lm = ao.getLastModified();
            if (ao.isFolder()) {
                lm = JAlbumUtilities.deepLastModified(ao);
            }
            if (lm <= lastModified) continue;
            lastModified = lm;
        }
        return lastModified;
    }
}

