/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Icon;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;

public class AlbumProject {
    private File projectFile;
    private Properties props;
    private AlbumObject root;
    Icon icon;

    public AlbumProject(File projectFile) throws IOException {
        this(projectFile, JAlbumContext.getInstance().getAlbumObjectfactory());
    }

    public AlbumProject(File projectFile, AlbumObjectFactory factory) throws IOException {
        this.projectFile = projectFile;
        String directory = this.getProperties().getProperty("directory");
        if (directory == null) {
            throw new IOException("Project file " + projectFile + " doesn't point to a valid jAlbum project");
        }
        File imageDir = new File(directory);
        this.root = factory.createInstance(imageDir);
    }

    public AlbumProject(File projectFile, AlbumObject root) {
        if (projectFile == null) {
            projectFile = JAlbumFrame.defaultProjectFile;
        }
        this.projectFile = projectFile;
        this.root = projectFile != null ? root : null;
    }

    Properties getProperties() throws IOException {
        if (this.props == null) {
            this.props = JAlbumUtilities.importProject(this.projectFile);
        }
        return this.props;
    }

    public AlbumObject getRootFolder() {
        return this.root;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlbumProject other = (AlbumProject)obj;
        return this.projectFile == other.projectFile || this.projectFile != null && this.projectFile.equals(other.projectFile);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.projectFile != null ? this.projectFile.hashCode() : 0);
        return hash;
    }

    public String getName() {
        if (this.projectFile == null) {
            return "New project";
        }
        return this.projectFile.getParentFile().getName();
    }

    public String getLongName() {
        if (this.projectFile == null) {
            return "New project";
        }
        File parent = this.projectFile.getParentFile();
        String longName = "";
        String projectFileName = "";
        if (!this.projectFile.getName().equals("jalbum-settings.jap")) {
            projectFileName = File.separatorChar + this.projectFile.getName();
        }
        longName = parent.getParentFile() == null ? longName + parent.getName() + projectFileName : longName + parent.getParentFile().getName() + File.separatorChar + parent.getName() + projectFileName;
        return longName;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setRootFolder(AlbumObject root) {
        this.root = root;
    }

    public String toString() {
        return "Album project {" + this.projectFile.getAbsolutePath() + "}";
    }
}

