/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JAddressBar
extends JPanel {
    private JAlbumExplorer context;
    private JTextField address = new JTextField();
    private JPopupMenu menu = new JPopupMenu();
    private Action closeAction = new AbstractAction(Msg.get("close")){

        public void actionPerformed(ActionEvent e) {
            ((JAddressBar)JAddressBar.this).context.addressBarMenuItem.setSelected(false);
            ((JAddressBar)JAddressBar.this).context.addressBarAction.actionPerformed(e);
        }
    };
    private Action showInFilesystemAction = new AbstractAction(Msg.get("edit.showInFilesystem")){

        public void actionPerformed(ActionEvent e) {
            try {
                BrowserLauncher.openLocal(JAddressBar.this.context.getCurrentFolder().getFile());
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JAddressBar.this.context, ex);
            }
        }
    };

    public JAddressBar(JAlbumExplorer context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JAlbumColor.border));
        this.address.setEditable(false);
        this.address.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JAddressBar.this.menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JAddressBar.this.menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        BrowserLauncher.openLocal(JAddressBar.this.context.getCurrentFolder().getFile());
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JAddressBar.this.context, ex);
                    }
                }
            }
        });
        this.add(this.address);
        this.menu.add(this.showInFilesystemAction);
        this.menu.add(this.closeAction);
    }

    public void setFolder(AlbumObject folder) {
        if (folder.getName().length() > 0) {
            this.address.setText(folder.getFile().getAbsolutePath());
        } else {
            this.address.setText("");
        }
    }
}

