/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;

class CaptionEditor
extends JAlbumObject.LabelEditor {
    private static KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
    private static KeyStroke altEnterStroke = KeyStroke.getKeyStroke(10, 512);
    private static KeyStroke shiftEnterStroke = KeyStroke.getKeyStroke(10, 64);
    private AlbumObject ao;
    private boolean editing;
    private WrappableJLabel label = new WrappableJLabel();
    private JTextArea captionArea;
    Dimension lastCaptionAreaDimension = new Dimension(0, 0);
    private JScrollPane scrollPane = new JScrollPane(21, 31);
    private Color deselectedTextColor = SystemColor.textText;

    public void removeNotify() {
        super.removeNotify();
        this.remove(this.scrollPane);
        this.scrollPane.setViewportView(null);
    }

    public CaptionEditor(JAlbumObject jao) {
        super(jao);
        this.ao = jao.ao;
        this.init();
    }

    private JTextArea getCaptionArea() {
        if (this.captionArea == null) {
            this.captionArea = new JTextArea(2, 10){
                {
                    this.addKeyListener(new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            if (event.getKeyCode() == 9 || event.getKeyChar() == '\t') {
                                JAlbumObject.tabCycling = true;
                                if (event.isShiftDown()) {
                                    CaptionEditor.this.jao.transferFocusBackward();
                                } else {
                                    CaptionEditor.this.captionArea.transferFocus();
                                }
                                event.consume();
                            }
                        }
                    });
                }

                public boolean isManagingFocus() {
                    return true;
                }
            };
            this.captionArea.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    CaptionEditor.this.setEditing(false);
                }
            });
            this.captionArea.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        CaptionEditor.this.captionArea.setText(CaptionEditor.this.ao.getComment());
                        CaptionEditor.this.setEditing(false);
                    }
                }
            });
            this.captionArea.setFont(this.label.getFont());
            this.captionArea.setText(this.label.getText());
            this.captionArea.setLineWrap(true);
            this.captionArea.setWrapStyleWord(true);
            this.captionArea.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    CaptionEditor.this.updateCaptionAreaSize();
                }

                public void removeUpdate(DocumentEvent e) {
                    CaptionEditor.this.updateCaptionAreaSize();
                }

                public void changedUpdate(DocumentEvent e) {
                    CaptionEditor.this.updateCaptionAreaSize();
                }
            });
            AbstractAction myEnterAction = new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    CaptionEditor.this.setEditing(false);
                }
            };
            InputMap im = this.captionArea.getInputMap();
            Object enterActionKeyName = im.get(enterStroke);
            im.put(altEnterStroke, enterActionKeyName);
            im.put(shiftEnterStroke, enterActionKeyName);
            im.put(enterStroke, myEnterAction);
            this.scrollPane.setViewportView(this.captionArea);
        }
        return this.captionArea;
    }

    private void init() {
        this.refresh();
        this.label.setFont(labelFont);
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        int w = this.jao.context.iconBounds.width;
        this.label.setPreferredWidth(w);
        Insets in = new Insets(0, 0, 0, 0);
        Border originalScrollBorder = this.scrollPane.getBorder();
        if (originalScrollBorder != null) {
            in = originalScrollBorder.getBorderInsets(this.scrollPane);
            Border emptyBorder = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            this.label.setBorder(emptyBorder);
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)this.label, "North");
        this.scrollPane.setVisible(false);
        this.add((Component)this.scrollPane, "South");
        this.jao.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (e.getButton() == 0 && CaptionEditor.this.ao.getComment().length() == 0) {
                    CaptionEditor.this.label.setText(Msg.get("ui.addCaption"));
                }
            }

            public void mouseExited(MouseEvent e) {
                CaptionEditor.this.refresh();
            }
        });
    }

    private void updateCaptionAreaSize() {
        Dimension dim = this.captionArea.getPreferredSize();
        if (!dim.equals(this.lastCaptionAreaDimension)) {
            this.lastCaptionAreaDimension = dim;
            Insets in = new Insets(0, 0, 0, 0);
            Border originalScrollBorder = this.scrollPane.getBorder();
            if (originalScrollBorder != null) {
                in = originalScrollBorder.getBorderInsets(this.scrollPane);
            }
            dim = this.captionArea.getPreferredSize();
            dim.width += in.left + in.right;
            dim.height += in.top + in.bottom;
            this.scrollPane.setPreferredSize(dim);
            this.revalidate();
        }
    }

    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        if (this.captionArea != null && this.captionArea.hasFocus()) {
            this.jao.requestFocusInWindow();
        }
        this.scrollPane.setVisible(editing);
        this.label.setVisible(!editing);
        if (editing) {
            this.getCaptionArea();
            this.captionArea.setText(this.ao.getComment());
            this.validate();
            this.repaint();
            this.captionArea.requestFocusInWindow();
            this.updateCaptionAreaSize();
        } else {
            String newCaption = this.captionArea.getText();
            if (!newCaption.equals(this.ao.getComment())) {
                Tracer.getInstance().trace("caption edited", "location:explorer");
                try {
                    this.ao.setComment(newCaption);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.refresh();
            this.validate();
            this.repaint();
        }
    }

    void refresh() {
        String comment = this.ao.getComment();
        if ("".equals(comment)) {
            this.deselectedTextColor = SystemColor.textInactiveText;
            this.label.setText(this.ao.getName());
        } else {
            this.deselectedTextColor = SystemColor.textText;
            this.label.setText(this.ao.getComment());
        }
        this.label.setForeground(this.jao.isSelected() ? SystemColor.textHighlightText : this.deselectedTextColor);
    }

    boolean isEditing() {
        return this.editing;
    }

    void setSelected(boolean selected) {
        if (selected) {
            this.label.setForeground(SystemColor.textHighlightText);
            this.label.setBackground(SystemColor.textHighlight);
        } else {
            this.label.setForeground(this.deselectedTextColor);
            this.label.setBackground(SystemColor.text);
        }
    }
}

