/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;

public class RoundedLineBorder
implements Border {
    private int radius = 4;
    private int lineWeight = 1;
    private Color lineColor;

    public RoundedLineBorder() {
    }

    public RoundedLineBorder(Color lineColor) {
        this.lineColor = lineColor;
    }

    public RoundedLineBorder(int radius) {
        this.radius = radius;
    }

    public RoundedLineBorder(int radius, int lineWeight) {
        this.radius = radius;
        this.lineWeight = lineWeight;
    }

    public void paintBorder(Component c, Graphics g1, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setColor(c.getBackground());
        g.fillRoundRect(x, y, width - 1, height - 1, this.radius * 2, this.radius * 2);
        if (this.lineColor != null) {
            g.setColor(this.lineColor);
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius * 2, this.radius * 2);
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.radius, this.radius, this.radius, this.radius);
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

