/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.datadosen.component.JPlainButton;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JHtmlBox;

public class JNotification
extends JPanel {
    private JComponent content = new JPanel();
    private JLabel iconLabel = null;
    protected JPlainButton abortButton = new JPlainButton(Icons.getIcon("tiny.close"), (Icon)Icons.getIcon("tiny.close1"));
    private int yOffset = 0;
    private int expiration = 0;
    private Priority priority = Priority.NORMAL;
    private boolean backgroundGradient = false;
    private Preferences prefs;
    private static final String LAST_DISMISSED_KEY = "lastDismissedNotification";
    private static final String LAST_SHOWN_KEY = "lastShownNotification";
    private boolean rememberDismissed = false;
    private boolean rememberShown = false;

    public JNotification(JComponent content) {
        super(new BorderLayout());
        this.init(content);
    }

    public JNotification(JComponent content, Type type) {
        super(new BorderLayout());
        this.init(content);
        this.setType(type);
    }

    public JNotification(String htmlText) {
        super(new BorderLayout());
        this.init(new JHtmlBox(htmlText));
    }

    public JNotification(String htmlText, Type type) {
        super(new BorderLayout());
        this.init(new JHtmlBox(htmlText));
        this.setType(type);
    }

    public JNotification() {
        super(new BorderLayout());
        this.init(new JPanel());
    }

    public static void forgetAllDismissed() throws BackingStoreException {
        Preferences node = Preferences.userNodeForPackage(JNotification.class).node(LAST_DISMISSED_KEY);
        node.removeNode();
    }

    public static void forgetAllShown() throws BackingStoreException {
        Preferences node = Preferences.userNodeForPackage(JNotification.class).node(LAST_SHOWN_KEY);
        node.removeNode();
    }

    public void setType(Type type) {
        this.setBackground(type.color);
        this.setBackgroundGradient(type.gradientBackground);
        this.setIcon(type.icon);
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int secs) {
        this.expiration = secs;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public boolean isBackgroundGradient() {
        return this.backgroundGradient;
    }

    public void setBackgroundGradient(boolean gradientBackground) {
        this.backgroundGradient = gradientBackground;
    }

    public boolean isRememberDismissed() {
        return this.rememberDismissed;
    }

    public void setRememberDismissed(boolean rememberDismissed) {
        this.rememberDismissed = rememberDismissed;
    }

    public boolean isRememberShown() {
        return this.rememberShown;
    }

    public void setRememberShown(boolean rememberShown) {
        this.rememberShown = rememberShown;
    }

    public long getLastShown() {
        Preferences p = this.getPreferences().node(LAST_SHOWN_KEY);
        return p.getLong(String.valueOf(this.content.hashCode()), 0L);
    }

    public boolean isShownBefore() {
        return this.getLastShown() > 0L;
    }

    public boolean isDismissedBefore() {
        return this.getLastDismissed() > 0L;
    }

    public void setLastShown(long time) {
        Preferences p = this.getPreferences().node(LAST_SHOWN_KEY);
        String key = String.valueOf(this.content.hashCode());
        if (time > 0L) {
            p.putLong(key, time);
        } else {
            p.remove(key);
        }
        try {
            p.flush();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setLastDismissed(long time) {
        Preferences p = this.getPreferences().node(LAST_DISMISSED_KEY);
        String key = String.valueOf(this.content.hashCode());
        if (time > 0L) {
            p.putLong(key, time);
        } else {
            p.remove(key);
        }
        try {
            p.flush();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public long getLastDismissed() {
        Preferences p = this.getPreferences().node(LAST_DISMISSED_KEY);
        return p.getLong(String.valueOf(this.content.hashCode()), 0L);
    }

    private Preferences getPreferences() {
        if (this.prefs == null) {
            this.prefs = Preferences.userNodeForPackage(this.getClass());
            try {
                this.prefs.sync();
            }
            catch (BackingStoreException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.prefs;
    }

    private void init(JComponent content) {
        this.setContent(content);
        this.setBackground(new Color(240, 155, 44));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.abortButton.setRealBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JNotification.this.setVisible(false);
                if (JNotification.this.rememberDismissed) {
                    JNotification.this.setLastDismissed(System.currentTimeMillis());
                }
                JNotification.this.firePropertyChange("dismissed", false, true);
            }
        });
        JPanel eastPanel = new JPanel(new BorderLayout());
        eastPanel.setOpaque(false);
        eastPanel.add((Component)this.abortButton, "North");
        this.add((Component)eastPanel, "East");
        this.setContent(content);
    }

    private int getIntendedHeight() {
        int height = this.getHeight();
        if (height == 0) {
            height = this.getPreferredSize().height;
        }
        return height;
    }

    public void jumpDown() {
        this.yOffset = this.getIntendedHeight();
        this.repaint();
    }

    public void rollUp() {
        try {
            for (int y = this.getIntendedHeight(); y >= 0; y -= 5) {
                this.yOffset = y >= 0 ? y : 0;
                this.repaint();
                Thread.sleep(20L);
            }
            this.yOffset = 0;
            this.repaint();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void rollDown() {
        try {
            int height = this.getIntendedHeight();
            for (int y = 0; y <= height; y += 5) {
                this.yOffset = y <= height ? y : height;
                this.repaint();
                Thread.sleep(20L);
            }
            this.yOffset = height;
            this.repaint();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setContent(JComponent content) {
        if (this.content != null) {
            this.remove(this.content);
        }
        content.setOpaque(false);
        this.content = content;
        if (content != null) {
            this.add((Component)content, "Center");
        }
    }

    public void setIcon(Icon icon) {
        if (this.iconLabel != null) {
            this.remove(this.iconLabel);
            this.iconLabel = null;
        }
        if (icon != null) {
            this.iconLabel = new JLabel(icon);
            this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
            this.add((Component)this.iconLabel, "West");
        }
    }

    public void setCloseButtonToolTipText(String toolTip) {
        this.abortButton.setToolTipText(toolTip);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.rememberShown) {
            this.setLastShown(System.currentTimeMillis());
        }
    }

    public void paint(Graphics g) {
        Graphics g2 = g.create();
        if (this.getParent() != null) {
            g2.setColor(this.getParent().getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2.translate(0, this.yOffset);
        super.paint(g2);
    }

    protected void paintComponent(Graphics g) {
        if (!this.backgroundGradient) {
            super.paintComponent(g);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Insets in = new Insets(0, 0, 0, 0);
        int w = this.getWidth() - in.left - in.right;
        int h = this.getHeight() - in.top - in.bottom;
        Color topColor = this.getBackground().brighter();
        Color bottomColor = this.getBackground();
        GradientPaint gradient = new GradientPaint(in.left, in.top, topColor, in.left, h, bottomColor, false);
        g2.setPaint(gradient);
        g2.fillRect(in.left, in.top, w, h);
    }

    public boolean equals(Object obj) {
        return obj instanceof JNotification && this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        HIGH,
        NORMAL,
        LOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JALBUM(new Color(100, 230, 100), true, Icons.getIcon("large.frog")),
        SKIN(new Color(228, 183, 105), false, Icons.getIcon("large.skin")),
        TIP(new Color(255, 255, 205), false, Icons.getIcon("big.lightbulb")),
        PLAIN(Color.orange, false, null);

        public final Color color;
        public final boolean gradientBackground;
        public final Icon icon;

        private Type(Color color, boolean gradientBackground, Icon icon) {
            this.color = color;
            this.gradientBackground = gradientBackground;
            this.icon = icon;
        }
    }
}

